



read "CoreDefs.asm"
limit &E00	
org &50


;
;Rastercolor buffer - 80 bytes (&50
RasterColors_ColorArray1:
	defb 1
	defb 1
	defb 64+20,64+24,64+29,64+11	 :IlluminatedPaletteA_Plus2
RasterColors_ColorArray2:
	defb 1
	defb 1

	defb 64+20,64+12,64+13,64+11	:IlluminatedPaletteB_Plus2
	defb 0
	defb 64+20,64+24,64+29,64+11
	defb 12
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+24,64+29,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
RasterColors_ColorArray3:
	defb 1
	defb 1
	defb 64+20,64+12,64+13,64+11 :IlluminatedPaletteC_Plus2
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
RasterColors_ColorArray4:
	defb 1
	defb 1 
	defb 64+20,64+31,64+14,64+11 :IlluminatedPaletteD_Plus2
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+31,64+14,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+31,64+14,64+11



align 256,&00
StarArraySize equ 255
StarArrayPointer: 	
defs StarArraySize*3,&00


ObjectArraySize equ 60
PlayerStarArraySize equ 36

align 256,&00
PlayerStarArrayPointer: 
defs 64,&00
ObjectArrayPointer:
defs 64,&00
align 256,&00
defs 255*5,&00

;defs ObjectArraySize*6,&00
;defs PlayerStarArraySize*3,&00

;align 256,&00

	

Event_SavedSettings:
defs 4*16,&00



CustomRam:
defs 64 ;  Pos-Tick-Pos-Tick ; enough memory for 16 enemies!


limit &4000
org &E00	
	; Placeholder for the SFX

org &1000
PlayerSprites:
;incbin "Sprites\PLAYER.SPR"



org &2300
LevelSprites:
incbin "Sprites\LEVEL8.SPR"





limit &3ff0
org &3700



RasterColors_ColorArray1Alt:
	defb 1
	defb 0			
	defb &54,&5D,&53,&4B		;58

RasterColors_ColorArray2Alt:
	defb 1	; Switches
	defb 32	;delay			
	defb &54,&5D,&53,&4B

RasterColors_ColorArray3Alt:
	defb 0
	defb 1
	defb &54,&54,&54,&54		 :IlluminatedPaletteCAlt_Plus2
RasterColors_ColorArray4Alt:
	defb 1 ; no of switches
	defb 0	;delays			
	defb &54,&5D,&5B,&4B		


evtSettingsBank_Save equ %10010000+15
evtSettingsBank_Load equ %10010000+0
evtMultipleCommands equ %01110000


evtSetMoveLife     equ 128
evtSetProg	   equ 129
evtSetLife	   equ 130
evtSetMove	   equ 131
evtSetProgMoveLife equ 132
evtSetSprite	   equ 133
evtAddToForeground equ 135
evtAddToBackground equ 134
evtJumpToNewTime   equ 136
evtCallAddress	   equ 137
evtSaveLstObjToAdd equ 138
evtResetPowerup    equ 139
evtSetLevelSpeed   equ 140

evtReprogramPalette 	equ %11110000
evtReprogramBackground 	equ %11110001	
evtReprogramHitHandler 	equ %11110010		
evtReprogramParalax	equ %11110011		

evtReprogramCustomMove1 equ %11110100
evtReprogramCustomMove2 equ %11110101
evtReprogramCustomMove3 equ %11110111
evtReprogramCustomMove4 equ %11111000

evtReprogramCustomProg1 equ %11111001
evtReprogramCustomProg2 equ %11111010
evtReprogramCustomProg3 equ %11111011
evtReprogramCustomProg4 equ %11111100


evtReprogram_PowerupSprites equ %11110110
evtReprogramScrollDirection equ %11111101	; 0-Left (Default) 1-Right 2-Up 3-Down
evtReprogramObjectFullCustomMoves equ	%11111110

evtSingleSprite equ 0

;Time,type,Sprite,XY (16 px precision)

; Types:
;type XXXX----
;     00000000 A X Y = (0)  add one object A=sprnum, X , Y
;     00000001 Y    	Add one sprite to pos Y Far right (Same sprite as last time
;     0000yyyy A	2-13 add one 24 pixel object far right X=160+24 Y*16 -8 (Same sprite as last time
;     0001xxxx A B = (16) add  xxxx objects
;     0010xxxx X B = (32) add  xxxx objects all on column X
;     0011xxxx X Y S = (48) add  xxxx objects all on column X, Ypos Spaced S apart vertically
;     0100xxxx X Y   = (64) add stars to X,Y (pattern xxxx)
;     0101       Unused
;     0110       Unused
;     0111xxxx  = (112) Read Multiple events at the same time point

;     10000000 M L = (128) Change object movement to M, Life to L
;     10000001 P = (129) Change object Program
;     10000010 L = (130) Change object Life
;     10000011 M = (131) Change object Move
;     10000100 P M L = (132) Change object Program Move and Life
;     10000101 S = (133) Change object Sprite (only works with 0000XXXX )
;     10000110 (134) Add Objects to Front of list first (Background)
;     10000111 (135) Add Objects to Back of list first (Foreground)
;     10001000 L H T (136) = Load HL as next event pointer, change time to T
;     10001001 L H   (137) = Call HL - (untested)
;     10001010 L H   (138) = Load last added object address to address HL
;     10011111 B = Save to bank B
;     1001XXXX 	Load object settings (Prog, Move,Life) from XXXX bank (0-14 - see above 15 is save command)
;		Use this function to create template enemy moves and background object types
;     1010       Unused
;     1011       Unused	
;     1100XXXX   Unused
;     1101XXXX   Unused
;     1110XXXX   Unused
;     1111XXXX   Reprogram memory chunk

;     1111XXXX   Reprogram memory chunk
;     11110000 O B	X X X  = (240) Reprogram palette (B no of Bytes, O = offset; X X X byte data)
;     11110001 O B	X X X  = (240) Reprogram Background (B no of Bytes (up to 41), O = offset; X X X byte data)
;     11110010 LH 	= when an object is shot jump to HL (Akuyou_Object_DecreaseLifeShot is true hitcounter)
;     11110011 1P2	= Scroll rate 1 before P then 2 (1 must be faster than 2)
;     11110100 LH	= Reprogram Custom Move1
;     11110101 LH	= Reprogram Custom Move2

; Life BPxxxxx 		B=hurt by bullets , P hurts player, xxxxxx = Life ... Life decreases either over time or due to hits %00000000 means an immortal object which will only dissapear if it goes ofscreen

;Domoves
;0MYYYXXX	; Linear move
;11ddXXXX	; Background (Slow) move
;100001XX	; Seek player 1 speed -----XX1
;1010DSPP	D = Depth bit, S= Speed, PP Position


evtTileSprite equ 48 ;     0011xxxx X Y S = (48) add  xxxx objects all on column X, Ypos Spaced S apart vertically

prgNothing	equ 0
prgSpecial	equ 2
prgBonus 	equ 3
prgMovePlayer	equ 4
prtSpriteAlt	equ 5
prgFireSnail	equ %10000000
prgFireSlow	equ %01100000
prgFireMid	equ %01000000
prgFireMid2	equ %11000000
prgFireFast	equ %00100000
prgFireHyper	equ %10100000

; Fire Patterns

;defw	Stars_AddObject			;0 = just one - Special use only
;defw	Stars_AddBurst_TopLeft		;1
;defw	Stars_AddBurst_BottomLeft	;2
;defw	Stars_AddBurst_TopRight		;3
;defw	Stars_AddBurst_BottomRight	;4
;defw	Stars_AddBurst_Top		;5
;defw	Stars_AddBurst_Bottom		;6
;defw	Stars_AddBurst_Left		;7
;defw	Stars_AddBurst_Right		;8
;defw	Stars_AddBurst_TopWide		;9
;defw	Stars_AddBurst_BottomWide	;10
;defw	Stars_AddBurst_LeftWide		;11
;defw	Stars_AddBurst_RightWide	;12
;defw	Stars_AddBurst	All Dirs	;13
;defw	Stars_AddBurst	All Dirs Small	;14
;defw					;15
;	Fire W				 16 
;	Fire NW				 17
;	Fire N				 18

prgCustom1 	equ %11111100			;Custom 1
prgCustom2 	equ %11111101			;Custom 2
prgCustom3 	equ %11111110			;Custom 3
prgCustom4 	equ %11111111			;Custom 4


mveStatic 	equ &24
mveBackground   equ %11000000
mveSeaker	equ %10000100
mveWave		equ %10100000
;mveWaveSmall	equ %10010000 depricated
mveCustom1	equ %11110000
mveCustom2	equ %11100000
mveCustom3	equ %11010000
mveCustom4	equ %10110000

;	Moves - Regular
;		0	1	2	3	4	5	6	7
;		-4	-3	-2	-1	0	1	2	3
;-4	0	00	01	02	03	 04	05	06	07
;-3	1	08	09	0A	0B	 0C	0D	0E	0F
;-2	2	10	11	12	13	 14	15	16	17
;-1	3	18	19	1A	1B	 1C	1D	1E	1F

;0	4	20	21	22	23	[24]	25	26	27

;1	5	28	29	2A	2B	 2C	2D	2E	2F
;2	6	30	31	32	33	 34	35	36	37
;3	7	38	39	3A	3B	 3C	3D	3E	3F



;	Moves - Fast
;		0	1	2	3	4	5	6	7
;		-4	-3	-2	-1	0	1	2	3
;-4	0	40	41	42	43	 44	45	46	47
;-3	1	48	49	4A	4B	 4C	4D	4E	4F
;-2	2	50	51	52	53	 54	55	56	57
;-1	3	58	59	5A	5B	 5C	5D	5E	5F

;0	4	60	61	62	63	[64]	65	66	67

;1	5	68	69	6A	6B	 6C	6D	6E	6F
;2	6	70	71	72	73	 74	75	76	77
;3	7	78	79	7A	7B	 7C	7D	7E	7F


lifCustom       equ 255		; We use 63 as a marker for custom code's INIT - a real life will be set by the custom code
lifEnemy	equ %11000000	;HurtByBullets,Hurts Player
lifTimed	equ %00000000	;Doesnt hurt, dies automatically
lifDeadly	equ %01000000	;Deadly and cant be shot
TwoFrameSprite  equ 128




EventStreamArray:

;defb 1,128,&24,128+64+60		; Move Static


;defb 0,evtResetPowerup
defb 0,evtReprogramScrollDirection,2; 0-Left (Default) 1-Right 2-Up 3-Down

defb 0,evtReprogramHitHandler				;Install a custom hit handler
defw CustomObjectHitHandler


defb 0,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*2+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54		



; Define the background

defb 0
defb 240+1,0,12*2+1				; (Time,Cmd,Off,Bytes) Load 41 bytes into the background - 41 bytes is the limit
defb 0,0
defb 198,&A0	;1
defb 190,&50	;2
defb 176,&80	;3
defb 170,&20	;4
defb 166,&00	;5
defb 160,&00	;6
defb 36,&20	;7
defb 30,&80	;8
defb 26,&50	;9
defb 20,&A0	;10
defb 02,&F0	;11
defb 0

;We will use 4 Paralax layers
; ---------()- (sky)		%11001000
; ------------ (Far)		%11000100
; -----X---X-- (mid)		%11000010	Bank 1
; []=====[]=== (foreground) 	%11000001	Bank 0



FirstPowerupSprite equ  128+32
defb 0,evtReprogram_PowerupSprites,FirstPowerupSprite+3,FirstPowerupSprite+2,FirstPowerupSprite+1,FirstPowerupSprite	; sprites drone,speed,power,coin

; Background L
defb 0,128+4,1,mveBackground+%00000001,0			; Program - Bitshift Sprite... Move - dir Left Slow ... Life - immortal
defb 0,evtSettingsBank_Save,0				; Save Object settings to Bank 0

defb 0,128+4,1,mveBackground+%00000010,0			; Program - Bitshift Sprite... Move - dir Left Slow ... Life - immortal
defb 0,evtSettingsBank_Save,1				; Save Object settings to Bank 1




; Side Snapper Left
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,PrgFireMid+12,mveCustom1,lifCustom; Program - Fire Left... Move - wave... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,19;16		
defb 	evtSettingsBank_Save,2

defb 0,evtReprogramCustomMove1
defw CustomMove1





; Side Snapper Right
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,PrgFireMid+11,mveCustom1+1,lifCustom; Program - Fire Left... Move - wave... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,14	
defb 	evtSettingsBank_Save,3

defb 0,evtReprogramCustomMove1
defw CustomMove1




;Floater
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,PrgFireMid+9,mveCustom2+2,lifCustom; Program - Fire Left... Move - wave... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+19	
defb 	evtSettingsBank_Save,4

defb 0,evtReprogramCustomMove2
defw CustomMove2



; Glider Right
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgFireMid2+10,&29,lifEnemy+10	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+19
defb 	evtSettingsBank_Save,5

; Glider Left
defb 0,evtMultipleCommands+3	
defb 	evtSetProgMoveLife,prgFireMid2+10,&2F,lifEnemy+10	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+22
defb 	evtSettingsBank_Save,7



; Falling Rock
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prtSpriteAlt,&74,lifEnemy+10	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,13			;7b
defb 	evtSettingsBank_Save,6

; BigFlame
defb 0,evtMultipleCommands+2
defb 	evtSetProgMoveLife,0,mveBackground+%00000001,lifDeadly+8	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSettingsBank_Save,8

; VolcaRok
defb 0,evtMultipleCommands+2
defb 	evtSetProgMoveLife,0,mveBackground+%00000001,0	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSettingsBank_Save,9


; Ball of fire
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,0,&61,lifEnemy+20	; &67
defb 	evtSetSprite,TwoFrameSprite+31		;
defb 	evtSettingsBank_Save,10


; Ball of fire
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,0,&67,lifEnemy+20	; &67
defb 	evtSetSprite,TwoFrameSprite+10		;
defb 	evtSettingsBank_Save,11



;SideSnappers
defb 0,evtMultipleCommands +2
defb 	evtSettingsBank_Load +3
defb 	evtSingleSprite,128+14,160-12+24,199
;defb 	evtSettingsBank_Load +2
;defb 	evtSingleSprite,128+19,24,199




;Palette Change
defb 1,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 0
	defb &54,&54,&44,&40

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 32			
	defb &54,&54,&44,&40	

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 0				
	defb &54,&54,&44,&40		

	defb 240,26*2+6,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 0				
	defb &54,&54,&44,&40			


; Load Palette

	defb 2,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 0				
	defb &54,&58,&5F,&4B		;Black,DkBlue,LtYellow,White

	defb 240,26*0+6,5*1+1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1	; Switches
	defb 32	;delay			
	defb &54,&5D,&53,&4B


	defb 240,26*1+6,1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0

	defb 240,26*2+6,5*1+1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1 ; no of switches
	defb 0	;delays			
	defb &54,&4D,&5B,&4B		

defb 2,evtCallAddress			;Start the palette switcher
defw	RasterColorsStartPalleteFlip



;	defb 5 
;	defb 136				; Jump to a different level point
;	defw LevelEndAnim				; pointer
;	defb 145



;Floater
defb 8,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb	evtSingleSprite,TwoFrameSprite+16,24*3,199+24
defb	evtSingleSprite,TwoFrameSprite+17,24*3+12,199+24

;VolcaRok
defb 16,evtMultipleCommands +2
defb 	evtSettingsBank_Load +9
defb	evtSingleSprite,27,160+24-12,199+24

;VolcaRok
defb 16,evtMultipleCommands +2
defb 	evtSettingsBank_Load +9
defb	evtSingleSprite,26,24,199+24


;Floater
defb 24,evtMultipleCommands +4
defb 	evtSettingsBank_Load +4
defb evtSetMove,mveCustom2+5
defb	evtSingleSprite,TwoFrameSprite+16,24*6,199+24
defb	evtSingleSprite,TwoFrameSprite+17,24*6+12,199+24

;Glider Right
defb 32,evtMultipleCommands +2
defb 	evtSettingsBank_Load +5
defb	evtSingleSprite,TwoFrameSprite+18,160+24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4


;Glider Left
defb 32,evtMultipleCommands +2
defb 	evtSettingsBank_Load +7
defb	evtSingleSprite,TwoFrameSprite+21,24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4



;Ball of fire
defb 32,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb	evtSingleSprite,TwoFrameSprite+31,160+24-12,199+24-32

;Falling Rock
defb 48,evtMultipleCommands +2
defb 	evtSettingsBank_Load +6
defb	evtSingleSprite,13,24+40-3,8

;Ball of fire
defb 48,evtMultipleCommands +2
defb 	evtSettingsBank_Load +11
defb	evtSingleSprite,TwoFrameSprite+9,24+12,199+24-64


;Glider Left
defb 64,evtMultipleCommands +2
defb 	evtSettingsBank_Load +7
defb	evtSingleSprite,TwoFrameSprite+21,24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4

;SideSnappers
defb 64,evtMultipleCommands +2
;defb 	evtSettingsBank_Load +3
;defb 	evtSingleSprite,128+14,160-12+24,199
defb 	evtSettingsBank_Load +2
defb 	evtSingleSprite,128+19,24,199


;Ball of fire
defb 64,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb	evtSingleSprite,TwoFrameSprite+31,160+24-12,199+24-96+8

;Spike on Left
defb 64,evtMultipleCommands +3
defb 	evtSettingsBank_Load +0
defb	evtSetLife,lifEnemy+30
defb	evtTileSprite+6,24,199+24,12,	8,8,0,1,2,3



;Ball of fire
defb 72,evtMultipleCommands +2
defb 	evtSettingsBank_Load +11
defb	evtSingleSprite,TwoFrameSprite+9,24+12,199+24-128+8

;Falling Rock
defb 72,evtMultipleCommands +2
defb 	evtSettingsBank_Load +6
defb	evtSingleSprite,13,24+120-3,8

;Floater
defb 72,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb	evtSingleSprite,TwoFrameSprite+16,24*6,199+24
defb	evtSingleSprite,TwoFrameSprite+17,24*6+12,199+24


;Floater
defb 88,evtMultipleCommands +4
defb 	evtSettingsBank_Load +4
defb evtSetMove,mveCustom2+6
defb	evtSingleSprite,TwoFrameSprite+16,24*3,199+24
defb	evtSingleSprite,TwoFrameSprite+17,24*3+12,199+24



;Ball of fire
defb 88,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb	evtSingleSprite,TwoFrameSprite+31,160+24-12,199+24-160+16


;Spike on Right
defb 88,evtMultipleCommands +3
defb 	evtSettingsBank_Load +0
defb	evtSetLife,lifEnemy+30
defb	evtTileSprite+6,160+24-72,199+24,12,	4,5,6,7,8,8






;Ball of fire
defb 104,evtMultipleCommands +2
defb 	evtSettingsBank_Load +11
defb	evtSingleSprite,TwoFrameSprite+9,24+12,199+24-192+16


;VolcaRok
defb 116,evtMultipleCommands +2
defb 	evtSettingsBank_Load +9
defb	evtSingleSprite,27,160+24-12,199+24



;VolcaRok
defb 124,evtMultipleCommands +2
defb 	evtSettingsBank_Load +9
defb	evtSingleSprite,26,24,199+24


;Falling Rock
defb 124,evtMultipleCommands +2
defb 	evtSettingsBank_Load +6
defb	evtSingleSprite,13,24+40-3,8


;Floater
defb 124,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb	evtSingleSprite,TwoFrameSprite+16,24*3,199+24
defb	evtSingleSprite,TwoFrameSprite+17,24*3+12,199+24



;Floater
defb 148,evtMultipleCommands +4
defb 	evtSettingsBank_Load +4
defb evtSetMove,mveCustom2+6
defb	evtSingleSprite,TwoFrameSprite+16,24*6,199+24
defb	evtSingleSprite,TwoFrameSprite+17,24*6+12,199+24

;BigFlame
defb 148,evtMultipleCommands +4
defb 	evtSettingsBank_Load +8
defb	evtTileSprite+5,24+160-60-12,199+24-47-16,12,	TwoFrameSprite+28,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+30
defb 	evtSettingsBank_Load +8
defb	evtTileSprite+7,24+12,199+24-47,12,	TwoFrameSprite+10,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+12


;Glider Left
defb 164,evtMultipleCommands +2
defb 	evtSettingsBank_Load +7
defb	evtSingleSprite,TwoFrameSprite+21,24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4




;SideSnappers
defb 164,evtMultipleCommands +4
defb 	evtSettingsBank_Load +3
defb 	evtSingleSprite,128+14,160-12+24,199
defb 	evtSettingsBank_Load +2
defb 	evtSingleSprite,128+19,24,199


;BigFlame
defb 172,evtMultipleCommands +4
defb 	evtSettingsBank_Load +8
defb	evtTileSprite+7,24+160-84-12,199+24-96-16,12,	TwoFrameSprite+28,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+30
defb 	evtSettingsBank_Load +8
defb	evtTileSprite+5,24+12,199+24-96,12,	TwoFrameSprite+10,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+12


;Falling Rock
defb 174,evtMultipleCommands +2
defb 	evtSettingsBank_Load +6
defb	evtSingleSprite,13,24+120-3,8


;Glider Left
defb 196,evtMultipleCommands +2
defb 	evtSettingsBank_Load +7
defb	evtSingleSprite,TwoFrameSprite+21,24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4


;BigFlame
defb 196,evtMultipleCommands +4
defb 	evtSettingsBank_Load +8
defb	evtTileSprite+5,24+160-60-12,199+24-141-16,12,	TwoFrameSprite+28,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+30
defb 	evtSettingsBank_Load +8
defb	evtTileSprite+7,24+12,199+24-141,12,	TwoFrameSprite+10,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+12


;Falling Rock
defb 220,evtMultipleCommands +2
defb 	evtSettingsBank_Load +6
defb	evtSingleSprite,13,24+80-3,8


;Floater
defb 220,evtMultipleCommands +4
defb 	evtSettingsBank_Load +4
defb evtSetMove,mveCustom2+5
defb	evtSingleSprite,TwoFrameSprite+16,24*3,199+24
defb	evtSingleSprite,TwoFrameSprite+17,24*3+12,199+24


;Glider Right
defb 220,evtMultipleCommands +2
defb 	evtSettingsBank_Load +5
defb	evtSingleSprite,TwoFrameSprite+18,160+24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4


;Glider Left
defb 220,evtMultipleCommands +2
defb 	evtSettingsBank_Load +7
defb	evtSingleSprite,TwoFrameSprite+21,24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4



;Floater
defb 230,evtMultipleCommands +4
defb 	evtSettingsBank_Load +4
defb evtSetMove,mveCustom2+7
defb	evtSingleSprite,TwoFrameSprite+16,24*6,199+24
defb	evtSingleSprite,TwoFrameSprite+17,24*6+12,199+24

;Glider Right
defb 240,evtMultipleCommands +2
defb 	evtSettingsBank_Load +5
defb	evtSingleSprite,TwoFrameSprite+18,160+24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4


;Glider Left
defb 240,evtMultipleCommands +2
defb 	evtSettingsBank_Load +7
defb	evtSingleSprite,TwoFrameSprite+21,24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4


;Floater
defb 250,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb	evtSingleSprite,TwoFrameSprite+16,24*3,199+24
defb	evtSingleSprite,TwoFrameSprite+17,24*3+12,199+24

;Glider Right
defb 1,evtMultipleCommands +4
defb 	evtSettingsBank_Load +5
defb	evtSingleSprite,TwoFrameSprite+18,160+24,24
defb 	evtSettingsBank_Load +7
defb	evtSingleSprite,TwoFrameSprite+21,24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4




;SideSnappers
defb 8,evtMultipleCommands +4
defb 	evtSettingsBank_Load +3
defb 	evtSingleSprite,128+14,160-12+24,199
defb 	evtSettingsBank_Load +2
defb 	evtSingleSprite,128+19,24,199



;VolcaRok
defb 16,evtMultipleCommands +2
defb 	evtSettingsBank_Load +9
defb	evtSingleSprite,27,160+24-12,199+24

;Glider Left
defb 16,evtMultipleCommands +2
defb 	evtSettingsBank_Load +7
defb	evtSingleSprite,TwoFrameSprite+21,24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4



;VolcaRok
defb 24,evtMultipleCommands +2
defb 	evtSettingsBank_Load +9
defb	evtSingleSprite,26,24,199+24


;Falling Rock
defb 24,evtMultipleCommands +2
defb 	evtSettingsBank_Load +6
defb	evtSingleSprite,13,24+40-3,8



;VolcaRok
defb 48,evtMultipleCommands +2
defb 	evtSettingsBank_Load +9
defb	evtSingleSprite,27,160+24-12,199+24

;VolcaRok
defb 48,evtMultipleCommands +2
defb 	evtSettingsBank_Load +9
defb	evtSingleSprite,26,24,199+24


;BigFlame
defb 48,evtMultipleCommands +4
defb 	evtSettingsBank_Load +8
defb	evtTileSprite+5,24+160-60-12,199+24-47-16,12,	TwoFrameSprite+28,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+30
defb 	evtSettingsBank_Load +8
defb	evtTileSprite+7,24+12,199+24-47,12,	TwoFrameSprite+10,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+12


;Ball of fire
defb 64,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb	evtSingleSprite,TwoFrameSprite+31,160+24-12,199+24-32

;BigFlame
defb 72,evtMultipleCommands +4
defb 	evtSettingsBank_Load +8
defb	evtTileSprite+7,24+160-84-12,199+24-96-16,12,	TwoFrameSprite+28,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+30
defb 	evtSettingsBank_Load +8
defb	evtTileSprite+5,24+12,199+24-96,12,	TwoFrameSprite+10,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+12


;Glider Right
defb 74,evtMultipleCommands +2
defb 	evtSettingsBank_Load +5
defb	evtSingleSprite,TwoFrameSprite+18,160+24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4


;Glider Left
defb 74,evtMultipleCommands +2
defb 	evtSettingsBank_Load +7
defb	evtSingleSprite,TwoFrameSprite+21,24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4


;Falling Rock
defb 74,evtMultipleCommands +4
defb 	evtSettingsBank_Load +6
defb	evtSingleSprite,13,24+120-3,8
defb	evtSingleSprite,13,24+80-3,8
defb	evtSingleSprite,13,24+40-3,8


;Floater
defb 80,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb	evtSingleSprite,TwoFrameSprite+16,24*3,199+24
defb	evtSingleSprite,TwoFrameSprite+17,24*3+12,199+24



;Floater
defb 80,evtMultipleCommands +4
defb 	evtSettingsBank_Load +4
defb evtSetMove,mveCustom2+6
defb	evtSingleSprite,TwoFrameSprite+16,24*6,199+24
defb	evtSingleSprite,TwoFrameSprite+17,24*6+12,199+24

;Falling Rock
defb 80,evtMultipleCommands +4
defb 	evtSettingsBank_Load +6
defb	evtSingleSprite,13,24+40-3,8
defb	evtSingleSprite,13,24+80-3,8
defb	evtSingleSprite,13,24+120-3,8

;Ball of fire
defb 80,evtMultipleCommands +2
defb 	evtSettingsBank_Load +11
defb	evtSingleSprite,TwoFrameSprite+9,24+12,199+24-64

;Ball of fire
defb 88,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb	evtSingleSprite,TwoFrameSprite+31,160+24-12,199+24-96+8


;BigFlame
defb 96,evtMultipleCommands +4
defb 	evtSettingsBank_Load +8
defb	evtTileSprite+5,24+160-60-12,199+24-141-16,12,	TwoFrameSprite+28,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+29,TwoFrameSprite+30
defb 	evtSettingsBank_Load +8
defb	evtTileSprite+7,24+12,199+24-141,12,	TwoFrameSprite+10,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+11,TwoFrameSprite+12

;Glider Right
defb 96,evtMultipleCommands +2
defb 	evtSettingsBank_Load +5
defb	evtSingleSprite,TwoFrameSprite+18,160+24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4


;Glider Left
defb 96,evtMultipleCommands +2
defb 	evtSettingsBank_Load +7
defb	evtSingleSprite,TwoFrameSprite+21,24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4



;Spike on Left
defb 102,evtMultipleCommands +3
defb 	evtSettingsBank_Load +0
defb	evtSetLife,lifEnemy+30
defb	evtTileSprite+6,24,199+24,12,	8,8,0,1,2,3





;Ball of fire
defb 104,evtMultipleCommands +2
defb 	evtSettingsBank_Load +11
defb	evtSingleSprite,TwoFrameSprite+9,24+12,199+24-128+8

;Spike on Right
defb 116,evtMultipleCommands +3
defb 	evtSettingsBank_Load +0
defb	evtSetLife,lifEnemy+30
defb	evtTileSprite+6,160+24-72,199+24,12,	4,5,6,7,8,8

;Ball of fire
defb 120,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb	evtSingleSprite,TwoFrameSprite+31,160+24-12,199+24-160+16


;Floater
defb 120,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb	evtSingleSprite,TwoFrameSprite+16,24*6,199+24
defb	evtSingleSprite,TwoFrameSprite+17,24*6+12,199+24

;Falling Rock
defb 120,evtMultipleCommands +2
defb 	evtSettingsBank_Load +6
defb	evtSingleSprite,13,24+80-3,8

;Glider Right
defb 120,evtMultipleCommands +2
defb 	evtSettingsBank_Load +5
defb	evtSingleSprite,TwoFrameSprite+18,160+24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4


;Glider Left
defb 136,evtMultipleCommands +2
defb 	evtSettingsBank_Load +7
defb	evtSingleSprite,TwoFrameSprite+21,24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4




;Ball of fire
defb 136,evtMultipleCommands +2
defb 	evtSettingsBank_Load +11
defb	evtSingleSprite,TwoFrameSprite+9,24+12,199+24-192+16

;Floater
defb 136,evtMultipleCommands +4
defb 	evtSettingsBank_Load +4
defb evtSetMove,mveCustom2+6
defb	evtSingleSprite,TwoFrameSprite+16,24*3,199+24
defb	evtSingleSprite,TwoFrameSprite+17,24*3+12,199+24



;Glider Right
defb 140,evtMultipleCommands +2
defb 	evtSettingsBank_Load +5
defb	evtSingleSprite,TwoFrameSprite+18,160+24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4


;Glider Left
defb 150,evtMultipleCommands +2
defb 	evtSettingsBank_Load +7
defb	evtSingleSprite,TwoFrameSprite+21,24,24
;defb 	evtSetLife,LifEnemy+10
;defb	evtSingleSprite,TwoFrameSprite+19,24*4+6,24*4




;Spike on Right
defb 150,evtMultipleCommands +3
defb 	evtSettingsBank_Load +0
defb	evtSetLife,lifEnemy+30
defb	evtTileSprite+6,160+24-72,199+24,12,	4,5,6,7,8,8





;defb 160,%01110000+2			; 3 commands at the same timepoint
;defb evtSetProgMoveLife,prgMovePlayer,&24,10
;defb 	0,21,80+24,190	; 	; Single Object sprite 11 (animated)




LevelEndAnim:
;defb 160,%01110000+2			; 3 commands at the same timepoint
;defb evtSetProgMoveLife,prgMovePlayer,&24,10
;defb 	0,128+	20,140+24,100+24	; 	; Single Object sprite 11 (animated)

defb 160,%10001001			;Call a memory location
defw	ClearBadguys
;Palette Change
defb 162,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*2+6,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40	





defb 163,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*2+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

defb 163,evtCallAddress			;Call a memory location
defw	EndLevel

;Illuminate

;Palette Change
;defb 2,%01110000+5			; 4 Commands
;	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
;	defb 1
;	defb 1				
;	defb &54,&40,&4C,&4B	IlluminatedPaletteA_Plus2

;	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
;	defb 1
;	defb 1				
;	defb &54,&40,&4C,&4B	IlluminatedPaletteB_Plus2

;	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
;	defb 0
;	defb 1				
;	defb &54,&40,&4C,&4B	IlluminatedPaletteC_Plus2	

;	defb 240,26*2+6,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
;	defb 1
;	defb 1				
;	defb &54,&40,&4C,&4B	IlluminatedPaletteD_Plus2

;defb 	evtJumpToNewTime
;defw 	&6969		EndIlluminatePointer_Plus2	; pointer
;defb	 &69		EndIlluminateTime_Plus1	; new time




EndLevel:
	pop hl	;
	ld hl,	&01FA
	jp	Akuyou_ExecuteBootStrap	; Start the game, no return


ClearBadguys:
	ld a,1
	ld i,a
	push hl
	call Akuyou_DoSmartBombCall
	pop hl
ret


LevelInit:

	; wipe our memory, to clear out any junk from old levels
	ld de,&51
	ld hl,&50
	ld bc,&5FF
	ld (hl),0
	ldir 


	;Fix up the Alt Palette - not needed if the palette is in the saved level code
	;ld hl,&0001
	;ld (RasterColors_ColorArray1Alt),hl
	;ld (RasterColors_ColorArray2Alt),hl
	;ld (RasterColors_ColorArray3Alt),hl
	;ld (RasterColors_ColorArray4Alt),hl
	call AkuYou_Player_GetPlayerVars
	ld a,(iy-5)
	ld (PaletteNo_Plus1-1),a
	ld hl,null
	cp 64
	jp nz,LevelInitUsingRasterFlip
	ld (DisablePaletteSwitcher_Plus2-2),hl
LevelInitUsingRasterFlip:
	call RasterColorsSetPalette1


	ld a, StarArraySize
	ld hl,StarArrayPointer
	call AkuYou_StarArrayInit_Enemy 

	ld a, PlayerStarArraySize
	ld hl,PlayerStarArrayPointer
	call AkuYou_StarArrayInit_Player 

	ld a,ObjectArraySize
	ld hl,ObjectArrayPointer
	call AkuYou_ObjectArray_Init

	ld hl,EventStreamArray		;Event Stream
	ld de,Event_SavedSettings	;Saved Settings
	call AkuYou_Event_StreamInit

	ld hl,LevelSprites		
	ld de,PlayerSprites
	call AkuYou_SpritePointerInit

	call AkuYou_Player_GetPlayerVars
	ld a,80+24
	ld (iy+1),a
	call Akuyou_Music_Restart

	call Akuyou_ScreenBuffer_Init
	call Akuyou_RasterColors_Init

	;call RasterColors_Reset
LevelLoop:
	

	;ld a,128+0
	;ld hl,(BossObject1)
	;call SetSprite

	call Akuyou_Background_Clear
	;ld l,&08
	;call Timer_Stop
	;ld l,&09
	;call Timer_Stop
	;ld a,"B"
	;call &bb5a 


	call Akuyou_EventStream_Process
	;ld l,&0a
	;call Timer_Stop
	;ld a,"S"
	;call &bb5a 


	call Akuyou_ObjectArray_Redraw
	;ld l,&0b
	;call Timer_Stop
	;ld a,"O"
	;call &bb5a 

	call Akuyou_Player_Handler
	;ld l,&0c
	;call Timer_Stop
	;ld a,"P"
	;call &bb5a 



	call Akuyou_StarArray_Redraw
	;ld l,&0d
	;call Timer_Stop
	;ld a,"S"
	;call &bb5a 


	call AkuYou_Player_StarArray_Redraw
	;ld l,&0e
	;call Timer_Stop
	;ld a,"F"
	;call &bb5a 


	call AkuYou_Player_DrawUI

	call Akuyou_PlaySfx


	ifdef debug
	call ShowLevelTime
	endif

	call Akuyou_ScreenBuffer_Flip



	jp LevelLoop

LevelShutdown:

ret


ShowLevelTime:
	;ld hl,&C000
	;call Akuyou_ShowSprite_SetBankAddr
	call Akuyou_SpriteBank_Font

	ld hl,&1001
	call Akuyou_DrawText_LocateSprite

	call Akuyou_GetLevelTime
	push bc	
	call ShowHex
	pop bc
	ld a,b
	call ShowHex
ret


ShowHex:

	push af         ;store original byte value
	rrca            
	rrca
	rrca
	rrca
	call ShowHexDigit
	pop af          ;retrieve original byte value

ShowHexDigit:
;	and %00001111   ;isolate lower nibble. (This contains the digit value 0...15)
;	add a,"0"       ;add ASCII for 0. Digits 0...9 become "0"..."9", digits 10..15
;	cp "9"+1        
;	jr c,ShowHexDigitNum     ;if number is in digit range 0...9, display digit
;	add a,"A"-"9"-1 ;modify ASCII value so that digits in the range 10...15
and %00001111   ;isolate lower nibble. (This contains the digit value 0...15)
cp &a           ;Less than 10?  Set carry if so
sbc a,&69
daa             ;Because previous instruction was a subtract operation this
                ;is known as 'das' in x86
ShowHexDigitNum:
	jp Akuyou_DrawText_CharSprite   ;display digit


RasterColorsStartPalleteFlip:
	push iy
		call AkuYou_Player_GetPlayerVars
		ld a,(iy-5)
		ld (PaletteNo_Plus1-1),a
	pop iy
ret

RasterColorsSetPalette1:
	ld a,1
	ld bc,RasterColors_ColorArray1
	ld de,RasterColors_ColorArray2
	ld hl,RasterColors_ColorArray3
	ld ix,RasterColors_ColorArray4
	ld iy,PaletteSwitcher :DisablePaletteSwitcher_Plus2
jp Akuyou_RasterColors_SetPointers

PaletteSwitcher:
	ld a,64:PaletteNo_Plus1
	cpl	
	ld (PaletteNo_Plus1-1),a
	or a
	jp nz,RasterColorsSetPalette1
RasterColorsSetPalette2:
	ld a,1
	ld bc,RasterColors_ColorArray1Alt
	ld de,RasterColors_ColorArray2Alt
	ld hl,RasterColors_ColorArray3Alt
	ld ix,RasterColors_ColorArray4Alt
	ld iy,PaletteSwitcher
jp Akuyou_RasterColors_SetPointers












CustomMoveHandlerQuadSpriteYoYo:

;		ld a,iyl ; Program Code
;		ld a,ixl ;Life  - MOVED INTO af'
;		ld a,iyh ;spr
;		ld (hl),ixh ;Move
;		ld (hl),b ;X
;		ld (hl),c ;Y

	push de
		ld d,mveBackground+1 ; Move
		call Akuyou_DoMoves
	pop de
	;    +          -  
	; 0  1 2  3  4  5   6    7 
	;1a 1b 2a 2b 2b 2a  1b   1a

;	Akuyou_ObjectProgram_SpriteBankSwitch
	call Akuyou_Timer_GetTimer

	;bit a,2
	;jr nz, CustomMoveHandlerQuadSpriteResetSprite	
	;bit a,1
	;jr nz, CustomMoveHandlerQuadSpriteIncSprite



	ld a,i
	and %00000111
	cp  %00000110 ;bit a,2
	jr z, CustomMoveHandlerQuadSpriteResetSprite	
	cp  %00000010 ;bit a,1
	jr z, CustomMoveHandlerQuadSpriteIncSprite
	

CustomMoveHandlerQuadSpriteContinue:
	cp %00000101
	jr c,CustomMoveHandlerQuadSpriteContinue2
	cpl
CustomMoveHandlerQuadSpriteContinue2:
	bit 0,a
	ret nz
	jp Akuyou_ObjectProgram_SpriteBankSwitch


CustomMoveHandlerQuadSpriteIncSprite:
	ld a,iyh
	inc a
	ld iyh,a
	jr CustomMoveHandlerQuadSpriteContinue

CustomMoveHandlerQuadSpriteResetSprite
	ld a,iyh
	dec a
	ld iyh,a
	jr CustomMoveHandlerQuadSpriteContinue


CustomObjectHitHandler:

	ld a,ixh
	and %11110000
	cp mveCustom2
	jr nz,CustomObjectHitHandler_Finish	
	

	ld a,ixl
	cp lifEnemy+3
	jp nc,CustomObjectHitHandler_Finish
	ld a,ixh
	di 
	exx
	push ix
		call GetCustomRam
		xor a
		ld (ix+3),a
	pop ix
	exx
	ld a,1
	ld ixl,a
	ei
CustomObjectHitHandler_Finish:
	jp Akuyou_Object_DecreaseLifeShot



CustomMove1:
	di
	exx
	ld hl,null
	ld de,CustomMoveHandlerQuadSpriteYoYo
	ld bc,CustomMovePattern_Init30

jr CustomMovePattern


CustomMove2:
	di
	exx
	ld hl,CustomMovePatternGeneric
	ld de,CustomMovePatternWaveB_With_Lifelink ; need CustomObjectHitHandler 
	ld bc,CustomMovePattern_InitLifeLink

;	ld de,CustomMovePatternLifeLinkB
;	ld bc,CustomMovePattern_InitLifeLink
jr CustomMovePattern

CustomMovePatternWaveB_With_Lifelink:
	call CustomMovePatternWaveB
	jp CustomMovePatternLifeLinkB


CustomMove3:
	di
	exx
	ld hl,CustomMovePatternGeneric
	ld de,CustomMovePatternCircleInfiniteb
	ld bc,CustomMovePattern_Init10

jr CustomMovePattern


CustomMove4:
	di
	exx
	ld hl,CustomMovePatternGeneric
	ld de,CustomMovePatternLifeLinkB
	ld bc,CustomMovePattern_InitLifeLink

jr CustomMovePattern

GetCustomRam:
	and %00001111
		ld hl,CustomRam
			
			ld d,0
			ld e,a
			add hl,de
			add hl,de
			add hl,de
			add hl,de
		push hl
		pop ix
ret

CustomMovePattern:		; B=X C=Y D=Move
	ld (CustomPatternJump_Plus2-2),hl
	ld (CustomPatternbJump_Plus2-2),de
	ld (CustomMovePattern_Init_Plus2-2),bc
	exx



;		ld a,iyl ; Program Code
;		ld a,ixl ;Life  - MOVED INTO af'
;		ld a,iyh ;spr
;		ld (hl),ixh ;Move
;		ld (hl),b ;X
;		ld (hl),c ;Y

		

	ld a,ixl	;lifCustom 
	ex af,af'

	ld a,d
	exx
	push ix


		call GetCustomRam

		call Akuyou_Timer_GetTimer
		ld d,a
		ld a,i	; Level time
		ld e,a


		;dont update more than once per tick! 
		ld a,(ix+1)
		cp e
		jr z,CustomMovePattern_NoTick	
		ld a,e
		ld (ix+1),e

		;see if this is our first run
		ex af,af'
			cp 250
			call nc,CustomMovePattern_Init :CustomMovePattern_Init_Plus2
		ex af,af'


		; here is where we make some moves!
		exx
		call CustomMovePatternGeneric :CustomPatternJump_Plus2
		exx
		;increment the pos
	

CustomMovePattern_NoTick:
		
		; here is where we make some moves!
		exx
		call null :CustomPatternbJump_Plus2


		ld a,b
		cp 160+24
		call NC,CustomMovePatternKill
		exx
		;increment the pos
	


	;	jp CustomMovePattern_Done

CustomMovePattern_Done:


	ld a,iyl
	cp prgSpecial
	jr nz,CustomMovePattern_NotBossTarget
	ld a,0:TargetSpritecountdown_Plus1
	or a
	jr z,CustomMovePattern_TargetReset
	dec a
	ld (TargetSpritecountdown_Plus1-1),a
CustomMovePattern_TargetSet:
	ld a,128+9	:HitTargetSprite_Plus1
	ld iyh,a
	jr CustomMovePattern_NotBossTarget
CustomMovePattern_TargetReset:
	ld a,128+8 	:ResetTargetSprite_Plus1
	ld iyh,a
CustomMovePattern_NotBossTarget:
	pop ix
	exx

	ex af,af'

	ld ixl,a	;lifCustom 


ei
ret

CustomMovePattern_InitImmortal:
	call CustomMovePattern_Init
	ld a,0		;New Life
ret
CustomMovePattern_InitInvincible:
	call CustomMovePattern_Init
	ld a,lifDeadly+63		;New Life

ret

CustomMovePattern_Init10:
	call CustomMovePattern_Init
	ld a,lifEnemy+10		;New Life
ret
CustomMovePattern_Init30:
	call CustomMovePattern_Init
	ld a,lifEnemy+30		;New Life
ret

CustomMovePattern_InitLifeLink:
	call CustomMovePattern_Init
	ld a,lifEnemy+10		;New Life
	ld (ix+3),a
ret

CustomMovePattern_Init:

	xor a
	;exx
	;B=X
	;C=Y
	;exx

	ld (ix+0),a
	ld (ix+1),a
	ld (ix+2),a
	ld (ix+3),a

	ld a,lifEnemy+6			;New Life

ret



CustomMovePatternGeneric: 

	ld a,(ix+0)
	inc a
	ld (ix+0),a	
ret



CustomMovePatternLifeLinkB:
	ld a,(ix+3)
	and %00111111
	jp z,CustomMovePatternKill

	ld a,(ix+3)
	exx
	ld b,a
	ex af,af'

	cp b
	jr nc,CustomMovePatternLifeLinkGreater
	ld (ix+3),a
	jr CustomMovePatternLifeLinkDone	
CustomMovePatternLifeLinkGreater:
	ld a,b
;	ld (ix+3),a
CustomMovePatternLifeLinkDone:
	ex af,af'
	exx
ret

CustomMovePatternWaveB:
	ld a,(ix+0)

	and %00111111 ; Size of wave
CustomMovePatternWaveContinue
		
	cp 32 ; Size of wave
	jr C,CustomMovePatternWaveLeft

	inc b ; this happens half the time 
	jr CustomMovePatternWaveDone

CustomMovePatternWaveLeft:
	dec b ; this happens half the time 
	jr CustomMovePatternWaveDone

CustomMovePatternWaveDone:	
	dec c	; this happens every move
ret

CustomMovePatternKill:
	;ex af,af'
	;xor a
	
	ld b,0
	ld c,b
	ld D,b
	;ex af,af'
ret

;CustomMovePatternCircle: ;
;
;	ld a,(ix+0)
;	inc a
;	ld (ix+0),a	
;ret

CustomMovePatternCircleb:
	;ld a,(ix+2)
	;or a
	;jr nz,CustomMovePatternCirclebMoveLeftDone

	call Akuyou_Timer_GetTimer
	bit 2,a
	jr z,CustomMovePatternCirclebMoveLeftDone

	inc b
	;ld a,(ix+0)
	;cp 192
	;jr nz,CustomMovePatternCirclebMoveLeftDone
	;ld a,1
	;ld (ix+2),a

CustomMovePatternCirclebMoveLeftDone:
	ld a,(ix+0)
	cpl
	;and %11110000
	and %00111100
	rrca
	rrca
	jr CustomMovePatternCircleProcess




CustomMovePatternCircleInfiniteb:
	ld a,(ix+2)

	or a
	jr nz,CustomMovePatternCircleInfinitebMoveLeftDone

	call Akuyou_Timer_GetTimer
	bit 2,a
	jr z,CustomMovePatternCircleInfinitebMoveLeftDone

	inc b
	ld a,(ix+0)
	cp 128
	jr NC,CustomMovePatternCircleInfinitebMoveLeftDone
	ld a,1
	ld (ix+2),a

CustomMovePatternCircleInfinitebMoveLeftDone:
	ld a,(ix+0)
	cpl
	and %01111000
	rrca
	rrca
	rrca
	jr CustomMovePatternCircleProcess




CustomMovePatternCircleProcess:
	exx
	;push bc
	;push hl
		ld hl,CustomMovePatternVector
		ld b,0
		ld c,a
		add hl,bc	;add twice for a two byte address
		add hl,bc
		ld a,(hl)		; read the two bytes in		
		inc hl
		ld h,(hl)
		ld l,a		; hl now is the memory loc of the line
		ld (CircleJump_Plus2-2),hl
	;pop hl
	;pop bc
	exx
	jp CustomMovePatternCircle1:CircleJump_Plus2


CustomMovePatternVector:
defw CustomMovePatternCircle1
defw CustomMovePatternCircle2
defw CustomMovePatternCircle3
defw CustomMovePatternCircle4
defw CustomMovePatternCircle5
defw CustomMovePatternCircle6
defw CustomMovePatternCircle7
defw CustomMovePatternCircle8
defw CustomMovePatternCircle9
defw CustomMovePatternCircle10
defw CustomMovePatternCircle11
defw CustomMovePatternCircle12
defw CustomMovePatternCircle13
defw CustomMovePatternCircle14
defw CustomMovePatternCircle15
defw CustomMovePatternCircle16

CustomMovePatternCircle1:	
	
	dec c	
	dec c
	
CustomMovePatternCircle2:	

	dec c	
	dec c	

CustomMovePatternCircle3:	
	dec b	
	dec b
	jr CustomMovePatternCircleDone

CustomMovePatternCircle5:	

	inc c
	inc c

CustomMovePatternCircle4:	
	dec b	
	dec b
	inc c
	inc c
	jr CustomMovePatternCircleDone
CustomMovePatternCircle6:	
	dec b	

CustomMovePatternCircle7:
	inc c
	inc c	

	inc c	
	inc c
	jr CustomMovePatternCircleDone
CustomMovePatternCircle8:
	inc b
	inc c	
	inc c

	inc c	
	inc c
	jr CustomMovePatternCircleDone
CustomMovePatternCircle9:	

	inc c	
	inc c

CustomMovePatternCircle10:	
	inc b
	inc b	
	inc c	
	inc c	
	jr CustomMovePatternCircleDone


CustomMovePatternCircle13:	
	dec c	
	dec c	
CustomMovePatternCircle12:	

	dec c
	dec c	
CustomMovePatternCircle11:	
	inc b
	inc b	
	jr CustomMovePatternCircleDone
CustomMovePatternCircle14:	
	inc b	
CustomMovePatternCircle15:	
	dec c	
	dec c	
	dec c	
	dec c	
	jr CustomMovePatternCircleDone
CustomMovePatternCircle16:	
	dec b
	dec c	
	dec c	
	dec c	
	dec c	
	jr CustomMovePatternCircleDone

CustomMovePatternCircleDone:
;	ld a,b
;	cp 160+24
;	jp NC,CustomMovePatternKill
ret



CustomProgram1:
	call Akuyou_Timer_GetTimer
	ld a,i	; Level time
	and %00000011
	;rrca
	add 16
	ld iyl,a		; Program Fire
	push bc
	push de
	push iy
	call Akuyou_FireStar
	pop iy
	pop de
	pop bc


	ld a,iyl
	add 4
	ld iyl,a
	jp Akuyou_FireStar


CustomProgram2:
	call Akuyou_Timer_GetTimer
	ld a,i	; Level time
	bit 0,a
	jr z,CustomProgram2_Fire2

	ld a,17
	ld iyl,a
	jp Akuyou_FireStar

CustomProgram2_Fire2:
	ld a,23
	ld iyl,a
	jp Akuyou_FireStar




null:ret

limit &3fff
org &3ff0
jp LevelInit; - Level Start &3ff0
jp LevelLoop; - Level loop &3ff3
jp null     ; - Level resume &3ff6
jp null     ; - Level Shutdown &3ff9


save direct "T25-SC1.D02",&2300,&1D00	;address,size...}[,exec_address]



