;
;
; Example for Real3D Versin 3.00
; Code: Chc/Chc!Productions
;
;

; Segmento de pila

pila    SEGMENT para stack 'STACK'

        dw 512 dup(0)

pila    ENDS

; Segmento de datos

data    SEGMENT para public 'DATA'

        include 3d.inc
        include poly.inc        ; las definiciones de las variables que usa
                                ; la rutina de polgonos...
        escape db 0             ; la variable de la tecla ESC
        multable dw 0           ; segmento de preclculo de divisiones

        paleta LABEL BYTE
        include paleta.inc

        ;mensaje final
        mensaje LABEL BYTE
                db " Micaco BBS +34-3-3986824, 28k8",13,10
                db "  Internet, 14 CD-ROMS on-line i molt ms!",13,10
                db "  Sense ratios! Truca Ara!",13,10,13,10
                db " Code by Chc / Jorge Cabezas Garcia",13,10
                db " No greetings (nobody greets me)",13,10
                db " Contact me at:",13,10,13,10
                db "          ei52625703@est.fib.upc.es",13,10
                db "          chc@micaco.encomix.com",13,10
                db "          2:343/121.39",13,10,"$"

data    ENDS

data2   SEGMENT PARA PUBLIC 'DATA2'

        light LABEL BYTE
              include light.inc

data2   ENDS

data3   SEGMENT PARA PUBLIC 'DATA3'

        object LABEL BYTE
               include object.inc
        
data3   ENDS

data4   SEGMENT PARA PUBLIC 'DATA4'

        picture LABEL BYTE
                include micaco.inc

data4   ENDS

;  Segmento de cdigo principal  

code 	SEGMENT para public 'CODE'
        ASSUME cs:code,ds:data,ss:pila

        .386                            ;Instrucciones 386...

        include mode.asm
        include 3d.asm

; interrupcin de teclado

int09   proc

        push    ax bx

        in al,60h       ; lee la tecla

        ;haz un strobe del teclado...

        mov bh,al
        in al,61h
        mov ah,al       ;el strobe consiste en poner a uno y despus a zero
        or al,80h       ;el bit de ms peso del registro de control del
        out 61h,al      ;controlador del teclado
        xchg ah,al
        out 61h,al

        ;comprueba si es un escape...

        dec     bh
        jnz     npres    ;si no hay escape no hagas nada...

        mov     byte ptr [Escape],1  ;si hay escape indcalo...
npres:

        ;EOI

        mov     al,20h
        out     20h,al

        pop     bx ax

        iret          ;vuelve a donde estaba...

        oldint09        dd      0

int09   endp

; interrupcin de reloj

int08   proc

        push ax ds

        mov ax,data
        mov ds,ax

        add word ptr [Xan],1
        and word ptr [Xan],1ffh
        add word ptr [Yan],2
        and word ptr [Yan],1ffh
;        add word ptr [Zan],1
;        and word ptr [Zan],1ffh

        ;EOI

        mov     al,20h
        out     20h,al

        pop ds ax

        iret          ;vuelve a donde estaba...

        oldint08        dd      0

int08   endp

SetPaleta PROC

          mov dx,3c8h
          xor al,al
          out dx,al
          inc dx
          mov si,OFFSET paleta
          mov cx,768
@@nn:     mov al,[si]
          inc si
          out dx,al
          dec cx
          jnz @@nn

          ret
          ENDP

; punto de entrada

start   PROC NEAR

        mov bx,200*1024/16               ;reserva memoria
        mov ah,04ah
        int 21h

        mov ax,data3
        mov fs,ax
        mov ax,data
        mov ds,ax                       ;DS apunta a los datos
        cld

        ;pon la frecuencia apropiada en el timer (50 hz's)

        mov     dx,0012h                ;1193000 en dx:ax
        mov     ax,34DCh
        mov     cx,70                   ;frecuencia del timer...
        div     cx                      ;ahora calculamos los datos para el
        mov     bx,ax

        mov     al,54
        out     43h,al
        mov     al,bl
        out     40h,al
        mov     al,bh                   ;pon la frecuencia apropiada en el timer
        out     40h,al

        ;Salva la anterior interrupcin...

        cli

        xor     ax,ax
        mov     es,ax
        mov     di,8*4                  ;cambia el vector de interrupcin
        mov     bx,es:[di]              ;de la IRQ 0,1, salvndolo
        mov     si,es:[di+2]            ;previamente en variables de apoyo...
        mov     word ptr cs:[oldint08],bx
        mov     word ptr cs:[oldint08+2],si
        mov     bx,es:[di+4]
        mov     si,es:[di+6]
        mov     word ptr cs:[oldint09],bx
        mov     word ptr cs:[oldint09+2],si

        ;pon la nueva interrupcin...

        mov     di,8*4
        mov     word ptr es:[di],OFFSET int08
        mov     word ptr es:[di+2],SEG int08
        mov     word ptr es:[di+4],OFFSET int09
        mov     word ptr es:[di+6],SEG int09

        sti

        ; reserva memoria para los buffers y las tablas de preclculos

        mov     ah,48h
        mov     bx,70*1024/16
        int     21h
        mov     es,ax

        mov     ah,48h
        mov     bx,65*1024/16
        int     21h
        mov     [multable],ax
        mov     gs,ax

        ; precalcula la tabla de divisiones para la interpolacion de normales

        xor     di,di
        push    es
        push    gs
        pop     es
        xor     ax,ax
        mov     cx,256
        rep     stosw
        pop     es

        mov     bx,1
        mov     bp,127
@@next11:
        xor     ax,ax
        mov     cx,256
@@next00:
        push ax
        shl ax,8
        cwd
        idiv bx
        mov gs:[di],ax
        inc di
        inc di
        pop ax
        inc ax
        loop @@next00
        inc bx
        dec bp
        jnz @@next11

        ; memoria para el buffer

        mov     ah,48h
        mov     bx,70*1024/16
        int     21h
        mov     gs,ax

        ; pon el dibujo en el buffer temporal

        push es ds
        push gs
        pop es
        mov ax,data4
        mov ds,ax
        xor di,di
        xor al,al
        mov cx,64000
        rep stosb
        mov di,320*9
        mov al,255
        mov cx,320*182
        rep stosb
        mov si,OFFSET picture+778
        mov di,320*10
        mov al,48
        mov cx,320*180
        rep stosb
        mov di,320*44
        mov cx,320*115
@@pixeln:
        mov al,[si]
        add al,32
        mov es:[di],al
        inc di
        inc si
        loop @@pixeln
        pop  ds es

        ; completa la paleta

        push    ds es
        push    ds
        pop     es
        mov     ax,data4
        mov     ds,ax
        mov     si,OFFSET picture+10
        mov     cx,32*3
        mov     di,OFFSET paleta
        add     di,32*3
        rep     movsb
        pop     es ds

        ; modo grfico e inicializa paleta

        call    SetGraphicMode
        call    SetPaleta

        ;clear previous frame

        cld
        xor  di,di
        mov  ecx,16000
        mov  eax,02020202h
        rep  stosd

        mov [escape],0
keypressed:
        call Vsync

        ;backup frame

        push es
        push ds

        push es
        pop  ds
        mov  ax,SCREEN_SEG
        mov  es,ax

        xor  si,si
        xor  di,di
        cld
        mov  ecx,16000
        rep  movsd

        pop  ds
        pop  es

        ;clear previous frame with picture

        push ds
        push gs
        pop  ds
        cld
        xor  di,di
        xor  si,si
        mov  ecx,16000
        rep  movsd
        pop  ds

        ;draw object

        mov si,OFFSET object
        call DrawObject

        ;espera que se pulse una tecla

        test    [escape],0ffh
        jz      keypressed

        ;pon el timer a la frecuencia inicial

        mov     al,36h                  ;restaura el valor inicial del timer
        out     43h,al                  ;del reloj del PC
        xor     ax,ax
        out     40h,al
        mov     al,ah
        out     40h,al

        ;Restaura la interrupcin anterior...

        cli                             ;fuera interrupciones...
        xor     ax,ax
        mov     es,ax
        mov     di,8*4                  ;posicin de la IRQ 0
        mov     si,OFFSET oldint08
        mov     ax,cs:[si]
        mov     es:[di],ax
        mov     ax,cs:[si+2]
        mov     es:[di+2],ax
        mov     si,OFFSET oldint09
        mov     ax,cs:[si]
        mov     es:[di+4],ax
        mov     ax,cs:[si+2]
        mov     es:[di+6],ax
        sti

        mov ax,3                        ; restaura el modo de texto...
        int 10h

        mov ah,49h                      ;libera memoria
        int 21h

        push gs
        pop es
        mov ah,49h
        int 21h

        mov ah,49h
        mov es,[multable]
        int 21h

        mov dx,OFFSET mensaje
        mov ah,9
        int 21h

        mov ah,4ch
        int 21h                         ;vuelve al DOS...

        ENDP

; Final del programa

code 	ENDS

        END start
