/*
+---------------------------------------------------+
|           Demoscene Logo Gallery Cover            |
|                                                   |
https://www.facebook.com/groups/demoscenelogogallery
|                                                   |
+---------------------------------------------------+

+---------------------------------------------------+
| This Demoscene Logo Gallery group cover is a      |
| tribute to the beloved Atari 8bits series.        |
| It runs on your A8 ;-)                      | 
+---------------------------------------------------+
DLG - A8 version painted using g2f and some code
      additions by PPs_May 7th, 2022

Original version:
----------------------------------------------------
Author : pp - http://peek.poke.free.fr/
System : Atari ST/STe
Date   : May 1st, 2022

Image format : animated image
Image size   : 320x200 x 256 colors (horiz. rasters)
----------------------------------------------------
*/

/***************************************/
/*  Use MADS http://mads.atari8.info/  */
/*  Mode: DLI (char mode)              */
/***************************************/

	icl "DLG.h"

	org $f0

fcnt	.ds 2
fadr	.ds 2
fhlp	.ds 2
cloc	.ds 1
regA	.ds 1
regX	.ds 1
regY	.ds 1
m	.ds 1

WIDTH	= 40
HEIGHT	= 30

; ---	BASIC switch OFF
	org $2000\ mva #$ff portb\ rts\ ini $2000

; ---	MAIN PROGRAM
	org $2000
ant	dta $70
	dta $F0,$42,a(scr),$82,$04,$04,$84,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04
	dta $04,$84,$04,$82,$04,$04,$04,$04,$04,$04,$70,$70,$70
	dta $41,a(ant)

scr	ins "DLG.scr"

	.ds 5*40

	.ALIGN $0400
fnt	ins "DLG.fnt"

	ift USESPRITES
	.ALIGN $0800
pmg	.ds $0300
	ift FADECHR = 0
	SPRITES
	els
	.ds $500
	eif
	eif

main
; ---	init PMG

	ift USESPRITES
	mva >pmg pmbase		;missiles and players data address
	mva #$03 pmcntl		;enable players and missiles
	eif

	lda:cmp:req $14		;wait 1 frame

	sei			;stop IRQ interrupts
	mva #$00 nmien		;stop NMI interrupts
	sta dmactl
	mva #$fe portb		;switch off ROM to get 16k more ram

	mwa #NMI $fffa		;new NMI handler

;set colors
	lda pal
	cmp #1
	beq no_ntsc
;ntsc
	mva #$a4 nmi.c0+1
	sta nmi.c2+1
	sta nmi.c7+1
	mva #$a2 nmi.c3+1
	sta dli.c14+1
	mva #$92 nmi.c5+1
	sta nmi.c6+1
	mva #$a6 dli.c8+1
	sta dli.c10+1
	sta dli.c12+1
	sta dli.c15+1
	sta dli.c17+1
no_ntsc

	mva #$c0 nmien		;switch on NMI+DLI again

	ift CHANGES		;if label CHANGES defined

_lp	lda trig0		; FIRE #0
	beq stop

	lda trig1		; FIRE #1
	beq stop

	lda consol		; START
	and #1
	beq stop

	lda skctl
	and #$04
	bne _lp			;wait to press any key; here you can put any own routine

	els

null	jmp DLI.dli1		;CPU is busy here, so no more routines allowed

	eif


stop
	.ifdef FADE_CHARS\ lda #0\ jsr fade_chars\ eif

	mva #$00 pmcntl		;PMG disabled
	tax
	sta:rne hposp0,x+

	mva #$ff portb		;ROM switch on
	mva #$40 nmien		;only NMI interrupts, DLI disabled
	cli			;IRQ enabled

	rts			;return to ... DOS

; ---	DLI PROGRAM

.local	DLI

	?old_dli = *

	ift !CHANGES

dli1	lda trig0		; FIRE #0
	beq stop

	lda trig1		; FIRE #1
	beq stop

	lda consol		; START
	and #1
	beq stop

	lda skctl
	and #$04
	beq stop

	lda vcount
	cmp #$02
	bne dli1

	:3 sta wsync

	DLINEW dli4

	eif

dli_start

dli4
	sta regA

	lda #$01
	sta wsync		;line=16
	sta gtictl
	DLINEW dli5 1 0 0

dli5
	sta regA
	stx regX

c8	lda #$96
	ldx #$04
	sta wsync		;line=32
	sta color2
	stx gtictl
	DLINEW dli6 1 1 0

dli6
	sta regA

c9	lda #$0E
	sta wsync		;line=56
	sta color1
	ldx #54
	lda cloc
@	sta color0
	sta wsync
	add #2
	dex
	bpl @-
	sta m
:2	inc m
	sta color0
c10	lda #$96
	ldx m
	sta wsync		;line=112
	sta colbak
	stx color0
	ldx #37
	lda m
@	sta color0
	sta wsync
	add #2
	dex
	bpl @-
	DLINEW dli8 1 1 0

dli8
	sta regA
	stx regX
	sty regY

c11	lda #$0A
	sta wsync		;line=152
	sta color1
	sta wsync		;line=153
	sta wsync		;line=154
	sta wsync		;line=155
	sta wsync		;line=156
	sta wsync		;line=157
x6	lda #$20
c12	ldx #$96
	sta wsync		;line=158
	sta hposp0
	stx colpm0
	sta wsync		;line=159
c13	lda #$06
c14	ldx #$92
	ldy #$01
	sta wsync		;line=160
	sta color1
	stx color2
	sty gtictl
x7	lda #$D0
	sta hposp1
c15	lda #$96
	sta colpm1
	DLINEW dli9 1 1 1

dli9
	sta regA
	stx regX

	lda #$04
	sta wsync		;line=168
	sta gtictl
c16	lda #$0A
c17	ldx #$96
	sta wsync		;line=169
	sta color1
	stx color2

	lda regA
	ldx regX
	rti


.endl

; ---

CHANGES = 1
FADECHR	= 0

SCHR	= 127

; ---

.proc	NMI

	bit nmist
	bpl VBL

	jmp DLI.dli_start
dliv	equ *-2

VBL
	sta regA
	stx regX
	sty regY

	sta nmist		;reset NMI flag

	mwa #ant dlptr		;ANTIC address program

	mva #@dmactl(standard|dma|lineX1|players|missiles) dmactl	;set new screen width

	inc cloc		;little timer

; Initial values

	lda >fnt+$400*$00
	sta chbase
c0	lda #$94
	sta colbak
	lda #$02
	sta chrctl
	lda #$04
	sta gtictl
c1	lda #$0A
	sta color1
c2	lda #$94
	sta color2
c3	lda #$92
	sta color3
c4	lda #$00
	sta color0
s0	lda #$01
	sta sizep1
x0	lda #$6E
	sta hposp1
c5	lda #$82
	sta colpm1
s1	lda #$01
	sta sizep0
	sta sizep2
	sta sizem
x1	lda #$46
	sta hposp0
x2	lda #$92
	sta hposp2
x3	lda #$4E
	sta hposm0
c6	lda #$82
	sta colpm0
	sta colpm2
s2	lda #$01
	sta sizep3
x4	lda #$8A
	sta hposp3
c7	lda #$94
	sta colpm3
x5	lda #$00
	sta hposm1
	sta hposm2
	sta hposm3

	mwa #DLI.dli_start dliv	;set the first address of DLI interrupt

;this area is for yours routines

quit
	lda regA
	ldx regX
	ldy regY
	rti

.endp

; ---
	run main
; ---

	opt l-

.MACRO	SPRITES
missiles
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 03 03 03 03 03 03 03 03 03 03 03 03 03 03
	.he 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03
	.he 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03
	.he 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03
	.he 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03
	.he 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03
	.he 03 03 03 03 03 03 03 03 03 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player0
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 3F 3F 3F 3F 3F 3F FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF 00
	.he 00 00 00 00 00 00 FF FF FF FF FF FF FF FF FF FF
	.he FF 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player1
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 30 38 38 38 38 3C
	.he FC FC FC FE FE FE FE FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF 00
	.he 00 00 00 00 00 00 00 00 FF FF FF FF FF FF FF FF
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player2
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 3F 3F 3F 3F 3F 3F FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF 7F 7F 7F 7F 3F 3F 3F 3F 1F 1F 1F 1F 0F 0F
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player3
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 0F 0F 0F 0F 1F 1F 1F 1F 3F 3F 3F 3F 7F 7F 7F 7F
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
.ENDM

USESPRITES = 1

.MACRO	DLINEW
	mva <:1 NMI.dliv
	ift [>?old_dli]<>[>:1]
	mva >:1 NMI.dliv+1
	eif

	ift :2
	lda regA
	eif

	ift :3
	ldx regX
	eif

	ift :4
	ldy regY
	eif

	rti

	.def ?old_dli = *
.ENDM

