-- ----------------------------
-- Rho/Trepaan
--
-- presents
--
-- "Chill like you never"
--
-- or, a reference to a great demo
-- from the days of yore
--
-- A Tic-80 256byte intro
-- for LoveByte 2021's
-- 256 VM intro competition
--
-- this would not have been possible
-- without the help of
-- * Superogue/Maquee Design:
---- to get LoveByte going
---- and get me going on the TIC80
-- * Exoticorn:
---- for his awesome Tic-Tool
-- https://github.com/exoticorn/tic-tool
-- and
-- * Scid/Ramjam:
---- for his ticpac
-- https://github.com/phlubby/pactic/releases/
-- * 303, by Acme
---- because reasons
-- https://www.pouet.net/prod.php?which=44


-- directives voor tic-tool

-- rename sum -> p
-- rename px -> h
-- rename py -> l
-- rename i -> T

--this works because x and y are only used in the beginning,
--and are redunant when starting to draw
-- rename X -> x
-- rename Y -> y

--tricky, but it is only used inside 'that loop'
-- after that, it can be used for another temporary floormap value
-- rename d -> Z

--this works because z is redundant when i start working with color
-- rename color -> Z


-- transform to load
function TIC()
 n=4
 px={}
 py={}
 t=time()/999

 --recasting math to m, might result in shorter code
 --m=math
 math.randomseed(16)
 for i=0,n do
  px[i]=math.sin((t+i+(math.random()-.5)*1.1))*78
  py[i]=math.sin((t+i+(math.random()-.5)*3.9))*42
 end

 for o=0,32640 do
  x=o%240-120
  y=o//240-68

--metaballs
  sum=0
  for i=0,n do
   d=((x-px[i])^2+(y-py[i])^2)^.5
   --technically, this can DIV_BY_ZERO
   sum=sum+16/d
   if(sum>6)then sum=6 end
  end

--floor/ceiling.background
  --u=(x-120)/4
  --v=(y-72)/7
  u=x/4
  v=y/7
  --Z=math.abs(v)+.1
  Z=(v^2)^.5+.1
--x/y are free from here

  --horizontal movement
  --X=(u/Z+t)//1
  --Y=99//Z
  --vertival movement
  X=u//Z
  Y=(19/Z+t)//1
--Z is free from here
--u v are free from here


--draw
--default color, ceiling, defunct because of newer else construct
  --color=(X&Y)%5+8
--draw metabals cutoff
  if(sum>1.8)then
   color=sum+1
--floor color

  -- old elseif with fallthrough with the default color
  --elseif(v>0)then
  -- color=(X&Y)%4+5
  --end
  --new construct
  else
   color=v>0 and (X|Y)%4+5 or (X&Y)%5+8
  end

  poke4(o,color)
--end forloop
 end
--TIC()
end