;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Busy soft ;;; Mixontil 512 ;;; 02.02.2024 ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sizexx	=	0x7E			;; Number of tiles in X
sizeyy	=	0x48			;; Number of tiles in Y

	format PE GUI 4.0
	include 'macro\Import32.inc'
	entry start

	section 'busy-imp' import readable writeable

	library gdi32,'GDI32.DLL', \
		user32,'USER32.DLL', \
		kernel32,'KERNEL32.DLL'

	import gdi32, \
		StretchDIBits,'StretchDIBits'

	import kernel32, \
		Sleep,'Sleep'

	import user32, \
		GetDC, 'GetDC', \
		ShowCursor,'ShowCursor', \
		GetClientRect,'GetClientRect', \
		CreateWindowExA,'CreateWindowExA', \
		GetAsyncKeyState,'GetAsyncKeyState'

	section 'busycode' readable executable

;;;;;;;;;;
;; Init ;;
;;;;;;;;;;

start:	mov	edx,0x91000000
	mov	ebx,wclass
	xor	eax,eax

	push	0x08
	pop	ecx
lopi:	push	eax
	loop	lopi

	push	edx			;; Parameter for CreateWindowExA: dwStyle = WS_POPUP or WS_VISIBLE or WS_MAXIMIZE
	push	eax			;; Parameter for CreateWindowExA: lpWindowName
	push	ebx			;; Parameter for CreateWindowExA: lpClassName
	push	eax			;; Parameter for CreateWindowExA: dwExStyle = 0

	push	eax			;; Parameter for ShowCursor
	call	dword [ShowCursor]	;; Do not show mouse cursor
	call	dword [CreateWindowExA]	;; Create application window

	mov	[hwnd],eax
	push	eax
	call	dword [GetDC]
	mov	[hdc],eax

	mov	ecx,4*sizexx*sizeyy
init:	lea	eax,[8*eax+eax+103]	;; Random number generator
	mov	ebx,eax
	shr	eax,12
	xor	eax,ebx
	mov	[colcnt - 4 + 4*ecx],eax
	loop	init

;;;;;;;;;;;;;;;
;; Main loop ;;
;;;;;;;;;;;;;;;

delay:	push	0x10
	call	dword [Sleep]

;; Render animation

	mov	ebx,vars		;; EBX = pointer to array of multiplicators for RGB values
	lea	esi,[ebx+8]		;; ESI = pointer to pointer and timing of scenario
	mov	eax,[esi]		;; EAX = pointer to actual item in scenario
	add	byte [esi+4],2
	jnc	scedat			;; Scenario item is changed every 128 frame
	inc	eax
scesto:	mov	[esi],eax
scedat:	mov	dl,[eax+scenar]		;; Get item from scenario
	mov	al,dl
	test	al,al			;; Zero means end of scenario
	jz	scesto			;; and the scenario repeats

	push	8
	pop	ecx

dirlop:	mov	al,[ebx]		;; Update multiplicators due to scenario item
	shr	dl,1			;;  - Decrement by 4 if the proper bit is 0
	jc	dirinc			;;  - Increment by 4 if the proper bit is 1
dirdec:	sub	al,4			;; with limits 0 and 255 (do not overflow)
	jc	dirnxt
	jmp	dirset
dirinc:	add	al,4
	jc	dirnxt

dirset:	mov	[ebx],al		;; Store new value of multiplicator
dirnxt:	inc	ebx
	loop	dirlop

	mov	bl,cl

kresli:	mov	ecx,4*sizexx*sizeyy	;; Main render loop
	mov	edi,screen-1
	xor	ebp,ebp

maluj:	lea	esi,[colcnt - 4 + 4*ecx]

	lea	ebp,[8*ebp+ebp+101]	;; Random number generator
	mov	eax,ebp
	ror	eax,23
	xor	eax,ebp
	and	eax,0x7F
	add	al,0x55			;; AL = random number in range 0x55..0xD4

	add	eax,[esi]		;; Increment iterator by this random number
	mov	[esi],eax

	shl	ax,3			;; Create value for R,G,B
	sbb	al,al
	xor	al,ah			;; colX = value oscilates 0..255..0..255..0

	and	bl,0x07			;; It it is 4th value (not user for R,G,B)
	cmovz	edx,eax			;; store it into DL as "col4" for future use

	mul	byte [ebx]		;; Evaluating result R,G,B values for screen
	mov	dh,ah
	inc	ebx
	mov	al,dl
	mul	byte [ebx]
	add	ah,dh
	inc	ebx			;; Result value = colX * mul0 + col4 * mul1

	mov	[edi+ecx],ah		;; Store result value into screen
	loop	maluj

;; Display prepared screen

zobraz:	xor	eax,eax		;; It is possible to use ECX instead of EAX and save 2 bytes

	push    0xCC0020	;; rop
	push	eax		;; iUsage = 0
	push	bminfo		;; lpbmi
	push	screen		;; lpbits
	push	sizeyy		;; SrcHeight
	push	sizexx		;; SrcWidth
	push	eax		;; ySrc = 0
	push	eax		;; xSrc = 0

	push	eax		;; DestHeight
	push	eax		;; DestWidth
	push	eax		;; yDest = 0
	push	eax		;; xDest = 0

	push	esp
	push	[hwnd]
	call	dword [GetClientRect]

	push	[hdc]
	call	dword [StretchDIBits]

;; Test ESC key

	push	0x1B
	call	dword [GetAsyncKeyState]
	test	al,al
	jz	delay

	retn

	section 'busydata' readable writeable

;;;;;;;;;;;;;;;;;;;
;; Constant data ;;
;;;;;;;;;;;;;;;;;;;

wclass	db	'Edit',0

libzac:
gdi32	db	'Gdi32',0  
user32	db	'User32',0
libdif	=	user32-gdi32

	;;	BBGGRRxxb	;; Color scenario
	;;	|||||||||
scenar	db	01000000b	;; Pure blue
	db	00000100b	;; Pure red
	db	00010000b	;; Pure green
	db	00010100b	;; Red-green-yellow
	db	01000100b	;; Blue-red-magenta
	db	01010000b	;; Blue-green-cyan
	db	01010100b	;; All RGB colors
	db	10001000b	;; Pure magenta
	db	00101000b	;; Pure yellow
	db	10100000b	;; Pure cyan
	db	10101000b	;; Pure white
	db	10011000b	;; Magenta-green-white
	db	10100100b	;; Cyan-red-white
	db	01101000b	;; Yellow-blue-white
	db	01010100b	;; All RGB colors

	ALIGN	0x04	;; Not needed but I have better feeling with it :)

;;  BITMAPINFO

bminfo	dd	0x28	;; biSize
	dd	sizexx	;; biWidth
	dd	-sizeyy	;; biHeight
	dw	1	;; biPlanes
	dw	0x20	;; biBitCount
	dd	0	;; biCompression
	dd	0	;; biSizeImage
	dd	0	;; biXPelsPerMeter
	dd	0	;; biYPelsPerMeter
	dd	0	;; biClrUsed
	dd	0	;; biClrImportant

;;;;;;;;;;;;;;;;;;;
;; Variable data ;;
;;;;;;;;;;;;;;;;;;;

hwnd	dd	?	;; Window handle
hdc	dd	?	;; Device context

	ALIGN	0x100

imports	db	0x1000 dup ?
vars	db	0x100 dup ?

screen	dd	sizexx * sizeyy	    DUP ?	;; Result bitmap to show on screen
colcnt	dd	sizexx * sizeyy * 4 DUP ?	;; Iterators for colours (4x for each pixel)
	db	0x100 dup ?
bend:

	ORG	0		;; Variables in "vars"
muls	db	8 dup ?		;; Multiplicators for RGB values
kdesce	dd	?		;; Pointer to actual item in scenario
count	db	?		;; Timing of scenario

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
