;intro for magpies
;sensenstahl/dsr
;www.sensenstahl.com
;fasm 1.69.31
;listening: aspidistrafly - the voice of flowers

;i had the idea for something with different
;resolutions, kinda. after finishing the
;routine and playing around with some moving
;elements (bar/glass as usual) i also tried
;some overlay but that all did not pump my nads.
;so i invested the remaining bytes in some
;text. the shiny appearence made me wonder if
;magpies would like to look at it and so the
;artsy fartsy title was set. and since it is
;an intro for magpies they also need a message.
;and yeah, (still) influenced by bbstros.
;simply because why not. and after optimizing
;a bit more the message in the number grew. fun!

;there are 5 (base) colors in total to access nice areas
;of the standard palette, all hand picked ... pecked ;)

;since this is out of compo i am not fishing in the
;waters of hellmood/dsr. this might be my 1st and only
;release of code under dsr though ;)

;assuming ax = 0 cx = 255 bx = 0

org 100h
use16

start:   push 0a000h     ;vga
         pop es

         mov al,13h
         int 10h         ;set 320*200 + set 0a000h = 0

         mov ah,09h      ;print string to vga
         mov dx,text     ;ds needs to be unchanged
         int 21h         ;so change afterwards

         push 07000h     ;2nd buffer
         pop fs          ;for the text

;copy text for displaying later
cls:
mov al,byte[es:bx] ;get
shr al,1           ;color change for displaying later
mov byte[fs:bx],al ;save
inc bx             ;just copy the whole segment
jnz cls

         push 08000h     ;buffer
         pop ds          ;for the things


reset:
mov word[bp+6],bx;0 ;init color change
                    ;to avoid random start values

main:

add word[bp],319 ;movement
jnc okok         ;of the bg

inc word[bp+6]   ;for change of colors
cmp word[bp+6],4 ;5 sets max
ja reset

okok:

;draw lines by inc
;which gives a range from about 0..16 (about)
;which in return can be put into nice areas
;of the standard palette by applying a base color

;ax = always the same here
;cx = 0
;mov cx,1800 ;=708h
mov ch,07h   ;enough things on screen then
line2:
inc ax    ;not always 0
mul cx    ;rnd enough
mov di,ax ;starting point

shr dx,5 ;lenght of line
inc dx   ;never 0
line:
mov si,di       ;save for changing/drawing
add si,word[bp] ;add movement
inc byte[ds:si] ;rise color
rcl si,cl       ;fancy fake bg / 2nd layer
inc byte[ds:si] ;rise color

sub di,319      ;move
dec dx          ;do complete lenght
jnz line        ;of the line

neeh:
loop line2


mov ax,320*100+320*29+10+8-2 ;base pos
mov cl,8                     ;start res

resloop:
pusha             ;save all
sub ax,cx         ;adjust x
mov word[bp+8],ax ;save pos

;dx = 1
go2:
;mov bx,320*48 ;=3c00h
mov bh,3ch ;y ;one height fits all
ok3:
mov di,320-32 ;x
ok22:
mov si,di ;x
;add si,bx ;y
add si,word[bp+8] ;add saved base pos
mov al,byte[ds:si+bx];get pixel

mov ah,cl ;set size / y
one1:
mov dx,cx ;x
two2:
mov byte[ds:si+bx],al ;set pixel
inc si     ;move
dec dx
jnz two2   ;do all x
sub si,cx  ;reset
add si,320 ;move down
dec ah     ;do full
jnz one1   ;height

sub di,cx ;move
jnz ok22
imul ax,cx,320 ;move
sub bx,ax
jnz ok3

popa ;restore all
sub ax,320*44 ;move up
shr cx,1 ;change res
jnz resloop  ;exit when 0

;shrinking/moving stuff to have only the low res parts inside the
;lines looked somehow meh
;draw a line on top and bottom
;bx = cx = 0
mov bx,304-16
border1:
mov byte[ds:bx+320*13+7+8],cl   ;top
mov byte[ds:bx+320*185+7+8],cl ;bottom
dec bx
jnz border1

;thick border left and right
;placing/length so only 2 corners are an edge
;mov bx,320*185 ;320*184=e600h
mov bh,0d7h ;320*172 = d700h
border2:
mov word[ds:bx+7+320*13+8-1],cx
mov word[ds:bx+312+320*12-8],cx
sub bx,320
jnz border2

mov dx,3dah     ;wait for vsync for constant speed
;vsync1:         ;to make things smoother
;in al,dx
;test al,8
;jnz vsync1
vsync2:
in al,dx
test al,8
jz vsync2

;slap the saved text on top and profit
letter:
mov ah,byte[fs:bx] ;get
                   ;using ah makes ah = 0 at last loop
                   ;because of the 0s besides the font
                   ;in the segment which then saves 1b at
                   ;esc check using dec ax instead dec al
adc byte[ds:bx+320*170+256-8*28],ah ;put there
inc bx
jnz letter

mov si,word[bp+6]         ;color management
;mov dl,byte[cs:colset+si] ;get it

;flip
;cx = bx = 0 here
flip:
mov al,byte[cs:colset+si];dl ;current color is the bg for all
                             ;slower than using dl but -2b
xchg al,byte[ds:di] ;grab vscreen
stosb               ;drop + inc di
loop flip

         in al,60h            ;read keyboard buffer
         dec ax               ;ESC?
         jnz main            ;no, so go on
breaker: ret                  ;halt!
         nop                  ;256

colset db 71+10h,64+10h,47+10h,40+10h,23+10h ;10h is a artefact from
                                             ;the 1st version
;                 1         2         3
;        1234567890123456789012345678901
text db 'PECK: +256-SHINY-STUFF-4ME-NOT4U$'