; [ Pits ] 256-byte intro for multicore x86 CPUs and MS-DOS compatible OS
; (c) 2024 Jin X ^ Fractal CORE (Eugene Krasnikov, https://t.me/jin_x, jin_x@list.ru)

; main source for fasm 1

; Features:
; - Multithreading (using all hyper-threads on all CPU cores)
; - Video mode up to Full HD / HiColor (1920x1080 / 16 bpp)
; - 64-iterative ray-casting
; - Pure DOS with Protected Mode (no drivers, no DPMI)

; Watch it: https://youtu.be/iIfW2BBRIDI
; Download: https://www.pouet.net/prod.php?which=96532

;          ______      ___  ___    ___
;        /        \   (   \/   )  /   )
;       /    __    \   \      /  (___/
;      /    /  \    \   \    /  ___
;     (     \  /    /   /    \ /   )    _______
;      \     \/    /   /      /   /   /        )
;       \         /   (___/\ /   /   /    ____/
;        \     __/          /   /   (    (
;         \    \           /   / \   \    \
;          \    \         /   /   \___)    )
;           \    \       /   / \ / \      /
;            \____)     (___/   (___)____/


; O══════════════════════════════════════════════════════════════════════════════════════════════════════════════════O
; ║ o──────────────────────────────────────────────────────────────────────────────────────────────────────────────o ║
; ║ │ ·:[ MACROS & SETTINGS ]:·                                                                                    │ ║▒▒
; ║ o──────────────────────────────────────────────────────────────────────────────────────────────────────────────o ║▒▒
; O══════════════════════════════════════════════════════════════════════════════════════════════════════════════════O▒▒
;    ▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒

include 'xmac16s.mac'

; Don't change the following!
col_depth	=	16			; color depth (bits per pixel)

;-- MP config
AP_STARTUP_ADDR	=	$98000			; AP startup address
APIC_BASE	=	$FEE00000		; base physical address of memory mapped APIC registers
APIC_ICR_LOW	=	APIC_BASE + $300	; local APIC ICR (Interrupt Command Register), low half
APIC_CMD_BCST_INIT =	$000C4500		; broadcast INIT IPI message to all APs
APIC_CMD_BCST_SIPI =	$000C4600 + (AP_STARTUP_ADDR shr 12) ; broadcast STARTUP IPI (SIPI) message to all APs using startup address

;-- GDT config
GDT_ADDR	=	$458			; address of GDT descriptor (cursor location area for videopages 4..7)
GDT_DESCR_FLAGS	=	$CF93			; GDT descriptor flags: read/write accessed data type, DPL=0, present, limit hi-byte=$F, AVL(user)=0, L(64bit)=0, expanded 4GB data seg, 4KB granularity

;-- misc
BPSL		=	(col_depth+7)/8 * scr_width ; bytes per scan line

;-- asserts
assert	vesa_info = GDT_ADDR
assert	(AP_STARTUP_ADDR and $FFF = 0) & (AP_STARTUP_ADDR >= $80000) & (AP_STARTUP_ADDR < $A0000)

; Addressing delative to DI/BP register (usage: RelDI(address), RelBP(address))
RelDI		equ	di-vesa_info+
RelBP		equ	bp-vesa_info+

; O══════════════════════════════════════════════════════════════════════════════════════════════════════════════════O
; ║ o──────────────────────────────────────────────────────────────────────────────────────────────────────────────o ║
; ║ │ ·:[ MAIN CODE ]:·                                                                                            │ ║▒▒
; ║ o──────────────────────────────────────────────────────────────────────────────────────────────────────────────o ║▒▒
; O══════════════════════════════════════════════════════════════════════════════════════════════════════════════════O▒▒
;    ▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒

org	$100

		; Assume: AX = BX = 0, CX = $FF, DX = CS, SI = $100, DI = SP = $FFFE

;----------------------------------------------------------------------------------------------------------------------;
; INITIALIZATION                                                                                                       ;
;----------------------------------------------------------------------------------------------------------------------;

Init:
		; Find and set video mode

		mov	ch,$41			; check modes $41xx (bit 14 = use LFB)
		mov	di,vesa_info
	.nextmode:
if vmode_search_method = 0
		cmp	W[RelDI(vesa_bpsl)],BPSL ; check bytes per scan line
else if vmode_search_method = 1
		cmp	D[RelDI(vesa_bpsl)],BPSL + scr_width shl 16 ; check screen width and bytes per scan line
else
  .err
end if ; vmode_search_method = ...
		mov	ax,$4F02		; set SVGA mode
		je	short @F
ifdo open_a20, \
		<out	$92,al>			; [AL = 2] open A20 line
		dec	ax			; [AX = $4F01] get SVGA mode info; VBE 1.1+ fills bytes [ES:DI+$42]..[ES:DI+$FF] with zero
	@@:	int	$10			; get mode info / set mode (AX = $4F on success)
		mov	bx,cx			; video mode
		loopne	short .nextmode
ifdo check_vmode, \
		<je	short @F>, \
		<ret>, \			; mode not found
	<@@:>

		; Multiprocessor initialization

		cli
		push	AP_STARTUP_ADDR shr 4 - $10
		pop	ds
		mov	D[si],$EA + APStartup shl 8 ; store jmp far CS:APStartup instruction
		mov	[si+3],cs		; to address AP_STARTUP_ADDR

		;-- init GDT
		pop	ds			; DS = 0
		dec	W[di]			; [0] GDTR limit & GDT descriptor limit low word ($FFFF); [2] GDTR & GDT descriptor base address (low) = 0; [4] (high/middle) = 0
		mov	W[di+5],GDT_DESCR_FLAGS	; [5] GDT descriptor flags; [7] GDT descriptor base address (high byte) = 0

if ~ unreal_mode
		;-- broadcast INIT IPI & SIPI to all APs
		mov	edx,APIC_ICR_LOW
		mov	D[edx],APIC_CMD_BCST_INIT ; broadcast INIT IPI
		mov	D[edx],APIC_CMD_BCST_SIPI ; broadcast SIPI
end if ; ~ unreal_mode

;======================================================================================================================;
; MULTIPROCESSOR CODE                                                                                                  ;
;======================================================================================================================;

		; BSP: AH = 0, DL = 0, DS = 0, BX = CX <> 0

APStartup:	; APs: flags are cleared (incl. IF); GPRs (incl. ESP) = 0, except EDX = CPUID; seg regs = 0; control regs = 0 (CR0 = $10) [see Intel SDM, vol.3, sec.10.1.1 (table 10-1)]

		; AP initialization

		push	cs
		pop	ss			; SS = CS
		mov	bp,vesa_info		; = GDT_ADDR

		;-- enter protected mode
		mov	al,1			; AX = 1
		lgdt	[ds:bp]			; load GDTR (5 bytes)
		lmsw	ax			; enter PMode
		mov	es,bp			; load ES with base = 0, limit = 4GB

if unreal_mode
		; Multiprocessor initialization
		jcxz	skip_mp_init		; skip multiprocessor initialization for APs (use it only for BSP)

		;-- broadcast INIT IPI & SIPI to all APs
		mov	edx,APIC_ICR_LOW
		mov	D[es:edx],APIC_CMD_BCST_INIT ; broadcast INIT IPI
		mov	D[es:edx],APIC_CMD_BCST_SIPI ; broadcast SIPI
	skip_mp_init:
end if ; unreal_mode

;----------------------------------------------------------------------------------------------------------------------;
; DRAW FRAMES                                                                                                          ;
;----------------------------------------------------------------------------------------------------------------------;

		; BP = vesa_info; ESP = line number (will be got below), ES:EDI - pixel pointer (will be got below)

		;-- get next line
	.nextline:
		mov	ax,[RelBP(vesa_height)]	; AX = screen height
ifel ~ zero_esp_hiword, \
		<mov	sp,1>, \
		\ ; else
		<xor	esp,esp>, \
		<inc	sp>
	lock	xadd	[RelBP(line_number)],sp	; SP = line number
		cmp	sp,ax
		jb	short .linenumok
		jne	short .locsub
	lock	sub	[RelBP(line_number)],ax	; (global) line number -= screen height
		inc	[RelBP(frame_number)]
	.locsub:sub	sp,ax			; (local) line number -= screen height
	.linenumok:
		imul	edi,esp,BPSL		; EDI = line number * bytes per scan line = line start offset
		add	edi,[RelBP(vesa_lfb_addr)] ; EDI = line start physical address

		;-- render the line
ifel good_frame_0, \
		<mov	si,-scr_width/2>, \
		<neg	si>			; SI = signed X

ifel ~ real_center, \
		<sub	sp,scr_height/2>, \
		\ ; else
		<shr	ax,1>, \
		<sub	sp,ax>			; SP = signed Y

		;-- calculate pixel
	.nextpixel:
		mov	cx,initial_z-1		; CX = Z
	.nextiter:
		inc	cx

		movzx	dx,B[RelBP(frame_number)]
		mov	ax,si			; AX = X
		mov	bx,sp			; BX = Y
		imul	ax,cx			; X' = X * Z
		imul	bx,cx			; X' = Y * Z
		shr	ax,8
		shr	bx,8
		add	al,dl
		sub	bl,dl
		sub	ax,128			; X'' = (X' / 256 + frame_number) % 256 - 128
		sub	bx,128			; Y'' = (Y' / 256 - frame_number) % 256 - 128
		imul	ax,ax			; X'' ^ 2
		imul	bx,bx			; Y'' ^ 2
		add	ax,bx			; AX = distance_from_tubule_center ^ 2
		add	ax,1024			; without this, holes appear

	@@:	neg	dl			; DL = abs(DL) (increasing 0..127 then decreasing 128..1)
		jl	short @B
		mov	bx,dx
if pit_radius_mult and 255 = 0
		mov	bh,- pit_radius_mult / 256
else ; pit_radius_mult and 255 <> 0
		sub	bx,pit_radius_mult
end if ; pit_radius_mult and 255 <=> 0
		imul	bx,cx			; DX *= Z (radius ^ 2)

		cmp	ax,bx
		mov	bx,1+32			; color multiplier (blue + green/2)
		ja	short .draw

		mov	bx,cx
		sub	bx,initial_z + ball_pos
		imul	bx,[RelBP(frame_number+1)]
		imul	bx,bx
		add	ax,bx
		shl	dx,3
		add	dh,1024/256		; ball radius
		cmp	ax,dx
		mov	bx,2048			; color multiplier (red)
		jb	short .draw

		cmp	cl,(initial_z+63) and 255
		jne	short .nextiter
	.draw:
		mov	ax,initial_z+63
		sub	ax,cx
		shr	ax,1
		imul	ax,bx

		stos	W[es:edi]		; output pixel

		inc	si			; X
		cmp	si,scr_width/2
		jl	short .nextpixel

ifel ~ reboot_by_esc, \
		<jmp	.nextline>, \
		\ ; else
		<in	al,$60>, \
		<cmp	al,1>, \
		<jne	.nextline>, \
		<jmp	$F000:$FFF0>

; O══════════════════════════════════════════════════════════════════════════════════════════════════════════════════O
; ║ o──────────────────────────────────────────────────────────────────────────────────────────────────────────────o ║
; ║ │ ·:[ DATA SECTION ]:·                                                                                         │ ║▒▒
; ║ o──────────────────────────────────────────────────────────────────────────────────────────────────────────────o ║▒▒
; O══════════════════════════════════════════════════════════════════════════════════════════════════════════════════O▒▒
;    ▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒

org	GDT_ADDR

vesa_info:
vesa_attrib	rw	1			; mode attributes (bit 0 - mode is supported by hardware; bit 7 - LFB is supported)
org	vesa_info + $10
vesa_bpsl	rw	1			; bytes per scan line
vesa_width	rw	1			; width in pixels
vesa_height	rw	1			; width in pixels
org	vesa_info + $19
vesa_bpp	rb	1			; number of bits per pixel
org	vesa_info + $28
vesa_lfb_addr	rd	1			; physical address of linear video buffer

; Initially zero filled area
org	vesa_info + $50
line_number	rw	1
frame_number	rw	1

;-----------------------------------------------------------------------------------------------------------------------

; ┌─── ───────── ───────────────────────────── ────────── -∙·
; │ ┌─── ───────── ───────────────────────── ────────── ────┐
; │ │ ┌─── ───────── ───────────────────── ────────── ────┐ │
; │ │ │ ┌─── ───────── ───────────────── ▄▄▄▄▄▄▄▄▄─ ────┐ │ │
; │ │ │ │ ┌─── ───────── ───────────── ▄▀      ▄▀ ────┐ │ │ │
; │ │ │ │ │ ┌─── ▄▄▄▄▄▄▄▄▄ ────────  ▄▀      ▄▀ ────┐ │ │ │ │
; │ │ │ │ │ │     ▀▄      ▀▄       ▄▀      ▄▀     : │ │ │ │ │
; │ │ │ │ │ │       ▀       ▀▄   ▄▀      ▄▀       | │ │ │ │ │
; │ │ │ │ │ │  ████████████▀  ▀▄▀ ▄██▀ ▄▀   ▄███  │ │ │ │ │ │
; │ │ │ │ │ │         ▄██▀      ▄██▀ ▄▀   ▄██▀██  │ │ │ │ │ │
; │ │ │ │ │ │       ▄██▀  ▀▄  ▄██▀ ▄▀   ▄██▀  ██  │ │ │ │ │ │
; │ │ │ │ │ │     ▄██▀   ▄▀ ▄██▀    ▀ ▄██▀    ██  │ │ │ │ │ │
; │ │ │ │ │ │   ▄██▀   ▄▀ ▄██▀ ▄    ▄██▀      ██  │ │ │ │ │ │
; │ │ │ │ │ |  ▀▀▀   ▄▀  ▀▀▀ ▄▀ ▀▄ ▀▀▀  ▀▄    ▀▀  │ │ │ │ │ │
; │ │ │ │ │ :      ▄▀      ▄▀     ▀▄      ▀▄      │ │ │ │ │ │
; │ │ │ │ └───── ▄▀      ▄▀ ─────── ▀▀▀▀▀▀▀▀▀ ────┘ │ │ │ │ │
; │ │ │ └───── ▄▀      ▄▀ ─────────── ───────── ────┘ │ │ │ │
; │ │ └───── ─▀▀▀▀▀▀▀▀▀ ─────────────── ───────── ────┘ │ │ │
; │ └───── ────────── ─────────────────── ───────── ────┘ │ │
; └───── ────────── ─────────────────────── ───────── ────┘ │
; ·∙-— ────────── ─────────────────────────── ───────── ────┘

; ====================[ Greetings to... ]====================
; Kuemmel ♦ Řrřola ♦ HellMood ♦ TomCat ♦ superogue ♦ Digimind
; exoticorn ♦ gopher ♦ bitl ♦ wbcbz7 ♦ g0blinish ♦ Dresdenboy
; iONic ♦♦ pestis ♦♦ sensenstahl ♦ Optimus ♦♦ ilmenit ♦♦ baze
; Georgy Lomsadze ♦ Ivan Dianov ♦ DArt ♦ bfox ♦ Adam Bazaroff
; teadrinker ♦ Pirx ♦♦ Baudsurfer ♦ frag ♦♦ provod ♦ p01 ♦ ps
; Quiet ♦ fatalsnipe ♦♦ Manwe ♦ TmK ♦♦ evvvvil ♦ NuSan ♦♦ ryg
; ==============[ ...all sizecoders & YOU! ;) ]==============

; .-------------< Welcome 2 sizecoding chats! >-------------.
; | https://discord.gg/pZE5rAQrHx • https://t.me/sizecoders |
; '---------------------------------------------------------'
