; 
; Giana meets her twin sisters
; 

	org	0100h

	mov	ax, 0x13	; 3b
	int	10h		; 2b
	push	0xa000		; 3b
	pop	es		; 1b
	mov	si, player	; 3b

main:	mov	cl, 5		; 2b player count
	sub	bp, 5*4		; 3b
	xor	di, di		; 2b

; calc jump
.2:	add	di, 48		; 3b next player X pos (in pixels)
	mov	al, [bp]	; 3b JumpX
	mov	dx, [bp+2]	; 3b JumpY
	sub	al, 32		; 2b jump height/length both 64 pixels
	imul	al		; 2b (JumpX-32)*(JumpX-32)
	shr	ax, 4		; 3b (JumpX-32)*(JumpX-32)/16
	sub	dx, 64		; 3b JumpY-64
	add	dx, ax		; 2b PlayerY = JumpY-64+(JumpX-32)*(JumpX-32)/16

	mov	bx, [si+60]	; 3b road position
	add	bx, di		; 2b player's xpos
	add	bx, 8		; 3b add a half pos (middle)
	shr	bx, 4		; 3b /16
	and	bx, 127		; 3b limit playfield length
	mov	al, [si+bx-100]	; 3b H = playfield[]
	and	al, 7		; 2b
	shl	al, 3		; 3b
	neg	al		; 2b
	add	al, 160		; 2b 160 - H * 8

	cmp	dx, ax		; 2b
	jbe	.1		; 2b
	mov	[bp], ch	; 3b reset JumpX (ch always zero)
	mov	[bp+2], ax	; 3b JumpY = PlayerY
	mov	dx, ax		; 2b
.1:	inc	byte [bp]	; 3b JumpX++

; draw player
	pusha			; 1b
	mov	bl, 20		; 2b sprite height
	call	draw		; 3b draw sprite
	popa			; 1b

	add	bp, 4		; 3b
	loop	.2		; 2b

; draw playfield
	mov	ax, [si+60]	; 3b Road position
	mov	bx, ax		; 2b
	and	ax, 15		; 3b ax = Road % 16
	shr	bx, 4		; 3b bx = Road / 16

	mov	cl, 19		; 2b no clipping, draw only visible area (19*16=304 pixels)
	add	bx, cx		; 2b drawing backwards bx+19..bx+0
.4:	and	bx, 127		; 3b limit playfield length
	mov	dl, [si+bx-100]	; 3b H = playfield[] (bricks height)
	and	dx, 7		; 3b
.5:	pusha			; 1b
	shl	dx, 3		; 3b
	neg	dx		; 2b
	add	dx, 160+20	; 4b Y = 160+22 - 8 * H
	mov	di, cx		; 2b
	shl	di, 4		; 3b
	sub	di, ax		; 2b X = cx * 16 - (Road % 16)
	mov	si, brick	; 3b sprite data
	mov	bl, 7		; 2b height
	call	draw		; 3b draw sprite
	popa			; 1b
	dec	dx		; 1b H--
	jns	.5		; 2b draw more bricks vertically
	dec	bx		; 1b bx--
	loop	.4		; 2b

	inc	word [si+60]	; 3b road++

; wait for vertical retrace
	mov	dx, 0x3da	; 3b
.3:     in	al, dx		; 1b
        test	al, 8		; 2b
        jz .3			; 2b

; clear screen
	salc			; 1b clears al (ah already 0), 1 byte shorter than xor al,al
	dec	cx		; 1b cx was 0 (a loop above)
	rep stosb		; 2b di can be any value, will wrap-around

	jmp	main		; 3b sorry, no space for clean exit

; sorry, no space for clipping
; a bit ugly but hey it must fit in 256b
draw:
	mov	ax, 320		; 3b
	mul	dx		; 2b
	add	di, ax		; 2b di = y*320+x
.3:	mov	cl, 4		; 2b safe to use cl, cx=0 here
	mov	ah, [si]	; 2b
.2:	shr	ax, 2		; 3b
	shr	al, 5		; 3b 0,1,2,3 => 0,2,4,6 : black, green, red, brown
	stosb			; 1b
	stosb			; 1b
	loop	.2		; 2b
	inc	si		; 1b
	xor	dh, 1		; 3b 16 pixels wide so loop once more
	jnz	.3		; 2b
	add	di, 320 - 16	; 4b
	dec	bx		; 1b
	jnz	.3		; 2b
	ret			; 1b

; 40b
player:	db 0x08,0x02,0xA8,0x16,0x68,0x15,0x59,0x5D,0x55,0x7F,0xd5,0x7F,0x95,0x6A,
	db 0xB5,0xC8,0xB5,0xC8,0xF5,0xFF,0xD5,0x73,0xD5,0x7F,0x54,0x1F,0xB0,0x3B,0xB0,0x3A,
	db 0xAC,0xEA,0xAC,0xEA,0xA8,0xAA,0xF0,0x3C,0xA0,0x28

; 14b
brick:	db 0xA2,0xA2,0xF3,0xF3,0xF3,0xF3,0x00,0x00,0x2A,0x2A,0x3F,0x3F,0x3F,0x3F
