;-----------------------------------------------
;'industrial times' by Kuemmel for Revision 2019
;-----------------------------------------------
org 100h
use16
;---screen init:   
sub al,-(0x13+0x80)	;no screen clearing but doesn't matter and provided address by Hellmood
mov fs,[si]			;double buffer (results in 0x6d2c which is okay as an address)
int 10h
;---palette init
mov dx,03c9h
pal_loop:			;greyscale
	mov al,cl
	out dx,al
	out dx,al
	out dx,al
loop pal_loop

;---sound init
mov ax,3508h		;21h, ah=35h get interrupt handler | al=08h interrupt number (PIT timer)
int 21h 			;return: es:bx
push es
push bx 			;backup current interrupt handler
mov al,63			;PIT counter divisor => 63 equals 18939 Hz
mov dx,irq			;new handler address
call init			;sound init routine (also used for exit)
;---screen address init
push 0a000h
pop es

;---main intro loop
main:	
;---create sky with random particles plus sound visualisation effect
;needs cx=0, uses ax,bx,cx,dx,di
mov ax,word[irq.counter-2]	;get random seed from irw counter into ax
cmp bx,40000
ja skip_sound_vis_effect
;cmp byte[si],0					;get sample from sound for visualisation
;je skip_sound_vis_effect
	;mov cl,20				;cx is zero here before due to screen copy loop after 1st screen
	mov cl,ah
	;shr cl,
	and cl,31
	
	;mov al,byte[si]
	;shr al,4
	;add cl,al
	skip_sound_vis_effect:
push bx
sun_plus_feinstaub_loop:
	adc bx,dx			;random routine from Hellmood's TV noise :-)
	adc ax,bx
	inc bx
	push ax				;backup random seed
	cmp al,ch			;amount of random particles trigger
	jb no_saturation	;random greyscale
	mov ax,0xcccd		;rrrola's trick 
	mul di				;x=dl (0...255), y=dh (0...199)
	mov al,dh			

	mov ch,63+16		;make feinstaub less dependent on y
	sub ch,dh
	shr ch,3			;adjust amount of feinstaub

	mul al				;y*y = > 199*199
	shr ax,1			;or 2
	xchg ax,dx			;ax=x; dx=y*y	
	mul al				;x*x = > 255*255
	shr ax,1			;or 2
	add ax,dx			;x*x+y*y
	add ah,cl			;sound visualisation offset
	cmp ah,63
	jbe no_saturation
		mov ah,63		;saturate to 63 colours
	no_saturation:
	mov byte[fs:di],ah
	skip_plotty:
	pop ax				;restore random seed
	inc di
jns sun_plus_feinstaub_loop	;no need for lower half of screen
pop bx

;---create 3 or 4 layers of industrial blocks with chimneys :-)
;needs ch=0, uses ax,bx,cx,dx,di
push bx
mov cx,16					;3 or 4 layers => layer = 8,16,32,64
layer_loop:
	shl bx,1				;parallax scrolling offset calc
	mov di,320*64			;di = 64*320 ;start/end address for industrial blocks 
	industrial_block_loop:
		mov ax,0xcccd		;rrrola's trick 
		mul di				;x=dl (0...255), y=dh (0...199)
		sub dl,bh			;parallax movement add
		mov al,64			;base is y = 64	
		add al,cl			;y + 8/16/32/64 
		cmp dh,al			;check line for design change
		jae skip_chimney
			;...chimney design
			push dx
			mov dh,cl
			shr dh,2		;1,2,3 amount of chimneys 1/2/4
			or dh,cl
			test dh,dl
			pop dx
			jz skip_chimney	;no plot if not chimney
		
			sub dh,112
			js skip_plot
			push cx
			not dl
			dec cx
			shr cx,2
			add dl,cl
			and dl,cl
			cmp dl,dh
			pop cx
			ja skip_plot
			
		skip_chimney:
			mov ax,cx		;colouring based on layer, placed here to clear ah=0 for exit
			sub al,8		;****** or dec ax if you need a byte
			;...building design
			push cx
			shr cl,2		;size of windows
			and dl,cl
			pop cx
			and dl,dh		;(x AND layer) AND y ? 0
			jz skip_window
				salc
		skip_window:
		mov byte[fs:di],al	;check if ds works later 
		skip_plot:
		inc di
	jnz industrial_block_loop
	add cl,cl				;layer = 8,16,32,64
jns layer_loop				;equals cmp cl,128 as 128 is first signed number 0x80
pop bx
			
;---vsync for timing & flicker reduce
mov dx,03dah
vsync:
  in al,dx
  test al,8
jz vsync

;---bx is global counter for parallax scroller movement, don't change anywhere else...
add bx,64

;---copy buffer to screen
;needs di=0,cx=0 di is zero here
xor cx,cx
copy_buffer_loop:
	salc				;xor cx,cx clears carry flag, following instructions don't
	xchg byte[fs:di],al	;clear backbuffer also otherwise glitches at first chimney layer
	stosb
loop copy_buffer_loop

;---key check and exit			
in al,60h
dec ax		;ah is zero :-)
jnz main	;nothing so go on
pop dx		;restore handler address at exit
pop ds				
init:		;ax is zero at exit here...
out 40h,al	;al = 0 or 63 => write PIT counter 0 divisor = 63 low byte
xchg ax,cx	;cx is zero here at exit and init
out 40h,al	;al = 0 => write PIT counter 0 divisor again = 0 high byte
			;=> this results in a frequency for the interrupt call of 18939 Hz.
			;as clock is 1,19318181818 MHz => 1,19318181818 MHz / 63 = 18939 Hz
mov ax,2508h
int 21h
ret			;return after init or exit code
;---bytebeat interrupt subroutine
;((t>>1|t>>4|t>>8|t>>15)*top_timer)+top_timer
;based on ideas from http://www.pouet.net/topic.php?which=8357&page=1
irq:
pusha
mov ax,0						;ax: t => self modifying code here
.counter:
shr ax,1						;>>1
mov cx,ax
shr ax,3						;>>3+1	   = 4
or cx,ax
shr ax,4						;>>3+1+4   = 8
or cx,ax
shr ax,7						;>>3+1+4+7 = 15
or cx,ax
xchg ax,cx
mul bp							;top timer for more variation
add ax,bp
mov dx,0378h					;LPT1 parallel port address
out dx,al						;write 8 bit sample data
mov [si],al						;backup sample for sound visualisation
inc word[irq.counter-2] 		;inc timer each interrupt call within code
mov al,20h
out 20h,al
popa
jnz skip_inc_top_timer
	add bp,10					;inc top timer/sound variation value every 65535/18939 = 3.46 seconds
								;no init needed, seems cool, with a "drop the beat" at some time :-)
skip_inc_top_timer: 
iret