; MAGIXFLY.ASM   - Simple 3d flying demo in 64 Bytes! (C) A.Millett 2014-2025. 
;-----------------------------------------------------------------------------
;
; Released as free/open software under the terms of the GNU GPL3 license.  
;      See:  www.gnu.org/licenses/gpl-3.0.html 
;  
; This is a simple DOS/VGA old-school graphics demo program in x86 Assembler, 
; demonstrating some basic asm methods. 
; It can run on an 8086 (or later) PC with VGA under MSDOS/Freedos.
; It does not require an FPU.
; For modern PCs, it will run on Linux/Windows in DOSBOX, or other emulators.
;
; All variables held in registers.
;   AX,DX,SI are temp calc regs.
;   DS (data seg) points to VGA screen (A000h)
;   BX = Pixel position for plotting.
;   CX = time (frame count) 
;   DI - Y position (for fx calc) 
;   BP = X position (for fx calc)
;
; It uses the NETWORK x86 assembler, NASM, but can easily be adapted to others. 
; Build with: NAS2COM magixfly
;   or    NASM -f bin magixfly.asm -o magixfly.com
;
; If you replace the key-hit check & ret with jp reloop, you can save 4 bytes.
;-----------------------------------------------------------------------------
;  History..
; ->DFLYA5  (23.10.2014) (64 bytes)
;  Take old demo, tidy up, add comments etc.
;  Remove shr ax,1   Add mov di,OFFSETY  (reduce flicker)
;  Imp constants OFFSETY, VDUX, VDUY 
; ->MAGIXFLY6 (20.4.2025) (63 bytes)

	; Init some Constants
	
  OFFSETY equ 12	; Start of y for calculation  (offset from 0 to reduce flicker)
  VDUX equ 319
  VDUY equ 199
  
 
  org 100h

  mov al,19	 	; Screen mode 19 - VGA 320x200x256  (Using default VGA palette)
  int 10h

reloop:
  push 0A000h
  pop ds		; DS=VGA segment A000
  xor bx,bx		; bx=0; (vdu char pos)
  mov di,OFFSETY	; ypos=OFFSETY  (di) (Start Y a little lower to remove flicker at top)
  ; sub di,di 		; ypos=0  (di) (use this to save 1 byte!)
			; time (cx:init not needed)
loopY:
  inc di	; Y++;
  mov ax,0A00h	; si = (2560/ypos) + time;  (Calc once for line)
  xor dx,dx
  div di
  ;shr ax,1
  add ax,cx
  mov si,ax

  mov bp,VDUX	; xpos=319  (bp)

		; Output a line..
loopX:
   mov ax,bp	; pVdu [bx] = (((((xpos<<4)/ypos) ^ si) + time/256) & 31);
   shl ax,4	;  (try 3,4,5 here)
   xor dx,dx
   div di
   xor ax,si	;    (sub here is an interesting fx)
   add al,ch	; add time/256  (hi of CX, rotates thro palette)
   and al,31    ;	(15 also works) 
   ; add al,12
   mov [bx],al
   inc bx		; Next vdu pixel pos..
   dec bp		; X--
  jge loopX		; if (X) goto loopX

  cmp di, VDUY + OFFSETY
  jle loopY		; if (Y<=199) goto loopY

  inc cx		; time++; (frame count)

			; Get a char in (al), loop till key hit..
  mov ah,1
  int 16h
  je reloop		; loop for next frame..
			; replace keytest/ret (NO EXIT!) with jp reloop saves 4 bytes.

  ;mov ax,3		; Screen mode 3 - Text 80x25
  ;int 10h

  ret			; EXIT (was: mov ah,4Ch: int 21h)

section .data		; Initialised data section

;tim:  dw 0		; Time var (init to 0)

section .bss	; Uninitialised data sect..

;tim:  resb 2	; Time var (reserve 2 bytes)

