-- title:  July
-- author: Jin X
-- desc:   TIC-80 256b intro
-- script: lua

t=0
cls()
function TIC()
 -- params
 v=math.sin(math.sin(time()*.000007)*1.57+3.14)*.8 -- julia parameter - angle (in sin)
 u=math.cos(math.sin(time()*.000007)*1.57+3.14)*.8
 z=math.sin(time()*.00007) -- moving from one side to another
 q=math.sin(math.sin(time()*.000007)*1.57/2+3.14)*z -- angle for viewpoint (in sin)
 p=math.cos(math.sin(time()*.000007)*1.57/2+3.14)*z
 z=math.sin(time()*.0004)*5+27 -- zoomer
 -- draw
 for y=t%4,68,4 do
  for x=0,120,2 do
   i=math.atan(y,x) -- angle of point
   r=(x*x+y*y)^.5*.02 -- distance from center
   -- julia fractal
   d=0 -- depth
   i=p+i*.9^z -- im
   r=q+r*.9^z -- re
   while 4>i*i+r*r and d>-48 do
    d=d-1
    i,r=i*i-r*r+u,2*i*r+v
   end
   circb(120-x,68-y,1,d/3)
   circb(120+x,68-y,1,d/3)
   circb(120-x,68+y,1,d/3)
   circb(120+x,68+y,1,d/3)
  end
 end
 sfx(t%16-1,t&t>>5&124)
 t=t+2
end
