cpu 486
org	0100h

;Setup video mode

mov al, 13h
int 10h

;;Enable speaker to pit
mov al, 11b
out 61h, al

push cs
pop es

;Draw strings on screen
mov cx, 40

drawText:
pusha

call rand
xchg ax, dx

and cl, 3
mov bp, cx
shl bp, 3
add bp, DEADLINE

mov bl, 15
mov cl, 8
mov ax, 1300h
int 10h

popa
loop drawText

;line counter
mov dx, 200*8

newScreen:

push dx
;Wait for redrace
mov dx, 0x3da
waitretrace:
in al, dx
test al, 8
jz waitretrace
pop dx

;Set stack to vram so bp can access it
push 0xa000
pop ss

;clear the screen
xor ax, ax
mov si, dx
shr si, 3
imul si, 320
lea bp, [si+320]
fillzero
mov [bp],al
inc bp
jnz fillzero
;Create a particle
;ax and bp should be zero here
;Draw a moving line

drawLine
cmp byte [bp+si],15
jnz skipparticle

;Create a new particle
mov di, [bx+2]
inc word [bx+2]
and di, PARTCOUNT-1
shl di, 3
add di, particles
;downward speed
call rand
shr ax, 10
stosw
;y coordinate
imul ax, dx, 16
stosw
;x speed
call rand
sar ax, 12
stosw
;x coordinate
mov ax, bp
shl ax, 6
stosw


mov al, 0xd0
out 43h, al
call rand
and al, 0x81
out 42h,al
;Make some noise
;in al, 61h
;xor al, 2
;out 61h,al

skipparticle:
mov byte [bp+si],4
inc bp
cmp bp, 320
jb drawLine

;Update my particles and render them
mov cx, PARTCOUNT
mov si, particles
partLoop:

;Speed and coordinate
inc word [si]
lodsw
add [si],ax
lodsw
shr ax, 7
jz skipPartDraw
cmp al, 200
jae skipPartDraw

imul bp, ax, 320
lodsw
add [si],ax
lodsw
shr ax, 6
add bp, ax
;silly colors
mov ax, si
shr ax, 2

mov byte [bp], al

loop partLoop
jmp nextframe

skipPartDraw
mov [si-4],ebx
add si, 4

loop partLoop

nextframe:


;increase counter
dec dx
jnz newScreen
inc dx
jmp newScreen


;Return random number in ax
rand:
mov ax, [bx]
add ax, 21365
imul ax, 4125
mov [bx], ax
ret


DEADLINE:
db 'LAZYIDEA'
db 'NOEFFORT'
db 'MORETIME'
db 'DEADLINE'

particles:
PARTCOUNT equ (4096)



