;Saves a TGA screenshot (assumes mode 10eh = 320x200, 16 bit).

SCREENSHOT
  pusha
  pushf
  push ds

  push cs
  pop  ds

;increase filename number

  mov  di,FILENAME + (HEADER-FILENAME) - 5
INCNAME
  inc  byte[di]
  cmp  byte[di],':'
  jb   ENDINCNAME
  mov  byte[di],'0'
  dec  di
  jmp  INCNAME
ENDINCNAME

;write the TGA file and return

  mov  ah,3Ch  ; create file
  mov  dx,FILENAME
  xor  cx,cx
  int  21h

  xchg ax,bx   ; bx=handle

  mov  ah,40h  ; write header and palette
  mov  dx,HEADER
  mov  cx,18
  int  21h


  xor dx,dx  ; page: 0..1
PAGES:
  push bx
  mov ax,0x4f05  ; each line: set VESA window, assume 64kB granularity
  xor bx,bx      ; bh=0 bl=window=0 dx=page
  int 10h
  pop bx

  push dx

COPY_PAGE:
  xor si,si

NEXT_BLOCK:
  mov di,BLOCK
  mov dx,BLOCK
CONVERT_BLOCK:
  push 0A000h
  pop  ds

  mov ax,[si]
  and ax,0b11111
  imul ax,0b0000100001000010
  mov [cs:di],ah
  inc di

  mov ax,[si]
  shr ax,5
  and ax,0b111111
  imul ax,0b0000010000010000
  mov [cs:di],ah
  inc di
  
  mov ax,[si]  ; [0]:gggbbbbb [1]:rrrrrggg
  shr ax,16-5
  imul ax,0b0000100001000010
  mov [cs:di],ah
  inc di
  
  inc si
  inc si
  
  cmp di,BLOCK+1024*3
  jne CONVERT_BLOCK
  
  push cs
  pop ds

  mov ah,40h  ; write pixels
  mov cx,1024*3
  int 21h
  
  test si,si
  jnz NEXT_BLOCK

  pop dx
  inc dx
  cmp dx,2
  jne PAGES

  mov  ah,3Eh  ; close file
  int  21h

  pop  ds
  popf
  popa
  ret

FILENAME db "0000/.tga" ;,0
HEADER   db 0,0,2
         dw 0,0
         db 0
         dw 0,0,320,200
         db 24,00100000b

section .bss align=1
BLOCK resb 1024*3
