/* MAGIXFLY.C  - Tiny MSDOS 3d flying effect demo in 144 bytes.
   (C) A.Millett 2012-2025. Released as free software under GNU GPL3 license. 
	(See: www.gnu.org/licenses/gpl-3.0.html )
	
Simple demo of ultra-small compilation using TurboC 3.

To compile: tctiny.bat tc3path magixfly
ie: tctiny \m\tc3\bin magixfly

   (needs MASM and exe2bin, or TASM)
*/

#include "tctiny.c" 

unsigned char far *pVdu;

unsigned int frame;	/* Frame count */

void main() 
{
    register unsigned int x;
    unsigned int y;
    unsigned int calcy;

    IO_VIDEOMODE (0x13);	/* Set VGA video mode 13h 320x200x256 */
    
    do {
      pVdu = (char far *) ((long) 0xa0000000L);
      for (y=10; y<210; y++) {
        calcy = ((2560/y) + frame) ;
        for (x=320; x; x --) {
          *pVdu = (BYTE) (((((x<<4)/y) ^ calcy) + (frame >> 8)) & 31) ;
          pVdu ++;
        }
      }
      frame ++;
      IO_GETKEY (x);               /* See if ESC key hit */
    } while (x == 0);
}
