; MAGIXFLY.ASM   - Simple 3d flying demo in 64 Bytes! (C) A.Millett 2014-2025. (+rrrola, see below)
;-----------------------------------------------------------------------------
;  
; Released as free/open software under the terms of the GNU GPL3 license.  
;      See:  www.gnu.org/licenses/gpl-3.0.html 
;  
; This is a simple DOS/VGA old-school graphics demo program in x86 Assembler, 
; demonstrating some basic asm methods. 
; It can run on an 8086 (or later) PC with VGA under MSDOS/Freedos.
; It does not require an FPU.
; For modern PCs, it will run on Linux/Windows in DOSBOX, or other emulators.
;
; All variables held in registers.
;
; It uses the NETWORK x86 assembler, NASM, but can easily be adapted to others. 
; Build with: NAS2COM magixfly
;   or    NASM -f bin magixfly.asm -o magixfly.com
;
; If you replace the key-hit check & ret with jp reloop, you can save 4 bytes.
;-----------------------------------------------------------------------------
;  History..
; ->DFLYA5  (23.10.2014) (64 bytes)
;  Take old demo, tidy up, add comments etc.
;  Remove shr ax,1   Add mov di,OFFSETY  (reduce flicker)
;  Imp constants OFFSETY, VDUX, VDUY 
; ->MAGIXFLY63 (20.4.2025) (63 bytes)
; 
;  25.4.2025 - A rework of the code from user "rrrola" brings the .COM size down to 52 Bytes.
; ->MAGIXFLY (20.4.2025) (52 bytes)
;   You can save 4 bytes more by not allowing user exit by hitting a key.
	; Init some Constants

; es:di = pixel address, bx=time, bp=y, cx=x

OFFSETY equ 12

  org 100h

  mov al,19
  int 10h			 	; Screen mode 19 - VGA 320x200x256  (Using default VGA palette)
  push 0A000h
  pop es

reloop:
  mov bp,OFFSETY

loopY:
  inc bp
  mov ax,0A00h
  cwd  ; dx=0 (ax=2560)
  div bp
  add ax,bx
  xchg ax,si

  mov cx,320
loopX:
   imul ax,cx,16
   cwd  ; dx=0 (ax<=5120)
   div bp
   xor ax,si
   add al,bh
   and al,31
   stosb		; (es:di) = al
  test di,di		
  loopnz loopX		; X--; if (X) goto loopX;
  jnz loopY		
; di=0 after the loop

  inc bx

  mov ah,1
  int 16h
  je reloop

  ret




section .data		; Initialised data section

;tim:  dw 0		; Time var (init to 0)

section .bss	; Uninitialised data sect..

;tim:  resb 2	; Time var (reserve 2 bytes)

