// 2D noise texture

#include <stdio.h>
#include <stdint.h>

#define WIDTH 256
#define HEIGHT 256

uint8_t img[WIDTH*(HEIGHT+1)];

int main() {
  uint32_t adr=WIDTH*HEIGHT-1;
  int32_t r=0;
  int32_t a=0;
  while (adr != -1u) {         // a = img[right]       | filter:
    a += img[adr + WIDTH - 1]; // a += img[left below] |     X 0.5
    a = (a + 1) >> 1;          // rounded average      | 0.5 . .
    r = r*85 + 1;              // next random value
    a += r >> 27;              // a += random(-16..15)
    a = a<0? 0 : a>255? 255 : a;  // clamp
    img[adr] = a;
    adr--;
  }
  
  // save a PGM image
  FILE* f = fopen("texture.pgm", "wb");
  if (f) {
    fprintf(f, "P5 %d %d 255\n", WIDTH, HEIGHT);
    fwrite(img, 1, WIDTH*HEIGHT, f);
    fclose(f);
  }
}
