;=======================================;
;         (- C.u.b.e.r.a.i.l -)         ;
;             by Assembler BoT          ;
;                                       ;
; Best viewed in DoxBox, 300000 cycles. ;
;                                       ;
;  Greetings everyone at Demobit 2o19!  ;
;=======================================;

VECTOR_X			EQU 24
VECTOR_Y			EQU 28

ROTATED_X			EQU 16
ROTATED_Y			EQU 20

[ORG 0x0100]
[SEGMENT .text]

	;-----------------------
	; set mode 320 x 200, 256 colors
	;-----------------------
	mov al,13h
	
	;-----------------------
	; palette
	;-----------------------
palette:
	int 10h

	mov cl,bl
	mov ch,bl
	mov dh,bl
	shr ch,1
	shr dh,2
	mov ah,bl
	sahf
	jz short p01
	mov cl,0
p01:
	js short p02
	xchg ch,cl
p02:
	mov ax,1010h
	dec bx
	jnz short palette

	;-----------------------
	; prepare output & time
	;-----------------------
	push word 0a000h
	pop es
	mov si,ax					; set si to safe area behind code
	mov byte [si+3], 049h		; set proper mantissa from time counter

	;-----------------------
	; frame
	;-----------------------
nextframe:
	
	;-----------------------
	; render
	;-----------------------
render:
	mul cx						; cx=0 => clears ax and dx in single instruction (nice trick from fr-01)
	add ax,di					; same as mov ax,di but also sets flags
	
	jnz skip_frame_inc
	inc word [si]				; move time exactly once per frame when di is zero
skip_frame_inc:

	mov bx,320
	div bx						; ax=Y dx=X
	add bx,bx					; safe offset after code (640)
	
CONST160 equ $+2
	sub dx,160
	sub ax,100

	test al,1					; check for every second line and clear CF, actual jump by this test is few instructions later

	; [bx]=SDF [si]=time [si+bx]=ANIMATION_ANGLE
	fninit
	
	;-----------------------
	; prepare camera vector
	;-----------------------
camera_vector:
	mov [bx],dx
	fild word [bx]
	fidiv word [CONST160]		; almost unit vectors
	xchg ax,dx
	cmc
	jc short camera_vector
	
	salc						; clear pixel color, CF=0 here
	jz draw						; draw black pixel (every second line)
	
								; st0=Vy st1=Vx
	fst dword [si+VECTOR_Y]		; st0=Vy st1=Vx
	fadd dword [CONSTM2_75]
	fxch st1					; st0=Vx st1=Vy
	fst dword [si+VECTOR_X]		; st0=Vx st1=Vy
	fld1						; st0=Vz st1=Vx st2=Vy

	;-----------------------
	; raymarching on SDF
	;-----------------------
	
	mov cl,64					; max ray iterations
raymarch:
								; st0=Pz st1=Px st2=Py
	;-----------------------
	; SDF
	;-----------------------

	; outer tunnel SDF
	fld st2						; st0=Py st1=Pz st2=Px st3=Py
	fmul st0					; st0=Py*Py st1=Pz st2=Px st3=Py
	
	fld st2						; st0=Px st1=Py*Py st2=Pz st3=Px st4=Py
	fmul st0					; st0=Px*Px st1=Py*Py st2=Pz st3=Px st4=Py
	
	faddp st1					; st0=Px*Px+Py*Py st1=Pz st2=Px st3=Py
	fsqrt						; st0=sqrt(Px*Px+Py*Py) st1=Pz st2=Px st3=Py
	fldl2t						; st0=Ro st1=sqrt(Px*Px+Py*Py) st2=Pz st3=Px st4=Py
	fsubrp st1					; st0=SDFo st1=Pz st2=Px st3=Py
	fstp dword [bx]				; st0=Pz st1=Px st2=Py
	
	; cube animation parameter iz
	fld st0						; st0=Pz st1=Pz st2=Px st3=Py
	fldl2t						; st0=3.34 st1=Pz st2=Pz st3=Px st4=Py
	fdivp st1					; st0=Pz/3.34 st1=Pz st2=Px st3=Py
	fadd dword [si]				; st0=Pz/3.34+TIME st1=Pz st2=Px st3=Py
	frndint						; st0=floor(Pz/3.34+TIME) st1=Pz st2=Px st3=Py
	fadd dword [si]				; st0=iz=floor(Pz/3.34+TIME)+TIME st1=Pz st2=Px st3=Py
	fcos						; st0=cos(iz) st1=iz st2=Pz st3=Px st4=Py
	fst dword [si+bx]			; st0=iz st1=Pz st2=Px st3=Py

	; cube rotation
	fsincos						; st0=cos st1=sin st2=Pz st3=Px st4=Py
	
	fld st4						; st0=Py st1=cos st2=sin st3=Pz st4=Px st5=Py
	fmul st1					; st0=cY st1=cos st2=sin st3=Pz st4=Px st5=Py
	fld st4						; st0=Px st1=cY st2=cos st3=sin st4=Pz st5=Px st6=Py
	fmul st3					; st0=sX st1=cY st2=cos st3=sin st4=Pz st5=Px st6=Py
	faddp st1					; st0=rotX st1=cos st2=sin st3=Pz st4=Px st5=Py
	fst dword [si+ROTATED_X]
	fabs						; st0=|rotX| st1=cos st2=sin st3=Pz st4=Px st5=Py
	
	fxch st2					; st0=sin st1=cos st2=rotX st3=Pz st4=Px st5=Py
	fmul st5					; st0=sY st1=cos st2=rotX st3=Pz st4=Px st5=Py
	fxch st1					; st0=cos st1=sY st2=rotX st3=Pz st4=Px st5=Py
	fmul st4					; st0=cX st1=sY st2=rotX st3=Pz st4=Px st5=Py
	fsubrp st1					; st0=rotY st1=rotX st2=Pz st3=Px st4=Py
	fst dword [si+ROTATED_Y]
	fabs						; st0=|rotY| st1=|rotX| st2=Pz st3=Px st4=Py
	
	; inner tunnel SDF
	faddp st1					; st0=dist st1=Pz st2=Px st3=Py
	fldl2e
	fsubp st1					; st0=SDFi st1=Pz st2=Px st3=Py
	
	; final SDF value = min(SDFo,SDFi)  --> [bx]
	fcom dword [bx]
	fnstsw ax
	sahf
	ja short outer_is_closer
	fst dword [bx]				; replace by final SDF value
outer_is_closer:
	fsub st0					; st0=0 st1=Pz st2=Px st3=Py, just get rid of stack top
	
	;-----------------------
	; hit check
	;-----------------------
CONST_INV124 equ $
	cmp byte [bx+3], 03ch		; compare just sign and mantissa bits, it's similar to comparison with 0.01, good enough to stop iteration
								; also this instruction is roughly 1/124.5 which is used as color scale
	jg continue
	mov cl,1					; break the loop and make sure that cx is 0 in next render loop
continue:
	
	;-----------------------
	; advance ray
	;-----------------------
	fadd dword [si+VECTOR_X]	; st0=Vx st1=Pz st2=Px st3=Py
	fmul dword [bx]				; st0=Vx st1=Pz st2=Px st3=Py
	faddp st2					; st0=Pz st1=Px st2=Py
	
	fld dword [si+VECTOR_Y]		; st0=Vy st1=Pz st2=Px st3=Py
	fmul dword [bx]				; st0=Vy st1=Pz st2=Px st3=Py
	faddp st3					; st0=Pz st1=Px st2=Py

	fadd dword [bx]				; st0=Pz st1=Px st2=Py

	loop raymarch

	;-----------------------
	; calculate color
	;-----------------------
CONSTM2_75 EQU $
	
	; st0=Pz st1=Px st2=Py
	fadd dword [si]				; st0=Pz+TIME st1=Px st2=Py (texture shift)
	xor al,al					; set color shift to 0
	
	sahf						; ah still contains last SDF value check flags
	ja short outer_color
	
	; inner color
	fld dword [si+bx]			; st0=ANGLE st1=Pz st2=Px st3=Py
	
	; rotate cube normal by PI/2 on every second side
	mov ah,[si+ROTATED_Y+3]
	xor ah,[si+ROTATED_X+3]
	sahf						; check just signs of 32bit floats
	js skip_rotation
	fldl2e						; st0=almost PI/2 st1=ANGLE st2=Pz st3=Px st4=Py
	faddp st1					; st0=ANGLE+PI/2 st1=Pz st2=Px st3=Py
skip_rotation:
	mov al,128					; set color shift to 128

outer_color:
	; outer tunnel color and also dot product of inner cubes normal with directional light
	fcos						; st0=cos st1=Pz st2=Px st3=Py
	fmul st0					; st0=cos*cos st1=Pz st2=Px st3=Py, intensify specular and also eliminate negative values
	fdiv dword [CONST_INV124]	; color scale
	fistp word [si+bx]			; st0=Pz st1=Px st2=Py
	add al,[si+bx]				; add color to shift value

	;-----------------------
	; draw
	;-----------------------
draw:
	stosb
	
	;-----------------------
	; esc test
	;-----------------------
	in al,60h
	dec al
	
	;-----------------------
	; next pixel
	;-----------------------
	jnz render

	;-----------------------
	; back to text mode, nice but +5 bytes
	;-----------------------
	;mov ax,03h
	;int 10h

	ret
