; ---------------------------------------------------------------------------------------------
; StarLine 256 bytes intro v1.1 [main code include file] (c) 2018-2020 by Jin X (jin_x@list.ru)
; ---------------------------------------------------------------------------------------------

; don't touch all these settings !!!
if	pts_on_line = 128 | draw_stars
  sub_pts_count	=	1
else
  sub_pts_count	=	0
end if

if	set_palette = -1
  connect_flash	=	0
end if

if	connect_flash & (inc_distance = 2 | flash_freq < 0x100)
  add_grad_col	=	0
else
  add_grad_col	=	connect_flash
end if

if	set_palette
  max_grad_col	=	63 + add_grad_col
  dist_div_coef	=	1
else
  max_grad_col	=	14 + add_grad_col
  dist_div_coef	=	4
end if

if	dist_method = 3 & inc_distance = 1
  display	">>> You can't set together dist_method = 3 & inc_distance = 1 !!!",7,13,10
  err
end if

if	~ midi_sound
  blink_on_beat	=	0
  if	flash_freq =	0
    connect_flash =	0
  end if
end if

; if-then-else
macro	ifel	cond, true, false
{
	if cond
		true
	else
		false
	end if
} ; ifel

;-----------------------------------------------------------------------------------------------------------------------

; initialize video mode and palette
macro	InitVideo
{
ifel safe_mode,	<mov ax,0x13>, <mov al,0x13>
		int	0x10			; init video mode

if	set_palette = 1
  ifel safe_mode, <xor bl,bl>
		mov	dx,0x3C9
		mov	al,64
		; color of lines: 1=blue, 2=green, 3=cyan (blue+green), 4=red, 5=magenta (red+blue), 6=yellow (red+green)
ifel line_color = 2, <xchg ax,bx> ; switch red off for green(2) - only for 1st pass
	@@:
ifel line_color = 1 | line_color = 3, <xchg ax,bx> ; switch red off for blue(1), green(2), cyan(3); red is still on for red(4), magenta(5), yellow(6)
		out	dx,al
ifel line_color >= 2 & line_color <= 5, <xchg ax,bx> ; switch green on for green(2), cyan(3); switch green off for red(4), magenta(5); green is still on for yellow(6); green is still off for blue(1)
		out	dx,al
ifel line_color = 1 | line_color = 2 | line_color = 5 | line_color = 6, <xchg ax,bx> ; switch blue on for blue(1), magenta(5); switch blue off for green(2), yellow(6); blue is still on for cyan(3); blue is still off for red(4)
		out	dx,al
ifel line_color = 4 | line_color = 6, <xchg ax,bx> ; switch red on for red(4), yellow(6); red is still on for magenta(5); red is still off for blue(1), green(2), cyan(3)
ifel line_color = 2, <dec bx>, <dec ax>
		jnz	@B
end if
} ; InitVideo

; initialize star coordinates and deltas
macro	InitCoords
{
	local	.next
if	randomize
		rdtsc
		xchg	bp,ax
end if
ifel safe_mode,	cld
		mov	di,star_coords
ifel safe_mode,	<mov cx,star_count>, <mov cl,star_count>
	.next:
ifel beauty_start = 2, <mov bx,320>, <mov bx,200>
	@@:	call	Random
		stosw
ifel beauty_start = 2, <sub bx,320-200>, <dec bx>
		jnp	@B
ifel beauty_start, <mov bl,max_speed*2+1>, <mov bl,max_speed>
	@@:	call	Random
if	beauty_start
  if	max_speed = 1
		dec	ax
  else
		sub	al,max_speed
  end if
		jz	@B
else
		inc	ax
end if
		stosb
		neg	cx
		js	@B
		loop	.next
} ; InitCoords

; clear screen buffer
; before call it must be set: si = screen_buffer, cx = 0
macro	ClearBuffer
{
		salc				; al = 0xFF (black), ah = 0 or 0xFF
		mov	ch,320*200/256/2
		rep stosw
}

; little delay
; before call it must be set: cx = 0 (if delay_type = 2)
macro	Delay
{
if	delay_type = 1
		hlt
else if delay_type = 2
		mov	ah,0x86
		cwd				; dx = 0xFFFF
		int	0x15
else if delay_type = 3
		mov	dx,0x3DA
	@@:	in	al,dx
		test	al,8			; vertical retrace
		jz	@B
else if delay_type = 4
		mov	di,0x46C
		mov	ax,[fs:di]
	@@:	cmp	ax,[fs:di]
		je	@B
end if
} ; Delay

; play MIDI music
macro	PlayMusic
{
if	midi_sound = 1
		PlayMusicPSP
else if	midi_sound >= 2
		PlayMusicMelody
else ; midi_sound = 0
		mov	si,star_coords		; for DrawAndMove
end if
} ; PlayMusic

; play MIDI music from PSP (maybe cacaphony) :)
macro	PlayMusicPSP
{
	local	.nosound
		mov	si,music_counter
		inc	byte [si]
		lodsb

ifel <delay_type = 3>, <mov dl,0x30 + enter_uart>, <mov dx,0x330 + enter_uart>
if	enter_uart
		outsb				; [0x3F] enter UART mode
		dec	dx
end if

if	midi_polyphony
		aam	sound_speed
		pushf
		and	ah,15
		mov	al,ah
		outsb				; [0xC0] program change (+ instrument)
  if	midi_polyphony = 1
		inc	ax
  else
		and	al,3
		add	al,35
  end if
		out	dx,al			; instrument
		popf
end if
		outsb				; [0x90] note on (+ note + volume)

ifel ~ midi_polyphony, <aam sound_speed>
		jnz	.nosound

ifel ~ midi_polyphony, <and ah,15>
		movzx	bx,ah
		mov	al,[bx]
		and	al,15
		jz	.nosound
		add	al,base_note
		out	dx,al			; note
ifel safe_mode, <mov al,0x7F>
		out	dx,al			; volume
	.nosound:
} ; PlayMusicPSP

; play MIDI music with melody
macro	PlayMusicMelody
{
	local	.nosound, .1
		mov	si,music_counter
		inc	byte [si]
		lodsb
		mov	cl,al

ifel <delay_type = 3>, <mov dl,0x30 + enter_uart>, <mov dx,0x330 + enter_uart>
if	enter_uart
		outsb				; [0x3F] enter UART mode
		dec	dx
end if

if	midi_polyphony
		outsb				; [0xC0] program change (+ instrument)
  if	midi_polyphony = 1
		shr	al,3 + bsf sound_speed
		inc	ax
  else
		shr	al,1 + bsf sound_speed
		and	al,3
    if	midi_sound = 4
		add	al,37
    else
		add	al,36
    end if
  end if
		out	dx,al			; instrument
end if
		outsb				; [0x90] note on (+ note + volume)

ifel midi_polyphony, <test cl,sound_speed-1>, <test al,sound_speed-1>
		jnz	.nosound

if	midi_sound = 2
		mov	eax,0x99A5A5A0		; "Grasshopper" notes
else if	midi_sound = 3
		mov	eax,0x1949DBD0		; "Pop Corn" notes
else if	midi_sound = 4
		mov	ax,0xDCDC		; "Omen" notes (part 1)
		mov	bx,0x003C
else if	midi_sound = 5
		mov	eax,0x677B4559		; "I'm raving" notes (part 1)
end if
if	sound_speed > 4
		shr	cl,bsr sound_speed - 2
else if sound_speed < 4
		shl	cl,2 - bsr sound_speed
end if
if	midi_sound = 2 | midi_sound = 3
		shr	eax,cl
else if	midi_sound = 4 | midi_sound = 5
		test	cl,0x20
		jz	.1
  if	midi_sound = 4
		mov	ax,0x4343		; "Omen" notes (part 2)
		mov	bl,0x18
	.1:	shrd	ax,bx,cl
  else
		mov	eax,0x44014434		; "I'm raving" notes (part 2)
	.1:	shr	eax,cl
		and	al,15
		add	cl,cl
		and	cl,3*8			; (note number and 3) * 8
		add	al,cl			; add 8 semitones
  end if	
end if
if	midi_sound <> 5
		and	al,15
		jz	.nosound
end if
		add	al,base_note
		out	dx,al			; note
ifel safe_mode, <mov al,0x7F>
		out	dx,al			; volume
	.nosound:
} ; PlayMusicMelody

; draw stars and lines, then move stars
; before call it must be set: si = star_coords, ch = 0
macro	DrawAndMove
{
	local	.next1, .next2, .skip, .end2, .move
		mov	cl,star_count

	.next1:	; draw lines
		lodsw
		xchg	di,ax			; di = Xa
		lodsw
		xchg	bp,ax			; bp = Ya

		pusha				; we need si and cx
		lodsw
	.next2:
		dec	cx
		jz	.end2
		lodsw
		sub	ax,di

if	dist_method = 1
		push	ax
		imul	ax
		xchg	bx,ax			; bx = (Xb-Xa)^2
		lodsw
		pop	dx			; dx = deltaX
		jc	.skip			; if result > 65535 on 'imul ax'

		sub	ax,bp
		push	ax
		imul	ax,ax			; ax = (Yb-Ya)^2 (we need to save dx)
		add	bx,ax			; bx = (Xb-Xa)^2 + (Yb-Ya)^2
		pop	ax			; ax = deltaY
		jc	.skip			; if overflow on 'add bx,ax'
		js	.skip			; if result is > 0x7FFF

		push	bx
		mov	bx,sp
		fild	word [bx]
		fsqrt
		fistp	word [bx]
		pop	bx			; bx = sqrt(bx) = distance

else ; ~ dist_method = 1
		mov	dx,ax
		jns	@F
		neg	ax
	@@:	xchg	bx,ax			; bx = |Xb-Xa| (deltaX)

		lodsw
		sub	ax,bp
		push	ax
		jns	@F
		neg	ax
	@@:
  if dist_method = 2
		cmp	bx,ax			; ax = |Yb-Ya| (deltaY)
		jnb	@F
		xchg	bx,ax			; bx = max(deltaX,deltaY) = distance
  else
		add	bx,ax
  end if
	@@:	pop	ax			; ax = deltaY
end if ; sqrt_distance

if	inc_distance = 1
		imul	bx,179/dist_div_coef	; bh = max(deltaX,deltaY)*0.7
		cmp	bh,max_grad_col
else
  if	inc_distance = 2
		shr	bx,1 + bsr dist_div_coef
  else ; inc_distance = 0
    ifel ~ set_palette, <shr bx,2>
  end if
		cmp	bx,max_grad_col
end if
		ja	.skip

if	connect_flash & flash_freq <> 0x100 & set_palette = 1
  if	flash_freq = 0
		test	byte [music_counter],flash_beat_freq-1
		jnz	@F
    ifel <inc_distance = 1>, <inc bh>, <inc bx>	; add 1 to flash sometimes
	@@:
  else
		push	ax
		in	al,0x40
		cmp	al,flash_freq
    ifel <inc_distance = 1>, <adc bh,ch>, <adc bl,ch> ; add 1 to flash sometimes
		pop	ax
  end if
end if

if	~ set_palette
  if	inc_distance = 1
    ifel connect_flash, <je @F>
		not	bh
	@@:	add	bh,0x20
  else
    ifel connect_flash, <je @F>
		not	bl
	@@:	add	bl,0x20
  end if
end if
ifel <connect_flash & inc_distance = 2 & flash_freq = 0x100>, <inc bx>
		DrawLine			; di,bp = Xa,Ya, dx,ax = deltaX,deltaY, bl (or bh) = color
	.skip:
		lodsw
		jmp	.next2
	.end2:
		popa				; cx and si

		; draw and move stars
		mov	dx,320
if	draw_stars
		imul	bp,dx
  ifel <star_color = 0x40>, <mov byte [di+bp+screen_buffer],dl>, <mov byte [di+bp+screen_buffer],star_color>
end if
		mov	bx,-5
	.move:
		lodsb
		cbw
		add	[si+bx],ax
		cmp	[si+bx],dx
		jb	@F
		neg	byte [si-1]
		add	ax,ax
		sub	[si+bx],ax
	@@:	inc	bx
		sub	dx,320-200
		jnp	.move
if 	$-.next1 < 127
		loop	.next1
else
		dec	cx
		jnz	.next1
end if
} ; DrawAndMove

; draw line from di,bp to di+dx,bp+ax pixel coordinates (excluding first and last [if pts_on_line=128 | draw_stars] points)
; with color bl (bh in inc_distance = 1 mode)
; all registers are saved except ch = 0
macro	DrawLine
{
	local	.next
		mov	ch,pts_on_line-sub_pts_count
	.next:	pusha

		; i donno how to optimize this more :(
	@@:	imul	ch
		sar	ax,bsr pts_on_line	; y and then x distance of point
		add	bp,ax
		neg	si
		jns	@F
		imul	bp,320
		xchg	ax,dx
		jmp	@B
	@@:
  ifel <inc_distance = 1>, <mov [di+bp+screen_buffer],bh>, <mov [di+bp+screen_buffer],bl>
		popa
		dec	ch
		jnz	.next
} ; DrawLine

; copy screen buffer to video buffer and clear screen buffer
; before call it must be set: si = screen_buffer, cx = 0, dh = 0
macro	CopyAndClear
{
		xor	di,di
		mov	ch,320*200/256
if	blink_on_beat
		test	byte [music_counter],flash_beat_freq-1
  if	blink_color = 1
		setz	dh
  else
		jnz	@F
		mov	dh,blink_color
  end if
end if
	@@:	movsb
		mov	[si-1],dh
		loop	@B
} ; CopyAndClear

;-----------------------------------------------------------------------------------------------------------------------

use16
org	0x100

		; ax=bx=0 (if no cmd line params), cx=0xFF, dx=cs=ds=es=ss, si=0x100, di=sp=0x0FFFE (as a rule), bp=0x91?,
		; fs=0 (on DOSBox, FreeDOS; not on all systems), flags=0x?202 (all base flags including cf=0; if=1)
		InitVideo
		InitCoords
ifel preclear_buf, ClearBuffer
		push	0xA000
		pop	es

	.mainloop:
		Delay
		PlayMusic
		DrawAndMove
		CopyAndClear

if	allow_exit
		in	al,0x60
		cbw
		dec	ax
		jnz	.mainloop

  if	ret_text_mode
		mov	al,3
		int	0x10
  end if

  if	print_sign
		mov	ah,9
		mov	dx,sign
		int	0x21
  end if

  if	wait_key
		mov	ax,0xC07
		int	0x21
  end if
  ifel safe_mode, <int 0x20>
else ; ~ allow_exit
		jmp	.mainloop
end if ; allow_exit

;-----------------------------------------------------------------------------------------------------------------------

; generate random number from 0 to bx-1, result in ax
Random:
		imul	bp,-123
  ifel randomize | safe_mode, <inc bp>		; random will not work if bp = 0
		mov	ax,bp
		mul	bx
		xchg	ax,dx
		ret

if	print_sign
  sign		db	"(c) Jin X / CC'18"
  ifel allow_exit, <db 10,'$'>
end if

if	midi_sound
  ifel best_music_start | (allow_exit & ~ safe_mode), <db 0>
  music_counter	=	$-1
  ifel enter_uart, <db 0x3F>
  ifel midi_polyphony, <db 0xC0>
		db	0x90
end if

star_coords	rw	star_count*3		; word X, word Y, byte deltaX, byte deltaY
screen_buffer	rb	320*200
