;"killed by 00256" - intro by Kuemmel for Revision 2018
bond_colour   = 16
circle_colour = 15
spiral_colour = 15
org 100h
use16

;---init data
  mov al,13h  				;mode 13, 320x200
  int 10h

  ;---draw 00256
  mov bp,bond_data
  xchg al,ah				;ax needs to be 1300h / al = attribute (cursor fix=0), ah = 13h (write string)
  mov bl,bond_colour	 	;bl = foreground colour for bond
  mov dx,20+11*256		 	;dl = x, dh = y position of text
  mov cl,9	         	 	;cx = length of string
  int 10h				 	;plot string, attention: ES needs to be = CS !

  push 0a000h				;graphics address
  pop es
  mov si,bond_tune			;init bond tune address, must stay the same all over as bp+si is also the timer
  mov word[bp+si],0xff7f    ;TIMER starts at around " - 4 seconds" 

;---main loop with all the timer stuff

main_loop:
  xor bx,bx					;clear for fp_routine
  
;---draw circle und take care of 00256
circle_loop:
  xor dx,dx					;init for div, crash otherwise
  mov ax,di
  mov cx,320				;no rrrrola this time, need the range and it is shorter like that
  div cx					;ax = y ; dx = x
  mov cl,al					;backup for blood test
  sub dx,159				;center x ...ouch...4 bytes...
  sub dx,word[si+64]		;add to x ...assume word[si+64] is zero at fresh DOSBox start

  sub ax,99					;center y
  jnz y_no_zero
    inc ax					;capture zero div, costs 3 bytes...otherwise visible line...
  y_no_zero:

  ;---draw spiral & circle & check if bond is there
  pusha						;based on http://www.sizecoding.org/wiki/Floating-point_Opcodes by Hellmood, thanx !
  fild 	word	[bx-8]		;x
  fild 	word	[bx-4]		;y 				x
  fpatan					;arc
  fld 	st0					;arc 			arc
  fcos						;cos(arc) 		arc
  fimul	dword	[si+15]		;l*cos(arc) 	arc		get suitable integer at that code position
  fidiv	word	[bx-4]		;l*cos(arc)/x	arc
  fistp	word	[bx-4]		;arc
  fimul	word	[bx]		;scaled_arc				bx is 0x20cd = 8397
  fistp	word	[bx-5]		;overwrite al, ch is also overwritten
  popa
  xor al,ah					
  test al,1111b				;dot on spiral !?
  salc						;clear if no spiral
  jne blacky
	mov al,spiral_colour
  blacky: 
  cmp ah,65					;check if in or outside circle, radius based on l*cos(arc(x/y))/x
  jb outside
	mov al,bond_colour
	cmp byte[es:di],al		;check if bond is there already
	je bond			
	  dec ax				;mov al,circle_colour, dec ax only works for bond_colour = 16
  outside:
  xor ch,ch					;needed for blood test as fp routine writes on ch
  cmp word[bp+si],cx   		;TIMER check
	jl bond					;draw blood dependant on y, after 0x0100 is reached blood is always there
	  and al,100b			;blood depending on timer and line, 4 is red = 0100b, AND works for white = 15 = 1111b
  bond:
  stosb
  test di,di
  jnz circle_loop
  
;--bond tune check & play & trigger circle movement offset
  mov dx,0x331				;init address also for tune play
  cmp word[bp+si],0xfff0	;TIMER - play a little before melody starts
  jne no_shot				;play gunshot sound only once and init instrument/vibrato for melody
	pusha
	;---play gunshot
	mov si,gunshot_data		;address of gunshot data
	outsb					;change to UART mode
	dec dx					;dec to data address
	mov cl,10				;ch zero from before
	rep outsb
	;---	
	popa
  no_shot:
    
;---bond tune check & play & calc x_offset for circle_loop
  cmp word[bp+si],bx		;TIMER check: BX is zero, saves a byte over using '0'
  js dont_do_anything
							
  ;---move circle with timer...
  fild word[bp+si]			;timer
  fidiv word[si-4]			;timer/speed_factor
  fsin						;sin(time/speed_factor)
  fimul word[si-2]			;x_factor*sin(time/speed_factor) = -x_factor...0...x_factor
  fistp word[si+64]			;store x_offset for circle_loop

  dec dx					;UART is already inited, just get data address
  mov bl,byte[bp+si]
  test bl,00000001b			;check timer
  jnz dont_do_anything
    mov al,10010000b	    ;play note 1001cccc | cccc = channel = 0
    out dx,al
	and bl,01111111b
	shr bl,2				;check with jnc later
	mov al,byte[si+bx]		;get byte from 4 Bit table, 64 notes/pauses
	jnc note_even			;even or uneven note count ?
		shr al,4			;mask upper half
	note_even:
	and al,00001111b		;mask lower half
	jz dont_do_anything 	;zero note is 'pause'
		add al,63			;add base note level 'E'-1 = 63   
		out dx,al
		mov al,01111111b	;play loud
		out dx,al
  dont_do_anything:
  
  inc word[bp+si]			;global timer based on vsync
  
;---vsync for timing
  mov dx,3dah
  vsync:
    in al,dx
    test al,8
  jz vsync
   
;---check keyboard 
  in al,0x60			  ;check for ESC
  dec al				  ;ax doesn't work as ah is not zero...
  jnz main_loop
  ret

;---data  
bond_data	    db  1,10,8,8		;or '2'
				db  170,219,10,8	;bond in ascii ;-)
				db  208

gunshot_data	db  0x3f,11000001b,127,10010001b,60,127 ;change to UART, select and play gunshot on channel 1
melody_instr    db  11000000b,11,10110000b,1,63			;then change instrument for melody on channel 0 to vibraphone and
														;set midi controller for vibrato/tremolo for a more spooky sound
speed_factor	dw  14									;defines speed of -x...+x movment
x_factor		dw  24									;defines amount of -x...+x movement in pixels
bond_tune		db 	 1+0*16, 3+3*16, 3+0*16, 3+0*16,      0, 1+0*16, 1+0*16, 1+0*16
				db 	 1+0*16, 4+4*16, 4+0*16, 4+0*16,      0, 3+0*16, 3+0*16, 1+0*16
				db 	12+0*16,11+0*16,      0,      0,      0,      0, 8+0*16, 6+0*16
				db 	 8+0*16;,     0,      0,      0,      0,      0,      0,      0
;bond tune encoded in 64 * 4 Bit note data as offset values to base level. Zero is 'pause'	
;skipped the last 7 bytes as memory is initiated in zeros when you have a fresh DOSBox start.
