; Killing Your Eyes - 256 byte intro
; entry for Function 2019 demo party
; code: TomCat
; music: ern0 (&Ed Sheeran)

; You can run it under DosBox or native DOS


PART1 EQU -2                    ; quick control for the starting part

M EQU 59                        ; magic constant - can tune the note freqs

F4 = (10500000000/88/34923+M/2)/M
E4 = (10500000000/88/32963+M/2)/M
D4 = (10500000000/88/29366+M/2)/M
C4 = (10500000000/88/26163+M/2)/M

ORG 256
 MOV AL,13H                     ; set 320x200 VGA mode
 INT 10H                        ; by the VGA BIOS
 XCHG CX,AX                     ; CH=0, CL=19 (13H)
;MOV AL,0B6H                    ; not necesary under DOSBox
;OUT 43H,AL                     ; just make it more compatible
 MOV DX,greetings               ; printing an empty line and
 MOV AH,9                       ; the greeting text
 INT 21H                        ; by the DOS function
 MOV DI,0A000H                  ; DI=nice constant to back buffer
 MOV DS,DI                      ; DS=the video memory segment
copy:
 LODSB                          ; read one pxel
 STOSB                          ; copy 4 pixels to back buffer
 STOSB
 STOSB
 STOSB
 DEC CH
 JNZ copy                       ; x256 loop
 MOV AL,210                     ; INT8 speedup to 22.21Hz
 OUT 40H,AL                     ; PTC counter = 210*257
 ADD SI,320-256                 ; seek to next line
 LOOP copy                      ; X19 loop
 PUSH DS
 POP  ES                        ; ES=the video memory segment
 PUSH CS
 POP DS                         ; DS=code segment
 MOV CH,PART1                   ; CX=start value for frame counter
nextframe:
 SUB DI,DI                      ; DI=0 (pointing to start of the screen)
 NEG DL                         ; DL=Y coord (-100...100) (1st frame sux)
nextline:
 NEG BX                         ; BX=X coord (-160...160)
nextpixel:
 MOV DH,DL                      ; DH=pixel value
 SUB DH,BL                      ; DH=Y-X
 TEST CH,3                      ; check part
 JNZ part                       ; if part2 then go on otherwise jump away
 MOV BYTE [multiplier+1],M      ; switch on the music
back:                           ; part1/part3 is comming back here
 MOV AL,DL
 IMUL AL
 XCHG BP,AX
 MOV AL,BL
 IMUL AL
 ADD AX,BP                      ; AX=Y*Y+X*X
 CMP AX,64*64
 JNB skip                       ; if AX>=R*R then skip
 ADD AH,DH                      ; AH=(Y*Y+X*X)/256+pixval (shading)
 NEG DH                         ; inverting pixval (DH)
 JS skip2                       ; only one half of the sphere needs shading
skip:
 MOV AH,0                       ; swith off shading
skip2:
 SHR AH,4                       ; adjust shade value
 SUB DH,CL                      ; DH=pixval-framecounter
pixel:
 SHR DH,3                       ; grab the 3rd bit of pixval (thickness)
 SALC                           ; AL=255 or AL=0
 AND AL,31                      ; AL=color value 31(white) or 0(black)
 TEST CH,3                      ; part1/3/4 will be b/w
 JNZ @F
 AND AL,9                       ; part2 will be grayscaled
 ADD AL,22
 SUB AL,AH                      ; add shading
@@:
 STOSB                          ; put pixel
 INC BX                         ; increment X coord
 CMP BX,160                     ; test X coord
 JNE nextpixel                  ; go to next pixel
 INC DX                         ; increment Y coord
 CMP DL,100                     ; test Y coord
 JNE nextline                   ; go to next scanline

 MOV AX,CX                      ; AX=frame counter
 SAR AX,1                       ; if 0th bit is zero
 JNC nosound                    ; then go to nosound
 SAR AX,1                       ; discarding 1st bit
 TEST AL,16+8                   ; at last we will play all notes
 JZ @F                          ; but before
 OR AL,8                        ; play half of the notes only
@@:
 AND AX,15;+512                 ; indexing notes (table+16+index)
 XCHG BP,AX                     ; BP=we need an index reg
multiplier:                     ; label for selfmodification
 MOV AL,0                       ; Multiplier is zero at the 1st part
 MUL BYTE [BP+table];-16]       ; counter = data * Multiplier
 OUT 42H,AL                     ; lowbyte of the counter
 MOV AL,AH
 OUT 42H,AL                     ; highbyte of the counter
nosound:
 SALC                           ; if pause then speaker turn off
 OUT 61H,AL                     ; else turn on

 CBW                            ; if speaker off then AH=0
 IN AL,60H                      ; if ESC pressed then AL=1
 HLT                            ; waiting for an interrupt (INT8)
 DEC AX                         ; if AX=1 then EXIT else go to nextframe
 LOOPNZ nextframe               ; decrementing frame counter at the same time
;OUT 40H,AL                     ; clean exit would be luxory :)
;OUT 40H,AL
;MOV AL,3
;INT 10H
RETN                            ; exit to DOS

part:
 MOV AX,BX                      ; AX=X coord
;TEST CH,3                      ; the same TEST executed just before
 JPO @F                         ; make difference bitween part1 and part3
 CBW
@@:                             ; AH=msb of BL or BH
 MOV AL,DL                      ; AL=Y coord backup
 CWD
 XOR DH,BL                      ; DH=abs(X) or abs(X')
 CBW
 XOR AH,AL                      ; AH=abs(Y)
 SUB AH,DH                      ; AH=abs(Y)-abs(X)
 XCHG DX,AX                     ; DH=abs(Y)-abs(X), DL=Y coord restore

 TEST CH,1                      ; check part
 JNZ back                       ; if not part4 then go back

 MOV DH,DL
 ADD DH,BL                      ; DH=Y+X
 MOVSX SI,DL                    ; SI=Y coord
 IMUL SI,SI,56                  ; 56 -> 1/height of letters
 AND SI,1111110000000000B       ; SI=Y*56/256*1024
 ADD SI,BX                      ; SI+=X coord
 MOVZX BP,CL
 IMUL BP,BP,-3                  ; BP=3*framecounter (fcnt is a neg num)
 CMP BYTE [BP+SI+0D360H],7      ; check back buffer
 JNZ @F                         ; if no text then skip
 MOV DH,BL                      ; else change pixel value
 SUB DH,DL                      ; DH=X-Y
@@:
 ADD DH,CL                      ; adding frame counter, scrolling actually
 JMP pixel                      ; go to putpixel

greetings:
 DB 10,'Hi iONic rascy$'        ; thx for the pouet comments at nosleep!

table:                          ; notes are in reversed order, 0 -> pause
 DB 0,C4,0,0,D4,0,0,E4,0,D4,0,0,F4,0,0,D4
