org 100h

 ; assume ax=0
 int 10h      ; set 40x25 video mode
 inc ah       ; assume ah was 0 on return from above
 inc cx       ; assume cx = 0xff to start with
 int 10h      ; hide cursor by setting top scan line > bottom scan line

; basic MIDI out routine from sizecoding.org
main:
 push word 0xb800
 pop es
 mov cx, 0xffff

.restart:
 mov si, midistart
 mov 	dx,	331h
 outsb
 dec dx
 inc cx             ; increment number of times played
 and cl, 3             ; repeat after 3 variations

 outsb                ; uart mode
 lodsb                ; load piano instrument
 test cl, cl
 ; This is the second or later time through the tune
 jz .clear
 mov al, 41          ; second time+ instrument: strings
.clear:

 ; write both foreground and style bits
 pusha
 ; xor di, di          ; not necessary?
 mov ax, 0x0a20
 mov cx, 40 * 25 + 1
 rep stosw
 popa

 out dx, al         ; write instrument
.keep_jigging_dammit:
 mov  al, 0x93       ; play note on channel 3
 out  dx, al
 lodsb    			; load note + length
 cmp al, 0x3e       ; is this the end of the tune? (0x3e is the first byte of figure data)
 je .restart
 mov bl, 2          ; length of short note in 18ths of a second
 shr al, 1          ; LSB is length
 jnc .set_length
 mov bl, 4          ; double speed
.set_length:
 cmp cl, 1
 jg .second_verse
 and al, 0x0f       ; remove second verse
 add al, 4 + 60     ; first verse offset
 jmp .write_it
.second_verse:
 shr al, 4          ; remove first verse
 add al, 14 + 60    ; second verse offset
.write_it:
 out 	dx,	al
 mov 	al,	0x75    ; volume -- though could just reuse note since they're all around 120
 out 	dx,	al

.wait_note:
 ; before we start waiting, draw the dancer
 mov ax, [fs:0x046c] ; get the current tick count
 pusha
 call draw
 popa

 ; wait for next note
 add bl, al
.wait:
 cmp bl, [fs:0x046c] 
 jne .wait

 ; stop note
 mov al, 0xb3        ; control message on channel 3
 out dx, al
 mov al, 123         ; stop the magic 'all notes' note, 123
 out dx, al
 out dx, al          ; doesn't matter what this value is

 in     al, 60h      ;read keyboard
 dec    al           ;ax = 0 => no keypress

 jnz .keep_jigging_dammit

.jigged_out:
 ;ret                ; no return here -- on exit we just run through draw() once more

draw:
 ; assume ax has a counter of some sort so we can invert the images
 ; assume cx contains the number of times we've played the tune
 ; amount to rotate each bit into carry - 1 means normal, 7 means horizontally flipped
 ; mov ax, [fs:0x046c]
 xor bx, bx

 dec cl
 js .one_dancer
 mov bl, 0x42           ; dancer counter (multiplied by 16) ( + 2 because they jump to the right)

.one_dancer:
 dec cl
 js .first_time

 ; draw rainbow based on where we are in the score
 pusha
 mov dl, al             ; dl = current tick count
 mov di, 1              ; write colour/style byte only
 mov bl, 0x19
.col_stripe:
 mov bh, 0x28
.row_stripe:
 mov ax, bx
 add al, ah
 add al, dl
 and al, 0x70           ; foreground masked to black
 stosb
 inc di
 dec bh
 jnz .row_stripe
 dec bl
 jnz .col_stripe

 popa

.first_time:
 mov cl, 1
 test ax, 16
 jz .no_invert
 mov cl, 7
 and bl, 0x40            ; dancers jump to left (if more than one)
.no_invert:
 

.draw_dancers:
 mov si, figure2
 mov di, 80 * 13
 add di, bx
 mov ch, 11

.draw_dancer:
 mov ah, 8
.draw_line:
 ror byte [si], cl
 salc
 and al, 0xdb
 stosb
 inc di                ; skip colour / style byte
 dec ah
 jnz .draw_line
 inc si
 add di, 0x40
 dec ch
 jns .draw_dancer
 sub bl, 0x10
 jns .draw_dancers

 ; ret                 ; bytes beyond 'midistart' (0x3f, 0xc3) disassemble to AAS, RET

midistart:
 db 03fh      ; uart mode
 db 0c3h, 1   ; change instrument
tune:
 ; bit 0 = length of note (1 = double length)
 ; bits 1, 2, 3, 4 = note for verse 1 (midi semitone minus 64)
 ; bits 5, 6, 7 = note for verse 2 (midi semitone minus 74)
 db 0x95, 0x15, 0x0e, 0x12, 0x54, 0x8e, 0xab, 0x85, 0x41, 0x05, 0x95, 0x15, 0x0e, 0x12, 0x54, 0x8e, 0xab, 0x85, 0xe1, 0x04, 0x4a, 0x95, 0x15, 0x0e, 0x12, 0x54, 0x8e, 0xab, 0x85, 0x4b, 0x14, 0x58, 0x9d, 0x15, 0x19, 0x53, 0x15, 0x15, 0x95, 0x19
endtune:

;figure1:
; db 0b00011100, 0b00111110, 0b00011100, 0b00001000, 0b01111111
; db 0b00011100, 0b00111110, 0b00011100, 0b00010100, 0b00011110
; db 0b00000100, 0b00000010

figure2:
 db 0b00111110, 0b01011101, 0b00011100, 0b00001001, 0b00111110, 0b01011100, 
 db 0b00111110, 0b01111111, 0b00010100, 0b00111100, 0b00010000, 0b00110000

;figure2_inverted:
; db 0b00110000, 0b00010000, 0b00111100, 0b00010100, 0b01111111, 0b00111110
; db 0b01011100, 0b00111110, 0b00001001, 0b00011100, 0b01011101, 0b00111110
