;    acrylic by unlord / xylem
;         256b intro for
;       Revision 2019 Party
;
; nasm acrylic.asm -o acrylic.com

struc stack
  .di: resw 1
  .si: resw 1
  .bp: resw 1
  .sp: resw 1
  .bx: resw 1
  .dx: resw 1
  .cx: resw 1
  .ax: resw 1
  .size:
endstruc

%define HIGH_DEF

%ifdef HIGH_DEF
%define WIDTH 640
%define HEIGHT 480
%define MODE 0x112
%else
%define WIDTH 320
%define HEIGHT 240
%define MODE 0x190
%endif

%define STEPS 5
%define SP_OFFSET (-2)

;%define IN_TD (1)
%define DOUBLE_SPEED (1)
;%define QUARTER_RES (1)
%define FIX_COLORS (1)
;%define USE_PENTIUM_PRO (1)

  org 0x100
segment .text
@_104:
  push 0xa000
  pop es

%ifdef IN_TD
  mov si, 0x100
%endif

  mov ax, 0x4f02 
  mov bx, MODE
  int 0x10

@main:
  fild word [frame]
  ;fild word [si - 0x10]  ; frame
  fidiv word [si + @_104 - $$]  ; 0x68
  fst dword [time]  ; XXX can we use SI to index??

  ; compute dial
  fisub word [_2]
  fidiv word [_4]
  fld1
%ifdef USE_PENTIUM_PRO
  fcomi st0, st1
%else
  fcom st0, st1
  fnstsw ax
  sahf
%endif
  ja @above
  fxch st0, st1
@above:
  fstp st0
  fld1
  faddp
  fstp dword [dial]

  mov ax, 4
  mov dx, ax
  mov bx, tbl
  mov di, val
@load:
  fld1
  mov cl, STEPS
@fill:
  fst dword [bx]
  add bx, ax
  fmul dword [di]
  loop @fill
  fstp st0
  add di, ax
  dec dx
  jnz @load

  xor bx, bx
  xor di, di
%ifdef HIGH_DEF
  mov bp, 4
%else
  mov bp, -1
%endif

%ifndef HIGH_DEF
  mov dx, HEIGHT
%else
%ifdef QUARTER_RES
  mov dl, HEIGHT/4
%else
  mov dl, HEIGHT - 256
%endif
%endif
@row:
  mov cx, WIDTH
@col:

  test di, di
  jnz @no_bank
  inc bp
  pusha
  mov dx, bp
  mov ax, 0x4f05
  int 0x10
  popa
@no_bank:

  ; AX = 4
  ; BX = 0
  ; CX = x
  ; DX = y
  ; DI = pixel
  ; SI = 0x100
  ; BP = bank

  pusha

  shl cx, 3
  sub cx, WIDTH*4
  shl dx, 3
  sub dx, HEIGHT*4

  pusha

  ; compute position
  fild word [bx + SP_OFFSET - 2*stack.size + stack.dx]
  fidiv word [si + @row + 1 - $$]
  fild word [bx + SP_OFFSET - 2*stack.size + stack.cx]
  fidiv word [si + @row + 1 - $$]

  ;add si, si
  mov si, tbl

  mov cx, STEPS
@steps:

@prime:
  fld st1
  fmul dword [bx + si + 2*STEPS*4]
  ;fld dword [time]
  fld dword [si - 4]  ; time
  fmul dword [bx + si + 0*STEPS*4]
  faddp st1
  fsin
  fmul dword [bx + si + 1*STEPS*4]
  dec ax
  jp @prime

  fxch
  fldz
@norm:
  faddp st3
  fadd st2, st0
  ;fmul dword [norm]
  fmul dword [si - 24]  ; 0.3
  inc ax
  jp @norm
  fsubp st1

  add bx, ax
  loop @steps

  fld st0
  fadd st2
  fmul dword [si - 16]

%ifdef FIX_COLORS
  fxch
%endif

  popa

  mov cx, 3
@blit:
  fsin
  fld1
  faddp
  fimul word [si + @_104 - $$]
  push ax
  fistp word [bx + SP_OFFSET - stack.size - 2]
  pop ax
  stosb
  loop @blit

  popa

  add di, ax

  loop @col

  dec dx
  jnz @row

%ifdef DOUBLE_SPEED
  add word [frame], 2
%else
  inc word [frame]
%endif

  mov ah, 1
  int 0x16
  jz @main

  mov ax, 0x3
  int 0x10

  ret

frame: dw 0
_2: dw 2
_4: dw 4
norm: dd 0.3
val: dd 0.869565217391304 ; 1/1.15
half:dd 0.588235294117647 ; 1/1.7

segment .bss align=1
dial:resd(1)
     resd(1)
time: resd(1)
tbl: resd(STEPS*4)
