;BALLS HARMONY by TomCat/Abaddon
;FAST code / FASM source

COLOR EQU 171
BALLS EQU 15
RESX EQU 640
RESY EQU 480
SINLEN EQU 4*1024*2

ORG 256
 INC    SI              ; Write Combine speedup
 PUSH   SI              ; (kills DOSBox)
 PUSH   SI              ; greets to Rrrola
 POP    EAX             ; MOV EAX,01010101H
 DB     66H             ; greets to Ervin
 LEA    CX,[259H]       ; MOV ECX,00000259H
 CDQ                    ; MOV EDX,00000000H
 WRMSR                  ; greets to HellMood

 MOV    BX,121H         ; #121h - ATI/AMD
setvideo:
 MOV    AX,4F02H        ; 640x480x32bits video mode setup
 INT    10H
 CMP    AH,BH
 MOV    BL,12H          ; #112H - nVidia/Intel/DOSBox/WinXP
 JE     setvideo

 POP    BP              ; BP: 0, frame counter
 MOV    SI,SINLEN/2
 MOV    DWORD [SI],3EFA0000H+RESX
 PUSH   SI
 MOV    BX,0A000H
 PUSH   BX
@@:
 MOV    [SI+BX],BX
 FLDPI
 FIMUL  WORD [SI+BX]
 FIDIV  WORD [DI]
 FSIN
 FIMUL  WORD [SI]
 FIADD  WORD [SI]
 FIADD  WORD [SI]
 FSTP   DWORD [SI+BX]
 ADD    BX,SP           ; BX=BX-4
 JNZ    @B              ; BX: 0
 POP    ES

nextframe:
 PUSH   DX              ; [BX-4]: SOUND
 MOV    CX,RESY*3
 MOV    DI,SP           ; DI: -4
 HLT
nextline:
 MOV    BYTE [BX-1],RESX*4/256
nextpixel:
 SUB    DI,SP           ; DI=DI+4
 JNZ    nobank
 MOV    AX,4F05H
 INT    10H
 INC    DX
nobank:
 PUSHA

 XCHG   AX,BP
 IMUL   BP,AX,51
 MOV    DL,BALLS
nextball:
 FUCOMPP                ; clear the FPU stack
 IMUL   CX,DX,-(RESY*3/(BALLS+1))
 ADD    CX,RESY*3
 MOV    [SI],CX

 FILD   WORD [BX-8]     ; Y
 FISUB  WORD [SI]       ; dY
 MOV    WORD [SI],SINLEN-4;RADIUS*RADIUS
 FLD    ST0             ; dY dY
 FMUL   ST0,ST0         ; dY2 dY
 AND    BP,[SI]
 FILD   WORD [BX-2]     ; X dY2 dY
 FSUBR  DWORD [BP+SI+4] ; dX dY2 dY
 FADD   ST2,ST0         ; dX dY2 dY+dX
 FMUL   ST0,ST0         ; dX2 dY2 dY+dX
 FADDP                  ; dY2+dX2 dY+dX
 FILD   WORD [SI]       ; r2 dY2+dX2 dY+dX
 FCOMI  ST0,ST1         ; r2 dY2+dX2 dY+dX
 FSUBRP ST1,ST0         ; z2 dY+dX
 JA     intersection

 ADD    BP,AX           ; +frame counter
 DEC    DX
 JNZ    nextball

 FST    ST1

putpixel:
 CMP    DL,AH
 SALC
 XCHG   CX,AX

bgr:
 PUSH   AX              ; Intensity
 NOT    AH              ; Shadow test
 AND    AL,AH           ; Diffuse
 ADD    AL,37           ; Diffuse+Ambient
 AND    AL,CL           ; make it black at start
 MUL    BYTE [WORD (BX+SI-SINLEN/2+256+COLOR)]
_color:                 ; Color*(Diffuse+Ambient)
 FCOMI  ST0,ST1         ; Shine N.H
 SALC                   ; Highlight test
 OR     AL,AH           ; Color*(Diffuse+Ambient)+Specular
 STOSB
 POP    AX
 INC    SI
 JPO    bgr

 POPA
 ADD    [BX-2],SP
 JNZ    nextpixel
 DEC    CX
 DEC    CX
 LOOP   nextline

 SUB    BP,SP
 TEST   BP,SINLEN/2-1
 LOOPNZ skip            ; CH: 255
 SUB    BYTE [_color-2],14
skip:

 POP    AX
 CWD
;MOV    CH,M            ; CH = Multiplier
 MUL    CH              ; counter = data * Multiplier
 OUT    42H,AL          ; lowbyte of the counter
 MOV    AL,AH
 OUT    42H,AL          ; highbyte of the counter
 SALC                   ; if pause then speaker turn off
 OUT    61H,AL          ; else turn on
 CBW                    ; if speaker off then AH=0
 IN     AL,60H          ; if ESC pressed then AL=1
 DEC    AX              ; if AX=1 then EXIT
 JNZ    nextframe
RETN

intersection:
 FSQRT                  ; z dY+dX
 FXCH                   ; dY+dX z
 FADD   ST0,ST1         ; r*N.S z
 FADD   ST1,ST0         ; r*N.S r*N.H
 FMUL   DWORD [SI]      ; Intensity r*N.H
 FISTP  WORD [SI]       ; r*N.H
 MOV    CX,220
 XCHG   CX,[SI]
 FILD   WORD [SI]       ; Shine r*N.H

 CMP    AH,DL
 JB     .2
 TEST   BP,(SINLEN/2-256)
 JNZ    .2
 MOV    [BX-4],DX
.2:
 MOV    BX,DX
 JMP    putpixel
