; leebsi 13:36:51 (c) IlII / RMDA / 2020
; FASM

        org 100h

        ; ax = bx = 0, cx = 0FFh, si = 100h, bp = 9XXh

        ; Init video
        mov al,3
        int 10h         ; set color text mode 80x25

        ; Hide cursor
        xchg ax,si      ; ah = 1
        mov ch,20h
        int 10h         ; hide cursor (VMware returns al = 0Bh)

        ; Fill screen with zero chars
        xchg ax,bp      ; ah = 9
        salc            ; al = 0 (char)
        mov di,ax       ; di = 900h (buffer address)
        mov bl,1        ; video page (0) and color (1)
        int 10h         ; fill screen with char 0, cx = number of chars (VMware returns ah = 1)

        mov ax,$FF00 + 51*4 ; start seconds (51)

again:  ; Prepair text
        pusha
        push di
        mov dl,36*4     ; minutes (36)
        cmp al,60*4
        jb @F
        mov dl,37*4     ; if seconds = 60 then set 37 minues
        salc            ; and 0 seconds
@@:     push ax         ; seconds
        push dx         ; minutes
        push 13*4       ; hours

        out 61h,al      ; crackle sound

.number:
        pop ax          ; get number
        shr al,2
        aam             ; ah = al / 10, al = al % 10 (ah = 1st digit, al = 2nd digit)
        xchg al,ah      ; swap digits
        add ax,'00'
        stosw           ; store numbers
        mov al,':'
        stosb           ; store separator
        add bl,5Eh      ; 1 -> 5Fh -> 0BDh -> 1Bh
        jnc .number     ; repeat

        ; Display text
        mov ax,1300h
        mov cx,8
        mov dx,0B00h + 41-8/2 ; screen position (screen center)
        pop bp          ; es:bp = text address
        push bp
        int 10h         ; display the 1st line of text, bl = color (1Bh), bh = 0 (video page)

        mov bl,13h      ; another color
        inc dh          ; next line
        int 10h         ; display the 2nd line of text

        ; Get font address
        mov ax,1130h
        mov bh,6        ; font type
        int 10h         ; get 8x16 font address (es:bp), cx = number of scan-lines (bytes) per char, dl = max screen row number (24)

        ; Copy and flip font (with wave effect)
        pop di          ; es:di = buffer for new font
        push di
        mov ch,1        ; 256 chars
.char:
        mov si,15       ; highest of scan-line number of char
.line:  mov [di],dl     ; copy data to buffer upside down
        mov dx,[es:bp+si] ; read font data
        and dx,0F00Fh
andimm = $-2
        or dl,dh        ; merge two halfs of line
        inc di
        dec si
        jns .line
        mov dl,0FFh     ; horizontal line on the top (for all chars except 0)
        add bp,16       ; next char
        loop .char

        ; Load font and activate font blocks
        salc            ; ax = 1100h
        mov bx,1001h    ; height of char is scan lines (16 bytes), bank (1)
        mov ch,1        ; char count (256)
        cwd             ; first char (0)
        pop bp          ; es:bp = font address
        push ds
        pop es          ; es = code/data segment
        int 10h         ; load user-defined font

        mov al,3        ; ax = 1103h
        int 10h         ; activate 512-char mode (bl = 1: bank 1 (bits 0,1,4) font when attr bit 3 = 0, bank 0 (bits 2,3,5) font when attr bit 3 = 1)

        ; Delay and restart
        hlt
        hlt
        hlt
        hlt
        hlt             ; delay (55*5 ~ 275 millisec)

        not word [andimm] ; change wave direction

        in al,60h       ; get key scan code
        dec al
        popa
        jz short exit   ; exit if Esc key is pressed

        inc ax          ; increase time (1/4 of second)

        jnz short again ; repeat if Esc key is not pressed

        ; Show text in graphics
        mov al,13h      ; ax = 13h
        int 10h         ; 320x200, 2560 colors

        mov ax,1124h
        int 10h         ; set font size 8x16, bl = 1

        mov ah,2
        mov dx,$410     ; row = 4, column = 16
        int 10h         ; set cursor position, bh = 0

        mov ax,0E00h+'R'
        mov bl,12       ; color (red)
        int 10h

        mov ah,9
        mov dx,text
        int 21h         ; show text

        ; Sound: t * ((t>>12 | t>>8) & t>>4 & 63)
        mov al,14h      ; set lower byte only
        out 43h,al
        mov al,95h      ; 95h ~ 8000 Hz (1193182/8000 = 95h)
        out 40h,al      ; tune timer
.sound:
        shld eax,ebx,32-4 ; al = t>>4, ah = t>>12
        or ah,bh        ; ah = t>>12 | t>>8
        and al,ah       ; al = (t>>12 | t>>8) & t>>4
        and al,63       ; al = (t>>12 | t>>8) & t>>4 & 63
        mul bl          ; al *= t
        inc ebx         ; increase counter
        shr al,6
;       and al,2
        out 61h,al

        hlt             ; delay

        in al,60h
        dec al
        jnz .sound      ; repeat until Esc keypress
exit:
        ret             ; exit to DOS

text db 'ussian',13,10
     db 9,9,'Massive',13,10
     db 9,9,'Digital',13,10
     db 9,9,'Aggression$'
