SIDES=4
VEC2 EQU BP
BASE EQU BP-16
BASE2 EQU SI-256+BP-16
REGS0 EQU BASE-2
SAX0 EQU REGS0-2
SDX0 EQU REGS0-6
REGS1 EQU REGS0-16
SAX1 EQU REGS1-2
SDX1 EQU REGS1-6
REGS2 EQU REGS1-16
SAX2 EQU REGS2-2
SDX2 EQU REGS2-6

ORG 256

 FLDLN2 		; alpha
 MOV AL,13H		; set video mode 320x200
 INT 10H		; call VGA Bios
 DEC BX 		; BX:0FFFFH
nextcolor:
 XCHG BX,CX
 SHR CL,1
 JNO .2
 MOV CL,63
.2:
	 DB 0
BIG:
STEP:	;DD 0.04;0.03217
MAXCOLOR DW -131;-198;255;56;74;94
	 DW 3D23H
 IMUL DX,BX,64
 MOV AX,1010H		; set only one color by the VGA BIOS
 INT 10H		; call VGA Bios
 MOV CX,BX
 LOOP nextcolor 	; CX:0 BX:1 DX:64
 CBW			; AX:16
 XCHG BP,AX		; BP:16
 MOV BL,4		; BX:4

 PUSH WORD 0A064H
 PUSH WORD 08000H
 POP DS
 POP ES

.1:
 FADD DWORD [BASE2+STEP]; alpha
 FLD ST0		; alpha alpha
 FADD ST0,ST0		; 2*alpha alpha
 MOV AX,110101000011B	; tetrahedron normal vectors
.2:
 MOV CL,3
.3:
 FLD1
 SHR AX,1
 JNC .4
 FCHS
.4:
 LOOP .3
.5:
 FLD ST3		; 2a NX NZ NY 2a a
 FSINCOS		; cos sin NX NZ NY 2a a
 FLD ST3		; NZ cos sin NX NZ NY 2a a
 FMUL ST0,ST1		; cosNZ cos sin NX NZ NY 2a a
 FXCH ST4		; NZ cos sin NX cosNZ NY 2a a
 FMUL ST0,ST2		; sinNZ cos sin NX cosNZ NY 2a a
 FXCH ST3		; NX cos sin sinNZ cosNZ NY 2a a
 FMUL ST2,ST0		; NX cos sinNX sinNZ cosNZ NY 2a a
 FMULP ST1,ST0		; cosNX sinNX sinNZ cosNZ NY 2a a
 FSUBRP ST2,ST0 	; sinNX cosNX-sinNZ cosNZ NY 2a a
 FADDP ST2,ST0		; cosNX-sinNZ sinNX+cosNZ NY 2a a
 FSTP DWORD [DI+BX]	; sin*NX+cosNZ NY 2a a
 NEG BX
 JS .5			; loop 2x (next axis)
 FSTP DWORD [DI]	; 2a a
 ADD DI,VEC2
 TEST AX,AX
 JNZ .2 		; loop 6x (next side)
 FSTP ST0		; a
 TEST DI,DI
 JNZ .1
 FSTP ST0		; -

 MOV CL,190
nextframe:
 HLT
 PUSHA
nextline:
 MOV DX,320
nextpixel:
 PUSHA
 MOV AL,31
 AND AX,CX
 SHR CX,5
 MOV DI,DX
 SHR DI,5
 AND DX,31
 IMUL DI,DI,6
 ADD DI,CX
 BT [BASE2+logo],DI
 JNC .1
 SUB DI,DI
.1:
 IMUL DI,DI,117
 ADD DI,[SDX0]
 SHL DI,6
 SUB AX,BP
 SUB DX,BP
 PUSHA
 FILD DWORD [BASE2+BIG] ; positive_bignumber
 FILD WORD [BASE2+BIG]	; negaive_bignumber positive_bignumber

 MOV CL,SIDES
nextside:
 SUB DI,VEC2
 FLD DWORD [DI-4]	; Nz max min
 FLDZ			; 0 Nz max min
 FUCOMIP ST0,ST1	; Nz max min
;JZ skip		; no intersection
 FLDL2T 		; c Nz max min
 FMUL ST0,ST1		; c*Nz Nz max min
 FLDL2T 		; c c*Nz Nz max min
 FMUL DWORD [DI+BX]	; c*Nx c*Nz Nz max min
 FISUBR WORD [SDX2]	; Px-c*Nx c*Nz Nz max min
 FMUL DWORD [DI+BX]	; Nx*(Px-c*Nx) c*Nz Nz max min
 FLDL2T 		; c Nx*(Px-c*Nx) c*Nz Nz max min
 FMUL DWORD [DI]	; c*Ny Nx*(Px-c*Nx) c*Nz Nz max min
 FISUBR WORD [SAX2]	; Py-c*Ny Nx*(Px-c*Nx) c*Nz Nz max min
 FMUL DWORD [DI]	; Ny*(Py-c*Ny) Nx*(Px-c*Nx) c*Nz Nz max min
 FADDP ST1,ST0		; Nx*(Px-c*Nx)+Ny*(Py-c*Ny) c*Nz Nz max min
 FDIVRP ST2,ST0 	; c*Nz (Nx*(Px-c*Nx)+Ny*(Py-c*Ny))/Nz max min
 FSUBRP ST1,ST0 	; c*Nz-(Nx*(Px-c*Nx)+Ny*(Py-c*Ny))/Nz max min
 JA front

 FUCOMI ST0,ST2 	; Iz max min
 FCMOVNB ST0,ST2	; Iz max min
 FSTP ST2		; max min

skip:
 LOOP nextside

 POPA
 POPA
 FUCOMI ST0,ST1 	; max min
 JC .1
 SALC
.1:
 FUCOMPP		; -
 ADD AL,255-223 	; ambient
 STOSB
 DEC DX
 JNZ nextpixel
 LOOP nextline
 POPA
 INC DX
 IN AL,60H
 DEC AX
 JNZ nextframe
RETN			; return to DOS prompt

logo:
 DD 11000000111111001000000100111111B
 DD 00001111111010001000000000001011B

front:
 FUCOMI ST0,ST1 	; Iz max min
 FCMOVB ST0,ST1 	; Iz max min
 FSTP ST1		; max min
 JB skip
 FLD DWORD [DI-4]
 FIMUL WORD [BASE2+MAXCOLOR]
 FISTP WORD [SAX1]
JMP skip
