SIDES=4
VEC2 EQU BP
BASE EQU BP-16
BASE2 EQU SI-256+BP-16
REGS0 EQU BASE-2
SDX0 EQU REGS0-6
REGS1 EQU REGS0-16
SAX1 EQU REGS1-2
SCX1 EQU REGS1-4
REGS2 EQU REGS1-16
SAX2 EQU REGS2-2
SCX2 EQU REGS2-4
SDX2 EQU REGS2-6

ORG 256

 FLDLN2 		; alpha
 MOV AL,13H		; set video mode 320x200
 INT 10H		; call VGA Bios
 DEC BX 		; BX:0FFFFH
nextcolor:
 XCHG BX,CX
 SHR CL,1
 JNO .2
 MOV CL,63
.2:
	 DB 0
BIG:
STEP:	;DD 0.04;0.03217
MAXCOLOR DW -131;-198;255;56;74;94
	 DW 3D23H
 IMUL DX,BX,64
 MOV AX,1010H		; set only one color by the VGA BIOS
 INT 10H		; call VGA Bios
 MOV CX,BX
 LOOP nextcolor 	; CX:0 BX:1 DX:64
 CBW			; AX:16
 XCHG BP,AX		; BP:16
 MOV BL,4		; BX:4

 PUSH WORD 0A064H
 PUSH WORD 08000H
 POP DS
 POP ES

.1:
 FADD DWORD [BASE2+STEP]; alpha
;FLDPI
;FMUL ST0,ST1
;FSIN
 FLD ST0		; alpha alpha
 FADD ST0,ST0		; 2*alpha alpha
;FCOS
 MOV AX,110101000011B	; tetrahedron normal vectors
.2:
 MOV CL,3
.3:
 FLD1
 SHR AX,1
 JNC .4
 FCHS
.4:
 LOOP .3
.5:
 FLD ST3		; 2a NX NZ NY 2a a
 FSINCOS		; cos sin NX NZ NY 2a a
 FLD ST3		; NZ cos sin NX NZ NY 2a a
 FMUL ST0,ST1		; cosNZ cos sin NX NZ NY 2a a
 FXCH ST4		; NZ cos sin NX cosNZ NY 2a a
 FMUL ST0,ST2		; sinNZ cos sin NX cosNZ NY 2a a
 FXCH ST3		; NX cos sin sinNZ cosNZ NY 2a a
 FMUL ST2,ST0		; NX cos sinNX sinNZ cosNZ NY 2a a
 FMULP ST1,ST0		; cosNX sinNX sinNZ cosNZ NY 2a a
 FSUBRP ST2,ST0 	; sinNX cosNX-sinNZ cosNZ NY 2a a
 FADDP ST2,ST0		; cosNX-sinNZ sinNX+cosNZ NY 2a a
 FSTP DWORD [DI+BX]	; sin*NX+cosNZ NY 2a a
 NEG BX
 JS .5			; loop 2x (next axis)
 FSTP DWORD [DI]	; 2a a
 ADD DI,VEC2
 TEST AX,AX
 JNZ .2 		; loop 6x (next side)
 FSTP ST0		; a
 TEST DI,DI
 JNZ .1
 FSTP ST0		; -

 MOV CL,190
nextframe:
 HLT
 PUSHA
nextline:
 MOV DX,320
nextpixel:
 PUSHA
 MOV AL,31
 PUSH AX
 AND AX,DX
 SHR CX,5
 SHR DX,5
 IMUL DI,DX,6
 ADD DI,CX
 IMUL DI,DI,117
 ADD DI,[SDX0]
 SHL DI,6
 ADD CX,DX
 ADD CX,[SDX0]
 IMUL CX,CX,25;-44
 POP DX
 AND DX,[SCX1]
 SUB AX,BP
 SUB DX,BP
 PUSHA

 FILD WORD [SCX2]	; c
 FSIN
 FABS
 FLDL2T 		; c
 FMULP
 FILD DWORD [BASE2+BIG] ; positive_bignumber
 FILD WORD [BASE2+BIG]	; negaive_bignumber positive_bignumber

 MOV CX,SIDES
nextside:
 SUB DI,VEC2
 FLD DWORD [DI-4]	; Nz max min c
 FLDZ			; 0 Nz max min c
 FUCOMIP ST0,ST1	; Nz max min c
;JZ skip		; no intersection

 FLD ST3		; c Nz max min c
 FMUL ST0,ST1		; c*Nz Nz max min c
 FLD ST4		; c c*Nz Nz max min c
 FMUL DWORD [DI+BX]	; c*Nx c*Nz Nz max min c
 FISUBR WORD [SAX2]	; Px-c*Nx c*Nz Nz max min c
 FMUL DWORD [DI+BX]	; Nx*(Px-c*Nx) c*Nz Nz max min c
 FLD ST5		; c Nx*(Px-c*Nx) c*Nz Nz max min c
 FMUL DWORD [DI]	; c*Ny Nx*(Px-c*Nx) c*Nz Nz max min c
 FISUBR WORD [SDX2]	; Py-c*Ny Nx*(Px-c*Nx) c*Nz Nz max min c
 FMUL DWORD [DI]	; Ny*(Py-c*Ny) Nx*(Px-c*Nx) c*Nz Nz max min c
 FADDP ST1,ST0		; Nx*(Px-c*Nx)+Ny*(Py-c*Ny) c*Nz Nz max min c
 FDIVRP ST2,ST0 	; c*Nz (Nx*(Px-c*Nx)+Ny*(Py-c*Ny))/Nz max min c
 FSUBRP ST1,ST0 	; c*Nz-(Nx*(Px-c*Nx)+Ny*(Py-c*Ny))/Nz max min c
 JA front

 FUCOMI ST0,ST2 	; Iz max min c
 FCMOVNB ST0,ST2	; Iz max min c
 FXCH ST2		; Iz max min c

skip:
 FSTP ST0		; max min c
 LOOP nextside

 POPA
 POPA
 FUCOMIP ST0,ST1	; min c
 JC .1
 SALC
.1:
 FUCOMPP		; -
 ADD AL,255-223 	; ambient
 STOSB
 DEC DX
 JNZ nextpixel
 DEC CX
 JNZ nextline
; LOOP nextline
 POPA
 INC DX
 IN AL,60H
 DEC AX
 JNZ nextframe
RETN			; return to DOS prompt

front:
 FUCOMI ST0,ST1 	; Iz max min c
 FCMOVB ST0,ST1 	; Iz max min c
 FXCH ST1		; Iz max min c
 JB skip
 FLD DWORD [DI-4]
 FIMUL WORD [BASE2+MAXCOLOR]
 FISTP WORD [SAX1]
JMP skip
