;\>  ZIMA
; \>
; /> a 64-byte intro by rrrola <rrrola@gmail.com>
;/>  greets to everyone who likes winter

; How it works:
; - It's almost a Julia fractal.
;   - Julia: [x, y] -> [x*x - y*y + x0, 2*x*y + y0].
;   - Zima:  [x, y] -> [abs(x) - abs(y) + x0, 2*x*y + y0].
; - Math is done in signed bytes with 6 fractional bits.
;   - (2*x*y) is computed in 16 bits as (x*y) >> 5.
; - Everything repeats after 8192 frames.
;   - x0 changes every frame, y0 changes every 32 frames.

  org 100h     ; assume ax=bx=0 cx=0xff si=0x100

; Set mode and palette (black, blue->cyan).
;04 13
  add al,0x13
  cwd          ; dx=0
P int 0x10
  mov ax,0x1010; set palette: bl=index dh=R=0 ch=G cl=B=0xff
  inc bx       ; index++: 1..15 (0 stays black)
  add ch,[si]  ; G+=4 (4,8,12,...,60)
  jnc P

  mov bx,0x9fb4; screen segment = centering offset
  mov ds,bx    ; 0x9fb40 - 0xa0000 - (0xb4-128)/256*320 = -1281

; Main loop: si=t, di=pixel address.
M mov ax,0xcccd
  mul di
  add dx,bx    ; dh=y, dl=x (signed fixed-point: -2 .. 1.984)

  mov cl,15    ; max 15 iterations
I mov ax,dx

X neg dl
  jl X
Y neg dh
  jl Y
  sub dl,dh
  add dx,si    ; x_new = wrap_u8(abs(x) - abs(y) + t)
  cmp dl,bl
  jl B         ; break when x < -1.1875

  imul ah
  add ax,si
  sar ax,5
  mov dh,al    ; y_new = wrap_u8(2*x*y + t/32)
  loop I

B inc di       ; adjust the centering offset to -1280 = -4*320
  mov [di],cl
  jnz M
  dec si       ; t--
  jmp M
