;Plasmifier cover 256B by TomCat/Abaddon
;the original 1k intro by FruitieX

;Textmode + PC Speaker

;TIMINGS
HIHAT_    EQU 5
ARPEGGIO_ EQU 3
FADEOUT_  EQU 16

Divider   EQU 63

ORG 256
 MOV    AH,80H                  ; sample segment
 MOV    GS,AX

 PUSH   BX
 PUSH   0B6H-256
 MOV    AX,3508H
 INT    21H
 PUSH   ES
 PUSH   BX
 CALL   INIT

 PUSH   0B800H                  ; text mode video memory
 POP    ES
MAIN:
 SUB    DI,DI

SHOW:
 MOV    ESI,1                   ; my own timer counter
.COUNTER:

 MOV    CX,80*25*2              ; fill the screen with sample data
 SUB    SI,CX
 GS     REP MOVSB

 MOV    AH,1                    ; check keyboard buffer
 INT    16H
 JNZ    RESET

 JMP    MAIN


INIT:
 PUSH   Divider
.RATE:
 PUSH   90H-256
 PUSH   CS
 PUSH   IRQ
RESET:
 POP    DX
 POP    DS
 MOV    AX,2508H
 INT    21H
 POP    AX
 OUT    43H,AL
 POP    AX
 OUT    61H,AL
 OUT    40H,AL
 SALC
 OUT    40H,AL
RETN

IRQ:
 PUSHAD
 MOV    BP,SHOW.COUNTER-4
 MOV    ESI,[BP]
 GS     LODSB
 TEST   AL,AL
 JZ     @F
 OUT    42H,AL
@@:
 MOV    BX,[BP+2]
 INC    DWORD [BP]

KICKDRUM:
 MOV    BP,8191
.TEMPO:
 AND    BP,SI
 MOV    AX,9999
.LENGTH:
 CWD
 INC    BP
 DIV    BP
.SKIP:
 MOV    DI,AX
 DB     25H,32,0                ; AND AX,32
.VOLUME:
 CWD
 XCHG   CX,AX

HIHAT:
 CMP    BL,HIHAT_
.ENABLE:
 JB     .SKIP
 MOV    AX,SI
 MOV    BP,99
.RANDOM:
 DIV    BP
 XCHG   AX,DX
 MUL    SI
 AND    AX,64
.VOLUME:
 CWD
 SHRD   BP,SI,16+7
.SPEED:
 AND    BP,127
.TEMPO:
 ADD    BP,4
.FADEOUT:
 DIV    BP
 ADD    CX,AX
.SKIP:

BASS:
 MOV    BP,BX
 AND    BP,3
.LENGTH:
 MOV    AH,[BP+NOTESB]
 SALC
 MUL    SI
 XCHG   AX,DX
 AND    AX,15
.VOLUME:
 CWD
 DIV    DI
 ADD    CX,AX
.SKIP:

ARPEGGIO:
 CMP    BL,ARPEGGIO_
.ENABLE:
 JB     .SKIP
.RATE:
 IMUL   AX,BX,3
 AAM    13
 ADD    AL,4
 XCHG   CX,AX
 MOV    EBP,ESI
 SHR    EBP,CL
 XCHG   CX,AX
 AND    BP,3
.LENGTH:
 TEST   SI,8192*2
.SWITCH:
 JNZ    @F
 ADD    BP,NOTESA2-NOTESA1
@@:
 MOV    AH,[BP+NOTESA1]
 SALC
 MUL    SI
 XCHG   AX,DX
 AND    AX,15
.VOLUME:
 CWD
 DIV    DI
 ADD    CX,AX
.SKIP:

FADEOUT:
 MOV    AX,65535
.VOLUME:
 MUL    CX
 JNC    .SKIP
 CMP    BL,FADEOUT_
.ENABLE:
 JB     .SKIP
 DEC    WORD [CS:FADEOUT.VOLUME-2]
.SKIP:

 MOV    [GS:SI],DL
IRQEND:
 MOV    AL,20H
 OUT    20H,AL
 POPAD
IRET

NOTESB:
 DB     24,16,21,16
NOTESA1:
 DB     128,144,192,0
NOTESA2:
 DB     128,152,192,0
