; DLIFE1Dx.ASM   - Classic 1D Cellular Automata Generator. 
;     			(C) A.Millett 2014-25.
;
; Released as free/open software under the terms of the GNU GPL3 license.  
;      See:  www.gnu.org/licenses/gpl-3.0.html 
;  
; Simplified one Dimensional Cellular Automata pattern Generator, for DOS. 
; Hit SPACE for next pattern, ESC to quit.
; Uses MOD 5 sum of 3 cells above for next gen.
; For DOS/VGA, minimal version written in NASM.
; 
;  assemble with: NAS2COM name
;           or    NASM -f bin name.asm -o name.com
;  
; -> DLIFE1D-103 5.5.2025
; -> DLIFE1D-104 6.5.2025 (81 bytes)
; -> DLIFE1D-105 6.5.2025 (73 bytes)
; 
; Note: You can make it smaller with NSTATES = 8, POWER2 = 0, but gfx is less interesting.


cpu 8086
  
%define FULLVER   0
%define USERKEY   1	; User key test at end
%define NSTATES   5	; # cell states (or colours)
%define POWER2    0	; Set if NSTATES is 4,8,16 for smaller code.

  org 100h

  mov al,19	 	; Screen mode 19 - VGA 320x200x256
  int 10h
  mov bp,0xa000		; Init RND seed..
  mov es,bp		; ES=VGA segment A000

reloop:
  xor di,di		; bx=0; Start after 1st line.
  mov ax,bp
loopX:
			; Simple pseudo rnd number generator (CX)
  add ax,di
  rol ax,1
  xor al,ah
  stosb
  ; mov [es:di],al
  ; inc di	
  cmp di,320
  jne loopX		; if (BX<320) goto loopX

  xor di,di


loop2:

%if POWER2	; Smaller code if #states is power of 2
  mov bl,[es:di-1]
  add bl,[es:di]
  add bl,[es:di+1]	; al=peek(bx)+peek(bx+1)+peek(bx+2)
  and bx,(NSTATES - 1)
  mov al,[es:bx]	; Use 1st line as rules array.
%else
  mov al,[es:di-1]
  add al,[es:di]
  add al,[es:di+1]	; al=peek(bx)+peek(bx+1)+peek(bx+2)
  mov cx,NSTATES	; Use as modulus. (can be set outside loop)
  xor dx,dx
  div cx
  mov si,dx		; si=(cx mod 5)
  mov al,[es:si]	; Use 1st line as rules array.
%endif

  mov [es:di+320],al	; pVdu[bx+320]=al
  inc di
  jne loop2

  inc bp		; Inc random seed
  
%if USERKEY
keyloop:
			; Get a char in (al), loop till key hit..
%if POWER2  
  xor ax,ax		; You can sometimes assume ah=0.
%endif
  int 16h		; ah=0, read key
  cmp al,0
  je keyloop
  cmp al,27
  jne reloop
%endif

%if FULLVER

  mov	ax,3		; Screen mode 3 - Text 80x25
  int 10h

  mov dx,msg	 	; Print a message
  mov ah,9
  int 21h
%endif
  ret


section .data		; Initialised data section

%if FULLVER
msg:
  db ' DLIFE2D (C) A.Millett 2014. Freeware.',0Dh,0Ah,'$'
%endif

section .bss		; Uninitialised data sect..

; xrnd:  resb 2		; rand var (reserve 2 bytes)
