#ifndef FONT_DATA_HPP
#define FONT_DATA_HPP

namespace font_data
{

#if 0
const float SCALE = 0.9f;
const float I = 1.0f * SCALE;
const float O = 0.0f * SCALE;
const float H = 0.5f * SCALE;
const float Q = 0.33 * SCALE;
const float Q3 = 0.66 * SCALE;

// A
float g_v_fnt_a[] = {
    O, I,
    -I, -I,
    I, -I};

unsigned g_i_fnt_a[] = {0, 1, 2};

// B
float g_v_fnt_b[] = {
    -I, I,
    -I, -I,
    -Q3, -I,
    I, H,
    I, -H,
    -I, O
};

unsigned g_i_fnt_b[] = {
    0, 1, 2,
    0, 5, 3,
    5, 1, 4
};

// C
float g_v_fnt_c[] = {
    -I, O,
    O, -I,
    O, I,
    I, H,
    I, I,
    I, -I,
    I, -H 
};

unsigned g_i_fnt_c[] = {
    0, 1, 2,
    2, 3, 4,
    1, 5, 6
};

// D
float g_v_fnt_d[] = {
    -I, I,
    -I, -I,
    I, 0,
};

unsigned g_i_fnt_d[] = {0, 1, 2};

// E
float g_v_fnt_e[] = {
    -I, O,
    -Q3, -I,
    -Q3, I,
    I, I,
    I, Q3,
    I, Q,
    I, -Q,
    I, -Q3,
    I, -I
};

unsigned g_i_fnt_e[] = {
    0, 1, 2,
    3, 2, 4,
    5, 0, 6,
    7, 1, 8
};

// F
float g_v_fnt_f[] = {
    -I, O,
    -Q3, -I,
    -Q3, I,
    I, I,
    I, Q3,
    Q3, Q,
    Q3, -Q
};

unsigned g_i_fnt_f[] = {
    0, 1, 2,
    3, 2, 4,
    5, 0, 6,
}; 

// G
float g_v_fnt_g[] = {
    -I, O,
    O, -I,
    O, I,
    I, H,
    I, I,
    I, -I,
    I, -H,
    Q, O,
    I, O
};

unsigned g_i_fnt_g[] = {
    0, 1, 2,
    2, 3, 4,
    1, 5, 6,
    7, 6, 8
};

// H
float g_v_fnt_h[] = {
    -I, -I,
    -I, I,
    I, I,
    I, -I,
    -Q, O,
    Q, O,
    O, -Q,
};

unsigned g_i_fnt_h[] = {
    0, 4, 1,
    2, 5, 3,
    4, 6, 5
};

// I
float g_v_fnt_i[] = {
    -Q, -I,
    Q, -I,
    O, I
};

unsigned g_i_fnt_i[] = {1, 2, 0};

// J
float g_v_fnt_j[] = {
    -I, -H,
    O, -I,
    I, -Q3,
    Q3, I,
    I, I
};

unsigned g_i_fnt_j[] = {
    0, 1, 2,
    2, 4, 3
};

// K
float g_v_fnt_k[] = {
    -H, O,
    -I, -I,
    -I, I,
    I, I,
    I, -I,
    H, I,
    H, -I

};

unsigned g_i_fnt_k[] = {
    0, 2, 1,
    0, 3, 5,
    0, 6, 4
};

// L
float g_v_fnt_l[] = {
    -I, I,
    -I, -I,
    -Q3, -I,
    I, -I,
    -I, -Q3
};

unsigned g_i_fnt_l[] = {
    0, 1, 2,
    1, 3, 4
};

// M
float g_v_fnt_m[] = {
    -I, I,
    -I, -I,
    -Q3, -I,
    I, I,
    I, -I,
    Q3, -I,
    O, O,
    O, Q
};

unsigned g_i_fnt_m[] = {
    0, 1, 2,
    3, 5, 4,
    0, 6, 7,
    3, 7, 6
};

// N
float g_v_fnt_n[] = {
    -I, I,
    -I, -I,
    -Q3, O,
    I, I,
    I, -I,
    Q3, O
};

unsigned g_i_fnt_n[] = {
    0, 1, 2,
    3, 5, 4,
    0, 4, 5,
    0, 2, 4
};

// O
float g_v_fnt_o[] = {
    -I, O,
    O, -I,
    I, O,
    O, I,
    -Q, Q,
    -Q, -Q,
    Q, -Q,
    Q, Q
};

unsigned g_i_fnt_o[] = {
    0, 4, 3,
    0, 1, 5,
    1, 2, 6,
    2, 3, 7
};

// P
float g_v_fnt_p[] = {
    -I, I,
    -I, -I,
    -Q3, -I,
    -I, O,
    H, H
};

unsigned g_i_fnt_p[] = {
    0, 1, 2,
    0, 3, 4
};

// Q
float g_v_fnt_q[] = {
    -I, O,
    O, -I,
    I, O,
    O, I,
    -Q, Q,
    -Q, -Q,
    Q, -Q,
    Q, Q,
    O, O,
    Q3, -I,
    I, -Q3
};

unsigned g_i_fnt_q[] = {
    0, 4, 3,
    0, 1, 5,
    1, 2, 6,
    2, 3, 7,
    8, 9, 10
};

// R
float g_v_fnt_r[] = {
    -I, I,
    -I, -I,
    -Q3, -I,
    -I, O,
    H, H,
    O, -I,
    H, -I,
};

unsigned g_i_fnt_r[] = {
    0, 1, 2,
    0, 3, 4,
    3, 5, 6
};

// S
float g_v_fnt_s[] = {
    -Q3, Q3,
    -I, O,
    I, I,
    -I, -I,
    Q3, -Q3,
    I, O,
    O, Q
};

unsigned g_i_fnt_s[] = {
    0, 1, 2,
    3, 4, 5,
    1, 5, 6
};

// T
float g_v_fnt_t[] = {
    -I, I,
    O, H,
    I, I,
    Q, -I,
    -Q, -I
};

unsigned g_i_fnt_t[] = {
    0, 1, 2,
    1, 4, 3
};

// U
float g_v_fnt_u[] = {
    -I, I,
    -I, -H,
    -Q3, I,
    Q3, I,
    I, -H,
    I, I,
    O, -I
};

unsigned g_i_fnt_u[] = {
    0, 1, 2,
    3, 4, 5,
    1, 6, 4
};

// V
float g_v_fnt_v[] = {
    -I, I,
    O, -I,
    I, I,
};

unsigned g_i_fnt_v[] = {0, 1, 2};

// W
float g_v_fnt_w[] = {
    -I, I,
    -H, -I,
    O, I,
    H, -I,
    I, I
};

unsigned g_i_fnt_w[] = {
    0, 1, 2,
    2, 3, 4
};

// X
float g_v_fnt_x[] = {
    O, O,
    -I, Q3,
    -Q3, I,
    I, Q3,
    Q3, I,
    I, -Q3,
    Q3, -I,
    -I, -Q3,
    -Q3, -I,
};

unsigned g_i_fnt_x[] = {
    0, 2, 1,
    0, 3, 4,
    0, 6, 5,
    0, 7, 8
};

// Y
float g_v_fnt_y[] = {
    O, O,
    -I, Q3,
    -Q3, I,
    I, Q3,
    Q3, I,
    -Q, -I,
    Q, -I
};

unsigned g_i_fnt_y[] = {
    0, 2, 1,
    0, 3, 4,
    0, 5, 6
};

// Z
float g_v_fnt_z[] = {
    -I, I,
    I, Q3,
    I, I,
    -I, -I,
    I, -I,
    -I, -Q3,
};

unsigned g_i_fnt_z[] = {
    0, 1, 2,
    3, 4, 5,
    1, 2, 5,
    4, 5, 1
};
#else
// a
float g_v_fnt_a[] = { 
  -1.0, -1.0,
  1.0, -1.0,
  -0.19921875, 1.0,
  0.19921875, 1.0,
  -0.3330078125, -1.0,
  0.3330078125, -1.0,
  0.0, 0.0,
};

unsigned g_i_fnt_a[] = { 
  2, 6, 3,
  6, 2, 0,
  6, 1, 3,
  0, 4, 6,
  6, 5, 1,
};


// b
float g_v_fnt_b[] = { 
  -1.0, -1.0,
  -0.5, -1.0,
  -1.0, 1.0,
  -0.5, 1.0,
  -0.5, -0.69921875,
  -0.5, -0.19921875,
  -0.5, 0.599609375,
  0.5, -1.0,
  0.2998046875, -0.69921875,
  0.94921875, -0.349609375,
  0.44921875, -0.349609375,
  0.5, 1.0,
  0.19921875, 0.599609375,
  0.94921875, 0.44921875,
  0.44921875, 0.44921875,
  -0.5, 0.1494140625,
  0.5, -0.19921875,
  0.5, 0.1494140625,
  0.69921875, -0.0244140625,
};

unsigned g_i_fnt_b[] = { 
  0, 4, 5,
  1, 7, 8,
  7, 9, 10,
  3, 6, 12,
  11, 12, 14,
  15, 5, 16,
  9, 16, 10,
  17, 13, 14,
  17, 18, 13,
  16, 9, 18,
  15, 2, 0,
  2, 6, 3,
  0, 5, 15,
  0, 1, 4,
  15, 6, 2,
  4, 1, 8,
  8, 7, 10,
  11, 3, 12,
  13, 11, 14,
  16, 17, 15,
  17, 16, 18,
};


// c
float g_v_fnt_c[] = { 
  0.0, 1.0,
  -0.3818359375, 0.923828125,
  -0.70703125, 0.70703125,
  -0.923828125, 0.3818359375,
  -1.0, 0.0,
  -0.923828125, -0.3818359375,
  -0.70703125, -0.70703125,
  -0.3818359375, -0.923828125,
  0.0, -1.0,
  0.3818359375, -0.923828125,
  0.70703125, -0.70703125,
  0.623046875, -0.3818359375,
  0.623046875, 0.3818359375,
  0.70703125, 0.70703125,
  0.3818359375, 0.923828125,
  0.0, 0.599609375,
  -0.2294921875, 0.5537109375,
  -0.423828125, 0.423828125,
  -0.5537109375, 0.2294921875,
  -0.599609375, 0.0,
  -0.5537109375, -0.2294921875,
  -0.423828125, -0.423828125,
  -0.2294921875, -0.5537109375,
  0.0, -0.599609375,
  0.2294921875, -0.5537109375,
  0.423828125, -0.423828125,
  0.423828125, 0.423828125,
  0.2294921875, 0.5537109375,
};

unsigned g_i_fnt_c[] = { 
  19, 4, 20,
  16, 0, 1,
  27, 13, 14,
  13, 26, 12,
  10, 25, 24,
  27, 26, 13,
  10, 11, 25,
  15, 27, 14,
  9, 24, 23,
  0, 15, 14,
  9, 10, 24,
  16, 15, 0,
  8, 23, 22,
  17, 16, 1,
  8, 9, 23,
  2, 17, 1,
  7, 22, 21,
  18, 17, 2,
  7, 8, 22,
  3, 18, 2,
  6, 21, 20,
  19, 18, 3,
  6, 7, 21,
  4, 19, 3,
  20, 4, 5,
  5, 6, 20,
};


// d
float g_v_fnt_d[] = { 
  -1.0, -1.0,
  1.0, -0.19921875,
  -1.0, 1.0,
  1.0, 0.19921875,
  0.728515625, 0.599609375,
  0.2998046875, 0.8994140625,
  -0.349609375, 1.0,
  -0.349609375, -1.0,
  0.2998046875, -0.8994140625,
  0.728515625, -0.599609375,
  -0.544921875, -0.599609375,
  0.654296875, -0.119140625,
  -0.544921875, 0.599609375,
  0.654296875, 0.119140625,
  0.4912109375, 0.359375,
  0.2333984375, 0.5390625,
  -0.1552734375, 0.599609375,
  -0.1552734375, -0.599609375,
  0.2333984375, -0.5390625,
  0.4912109375, -0.359375,
};

unsigned g_i_fnt_d[] = { 
  12, 16, 6,
  16, 15, 5,
  15, 14, 4,
  4, 14, 13,
  13, 11, 1,
  11, 19, 9,
  9, 19, 18,
  8, 18, 17,
  7, 17, 10,
  0, 10, 12,
  2, 12, 6,
  6, 16, 5,
  5, 15, 4,
  3, 4, 13,
  3, 13, 1,
  1, 11, 9,
  8, 9, 18,
  7, 8, 17,
  0, 7, 10,
  2, 0, 12,
};


// e
float g_v_fnt_e[] = { 
  -1.0, -1.0,
  -0.5, -1.0,
  -1.0, 1.0,
  -0.5, 1.0,
  -0.5, -0.599609375,
  -0.5, -0.19921875,
  -0.5, 0.19921875,
  -0.5, 0.599609375,
  1.0, -1.0,
  1.0, -0.599609375,
  0.7998046875, -0.19921875,
  0.7998046875, 0.19921875,
  1.0, 1.0,
  1.0, 0.599609375,
};

unsigned g_i_fnt_e[] = { 
  0, 5, 6,
  1, 8, 9,
  5, 10, 11,
  7, 13, 12,
  6, 2, 0,
  2, 7, 3,
  0, 4, 5,
  6, 7, 2,
  0, 1, 4,
  4, 1, 9,
  6, 5, 11,
  3, 7, 12,
};


// f
float g_v_fnt_f[] = { 
  -1.0, -1.0,
  -0.5, -1.0,
  -1.0, 1.0,
  -0.5, 1.0,
  -0.5, -0.2998046875,
  -0.5, 0.099609375,
  -0.5, 0.599609375,
  0.2998046875, -0.2998046875,
  0.2998046875, 0.099609375,
  0.69921875, 1.0,
  0.69921875, 0.599609375,
};

unsigned g_i_fnt_f[] = { 
  2, 0, 5,
  4, 7, 8,
  6, 10, 9,
  4, 5, 0,
  2, 6, 3,
  0, 1, 4,
  2, 5, 6,
  5, 4, 8,
  3, 6, 9,
};


// g
float g_v_fnt_g[] = { 
  0.0, 1.0,
  -0.5, 0.865234375,
  -0.865234375, 0.4990234375,
  -1.0, 0.0,
  -0.865234375, -0.5,
  -0.5, -0.865234375,
  0.0, -1.0,
  0.4990234375, -0.865234375,
  0.865234375, -0.5,
  0.51953125, 0.0,
  0.865234375, 0.4990234375,
  0.5, 0.865234375,
  0.0, 0.599609375,
  -0.2998046875, 0.51953125,
  -0.51953125, 0.2998046875,
  -0.599609375, 0.0,
  -0.51953125, -0.2998046875,
  -0.2998046875, -0.51953125,
  0.0, -0.599609375,
  0.2998046875, -0.51953125,
  0.51953125, -0.2998046875,
  0.865234375, -0.19921875,
  0.51953125, 0.2998046875,
  0.2998046875, 0.51953125,
  0.119140625, 0.0,
  0.119140625, -0.2998046875,
};

unsigned g_i_fnt_g[] = { 
  21, 9, 20,
  24, 25, 20,
  3, 4, 15,
  8, 21, 20,
  9, 24, 20,
  13, 0, 1,
  22, 10, 11,
  8, 20, 19,
  23, 22, 11,
  7, 19, 18,
  12, 23, 11,
  7, 8, 19,
  0, 12, 11,
  6, 18, 17,
  13, 12, 0,
  6, 7, 18,
  14, 13, 1,
  5, 17, 16,
  2, 14, 1,
  5, 6, 17,
  15, 14, 2,
  4, 16, 15,
  16, 4, 5,
  15, 2, 3,
};


// h
float g_v_fnt_h[] = { 
  -1.0, -1.0,
  1.0, -1.0,
  -1.0, 1.0,
  1.0, 1.0,
  -0.3330078125, 1.0,
  0.3330078125, 1.0,
  -0.3330078125, -1.0,
  0.3330078125, -1.0,
  -0.3330078125, -0.2998046875,
  0.3330078125, -0.2998046875,
  -0.3330078125, 0.2998046875,
  0.3330078125, 0.2998046875,
};

unsigned g_i_fnt_h[] = { 
  11, 10, 9,
  10, 2, 0,
  3, 5, 11,
  10, 4, 2,
  1, 3, 11,
  8, 0, 6,
  7, 1, 11,
  10, 0, 8,
  10, 8, 9,
};


// i
float g_v_fnt_i[] = { 
  -0.3193359375, -0.9990234375,
  0.3193359375, -0.9990234375,
  -0.3193359375, 0.19921875,
  0.3193359375, 0.19921875,
  -0.3193359375, 0.4990234375,
  0.3193359375, 0.4990234375,
  -0.3193359375, 1.0,
  0.3193359375, 1.0,
};

unsigned g_i_fnt_i[] = { 
  1, 3, 2,
  5, 7, 6,
  0, 1, 2,
  4, 5, 6,
};


// j
float g_v_fnt_j[] = { 
  0.19921875, -0.099609375,
  0.7998046875, -0.099609375,
  0.19921875, 1.0,
  0.7998046875, 1.0,
  0.2099609375, -0.421875,
  0.7890625, -0.4775390625,
  0.1279296875, -0.572265625,
  0.4716796875, -0.826171875,
  -0.037109375, -0.6025390625,
  0.037109375, -0.99609375,
  -0.3369140625, -0.6025390625,
  -0.5615234375, -0.99609375,
  -0.4443359375, -0.5029296875,
  -0.8544921875, -0.6962890625,
  -0.4228515625, -0.298828125,
  -0.8759765625, -0.30078125,
};

unsigned g_i_fnt_j[] = { 
  1, 3, 2,
  1, 0, 4,
  4, 6, 7,
  6, 8, 9,
  9, 8, 10,
  11, 10, 12,
  12, 14, 15,
  0, 1, 2,
  5, 1, 4,
  5, 4, 7,
  7, 6, 9,
  11, 9, 10,
  13, 11, 12,
  13, 12, 15,
};


// k
float g_v_fnt_k[] = { 
  -1.0, -1.0,
  -0.5, -1.0,
  -1.0, 1.0,
  -0.5, 1.0,
  -0.5, -0.232421875,
  -0.5, 0.232421875,
  0.0, -0.099609375,
  0.0, 0.099609375,
  0.3994140625, 1.0,
  0.7998046875, 0.7998046875,
  0.19921875, -1.0,
  0.69921875, -1.0,
};

unsigned g_i_fnt_k[] = { 
  0, 4, 5,
  4, 6, 7,
  7, 9, 8,
  6, 4, 10,
  5, 2, 0,
  0, 1, 4,
  5, 3, 2,
  5, 4, 7,
  5, 7, 8,
  11, 6, 10,
};


// l
float g_v_fnt_l[] = { 
  -1.0, -1.0,
  -0.5, -1.0,
  -1.0, 1.0,
  -0.5, 1.0,
  -0.5, -0.5693359375,
  0.7998046875, -1.0,
  0.7998046875, -0.5693359375,
};

unsigned g_i_fnt_l[] = { 
  2, 4, 3,
  1, 5, 6,
  4, 2, 0,
  0, 1, 4,
  4, 1, 6,
};


// m
float g_v_fnt_m[] = { 
  -1.0, -1.0,
  1.0, -1.0,
  -1.0, 1.0,
  1.0, 1.0,
  -0.5, -1.0,
  0.5390625, -1.0,
  -0.5, 0.2998046875,
  0.5390625, 0.3994140625,
  -0.599609375, 1.0,
  0.0, 0.19921875,
  0.5390625, 1.0,
  0.0, -0.3095703125,
};

unsigned g_i_fnt_m[] = { 
  11, 7, 9,
  6, 2, 0,
  7, 10, 9,
  6, 0, 4,
  7, 1, 3,
  8, 2, 6,
  7, 5, 1,
  9, 8, 6,
  7, 3, 10,
  9, 6, 11,
};


// n
float g_v_fnt_n[] = { 
  -1.0, -1.0,
  1.0, 1.0,
  -1.0, 1.0,
  1.0, -0.5,
  -0.5, 1.0,
  1.0, -1.0,
  0.599609375, -1.0,
  -0.5, -1.0,
  0.599609375, -0.5,
  -0.5, 0.3994140625,
  0.599609375, 1.0,
};

unsigned g_i_fnt_n[] = { 
  9, 6, 8,
  6, 5, 3,
  3, 1, 10,
  0, 7, 9,
  4, 9, 8,
  8, 6, 3,
  8, 3, 10,
  9, 2, 0,
  2, 9, 4,
};


// o
float g_v_fnt_o[] = { 
  0.0, 1.0,
  -0.5, 0.865234375,
  -0.865234375, 0.4990234375,
  -1.0, 0.0,
  -0.865234375, -0.5,
  -0.5, -0.865234375,
  0.0, -1.0,
  0.4990234375, -0.865234375,
  0.865234375, -0.5,
  1.0, 0.0,
  0.865234375, 0.4990234375,
  0.5, 0.865234375,
  0.0, 0.69921875,
  -0.349609375, 0.60546875,
  -0.60546875, 0.349609375,
  -0.69921875, 0.0,
  -0.60546875, -0.349609375,
  -0.349609375, -0.60546875,
  0.0, -0.69921875,
  0.349609375, -0.60546875,
  0.60546875, -0.349609375,
  0.69921875, 0.0,
  0.60546875, 0.349609375,
  0.349609375, 0.60546875,
};

unsigned g_i_fnt_o[] = { 
  8, 9, 21,
  9, 10, 22,
  0, 12, 23,
  11, 23, 22,
  1, 13, 12,
  2, 14, 13,
  3, 15, 14,
  4, 16, 15,
  5, 17, 16,
  6, 18, 17,
  7, 19, 18,
  8, 20, 19,
  20, 8, 21,
  21, 9, 22,
  11, 0, 23,
  10, 11, 22,
  0, 1, 12,
  1, 2, 13,
  2, 3, 14,
  3, 4, 15,
  4, 5, 16,
  5, 6, 17,
  6, 7, 18,
  7, 8, 19,
};


// p
float g_v_fnt_p[] = { 
  -1.0, -1.0,
  -0.5, -1.0,
  -1.0, 1.0,
  -0.5, 1.0,
  -0.5, -0.5,
  -0.5, 0.0,
  -0.5, 0.5,
  -0.19921875, -0.5,
  -0.19921875, 0.0,
  -0.19921875, 1.0,
  -0.19921875, 0.5,
  0.3994140625, 0.7998046875,
  0.1494140625, 0.4296875,
  0.2998046875, -0.2998046875,
  0.0, 0.099609375,
  0.599609375, 0.0,
  0.2197265625, 0.19921875,
  0.599609375, 0.3994140625,
};

unsigned g_i_fnt_p[] = { 
  0, 1, 4,
  4, 7, 8,
  6, 10, 9,
  9, 10, 12,
  8, 7, 13,
  13, 15, 16,
  16, 15, 17,
  12, 16, 17,
  5, 2, 0,
  2, 6, 3,
  0, 4, 5,
  5, 6, 2,
  5, 4, 8,
  3, 6, 9,
  11, 9, 12,
  14, 8, 13,
  14, 13, 16,
  11, 12, 17,
};


// q
float g_v_fnt_q[] = { 
  -1.0, 0.0,
  -0.865234375, 0.4990234375,
  -0.5, 0.865234375,
  0.0, 1.0,
  -0.865234375, -0.5,
  -0.5, -0.865234375,
  0.0, -1.0,
  0.4990234375, -0.765625,
  0.765625, -0.5,
  0.8994140625, 0.0,
  0.765625, 0.599609375,
  0.5, 0.865234375,
  -0.599609375, 0.0,
  -0.51953125, 0.2998046875,
  -0.2998046875, 0.51953125,
  0.0, 0.599609375,
  -0.51953125, -0.2998046875,
  -0.2998046875, -0.51953125,
  0.0, -0.599609375,
  0.2998046875, -0.51953125,
  0.51953125, -0.2998046875,
  0.599609375, 0.0,
  0.51953125, 0.2998046875,
  0.2998046875, 0.51953125,
  0.857421875, -0.95703125,
  0.9677734375, -0.84765625,
  0.154296875, -0.2646484375,
  0.2646484375, -0.154296875,
};

unsigned g_i_fnt_q[] = { 
  9, 21, 20,
  9, 10, 22,
  10, 11, 23,
  3, 15, 23,
  2, 14, 15,
  1, 13, 14,
  0, 12, 13,
  4, 16, 12,
  5, 17, 16,
  6, 18, 17,
  7, 19, 18,
  8, 20, 19,
  8, 7, 24,
  19, 20, 27,
  8, 9, 20,
  21, 9, 22,
  22, 10, 23,
  11, 3, 23,
  3, 2, 15,
  2, 1, 14,
  1, 0, 13,
  0, 4, 12,
  4, 5, 16,
  5, 6, 17,
  6, 7, 18,
  7, 8, 19,
  25, 8, 24,
  26, 19, 27,
};


// r
float g_v_fnt_r[] = { 
  -1.0, -1.0,
  -0.5, -1.0,
  -1.0, 1.0,
  -0.5, 1.0,
  -0.5, -0.5,
  -0.5, 0.0,
  -0.5, 0.599609375,
  0.0, 1.0,
  0.0, 0.599609375,
  0.4765625, 0.7265625,
  0.22265625, 0.373046875,
  0.576171875, 0.0263671875,
  0.22265625, 0.072265625,
  0.2763671875, -0.2724609375,
  -0.076171875, -0.0263671875,
  -0.5, -0.25,
  -0.2109375, -0.2607421875,
  0.7763671875, -0.982421875,
  0.2978515625, -1.0009765625,
};

unsigned g_i_fnt_r[] = { 
  13, 16, 18,
  6, 8, 7,
  8, 10, 9,
  10, 12, 11,
  12, 14, 13,
  0, 4, 15,
  16, 14, 5,
  17, 13, 18,
  3, 6, 7,
  7, 8, 9,
  9, 10, 11,
  11, 12, 13,
  5, 2, 0,
  2, 6, 3,
  0, 15, 5,
  0, 1, 4,
  5, 6, 2,
  14, 16, 13,
  16, 5, 15,
};


// s
float g_v_fnt_s[] = { 
  0.0, 0.69921875,
  0.8994140625, 0.599609375,
  0.0, 1.0,
  1.0, 0.8994140625,
  -0.3994140625, 0.3994140625,
  -0.599609375, 0.7998046875,
  -0.7998046875, 0.099609375,
  -0.8994140625, 0.5,
  0.69921875, 0.099609375,
  0.2998046875, -0.099609375,
  0.94921875, -0.44921875,
  0.5498046875, -0.44921875,
  0.814453125, -0.845703125,
  0.484375, -0.6533203125,
  -0.099609375, -1.0,
  0.0, -0.69921875,
  -1.0, -0.7998046875,
  -0.7998046875, -0.5,
  0.5, 1.0,
  0.5, 0.69921875,
};

unsigned g_i_fnt_s[] = { 
  19, 1, 3,
  0, 2, 5,
  4, 5, 7,
  4, 6, 9,
  8, 9, 11,
  11, 13, 12,
  13, 15, 14,
  14, 15, 17,
  18, 2, 0,
  19, 3, 18,
  18, 0, 19,
  4, 0, 5,
  6, 4, 7,
  8, 4, 9,
  10, 8, 11,
  10, 11, 12,
  12, 13, 14,
  16, 14, 17,
};


// t
float g_v_fnt_t[] = { 
  -1.0, 0.599609375,
  1.0, 0.599609375,
  -1.0, 1.0,
  1.0, 1.0,
  -0.2998046875, 0.599609375,
  0.2998046875, 0.599609375,
  -0.2998046875, -1.0,
  0.2998046875, -1.0,
};

unsigned g_i_fnt_t[] = { 
  2, 5, 3,
  4, 6, 7,
  4, 2, 0,
  5, 1, 3,
  2, 4, 5,
  5, 4, 7,
};


// u
float g_v_fnt_u[] = { 
  -1.0, -0.3994140625,
  -0.5, -0.3994140625,
  -1.0, 1.0,
  -0.5, 1.0,
  0.5, -0.3994140625,
  1.0, -0.3994140625,
  0.5, 1.0,
  1.0, 1.0,
  0.2998046875, -0.599609375,
  0.599609375, -0.7998046875,
  0.0, -0.69921875,
  0.0, -1.0,
  -0.599609375, -0.7998046875,
  -0.2998046875, -0.599609375,
};

unsigned g_i_fnt_u[] = { 
  1, 3, 2,
  5, 7, 6,
  4, 8, 9,
  8, 10, 11,
  1, 0, 12,
  13, 12, 11,
  0, 1, 2,
  4, 5, 6,
  5, 4, 9,
  9, 8, 11,
  13, 1, 12,
  10, 13, 11,
};


// v
float g_v_fnt_v[] = { 
  -0.2998046875, -1.0,
  0.2998046875, -1.0,
  -1.0, 1.0,
  1.0, 1.0,
  -0.5, 1.0,
  0.0, -0.599609375,
  0.5, 1.0,
};

unsigned g_i_fnt_v[] = { 
  0, 1, 5,
  5, 2, 0,
  3, 6, 5,
  5, 4, 2,
  1, 3, 5,
};


// w
float g_v_fnt_w[] = { 
  -0.69921875, -1.0,
  0.69921875, -1.0,
  -1.0, 1.0,
  1.0, 1.0,
  -0.349609375, -1.0,
  0.0, -0.3994140625,
  0.349609375, -1.0,
  -0.5, 1.0,
  0.0, 0.7998046875,
  0.5, 1.0,
  -0.25, -0.099609375,
  0.25, -0.099609375,
};

unsigned g_i_fnt_w[] = { 
  5, 6, 11,
  10, 2, 0,
  11, 8, 10,
  10, 7, 2,
  10, 4, 5,
  11, 6, 1,
  11, 3, 9,
  4, 10, 0,
  1, 3, 11,
  11, 10, 5,
};


// x
float g_v_fnt_x[] = { 
  -0.2822265625, 0.0,
  0.0, -0.2822265625,
  0.0, 0.2822265625,
  0.2822265625, 0.0,
  0.69921875, 0.982421875,
  0.982421875, 0.69921875,
  -0.982421875, 0.69921875,
  -0.69921875, 0.982421875,
  -0.982421875, -0.69921875,
  -0.69921875, -0.982421875,
  0.69921875, -0.982421875,
  0.982421875, -0.69921875,
};

unsigned g_i_fnt_x[] = { 
  1, 3, 2,
  3, 5, 4,
  2, 7, 6,
  0, 8, 9,
  1, 10, 11,
  0, 1, 2,
  2, 3, 4,
  0, 2, 6,
  1, 0, 9,
  3, 1, 11,
};


// y
float g_v_fnt_y[] = { 
  -0.2822265625, 0.0,
  0.69921875, 0.982421875,
  0.0, 0.2822265625,
  0.2822265625, 0.0,
  0.982421875, 0.69921875,
  -0.982421875, 0.69921875,
  -0.69921875, 0.982421875,
  -0.2822265625, -1.0,
  0.2822265625, -1.0,
};

unsigned g_i_fnt_y[] = { 
  3, 2, 0,
  3, 4, 1,
  2, 6, 5,
  0, 7, 8,
  2, 3, 1,
  0, 2, 5,
  3, 0, 8,
};


// z
float g_v_fnt_z[] = { 
  -1.0, 0.599609375,
  1.0, 0.599609375,
  -1.0, 1.0,
  1.0, 1.0,
  0.2998046875, 0.599609375,
  -0.2998046875, -0.599609375,
  -1.0, -0.599609375,
  -0.2998046875, -1.0,
  -1.0, -1.0,
  1.0, -0.599609375,
  1.0, -1.0,
};

unsigned g_i_fnt_z[] = { 
  2, 4, 3,
  4, 6, 5,
  6, 8, 7,
  7, 10, 9,
  4, 2, 0,
  4, 1, 3,
  1, 4, 5,
  5, 6, 7,
  5, 7, 9,
};

#endif

struct glyph_record
{
    float * vertices;
    unsigned v_count;
    unsigned * indices;
    unsigned i_count;
};

#define FNT_ENTRY(c) \
   {g_v_fnt_##c, sizeof(g_v_fnt_##c)/2/sizeof(float), \
    g_i_fnt_##c, sizeof(g_i_fnt_##c)/sizeof(unsigned)}

glyph_record const glyph_records[] =
{
    FNT_ENTRY(a),
    FNT_ENTRY(b),
    FNT_ENTRY(c),
    FNT_ENTRY(d),
    FNT_ENTRY(e),
    FNT_ENTRY(f),
    FNT_ENTRY(g),
    FNT_ENTRY(h),
    FNT_ENTRY(i),
    FNT_ENTRY(j),
    FNT_ENTRY(k),
    FNT_ENTRY(l),
    FNT_ENTRY(m),
    FNT_ENTRY(n),
    FNT_ENTRY(o),
    FNT_ENTRY(p),
    FNT_ENTRY(q),
    FNT_ENTRY(r),
    FNT_ENTRY(s),
    FNT_ENTRY(t),
    FNT_ENTRY(u),
    FNT_ENTRY(v),
    FNT_ENTRY(w),
    FNT_ENTRY(x),
    FNT_ENTRY(y),
    FNT_ENTRY(z),
};

} /* namespace font_data */

#endif /* FONT_DATA_HPP */
