%macro export_func 1
   global _%1
   _%1:
%endmacro
%define SAMPLE_RATE	44100
%define MAX_INSTRUMENTS	16
%define MAX_VOICES 1
%define HLD 1
%define BPM 120.000000
%define MAX_PATTERNS 72
%define PATTERN_SIZE_SHIFT 4
%define PATTERN_SIZE (1 << PATTERN_SIZE_SHIFT)
%define	MAX_TICKS (MAX_PATTERNS*PATTERN_SIZE)
%define	SAMPLES_PER_TICK 5512
%define DEF_LFO_NORMALIZE 0.0000453515
%define	MAX_SAMPLES	(SAMPLES_PER_TICK*MAX_TICKS)
%define 	GO4K_USE_16BIT_OUTPUT
;%define 	GO4K_USE_GROOVE_PATTERN
%define 	GO4K_USE_ENVELOPE_RECORDINGS
;%define 	GO4K_USE_NOTE_RECORDINGS
%define 	GO4K_CLIP_OUTPUT
%define 	GO4K_USE_DST
%define 	GO4K_USE_DLL
%define 	GO4K_USE_GLOBAL_DLL
%define 	GO4K_USE_FSTG
%define 	GO4K_USE_ENV_CHECK
%define 	GO4K_USE_ENV_MOD_GM
%define 	GO4K_USE_VCO_CHECK
%define 	GO4K_USE_VCO_PHASE_OFFSET
%define 	GO4K_USE_VCO_SHAPE
%define 	GO4K_USE_VCO_MOD_PM
%define 	GO4K_USE_VCO_MOD_TM
%define 	GO4K_USE_VCO_MOD_DM
%define 	GO4K_USE_VCO_MOD_CM
%define 	GO4K_USE_VCO_MOD_SM
%define 	GO4K_USE_VCF_CHECK
%define 	GO4K_USE_VCF_MOD_FM
%define 	GO4K_USE_VCF_HIGH
%define 	GO4K_USE_VCF_BAND
%define 	GO4K_USE_VCF_PEAK
%define 	GO4K_USE_DST_CHECK
%define		GO4K_USE_DLL_CHORUS
%define		GO4K_USE_DLL_CHORUS_CLAMP
%define 	GO4K_USE_DLL_DAMP
%define 	GO4K_USE_DLL_DC_FILTER
%define 	GO4K_USE_FSTG_CHECK
%define		GO4K_USE_WAVESHAPER_CLIP
%define	MAX_DELAY			65536
%define MAX_WORKSPACE_SLOTS	8
%define GO4K_BEGIN_CMDDEF(def_name)
%define GO4K_END_CMDDEF db 0
%define GO4K_BEGIN_PARAMDEF(def_name)
%define GO4K_END_PARAMDEF
GO4K_ENV_ID		equ		1
%macro	GO4K_ENV 5
	db	%1
	db	%2
	db	%3
	db	%4
	db	%5
%endmacro
%define	ATTAC(val)		val	
%define	DECAY(val)		val	
%define	SUSTAIN(val)	val	
%define	RELEASE(val)	val	
%define	GAIN(val)		val	
struc	go4kENV_val
	.attac		resd	1
	.decay		resd	1
	.sustain	resd	1
	.release	resd	1
	.gain		resd	1
	.size
endstruc
struc	go4kENV_wrk
	.state		resd	1
	.level		resd	1
	.gm			resd	1
	.am			resd	1
	.dm			resd	1
	.sm			resd	1
	.rm			resd	1
	.size
endstruc
%define ENV_STATE_ATTAC		0
%define ENV_STATE_DECAY		1
%define ENV_STATE_SUSTAIN	2
%define ENV_STATE_RELEASE	3
%define ENV_STATE_OFF		4
GO4K_VCO_ID		equ		2
%macro	GO4K_VCO 8
	db	%1
	db	%2
%ifdef GO4K_USE_VCO_PHASE_OFFSET	
	db	%3
%endif	
%ifdef GO4K_USE_VCO_GATE	
	db	%4
%endif	
	db	%5
%ifdef GO4K_USE_VCO_SHAPE	
	db	%6
%endif	
	db	%7
	db	%8
%endmacro
%define	TRANSPOSE(val)	val	
%define	DETUNE(val)		val	
%define	PHASE(val)		val	
%define	GATES(val)		val	
%define	COLOR(val)		val	
%define	SHAPE(val)		val 
%define	FLAGS(val)		val	
%define SINE		0x01
%define TRISAW		0x02
%define PULSE		0x04
%define NOISE		0x08
%define LFO			0x10
%define GATE		0x20
struc	go4kVCO_val
	.transpose	resd	1
	.detune		resd	1
%ifdef GO4K_USE_VCO_PHASE_OFFSET	
	.phaseofs	resd	1
%endif	
%ifdef GO4K_USE_VCO_GATE	
	.gate		resd	1
%endif	
	.color		resd	1
%ifdef GO4K_USE_VCO_SHAPE	
	.shape		resd	1
%endif	
	.gain		resd	1
	.flags		resd	1	
	.size
endstruc
struc	go4kVCO_wrk
	.phase		resd	1
	.tm			resd	1
	.dm			resd	1
	.fm			resd	1
	.pm			resd	1
	.cm			resd	1
	.sm			resd	1
	.gm			resd	1
	.size
endstruc
GO4K_VCF_ID		equ		3
%macro	GO4K_VCF 3
	db	%1
	db	%2
	db	%3
%endmacro
%define LOWPASS		0x1
%define HIGHPASS	0x2
%define BANDPASS	0x4
%define	BANDSTOP	0x3
%define ALLPASS		0x7
%define	PEAK		0x8
%define	FREQUENCY(val)	val
%define	RESONANCE(val)	val
%define	VCFTYPE(val)	val
struc	go4kVCF_val
	.freq		resd	1
	.res		resd	1
	.type		resd	1
	.size
endstruc
struc	go4kVCF_wrk
	.low		resd	1
	.high		resd	1
	.band		resd	1
	.freq		resd	1
	.fm			resd	1
	.rm			resd	1	
	.size
endstruc
GO4K_DST_ID		equ		4
%macro	GO4K_DST 2
	db	%1
%ifdef GO4K_USE_DST_SH	
	db	%2
%endif	
%endmacro
%define	DRIVE(val)		val
%define	SNHFREQ(val)	val
struc	go4kDST_val
	.drive		resd	1
%ifdef GO4K_USE_DST_SH	
	.snhfreq	resd	1
%endif	
	.size
endstruc
struc	go4kDST_wrk
%ifdef GO4K_USE_DST_SH	
	.out		resd	1
	.snhphase	resd	1
%endif	
	.dm			resd	1
	.sm			resd	1
	.size
endstruc
GO4K_DLL_ID		equ		5
%macro	GO4K_DLL 8
	db	%1
	db	%2
	db	%3
%ifdef GO4K_USE_DLL_DAMP	
	db	%4
%endif		
%ifdef GO4K_USE_DLL_CHORUS	
	db	%5
	db	%6
%endif
	db	%7
	db	%8
%endmacro
%define PREGAIN(val)	val
%define	DRY(val)		val
%define	FEEDBACK(val)	val
%define	DEPTH(val)		val
%define DAMP(val)		val
%define	DELAY(val)		val
%define	COUNT(val)		val
struc	go4kDLL_val
	.pregain	resd	1
	.dry		resd	1
	.feedback	resd	1
%ifdef GO4K_USE_DLL_DAMP	
	.damp		resd	1	
%endif
%ifdef GO4K_USE_DLL_CHORUS
	.freq		resd	1
	.depth
%endif
	.delay		resd	1
	.count		resd	1
	.size
endstruc
struc	go4kDLL_wrk
	.index		resd	1
	.store		resd	1
	.dcin		resd	1
	.dcout		resd	1
%ifdef GO4K_USE_DLL_CHORUS
	.phase		resd	1
%endif
	.buffer		resd	MAX_DELAY
	.size
endstruc
struc	go4kDLL_wrk2
 .pm			resd	1
 .fm			resd	1
 .im			resd	1
 .dm			resd	1
 .sm			resd	1
 .am			resd	1
 .size
endstruc
GO4K_FOP_ID	equ			6
%macro	GO4K_FOP 1
	db	%1
%endmacro
%define	OP(val)			val
%define FOP_POP			0x1
%define FOP_ADDP		0x2
%define FOP_MULP		0x3
%define FOP_PUSH		0x4
%define FOP_XCH			0x5
%define FOP_ADD			0x6
%define FOP_MUL			0x7
%define FOP_ADDP2		0x8
%define FOP_LOADNOTE	0x9
struc	go4kFOP_val
	.flags		resd	1
	.size
endstruc
struc	go4kFOP_wrk
	.size
endstruc
GO4K_FST_ID		equ		7
%macro	GO4K_FST 2
	db	%1
	db	%2
%endmacro
%define	AMOUNT(val)		val
%define	DEST(val)		val
struc	go4kFST_val
	.amount		resd	1
	.op1		resd	1
	.size
endstruc
struc	go4kFST_wrk
	.size
endstruc
GO4K_PAN_ID		equ		8
%macro	GO4K_PAN 1
%ifdef GO4K_USE_PAN
	db	%1
%endif
%endmacro
%define	PANNING(val)	val
struc	go4kPAN_val
%ifdef GO4K_USE_PAN
	.panning	resd	1
%endif
	.size
endstruc
struc	go4kPAN_wrk
	.pm			resd	1
	.size
endstruc
GO4K_OUT_ID		equ		9
%macro	GO4K_OUT 2
	db	%1
%ifdef GO4K_USE_GLOBAL_DLL	
	db	%2
%endif	
%endmacro
%define	AUXSEND(val)	val
struc	go4kOUT_val
	.gain		resd	1
%ifdef GO4K_USE_GLOBAL_DLL	
	.auxsend	resd	1
%endif
	.size
endstruc
struc	go4kOUT_wrk
	.am			resd	1
	.gm			resd	1
	.size
endstruc
GO4K_ACC_ID		equ		10
%macro	GO4K_ACC 1
	db	%1
%endmacro
%define OUTPUT			0
%define	AUX				8
%define ACCTYPE(val)	val
struc	go4kACC_val
	.acctype	resd	1
	.size
endstruc
struc	go4kACC_wrk
	.size
endstruc
%ifdef GO4K_USE_FLD
GO4K_FLD_ID	equ		11
%macro	GO4K_FLD 1
	db	
%endmacro
%define	VALUE(val)	val
struc	go4kFLD_val
	.value		resd	1
	.size
endstruc
struc	go4kFLD_wrk
	.vm			resd	1
	.size
endstruc
%endif
%ifdef GO4K_USE_FSTG
GO4K_FSTG_ID	equ		12
%macro	GO4K_FSTG 2
	db	%1
	dd	%2
%endmacro
struc	go4kFSTG_val
	.amount		resd	1
	.op1		resd	1
	.size
endstruc
struc	go4kFSTG_wrk
	.size
endstruc
%endif
struc	go4k_instrument
	.release	resd	1
	.note		resd	1
	.workspace	resd	256
	.dlloutl	resd	1
	.dlloutr	resd	1
	.outl		resd	1
	.outr		resd	1
	.size
endstruc
struc	go4k_synth
	.instruments	resb	go4k_instrument.size * MAX_INSTRUMENTS * MAX_VOICES
	.global			resb	go4k_instrument.size * MAX_VOICES
	.size
endstruc
%ifdef USE_SECTIONS
section .g4kmuc1 data align=1
%else
section .data align=1
%endif
go4k_patterns
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	78, 0, 0, 0, 0, 0, 0, 0, 0, 0, 80, 0, 0, 0, 73, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 76, 0, 73, 0, 
	db	78, 0, 0, 0, 0, 0, 0, 0, 0, 0, 81, 0, 0, 0, 74, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 80, 0, 81, 0, 
	db	76, 0, 0, 0, 0, 0, 0, 0, 0, 0, 81, 0, 0, 0, 76, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 0, 76, 0, 
	db	78, 0, 0, 0, 0, 0, 85, 0, 80, 0, 81, 0, 0, 0, 78, 0, 
	db	42, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42, HLD, 
	db	40, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, HLD, 
	db	43, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, HLD, 
	db	38, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 38, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 50, HLD, 0, 0, 49, HLD, 0, 0, 
	db	47, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, HLD, 
	db	52, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 45, HLD, 0, 0, 44, HLD, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 40, HLD, 0, 0, 39, HLD, 0, 0, 
	db	45, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 42, HLD, 0, 0, 45, HLD, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 49, HLD, 0, 0, 45, HLD, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 40, HLD, 0, 0, 37, HLD, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 37, HLD, 0, 0, 40, HLD, 0, 0, 
	db	42, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 0, 0, 0, 
	db	45, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 0, 
	db	0, 0, 0, 0, 0, 0, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 45, 0, 0, 0, 0, 0, 0, 0, 45, 0, 
	db	52, 0, 49, 0, 54, 0, 57, 0, 54, 0, 49, 0, 42, 0, 49, 0, 
	db	54, 0, 57, 0, 54, 0, 49, 0, 42, 0, 49, 0, 54, 0, 52, 0, 
	db	47, 0, 40, 0, 52, 0, 56, 0, 52, 0, 47, 0, 40, 0, 47, 0, 
	db	52, 0, 56, 0, 52, 0, 47, 0, 40, 0, 47, 0, 52, 0, 47, 0, 
	db	59, 0, 55, 0, 59, 0, 62, 0, 59, 0, 55, 0, 50, 0, 55, 0, 
	db	59, 0, 62, 0, 59, 0, 55, 0, 50, 0, 55, 0, 59, 0, 57, 0, 
	db	50, 0, 45, 0, 54, 0, 57, 0, 54, 0, 50, 0, 45, 0, 50, 0, 
	db	54, 0, 57, 0, 54, 0, 50, 0, 45, 0, 50, 0, 54, 0, 52, 0, 
	db	47, 0, 42, 0, 50, 0, 54, 0, 50, 0, 42, 0, 35, 0, 42, 0, 
	db	50, 0, 54, 0, 50, 0, 42, 0, 47, 0, 50, 0, 54, 0, 50, 0, 
	db	54, 0, 50, 0, 59, 0, 62, 0, 59, 0, 54, 0, 50, 0, 54, 0, 
	db	59, 0, 62, 0, 59, 0, 54, 0, 49, 0, 52, 0, 56, 0, 49, 0, 
	db	54, 0, 57, 0, 54, 0, 49, 0, 61, 0, 66, 0, 61, 0, 54, 0, 
	db	57, 0, 54, 0, 49, 0, 61, 0, 66, 0, 61, 0, 57, 0, 56, 0, 
	db	54, 0, 50, 0, 54, 0, 45, 0, 57, 0, 62, 0, 57, 0, 50, 0, 
	db	54, 0, 50, 0, 45, 0, 57, 0, 62, 0, 57, 0, 66, 0, 62, 0, 
	db	52, 0, 57, 0, 52, 0, 49, 0, 61, 0, 64, 0, 61, 0, 52, 0, 
	db	57, 0, 52, 0, 49, 0, 61, 0, 64, 0, 61, 0, 57, 0, 64, 0, 
	db	47, 0, 54, 0, 47, 0, 42, 0, 54, 0, 59, 0, 54, 0, 47, 0, 
	db	54, 0, 47, 0, 42, 0, 54, 0, 61, 0, 56, 0, 68, 0, 64, 0, 
	db	54, 0, 61, 0, 54, 0, 49, 0, 61, 0, 66, 0, 61, 0, 54, 0, 
	db	61, 0, 54, 0, 49, 0, 61, 0, 68, 0, 64, 0, 71, 0, 64, 0, 
	db	66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 38, 0, 38, HLD, 0, 0, 38, 38, 
	db	38, 0, 0, 0, 38, 0, 0, 0, 38, 0, 0, 0, 38, 0, 38, 0, 
	db	0, 0, 0, 0, 38, 0, 0, 0, 38, 0, 0, 0, 38, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 38, 0, 38, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 38, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 38, 0, 38, HLD, 0, 0, 0, 0, 
	db	64, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	67, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	62, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	69, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	71, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	52, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 0, 74, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 76, 0, 78, 0, 
	db	75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 0, 71, 0, 66, 0, 
	db	HLD, HLD, HLD, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	72, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	74, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	76, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	52, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, HLD, HLD, HLD, 
	db	HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 59, 63, 66, 0, 63, 66, 71, 0, 66, 71, 73, 0, 69, 0, 
	db	0, 0, 59, 63, 66, 0, 63, 66, 71, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 61, 66, 68, 0, 66, 68, 73, 0, 68, 73, 76, 0, 69, 0, 
	db	78, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 69, HLD, 71, HLD, 73, HLD, 0, 0, 73, HLD, 71, HLD, 
	db	73, HLD, 0, 0, 73, HLD, 71, HLD, 73, HLD, 0, 0, 73, HLD, 69, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, HLD, 73, HLD, 
	db	74, HLD, 0, 0, 74, HLD, 73, HLD, 74, HLD, 0, 0, 74, HLD, 73, HLD, 
	db	74, HLD, 0, 0, 74, HLD, 73, HLD, 74, HLD, 76, HLD, 78, HLD, 0, 0, 
	db	0, 0, 0, 0, 71, HLD, 73, HLD, 74, HLD, 0, 0, 74, HLD, 73, HLD, 
	db	74, HLD, 0, 0, 74, HLD, 73, HLD, 74, HLD, 0, 0, 74, HLD, 78, HLD, 
	db	74, HLD, 0, 0, 74, HLD, 76, HLD, 74, HLD, HLD, HLD, 73, HLD, HLD, 0, 
	db	85, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	83, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	86, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	81, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	88, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	66, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	78, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	102, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 69, 0, 71, 0, 73, HLD, 0, 0, 73, 0, 71, 0, 
	db	73, HLD, 0, 0, 73, 0, 71, 0, 73, HLD, 0, 0, 73, 0, 69, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 0, 73, 0, 
	db	74, HLD, 0, 0, 74, 0, 73, 0, 74, HLD, 0, 0, 74, 0, 73, 0, 
	db	74, HLD, 0, 0, 74, 0, 73, 0, 74, 0, 76, HLD, 78, 0, 0, 0, 
	db	0, 0, 0, 0, 71, 0, 73, 0, 74, HLD, 0, 0, 74, 0, 73, 0, 
	db	74, HLD, 0, 0, 74, 0, 73, 0, 74, HLD, 0, 0, 74, 0, 78, 0, 
	db	74, HLD, 0, 0, 74, 0, 76, 0, 74, HLD, HLD, HLD, 73, HLD, 0, 0, 
	db	0, 0, 0, 0, 73, 0, 71, 0, 69, 0, 71, 0, 73, 0, 76, 0, 
	db	73, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 0, 0, 
	db	0, 0, 0, 0, 73, 0, 71, 0, 69, 0, 71, 0, 73, 0, 71, 0, 
	db	69, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 0, 0, 
	db	0, 0, 0, 0, 69, 0, 66, 0, 69, 0, 71, 0, 73, 0, 76, 0, 
	db	0, 0, 0, 0, 73, 0, 71, 0, 73, 0, 76, 0, 81, 0, 83, 0, 
	db	78, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 78, 80, 81, 0, 80, 0, 78, 0, 76, 0, 
	db	0, 0, 0, 0, 73, 0, 71, 0, 73, 0, 76, 0, 81, 0, 80, 0, 
	db	0, 0, 0, 0, 66, 0, 68, 0, 69, HLD, 0, 0, 69, 0, 68, 0, 
	db	69, HLD, 0, 0, 69, 0, 68, 0, 69, HLD, 0, 0, 69, 0, 66, 0, 
	db	68, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 0, 69, 0, 
	db	71, HLD, 0, 0, 71, 0, 69, 0, 71, HLD, 0, 0, 71, 0, 69, 0, 
	db	71, HLD, 0, 0, 71, 0, 69, 0, 71, 0, 73, 0, 74, HLD, 0, 0, 
	db	0, 0, 0, 0, 66, 0, 69, 0, 71, HLD, 0, 0, 71, 0, 69, 0, 
	db	71, HLD, 0, 0, 71, 0, 69, 0, 71, HLD, 0, 0, 71, 0, 74, 0, 
	db	71, HLD, HLD, 0, 71, 0, 69, 0, 71, HLD, HLD, 0, 71, 0, 69, 0, 
	db	71, HLD, HLD, 0, 71, 0, 73, 0, 71, HLD, 0, 0, 69, HLD, 0, 0, 
	db	0, 0, 0, 0, 69, 0, 68, 0, 66, 0, 68, 0, 69, 0, 71, 0, 
	db	0, 0, 0, 0, 69, 0, 68, 0, 66, 0, 68, 0, 69, 0, 68, 0, 
	db	66, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 0, 0, 
	db	0, 0, 0, 0, 66, 0, 62, 0, 64, 0, 66, 0, 69, 0, 71, 0, 
	db	0, 0, 0, 0, 69, 0, 64, 0, 69, 0, 71, 0, 73, 0, 78, 0, 
	db	75, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 73, 76, 78, 0, 76, 0, 73, 0, 71, 0, 
	db	0, 0, 0, 0, 69, 0, 66, 0, 64, 0, 66, 0, 69, 0, 68, 0, 
	db	0, 0, 0, 0, 66, 0, 62, 0, 66, 0, 68, 0, 69, 0, 71, 0, 
	db	0, 0, 0, 0, 69, 0, 64, 0, 69, 0, 73, 0, 78, 0, 76, 0, 
	db	73, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	0, 0, 0, 0, 69, HLD, 71, HLD, 73, HLD, HLD, 0, 73, HLD, 71, HLD, 
	db	73, HLD, 0, 0, 73, HLD, 71, HLD, 73, HLD, HLD, 0, 73, HLD, 69, HLD, 
	db	74, HLD, HLD, 0, 74, HLD, 73, HLD, 74, HLD, 0, 0, 74, HLD, 73, HLD, 
	db	74, HLD, HLD, 0, 74, HLD, 73, HLD, 74, HLD, 76, HLD, 78, HLD, 0, 0, 
	db	0, 0, 0, 0, 71, HLD, 73, HLD, 74, HLD, HLD, 0, 74, HLD, 73, HLD, 
	db	74, HLD, 0, 0, 74, HLD, 73, HLD, 74, HLD, HLD, 0, 74, HLD, 78, HLD, 
	db	74, HLD, HLD, 0, 74, HLD, 76, HLD, 74, HLD, HLD, HLD, 73, HLD, HLD, 0, 
	db	54, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 0, 0, 0, 0, 0, 
go4k_patterns_end
%ifdef USE_SECTIONS
section .g4kmuc2 data align=1
%else
section .data
%endif
go4k_pattern_lists
Instrument0List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
Instrument1List		db	8, 0, 9, 0, 10, 0, 11, 12, 13, 0, 14, 0, 10, 0, 13, 15, 8, 0, 9, 0, 10, 0, 11, 12, 13, 0, 14, 0, 10, 0, 13, 15, 8, 16, 11, 0, 17, 18, 13, 19, 8, 16, 11, 0, 17, 20, 8, 21, 8, 16, 11, 0, 17, 18, 13, 19, 8, 16, 11, 0, 17, 20, 8, 0, 22, 0, 0, 0, 0, 0, 0, 0, 
Instrument2List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 24, 25, 24, 25, 24, 25, 24, 25, 24, 26, 24, 25, 24, 25, 24, 25, 24, 26, 24, 25, 24, 25, 24, 25, 24, 26, 24, 25, 24, 25, 24, 25, 24, 26, 24, 25, 24, 25, 24, 25, 24, 26, 24, 25, 24, 25, 24, 25, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
Instrument3List		db	27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 29, 30, 31, 32, 37, 38, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 29, 30, 31, 32, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 39, 40, 41, 42, 43, 44, 47, 48, 39, 40, 41, 42, 43, 44, 45, 46, 39, 40, 41, 42, 43, 44, 47, 48, 49, 0, 0, 0, 0, 0, 0, 0, 
Instrument4List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 52, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
Instrument5List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 54, 55, 54, 54, 54, 54, 54, 54, 54, 53, 54, 54, 54, 54, 54, 54, 54, 53, 54, 54, 54, 54, 54, 54, 54, 53, 54, 54, 54, 54, 54, 54, 54, 53, 54, 54, 54, 54, 54, 54, 54, 53, 54, 54, 54, 54, 54, 54, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
Instrument6List		db	0, 0, 56, 0, 57, 0, 58, 0, 0, 0, 56, 0, 57, 0, 0, 0, 0, 0, 56, 0, 57, 0, 58, 0, 0, 0, 56, 0, 57, 0, 0, 0, 0, 0, 58, 0, 59, 0, 60, 0, 0, 0, 58, 0, 59, 0, 0, 0, 0, 0, 58, 0, 59, 0, 60, 0, 0, 0, 58, 0, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
Instrument7List		db	56, 0, 0, 0, 0, 0, 0, 0, 59, 0, 0, 0, 0, 0, 59, 0, 56, 0, 0, 0, 0, 0, 0, 0, 59, 0, 0, 0, 0, 0, 59, 0, 56, 0, 0, 0, 0, 0, 0, 0, 56, 0, 0, 0, 0, 0, 56, 0, 56, 0, 0, 0, 0, 0, 0, 0, 56, 0, 0, 0, 0, 0, 56, 0, 61, 0, 0, 0, 0, 0, 0, 0, 
Instrument8List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 2, 3, 62, 5, 63, 64, 2, 1, 2, 3, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
Instrument9List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 65, 66, 65, 67, 65, 68, 65, 60, 65, 66, 65, 67, 65, 68, 65, 69, 65, 0, 0, 0, 0, 0, 0, 
Instrument10List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 71, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 71, 72, 0, 0, 0, 0, 0, 0, 
Instrument11List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 0, 0, 0, 0, 0, 0, 0, 75, 76, 0, 0, 0, 0, 0, 0, 0, 
Instrument12List		db	77, 78, 60, 79, 80, 81, 59, 0, 82, 83, 68, 79, 80, 84, 60, 0, 85, 0, 86, 0, 87, 0, 88, 0, 86, 0, 89, 0, 87, 0, 86, 0, 59, 65, 67, 65, 59, 65, 60, 65, 90, 65, 67, 65, 59, 65, 91, 65, 91, 65, 67, 65, 59, 65, 60, 65, 90, 65, 67, 65, 59, 65, 91, 65, 92, 0, 0, 0, 0, 0, 0, 0, 
Instrument13List		db	93, 94, 60, 95, 96, 97, 59, 0, 98, 99, 68, 95, 96, 100, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 102, 103, 104, 105, 102, 106, 107, 108, 102, 103, 104, 105, 102, 109, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
Instrument14List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 111, 112, 113, 114, 115, 90, 0, 116, 117, 60, 113, 118, 119, 90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 104, 121, 122, 123, 104, 124, 125, 126, 104, 127, 122, 128, 104, 129, 130, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
Instrument15List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131, 132, 60, 79, 133, 134, 59, 0, 135, 136, 68, 79, 133, 137, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 138, 0, 0, 0, 0, 0, 0, 0, 
go4k_pattern_lists_end
%ifdef USE_SECTIONS
section .g4kmuc3 data align=1
%else
section .data
%endif
go4k_synth_instructions
GO4K_BEGIN_CMDDEF(Instrument0)
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument1)
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument2)
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_ENV_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument3)
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument4)
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_PAN_ID
	db GO4K_DLL_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_FOP_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument5)
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCF_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument6)
	db GO4K_ENV_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument7)
	db GO4K_ENV_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument8)
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument9)
	db GO4K_ENV_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument10)
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument11)
	db GO4K_ENV_ID
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument12)
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument13)
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument14)
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_ENV_ID
	db GO4K_FSTG_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument15)
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Global)
	db GO4K_ACC_ID
	db GO4K_DLL_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_FOP_ID
	db GO4K_ACC_ID
	db GO4K_FOP_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
go4k_synth_instructions_end
%ifdef USE_SECTIONS
section .g4kmuc4 data align=1
%else
section .data
%endif
go4k_synth_parameter_values
GO4K_BEGIN_PARAMDEF(Instrument0)
	GO4K_ENV	ATTAC(0),DECAY(102),SUSTAIN(38),RELEASE(86),GAIN(128)
	GO4K_FST	AMOUNT(103),DEST(9*MAX_WORKSPACE_SLOTS+4)
	GO4K_VCO	TRANSPOSE(23),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(SINE|LFO)
	GO4K_FST	AMOUNT(33),DEST(7*MAX_WORKSPACE_SLOTS+5)
	GO4K_ENV	ATTAC(56),DECAY(128),SUSTAIN(0),RELEASE(103),GAIN(128)
	GO4K_FST	AMOUNT(65),DEST(7*MAX_WORKSPACE_SLOTS+1)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCO	TRANSPOSE(74),DETUNE(64),PHASE(36),GATES(0),COLOR(97),SHAPE(96),GAIN(103),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCF	FREQUENCY(0),RESONANCE(128),VCFTYPE(LOWPASS)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_DLL	PREGAIN(64),DRY(128),FEEDBACK(107),DAMP(64),FREQUENCY(95),DEPTH(24),DELAY(16),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(47), AUXSEND(18)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument1)
	GO4K_ENV	ATTAC(0),DECAY(78),SUSTAIN(52),RELEASE(92),GAIN(128)
	GO4K_FST	AMOUNT(87),DEST(13*MAX_WORKSPACE_SLOTS+4)
	GO4K_FOP	OP(FOP_PUSH)
	GO4K_VCO	TRANSPOSE(76),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(SINE|LFO)
	GO4K_FST	AMOUNT(86),DEST(8*MAX_WORKSPACE_SLOTS+2)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCO	TRANSPOSE(76),DETUNE(63),PHASE(100),GATES(85),COLOR(64),SHAPE(47),GAIN(128),FLAGS(SINE)
	GO4K_VCO	TRANSPOSE(76),DETUNE(64),PHASE(64),GATES(85),COLOR(7),SHAPE(4),GAIN(128),FLAGS(PULSE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(71),GATES(0),COLOR(62),SHAPE(66),GAIN(128),FLAGS(PULSE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(0),RESONANCE(103),VCFTYPE(LOWPASS)
	GO4K_DLL	PREGAIN(64),DRY(128),FEEDBACK(64),DAMP(64),FREQUENCY(95),DEPTH(24),DELAY(16),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(112), AUXSEND(30)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument2)
	GO4K_ENV	ATTAC(0),DECAY(64),SUSTAIN(96),RELEASE(64),GAIN(128)
	GO4K_FST	AMOUNT(128),DEST(0*MAX_WORKSPACE_SLOTS+2)
	GO4K_ENV	ATTAC(0),DECAY(70),SUSTAIN(0),RELEASE(0),GAIN(128)
	GO4K_DST	DRIVE(32), SNHFREQ(128)
	GO4K_FST	AMOUNT(80),DEST(6*MAX_WORKSPACE_SLOTS+1)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(46),DETUNE(64),PHASE(0),GATES(85),COLOR(64),SHAPE(64),GAIN(128),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(107), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument3)
	GO4K_ENV	ATTAC(0),DECAY(71),SUSTAIN(64),RELEASE(90),GAIN(103)
	GO4K_FST	AMOUNT(99),DEST(13*MAX_WORKSPACE_SLOTS+4)
	GO4K_FOP	OP(FOP_PUSH)
	GO4K_VCO	TRANSPOSE(105),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(107),FLAGS(SINE|LFO)
	GO4K_FST	AMOUNT(100),DEST(6*MAX_WORKSPACE_SLOTS+2)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(88),DETUNE(64),PHASE(121),GATES(85),COLOR(102),SHAPE(75),GAIN(94),FLAGS(TRISAW)
	GO4K_VCO	TRANSPOSE(107),DETUNE(68),PHASE(26),GATES(85),COLOR(94),SHAPE(96),GAIN(104),FLAGS(PULSE)
	GO4K_VCO	TRANSPOSE(88),DETUNE(64),PHASE(28),GATES(0),COLOR(121),SHAPE(8),GAIN(107),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(0),RESONANCE(128),VCFTYPE(LOWPASS)
	GO4K_DLL	PREGAIN(71),DRY(128),FEEDBACK(43),DAMP(64),FREQUENCY(89),DEPTH(37),DELAY(17),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(115), AUXSEND(67)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument4)
	GO4K_ENV	ATTAC(45),DECAY(62),SUSTAIN(18),RELEASE(20),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(64),GATES(85),COLOR(64),SHAPE(64),GAIN(128),FLAGS(NOISE)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(128),RESONANCE(128),VCFTYPE(BANDPASS)
	GO4K_PAN	PANNING(64)
	GO4K_DLL	PREGAIN(64),DRY(128),FEEDBACK(96),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(18),COUNT(1)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_DLL	PREGAIN(64),DRY(128),FEEDBACK(64),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(19),COUNT(1)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_OUT	GAIN(32), AUXSEND(15)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument5)
	GO4K_ENV	ATTAC(0),DECAY(85),SUSTAIN(46),RELEASE(89),GAIN(32)
	GO4K_FST	AMOUNT(128),DEST(0*MAX_WORKSPACE_SLOTS+2)
	GO4K_ENV	ATTAC(0),DECAY(45),SUSTAIN(15),RELEASE(62),GAIN(128)
	GO4K_FST	AMOUNT(108),DEST(6*MAX_WORKSPACE_SLOTS+1)
	GO4K_FST	AMOUNT(72),DEST(7*MAX_WORKSPACE_SLOTS+1)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(32),DETUNE(64),PHASE(0),GATES(85),COLOR(64),SHAPE(32),GAIN(64),FLAGS(SINE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(85),COLOR(64),SHAPE(80),GAIN(64),FLAGS(SINE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(85),COLOR(64),SHAPE(10),GAIN(64),FLAGS(NOISE)
	GO4K_VCF	FREQUENCY(52),RESONANCE(128),VCFTYPE(LOWPASS)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(85),COLOR(64),SHAPE(64),GAIN(16),FLAGS(NOISE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(22),RESONANCE(32),VCFTYPE(HIGHPASS)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(32), AUXSEND(3)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument6)
	GO4K_ENV	ATTAC(80),DECAY(0),SUSTAIN(128),RELEASE(85),GAIN(42)
	GO4K_FOP	OP(FOP_PUSH)
	GO4K_VCO	TRANSPOSE(70),DETUNE(64),PHASE(0),GATES(255),COLOR(128),SHAPE(64),GAIN(128),FLAGS(SINE|LFO)
	GO4K_FST	AMOUNT(80),DEST(9*MAX_WORKSPACE_SLOTS+2)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(68),DETUNE(64),PHASE(15),GATES(0),COLOR(72),SHAPE(24),GAIN(57),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(76),DETUNE(62),PHASE(0),GATES(0),COLOR(34),SHAPE(104),GAIN(128),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(83),DETUNE(64),PHASE(87),GATES(0),COLOR(74),SHAPE(26),GAIN(67),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_DLL	PREGAIN(100),DRY(22),FEEDBACK(115),DAMP(39),FREQUENCY(0),DEPTH(0),DELAY(8),COUNT(8)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(38),RESONANCE(58),VCFTYPE(PEAK)
	GO4K_DLL	PREGAIN(95),DRY(128),FEEDBACK(82),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(19),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(15), AUXSEND(7)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument7)
	GO4K_ENV	ATTAC(80),DECAY(0),SUSTAIN(128),RELEASE(85),GAIN(42)
	GO4K_FOP	OP(FOP_PUSH)
	GO4K_VCO	TRANSPOSE(70),DETUNE(64),PHASE(0),GATES(255),COLOR(128),SHAPE(64),GAIN(128),FLAGS(SINE|LFO)
	GO4K_FST	AMOUNT(80),DEST(9*MAX_WORKSPACE_SLOTS+2)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(69),DETUNE(64),PHASE(15),GATES(0),COLOR(72),SHAPE(24),GAIN(71),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(73),DETUNE(62),PHASE(0),GATES(0),COLOR(34),SHAPE(104),GAIN(128),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(78),DETUNE(64),PHASE(87),GATES(0),COLOR(74),SHAPE(26),GAIN(67),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_DLL	PREGAIN(100),DRY(22),FEEDBACK(115),DAMP(39),FREQUENCY(0),DEPTH(0),DELAY(8),COUNT(8)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(38),RESONANCE(58),VCFTYPE(PEAK)
	GO4K_DLL	PREGAIN(95),DRY(128),FEEDBACK(82),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(19),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(15), AUXSEND(7)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument8)
	GO4K_ENV	ATTAC(0),DECAY(79),SUSTAIN(15),RELEASE(94),GAIN(119)
	GO4K_FST	AMOUNT(91),DEST(11*MAX_WORKSPACE_SLOTS+4)
	GO4K_VCO	TRANSPOSE(67),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(SINE|LFO)
	GO4K_FST	AMOUNT(64),DEST(6*MAX_WORKSPACE_SLOTS+2)
	GO4K_VCO	TRANSPOSE(83),DETUNE(64),PHASE(100),GATES(85),COLOR(64),SHAPE(47),GAIN(128),FLAGS(SINE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(64),GATES(85),COLOR(94),SHAPE(96),GAIN(128),FLAGS(PULSE)
	GO4K_VCO	TRANSPOSE(76),DETUNE(64),PHASE(14),GATES(0),COLOR(56),SHAPE(64),GAIN(128),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(0),RESONANCE(103),VCFTYPE(LOWPASS)
	GO4K_DLL	PREGAIN(67),DRY(128),FEEDBACK(89),DAMP(64),FREQUENCY(76),DEPTH(44),DELAY(16),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(69), AUXSEND(39)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument9)
	GO4K_ENV	ATTAC(76),DECAY(125),SUSTAIN(122),RELEASE(85),GAIN(42)
	GO4K_FOP	OP(FOP_PUSH)
	GO4K_VCO	TRANSPOSE(82),DETUNE(64),PHASE(0),GATES(255),COLOR(128),SHAPE(64),GAIN(128),FLAGS(SINE|LFO)
	GO4K_FST	AMOUNT(80),DEST(9*MAX_WORKSPACE_SLOTS+2)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(66),DETUNE(64),PHASE(15),GATES(0),COLOR(72),SHAPE(24),GAIN(57),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(66),DETUNE(62),PHASE(0),GATES(0),COLOR(34),SHAPE(104),GAIN(128),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCO	TRANSPOSE(78),DETUNE(64),PHASE(87),GATES(0),COLOR(74),SHAPE(26),GAIN(67),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_DLL	PREGAIN(99),DRY(126),FEEDBACK(66),DAMP(68),FREQUENCY(77),DEPTH(32),DELAY(8),COUNT(8)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(90),RESONANCE(67),VCFTYPE(PEAK)
	GO4K_DLL	PREGAIN(71),DRY(128),FEEDBACK(78),DAMP(49),FREQUENCY(0),DEPTH(0),DELAY(16),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(38), AUXSEND(7)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument10)
	GO4K_ENV	ATTAC(79),DECAY(94),SUSTAIN(6),RELEASE(94),GAIN(128)
	GO4K_FST	AMOUNT(87),DEST(4*MAX_WORKSPACE_SLOTS+4)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(NOISE)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(46),RESONANCE(55),VCFTYPE(BANDPASS)
	GO4K_DLL	PREGAIN(64),DRY(128),FEEDBACK(106),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(19),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(17), AUXSEND(3)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument11)
	GO4K_ENV	ATTAC(0),DECAY(24),SUSTAIN(0),RELEASE(0),GAIN(128)
	GO4K_ENV	ATTAC(18),DECAY(67),SUSTAIN(0),RELEASE(0),GAIN(128)
	GO4K_FST	AMOUNT(87),DEST(8*MAX_WORKSPACE_SLOTS+4)
	GO4K_FST	AMOUNT(84),DEST(5*MAX_WORKSPACE_SLOTS+5)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(76),DETUNE(64),PHASE(0),GATES(85),COLOR(0),SHAPE(64),GAIN(128),FLAGS(TRISAW)
	GO4K_VCO	TRANSPOSE(88),DETUNE(64),PHASE(0),GATES(85),COLOR(6),SHAPE(64),GAIN(128),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(18),RESONANCE(66),VCFTYPE(LOWPASS)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_DLL	PREGAIN(45),DRY(107),FEEDBACK(75),DAMP(11),FREQUENCY(37),DEPTH(59),DELAY(20),COUNT(1)
	GO4K_DLL	PREGAIN(113),DRY(128),FEEDBACK(93),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(17),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(44), AUXSEND(37)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument12)
	GO4K_ENV	ATTAC(88),DECAY(88),SUSTAIN(88),RELEASE(88),GAIN(88)
	GO4K_VCO	TRANSPOSE(76),DETUNE(64),PHASE(64),GATES(85),COLOR(64),SHAPE(64),GAIN(64),FLAGS(SINE|LFO)
	GO4K_FST	AMOUNT(70),DEST(5*MAX_WORKSPACE_SLOTS+2)
	GO4K_FST	AMOUNT(70),DEST(6*MAX_WORKSPACE_SLOTS+5)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(65),PHASE(64),GATES(85),COLOR(52),SHAPE(64),GAIN(64),FLAGS(TRISAW)
	GO4K_VCO	TRANSPOSE(64),DETUNE(63),PHASE(64),GATES(85),COLOR(52),SHAPE(64),GAIN(64),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_DLL	PREGAIN(78),DRY(128),FEEDBACK(96),DAMP(64),FREQUENCY(76),DEPTH(32),DELAY(19),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(0), AUXSEND(128)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument13)
	GO4K_ENV	ATTAC(0),DECAY(120),SUSTAIN(38),RELEASE(84),GAIN(128)
	GO4K_FST	AMOUNT(107),DEST(10*MAX_WORKSPACE_SLOTS+4)
	GO4K_VCO	TRANSPOSE(82),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(SINE|LFO)
	GO4K_FST	AMOUNT(79),DEST(7*MAX_WORKSPACE_SLOTS+4)
	GO4K_ENV	ATTAC(0),DECAY(95),SUSTAIN(0),RELEASE(84),GAIN(128)
	GO4K_FST	AMOUNT(86),DEST(7*MAX_WORKSPACE_SLOTS+6)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(76),DETUNE(64),PHASE(14),GATES(0),COLOR(109),SHAPE(64),GAIN(128),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(19),RESONANCE(128),VCFTYPE(LOWPASS)
	GO4K_DLL	PREGAIN(73),DRY(128),FEEDBACK(93),DAMP(64),FREQUENCY(95),DEPTH(24),DELAY(16),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(48), AUXSEND(19)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument14)
	GO4K_ENV	ATTAC(0),DECAY(102),SUSTAIN(38),RELEASE(83),GAIN(128)
	GO4K_FST	AMOUNT(107),DEST(10*MAX_WORKSPACE_SLOTS+4)
	GO4K_VCO	TRANSPOSE(83),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(SINE|LFO)
	GO4K_FST	AMOUNT(77),DEST(7*MAX_WORKSPACE_SLOTS+4)
	GO4K_ENV	ATTAC(0),DECAY(99),SUSTAIN(0),RELEASE(84),GAIN(128)
	GO4K_FSTG	AMOUNT(98),DEST(13*go4k_instrument.size*MAX_VOICES+7*MAX_WORKSPACE_SLOTS*4+5*4+go4k_instrument.workspace)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(76),DETUNE(64),PHASE(17),GATES(0),COLOR(125),SHAPE(66),GAIN(77),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(0),RESONANCE(128),VCFTYPE(LOWPASS)
	GO4K_DLL	PREGAIN(64),DRY(128),FEEDBACK(93),DAMP(64),FREQUENCY(95),DEPTH(24),DELAY(16),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(44), AUXSEND(18)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument15)
	GO4K_ENV	ATTAC(0),DECAY(102),SUSTAIN(38),RELEASE(86),GAIN(128)
	GO4K_FST	AMOUNT(107),DEST(9*MAX_WORKSPACE_SLOTS+4)
	GO4K_VCO	TRANSPOSE(83),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(SINE|LFO)
	GO4K_FST	AMOUNT(76),DEST(7*MAX_WORKSPACE_SLOTS+4)
	GO4K_ENV	ATTAC(0),DECAY(128),SUSTAIN(0),RELEASE(95),GAIN(128)
	GO4K_FST	AMOUNT(70),DEST(7*MAX_WORKSPACE_SLOTS+1)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(36),GATES(0),COLOR(115),SHAPE(104),GAIN(103),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCF	FREQUENCY(0),RESONANCE(95),VCFTYPE(LOWPASS)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_DLL	PREGAIN(64),DRY(128),FEEDBACK(93),DAMP(64),FREQUENCY(95),DEPTH(24),DELAY(16),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(53), AUXSEND(18)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Global)
	GO4K_ACC	ACCTYPE(AUX)
	GO4K_DLL	PREGAIN(40),DRY(128),FEEDBACK(125),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(0),COUNT(8)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_DLL	PREGAIN(40),DRY(128),FEEDBACK(125),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(8),COUNT(8)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_ACC	ACCTYPE(OUTPUT)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_OUT	GAIN(64), AUXSEND(0)
GO4K_END_PARAMDEF
go4k_synth_parameter_values_end
%ifdef USE_SECTIONS
section .g4kmuc5 data align=1
%else
section .data
%endif
%ifdef GO4K_USE_DLL
global _go4k_delay_times
_go4k_delay_times
	dw 1116
	dw 1188
	dw 1276
	dw 1356
	dw 1422
	dw 1492
	dw 1556
	dw 1618
	dw 1140
	dw 1212
	dw 1300
	dw 1380
	dw 1446
	dw 1516
	dw 1580
	dw 1642
	dw 33075
	dw 16537
	dw 11025
	dw 22050
	dw 320
%endif
