#define B (0x100)
#define BM (0xff)

static int p[B+B+2];
static VEC4 g3[B+B+2];

#define lacunarity 1.875f
#define H .85f
#define octaves 14
#define offset .75f
#define sharpness 1.4f
#define threshold 4.f
#define Kt .85f

static float exponentarray[octaves];

void __fastcall init_noise()
{
	int i, j, k;
  seed = VOXEL_SEED;
	for (i = 0 ; i < B ; i++)
	{
	    p[i] = i;
      const float fx = efrand();
      const float fy = efrand();
      const float fz = efrand();
      g3[i].Init(fz,fy,fx);
      g3[i].Unit3();
	}

	while ((--i) > 0)
	{
	    j = erand() & BM;
	    k = p[i];
	    p[i] = p[j];
	    p[j] = k;
	}

	for (i = 0 ; i < B + 2 ; i++)
	{
	    p[B + i] = p[i];
      g3[B + i] = g3[i];
	}

  for (int i = 0; i < octaves; ++i)
  {
    exponentarray[i] = epow(lacunarity,(-i*H));
  }
}

float __fastcall noise3(VEC4 vec)
{
	int bx0, bx1, by0, by1, bz0, bz1, b00, b10, b01, b11;
	float rx0, rx1, ry0, ry1, rz0, rz1, sy, sz, a, b, c, d, t, u, v;
	int i, j;
  VEC4 q;

	/* setup(0, bx0,bx1, rx0,rx1) */
	t = vec.x;
	bx0 = efloor(t);
	bx1 = bx0+1;
	rx0 = t - (float)bx0;
	rx1 = rx0 - 1.f;
	/***/
	/* setup(1, by0,by1, ry0,ry1) */
	t = vec.y;
	by0 = efloor(t);
	by1 = by0+1;
	ry0 = t - (float)by0;
	ry1 = ry0 - 1.f;
	/***/
	/* setup(2, bz0,bz1, rz0,rz1) */
	t = vec.z;
	bz0 = efloor(t);
	bz1 = bz0+1;
	rz0 = t - (float)bz0;
	rz1 = rz0 - 1.f;
	/***/
  bx0 &= BM;
  bx1 &= BM;
  by0 &= BM;
  by1 &= BM;
  bz0 &= BM;
  bz1 &= BM;

	i = p[ bx0 ];
	j = p[ bx1 ];

	b00 = p[ i + by0 ];
	b10 = p[ j + by0 ];
	b01 = p[ i + by1 ];
	b11 = p[ j + by1 ];

	t  = esmoothstep(rx0);
	sy = esmoothstep(ry0);
	sz = esmoothstep(rz0);
    
	q = g3[ b00 + bz0 ] ; u = ( rx0 * q.x + ry0 * q.y + rz0 * q.z );
	q = g3[ b10 + bz0 ] ; v = ( rx1 * q.x + ry0 * q.y + rz0 * q.z );
	a = elerp(u, v,t);

	q = g3[ b01 + bz0 ] ; u = ( rx0 * q.x + ry1 * q.y + rz0 * q.z );
	q = g3[ b11 + bz0 ] ; v = ( rx1 * q.x + ry1 * q.y + rz0 * q.z );
	b = elerp(u, v,t);

	c = elerp(a, b,sy);

	q = g3[ b00 + bz1 ] ; u = ( rx0 * q.x + ry0 * q.y + rz1 * q.z );
	q = g3[ b10 + bz1 ] ; v = ( rx1 * q.x + ry0 * q.y + rz1 * q.z );
	a = elerp(u, v,t);

	q = g3[ b01 + bz1 ] ; u = ( rx0 * q.x + ry1 * q.y + rz1 * q.z );
	q = g3[ b11 + bz1 ] ; v = ( rx1 * q.x + ry1 * q.y + rz1 * q.z );
	b = elerp(u, v,t);

	d = elerp(a, b,sy);

	return elerp(c, d,sz);
}

#define snoise(x) (2.5f*(noise3(x)-0.5f))
float RMFractal(VEC4 PP)
{
  float result, signal, weight;
  signal = epow(efabs(offset-efabs(snoise(PP))),sharpness);
  result = signal;
	for(int i=1;i<octaves;i++) 
  {
    PP.x *= lacunarity;
    PP.y *= lacunarity;
    PP.z *= lacunarity;
    weight = signal * threshold;
    if (weight<0) weight=0;
    if (weight>1) weight=1;
   	signal = epow(efabs(offset-efabs(snoise(PP))),sharpness)*weight;
   	result += signal*exponentarray[i];
	}
  return 1.f-result*Kt;
}
