/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import javax.swing.JFrame;

public class Daleks4k
extends JFrame {
    Font scoreFont = new Font("Helvetica", 1, 15);
    Font gameOverFont = new Font("Helvetica", 0, 50);
    Font infoFont = new Font("Helvetica", 0, 30);
    private int level;
    public int count = 2000;
    private int zaps;
    private int score;
    private boolean gameOver;
    private boolean nextLevel;
    private boolean intro;
    private final int GRIDSIZE = 21;
    private final int EMPTY = 0;
    private final int MONSTER = 1;
    private final int MAN = 2;
    private final int CRASH = 3;
    Image[] images = new Image[4];
    int x;
    int y;
    Point playerloc;
    int[][] grid;

    public Point getFreeSpot() {
        int n;
        int n2;
        while (this.grid[n2 = (int)(Math.random() * 21.0)][n = (int)(Math.random() * 21.0)] != 0) {
        }
        return new Point(n2, n);
    }

    public void nextLevel() {
        this.nextLevel = true;
        ++this.level;
        if (this.level % 5 == 0) {
            this.zaps = this.level;
        }
        if (this.zaps < this.level) {
            ++this.zaps;
        }
        this.initLevel();
    }

    public void zap() {
        if (this.zaps == 0) {
            return;
        }
        --this.zaps;
        this.x = -1;
        while (this.x <= 1) {
            this.y = -1;
            while (this.y <= 1) {
                if (this.x + this.playerloc.x >= 0 && this.y + this.playerloc.y >= 0 && this.x + this.playerloc.x < 21 && this.y + this.playerloc.y < 21 && this.grid[this.x + this.playerloc.x][this.y + this.playerloc.y] == 1) {
                    this.grid[this.x + this.playerloc.x][this.y + this.playerloc.y] = 0;
                }
                ++this.y;
            }
            ++this.x;
        }
        this.makeMove(0, 0);
    }

    public void makeMove(int n, int n2) {
        if (this.count > 500) {
            this.count -= (this.count - 500) / 15;
        }
        Point point = new Point(this.playerloc.x + n, this.playerloc.y + n2);
        if (point.x < 0 || point.y < 0 || point.x >= 21 || point.y >= 21 || this.grid[point.x][point.y] == 3) {
            return;
        }
        int[][] nArray = new int[21][21];
        int n3 = 0;
        this.y = 0;
        while (this.y < 21) {
            this.x = 0;
            while (this.x < 21) {
                int n4 = nArray[this.x][this.y] = this.grid[this.x][this.y] == 3 ? 3 : 0;
                if (this.grid[this.x][this.y] == 1) {
                    ++n3;
                }
                ++this.x;
            }
            ++this.y;
        }
        nArray[point.x][point.y] = 2;
        this.playerloc = point;
        int n5 = 0;
        this.y = 0;
        while (this.y < 21) {
            this.x = 0;
            while (this.x < 21) {
                if (this.grid[this.x][this.y] == 1) {
                    int n6 = 0;
                    int n7 = 0;
                    if (this.x < point.x) {
                        n6 = 1;
                    }
                    if (this.x > point.x) {
                        n6 = -1;
                    }
                    if (this.y < point.y) {
                        n7 = 1;
                    }
                    if (this.y > point.y) {
                        n7 = -1;
                    }
                    switch (nArray[this.x + n6][this.y + n7]) {
                        case 2: {
                            nArray[this.x + n6][this.y + n7] = 2;
                            this.gameOver = true;
                            break;
                        }
                        case 1: {
                            nArray[this.x + n6][this.y + n7] = 3;
                            --n5;
                            break;
                        }
                        case 0: {
                            nArray[this.x + n6][this.y + n7] = 1;
                            ++n5;
                        }
                    }
                }
                ++this.x;
            }
            ++this.y;
        }
        this.grid = nArray;
        if (this.gameOver) {
            return;
        }
        this.score += n3 - n5;
        if (n5 == 0) {
            this.nextLevel();
            return;
        }
        this.repaint();
    }

    public void initLevel() {
        this.y = 0;
        while (this.y < 21) {
            this.x = 0;
            while (this.x < 21) {
                this.grid[this.x][this.y] = 0;
                ++this.x;
            }
            ++this.y;
        }
        this.x = 0;
        while (this.x < this.level * 5) {
            Point point = this.getFreeSpot();
            this.grid[point.x][point.y] = 1;
            ++this.x;
        }
        this.playerloc = this.getFreeSpot();
        this.grid[this.playerloc.x][this.playerloc.y] = 2;
        this.count = 2000;
        this.repaint();
    }

    public void resetGame() {
        this.grid = new int[21][21];
        this.score = 0;
        this.level = 1;
        this.zaps = 2;
        this.gameOver = false;
        this.nextLevel = true;
        this.initLevel();
    }

    public Daleks4k() {
        this.images[2] = Toolkit.getDefaultToolkit().getImage("rob.gif");
        this.images[1] = Toolkit.getDefaultToolkit().getImage("monster.gif");
        this.images[3] = Toolkit.getDefaultToolkit().getImage("crash.gif");
        this.intro = true;
        this.resetGame();
        this.setTitle("Daleks4k");
        this.setSize(new Dimension(430, 447));
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 402) {
            if (this.intro) {
                this.intro = false;
                this.repaint();
                return;
            }
            if (this.nextLevel) {
                this.nextLevel = false;
                this.repaint();
                return;
            }
            if (this.gameOver) {
                this.resetGame();
            }
            switch (((KeyEvent)aWTEvent).getKeyCode()) {
                case 27: {
                    System.exit(0);
                }
                case 103: {
                    this.makeMove(-1, -1);
                    break;
                }
                case 104: {
                    this.makeMove(0, -1);
                    break;
                }
                case 105: {
                    this.makeMove(1, -1);
                    break;
                }
                case 100: {
                    this.makeMove(-1, 0);
                    break;
                }
                case 102: {
                    this.makeMove(1, 0);
                    break;
                }
                case 97: {
                    this.makeMove(-1, 1);
                    break;
                }
                case 98: {
                    this.makeMove(0, 1);
                    break;
                }
                case 99: {
                    this.makeMove(1, 1);
                    break;
                }
                case 101: {
                    this.makeMove(0, 0);
                    break;
                }
                case 110: {
                    this.zap();
                    break;
                }
                case 96: {
                    Point point = this.getFreeSpot();
                    this.makeMove(point.x - this.playerloc.x, point.y - this.playerloc.y);
                }
            }
            this.invalidate();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(new Color(0, 0, 0));
        graphics.fillRect(0, 0, 500, 500);
        if (this.intro) {
            int n = 50;
            graphics.setColor(Color.WHITE);
            graphics.setFont(this.infoFont);
            graphics.drawString("Welcome to Daleks4k!!", 20, n);
            n += 50;
            return;
        }
        if (this.nextLevel) {
            graphics.setFont(this.gameOverFont);
            graphics.setColor(Color.RED);
            graphics.drawString("LEVEL: " + this.level, 92, 242);
            graphics.setColor(Color.WHITE);
            graphics.drawString("LEVEL: " + this.level, 94, 244);
            graphics.setFont(this.infoFont);
            graphics.setColor(Color.WHITE);
            graphics.drawString("Score: " + this.score, 94, 312);
            graphics.drawString("Zaps : " + this.zaps, 94, 344);
            return;
        }
        Insets insets = this.getInsets();
        this.y = 0;
        while (this.y < 21) {
            this.x = 0;
            while (this.x < 21) {
                int n = this.x * 20 + insets.left + 1;
                int n2 = this.y * 20 + insets.top + 1;
                if (this.grid[this.x][this.y] == 2 && this.gameOver) {
                    graphics.setColor(Color.BLACK);
                    graphics.fillRect(n, n2, 18, 18);
                    graphics.setColor(Color.WHITE);
                    graphics.drawRect(n, n2, 18, 18);
                    graphics.drawLine(n, n2, n + 18, n2 + 18);
                    graphics.drawLine(n + 18, n2, n, n2 + 18);
                } else if (this.grid[this.x][this.y] != 0) {
                    graphics.drawImage(this.images[this.grid[this.x][this.y]], n, n2, 18, 18, this);
                }
                ++this.x;
            }
            ++this.y;
        }
        if (this.gameOver) {
            graphics.setFont(this.gameOverFont);
            graphics.setColor(Color.RED);
            graphics.drawString("GAME OVER", 64, 244);
            graphics.setColor(Color.BLACK);
            graphics.drawString("GAME OVER", 66, 246);
        }
        graphics.setColor(Color.GREEN);
        graphics.setFont(this.scoreFont);
        graphics.drawString("Score: " + this.score, 10, 400);
        graphics.drawString("Zaps : " + this.zaps, 10, 420);
    }

    public static void main(String[] stringArray) throws Throwable {
        Daleks4k daleks4k = new Daleks4k();
        daleks4k.setVisible(true);
        while (true) {
            Thread.sleep(daleks4k.count);
            daleks4k.repaint();
        }
    }
}

