/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Designer
extends JFrame
implements ActionListener,
ListSelectionListener {
    private byte[][] map;
    private byte[][] links;
    private Level[] levels = new Level[50];
    private int currentLevel = 0;
    private BufferedImage[] tiles = new BufferedImage[10];
    private String[] tips = new String[10];
    private MapPanel mapPanel = new MapPanel();
    private JToggleButton[] buttons = new JToggleButton[10];
    private ButtonGroup group = new ButtonGroup();
    private JButton clear = new JButton("Clear");
    private JButton load = new JButton("Load");
    private JButton save = new JButton("Save");
    private JButton imp = new JButton("Import");
    private JButton exp = new JButton("Export");
    private JButton next = new JButton("Next");
    private JButton prev = new JButton("Prev");
    private int sx;
    private int sy;
    private boolean firstStep = true;
    private DefaultListModel linksModel = new DefaultListModel();
    private JList linksList = new JList(this.linksModel);
    private JButton remove = new JButton("Remove");

    public Designer() {
        super("Nebulus");
        this.drawTiles();
        int n = 0;
        while (n < this.levels.length) {
            this.levels[n] = new Level();
            ++n;
        }
        this.linksList.addListSelectionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        JScrollPane jScrollPane = new JScrollPane(this.mapPanel);
        jScrollPane.setBounds(5, 5, 420, 400);
        jPanel.add(jScrollPane);
        int n2 = 0;
        while (n2 < this.buttons.length) {
            this.buttons[n2] = new JToggleButton();
            if (this.tiles[n2] != null) {
                this.buttons[n2].setIcon(new ImageIcon(this.tiles[n2]));
                this.buttons[n2].setToolTipText(this.tips[n2]);
            }
            this.buttons[n2].setBounds(450 + n2 % 7 * 35, 5 + n2 / 7 * 35, 30, 30);
            jPanel.add(this.buttons[n2]);
            this.group.add(this.buttons[n2]);
            ++n2;
        }
        JLabel jLabel = new JLabel("Right Button to Provide Door Links");
        jLabel.setBounds(10, 410, 300, 30);
        jPanel.add(jLabel);
        this.buttons[0].setSelected(true);
        this.clear.setBounds(450, 150, 100, 30);
        jPanel.add(this.clear);
        this.clear.addActionListener(this);
        this.load.setBounds(450, 180, 100, 30);
        jPanel.add(this.load);
        this.load.addActionListener(this);
        this.save.setBounds(450, 210, 100, 30);
        jPanel.add(this.save);
        this.save.addActionListener(this);
        this.imp.setBounds(550, 180, 100, 30);
        jPanel.add(this.imp);
        this.imp.addActionListener(this);
        this.exp.setBounds(550, 210, 100, 30);
        jPanel.add(this.exp);
        this.exp.addActionListener(this);
        this.next.setBounds(670, 180, 100, 30);
        jPanel.add(this.next);
        this.next.addActionListener(this);
        this.prev.setBounds(670, 210, 100, 30);
        jPanel.add(this.prev);
        this.prev.addActionListener(this);
        jScrollPane = new JScrollPane(this.linksList);
        jScrollPane.setBounds(450, 250, 200, 150);
        jPanel.add(jScrollPane);
        this.remove.setBounds(450, 400, 100, 30);
        this.remove.addActionListener(this);
        jPanel.add(this.remove);
        this.selectLevel(0);
        this.setDefaultCloseOperation(3);
        this.setContentPane(jPanel);
        this.setSize(800, 500);
        this.setResizable(false);
        this.setVisible(true);
    }

    public int getSelected() {
        int n = 0;
        while (n < 10) {
            if (this.buttons[n].isSelected()) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private void drawTiles() {
        this.tiles[0] = new BufferedImage(20, 20, 2);
        Graphics graphics = this.tiles[0].getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 20, 20);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(0, 0, 20, 0);
        graphics.drawLine(0, 0, 0, 20);
        this.tips[0] = "Empty Block";
        this.tiles[1] = new BufferedImage(20, 20, 2);
        graphics = this.tiles[1].getGraphics();
        graphics.drawImage(this.tiles[0], 0, 0, null);
        graphics.setColor(Color.blue);
        graphics.fillRect(0, 15, 20, 5);
        this.tips[1] = "Plain Block - Floor";
        this.tiles[2] = new BufferedImage(20, 20, 2);
        graphics = this.tiles[2].getGraphics();
        graphics.drawImage(this.tiles[1], 0, 0, null);
        graphics.setColor(Color.yellow);
        graphics.fillRect(0, 15, 20, 2);
        this.tips[2] = "Teleport pad - up and down";
        this.tiles[3] = new BufferedImage(20, 20, 2);
        graphics = this.tiles[3].getGraphics();
        graphics.drawImage(this.tiles[1], 0, 0, null);
        graphics.setColor(Color.white);
        graphics.drawRect(0, 15, 19, 4);
        this.tips[3] = "Fall Through Block - step on it, it disappears";
        this.tiles[4] = new BufferedImage(20, 20, 2);
        graphics = this.tiles[4].getGraphics();
        graphics.drawImage(this.tiles[1], 0, 0, null);
        graphics.setColor(Color.gray);
        graphics.fillRect(3, 0, 15, 15);
        this.tips[4] = "Door - must be linked using the right button";
        this.tiles[5] = new BufferedImage(20, 20, 2);
        graphics = this.tiles[5].getGraphics();
        graphics.drawImage(this.tiles[1], 0, 0, null);
        graphics.setColor(Color.yellow);
        graphics.fillOval(3, 0, 15, 12);
        this.tips[5] = "Coin - 1000 points";
        this.tiles[6] = new BufferedImage(20, 20, 2);
        graphics = this.tiles[6].getGraphics();
        graphics.drawImage(this.tiles[1], 0, 0, null);
        graphics.setColor(Color.darkGray);
        graphics.fillRect(0, 15, 20, 2);
        graphics.setColor(Color.white);
        graphics.fillRect(10, 15, 10, 2);
        this.tips[6] = "End Point, step on to finish the level";
        this.tiles[7] = new BufferedImage(20, 20, 2);
        graphics = this.tiles[7].getGraphics();
        graphics.drawImage(this.tiles[1], 0, 0, null);
        graphics.setColor(Color.red);
        graphics.fillRect(3, 0, 15, 15);
        this.tips[7] = "Evil red square - bad guy that floats back and forth";
        this.tiles[8] = new BufferedImage(20, 20, 2);
        graphics = this.tiles[8].getGraphics();
        graphics.drawImage(this.tiles[1], 0, 0, null);
        graphics.setColor(Color.cyan);
        graphics.fillOval(3, 0, 15, 12);
        this.tips[8] = "Cyan Key - opens cyan barriers";
        this.tiles[9] = new BufferedImage(20, 20, 2);
        graphics = this.tiles[9].getGraphics();
        graphics.drawImage(this.tiles[1], 0, 0, null);
        graphics.setColor(Color.cyan);
        graphics.fillRect(5, 0, 13, 15);
        this.tips[9] = "Cyan Barrier - blocks movement until unlocked with a key";
    }

    public void addLink(int n, int n2, int n3, int n4) {
        this.links[this.getLinkCount()][0] = (byte)n;
        this.links[this.getLinkCount()][1] = (byte)n2;
        this.links[this.getLinkCount()][2] = (byte)n3;
        this.links[this.getLinkCount()][3] = (byte)n4;
        this.linksModel.addElement(String.valueOf(n) + "," + n2 + " -> " + n3 + "," + n4);
        this.setLinkCount(this.getLinkCount() + 1);
    }

    public void removeSelectedLink() {
        int n = this.linksList.getSelectedIndex();
        if (n >= 0) {
            int n2 = n;
            while (n2 < this.getLinkCount() - 1) {
                this.links[n2][0] = this.links[n2 + 1][0];
                this.links[n2][1] = this.links[n2 + 1][1];
                this.links[n2][2] = this.links[n2 + 1][2];
                this.links[n2][3] = this.links[n2 + 1][3];
                ++n2;
            }
            this.linksModel.remove(n);
            this.setLinkCount(this.getLinkCount() - 1);
        }
    }

    public static void main(String[] stringArray) {
        new Designer();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser;
        int n;
        int n2;
        JFileChooser jFileChooser2;
        int n3;
        int n4;
        int n5;
        File file;
        int n6;
        if (actionEvent.getSource() == this.clear) {
            this.levels[this.currentLevel].used = false;
            int n7 = 0;
            while (n7 < 20) {
                n6 = 0;
                while (n6 < 50) {
                    this.map[n7][n6] = 0;
                    ++n6;
                }
                ++n7;
            }
            this.linksModel.clear();
            this.setLinkCount(0);
            this.mapPanel.repaint(0L);
        }
        if (actionEvent.getSource() == this.prev && this.currentLevel > 0) {
            this.selectLevel(this.currentLevel - 1);
        }
        if (actionEvent.getSource() == this.next && this.currentLevel < this.levels.length - 1) {
            this.selectLevel(this.currentLevel + 1);
        }
        if (actionEvent.getSource() == this.imp) {
            JFileChooser jFileChooser3 = new JFileChooser(".");
            n6 = jFileChooser3.showOpenDialog(this);
            if (n6 == 0) {
                this.linksModel.clear();
                file = jFileChooser3.getSelectedFile();
                this.levels[this.currentLevel].used = true;
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    n5 = 0;
                    while (n5 < 50) {
                        n4 = 0;
                        while (n4 < 20) {
                            n3 = ((InputStream)fileInputStream).read();
                            this.map[n4][n5] = (byte)(n3 & 0xF);
                            this.map[n4 + 1][n5] = (byte)((n3 & 0xF0) >> 4);
                            n4 += 2;
                        }
                        ++n5;
                    }
                    this.setLinkCount(((InputStream)fileInputStream).read());
                    n5 = 0;
                    while (n5 < this.getLinkCount()) {
                        ((InputStream)fileInputStream).read(this.links[n5]);
                        ++n5;
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, exception.getMessage());
                }
                int n8 = 0;
                while (n8 < this.getLinkCount()) {
                    this.linksModel.addElement(String.valueOf(this.links[n8][0]) + "," + this.links[n8][1] + " -> " + this.links[n8][2] + "," + this.links[n8][3]);
                    ++n8;
                }
            }
            this.mapPanel.repaint(0L);
        }
        if (actionEvent.getSource() == this.exp && (n6 = (jFileChooser2 = new JFileChooser(".")).showSaveDialog(this)) == 0) {
            file = jFileChooser2.getSelectedFile();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                n5 = 0;
                while (n5 < 50) {
                    n4 = 0;
                    while (n4 < 20) {
                        n3 = (byte)(this.map[n4][n5] + (this.map[n4 + 1][n5] << 4));
                        fileOutputStream.write(n3);
                        n4 += 2;
                    }
                    ++n5;
                }
                fileOutputStream.write((byte)this.getLinkCount());
                n5 = 0;
                while (n5 < this.getLinkCount()) {
                    fileOutputStream.write(this.links[n5]);
                    ++n5;
                }
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage());
            }
        }
        if (actionEvent.getSource() == this.load) {
            JFileChooser jFileChooser4 = new JFileChooser(".");
            n6 = jFileChooser4.showOpenDialog(this);
            if (n6 == 0) {
                this.linksModel.clear();
                file = jFileChooser4.getSelectedFile();
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    n5 = ((InputStream)fileInputStream).read();
                    n4 = 0;
                    while (n4 < n5) {
                        this.selectLevel(n4);
                        this.levels[this.currentLevel].used = true;
                        n3 = 0;
                        while (n3 < 50) {
                            if ((n3 += ((InputStream)fileInputStream).read()) < 50) {
                                n2 = 0;
                                while (n2 < 20) {
                                    n = ((InputStream)fileInputStream).read();
                                    this.map[n2][n3] = (byte)(n & 0xF);
                                    this.map[n2 + 1][n3] = (byte)((n & 0xF0) >> 4);
                                    n2 += 2;
                                }
                            }
                            ++n3;
                        }
                        this.setLinkCount(((InputStream)fileInputStream).read());
                        n3 = 0;
                        while (n3 < this.getLinkCount()) {
                            ((InputStream)fileInputStream).read(this.links[n3]);
                            ++n3;
                        }
                        ++n4;
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, exception.getMessage());
                }
                this.selectLevel(0);
            }
            this.mapPanel.repaint(0L);
        }
        if (actionEvent.getSource() == this.save && (n6 = (jFileChooser = new JFileChooser(".")).showSaveDialog(this)) == 0) {
            file = jFileChooser.getSelectedFile();
            try {
                int n9 = 0;
                n5 = 0;
                while (n5 < this.levels.length) {
                    if (this.levels[n5].used) {
                        ++n9;
                    }
                    ++n5;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write((byte)n9);
                n4 = 0;
                while (n4 < this.levels.length) {
                    if (this.levels[n4].used) {
                        this.selectLevel(n4);
                        n3 = 0;
                        while (n3 < 50) {
                            int n10;
                            n2 = 0;
                            n = 0;
                            while (n == 0) {
                                n10 = 0;
                                while (n10 < 20) {
                                    if (this.map[n10][n3] != 0) {
                                        n = 1;
                                    }
                                    ++n10;
                                }
                                if (n != 0) continue;
                                ++n2;
                                if (++n3 > 49) break;
                            }
                            fileOutputStream.write(n2);
                            if (n != 0) {
                                n10 = 0;
                                while (n10 < 20) {
                                    byte by = (byte)(this.map[n10][n3] + (this.map[n10 + 1][n3] << 4));
                                    fileOutputStream.write(by);
                                    n10 += 2;
                                }
                            }
                            ++n3;
                        }
                        fileOutputStream.write((byte)this.getLinkCount());
                        n3 = 0;
                        while (n3 < this.getLinkCount()) {
                            fileOutputStream.write(this.links[n3]);
                            ++n3;
                        }
                    }
                    ++n4;
                }
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage());
            }
        }
        if (actionEvent.getSource() == this.remove) {
            this.removeSelectedLink();
        }
    }

    public void setLinkCount(int n) {
        this.levels[this.currentLevel].linkCount = n;
    }

    public int getLinkCount() {
        return this.levels[this.currentLevel].linkCount;
    }

    public void selectLevel(int n) {
        this.currentLevel = n;
        this.setTitle("Nebulus - Level " + (n + 1));
        this.map = this.levels[n].map;
        this.links = this.levels[n].links;
        this.linksModel.clear();
        int n2 = 0;
        while (n2 < this.getLinkCount()) {
            this.linksModel.addElement(String.valueOf(this.links[n2][0]) + "," + this.links[n2][1] + " -> " + this.links[n2][2] + "," + this.links[n2][3]);
            ++n2;
        }
        this.mapPanel.repaint(0L);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.mapPanel.repaint(0L);
    }

    public class MapPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 1L;

        public MapPanel() {
            this.setSize(400, 1000);
            this.setPreferredSize(new Dimension(400, 1000));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void paint(Graphics graphics) {
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, 500, 1000);
            int n2 = 0;
            while (n2 < 20) {
                n = 0;
                while (n < 50) {
                    graphics2D.drawImage((Image)Designer.this.tiles[Designer.this.map[n2][n]], n2 * 20, 980 - n * 20, null);
                    ++n;
                }
                ++n2;
            }
            graphics2D.setStroke(new BasicStroke(2.0f));
            n2 = 0;
            while (n2 < Designer.this.getLinkCount()) {
                graphics2D.setColor(Color.green);
                if (Designer.this.linksList.getSelectedIndex() == n2) {
                    graphics2D.setColor(Color.yellow);
                }
                n = Designer.this.links[n2][0] * 20 + 10;
                int n3 = 990 - Designer.this.links[n2][1] * 20;
                int n4 = Designer.this.links[n2][2] * 20 + 10;
                int n5 = 990 - Designer.this.links[n2][3] * 20;
                graphics2D.drawLine(n, n3, n4, n5);
                ++n2;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ((Designer)Designer.this).levels[((Designer)Designer.this).currentLevel].used = true;
            int n = mouseEvent.getX() / 20;
            int n2 = (1000 - mouseEvent.getY()) / 20;
            if (mouseEvent.getButton() == 1) {
                ((Designer)Designer.this).map[n][n2] = (byte)Designer.this.getSelected();
                this.repaint(0L);
            } else if (Designer.this.firstStep) {
                Designer.this.sx = n;
                Designer.this.sy = n2;
                Designer.this.firstStep = false;
            } else {
                Designer.this.addLink(Designer.this.sx, Designer.this.sy, n, n2);
                Designer.this.firstStep = true;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ((Designer)Designer.this).levels[((Designer)Designer.this).currentLevel].used = true;
            int n = mouseEvent.getX() / 20;
            int n2 = (1000 - mouseEvent.getY()) / 20;
            this.repaint(0L);
            ((Designer)Designer.this).map[n][n2] = (byte)Designer.this.getSelected();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class Level {
        public byte[][] map = new byte[20][50];
        public byte[][] links = new byte[100][4];
        public int linkCount;
        public boolean used = false;

        Level() {
        }
    }
}

