/*
 * Decompiled with CFR 0.152.
 */
package heartbeat.landboom;

import heartbeat.Camera;
import heartbeat.Col;
import heartbeat.Effect;
import heartbeat.Matrix;
import heartbeat.Mesh;
import heartbeat.RenderPipeline;
import heartbeat.SingleTriRotator;
import heartbeat.SoundListener;
import heartbeat.Texture;
import heartbeat.Vec;
import heartbeat.landboom.BloodRotator;
import heartbeat.landboom.Clover;
import heartbeat.landboom.GreetingsText;
import heartbeat.landboom.Heart;
import heartbeat.landboom.SeaMesh;
import java.util.Enumeration;
import java.util.Hashtable;

public class CustomEffect
extends Effect
implements SoundListener {
    private static final int CLOVER_TIME = 500;
    private static final int CLOVER_LEAVETIME = 80;
    private static final int HEART_TIME = 500;
    private static final int HEARTFLASH_TIME = 2;
    private static final int EXPLOSION_TIME = 820;
    private static final int END_TIME = 80;
    private static final int HEARTPULSE_WAIT = 10;
    private static final int HEARTPULSE_RISE = 3;
    private static final int HEARTPULSE_FALL = 3;
    private Camera myCam;
    private Vec myFocus;
    private Texture myLightTexture;
    private Texture myHeartTexture;
    private Texture myBumpTexture;
    private Mesh mySeaMesh;
    private Hashtable myCloverMesh;
    private Hashtable myHeartMesh;
    private SingleTriRotator myBloodRotator;
    private GreetingsText myGreetings;
    private float myCamAng;
    private float myStarAng;
    private float myStarPosAng;
    private float myStarRadAng;
    private int myStatus;
    private int myTimeLeft;
    private float myBaseHeight;
    private float myRotatorAng;
    private Vec myCloverPos;
    private Vec myHeartPos;
    private float myHeartScale;
    private int myHeartPulseMode;
    private int myHeartPulseWait;

    public void soundPlayed() {
        this.myHeartScale = 1.0f;
        this.myHeartPulseMode = 1;
        this.myHeartPulseWait = 3;
    }

    private Texture makeLightTexture(int col) {
        Texture texture = new Texture();
        int w = texture.width;
        int h = texture.height;
        int[] tex = texture.getData();
        int idx = 0;
        float reqDist = (float)Math.sqrt(w / 2 * (w / 2) + h / 2 * (h / 2));
        float r = Col.getR(col);
        float g = Col.getG(col);
        float b = Col.getB(col);
        int y = 0;
        while (y < w) {
            int x = 0;
            while (x < w) {
                float dx = x - w / 2;
                float dy = y - h / 2;
                float dist = (float)Math.sqrt(dx * dx + dy * dy);
                if (!(dist > reqDist)) {
                    float intensity = dist / reqDist;
                    float invInt = 1.0f - intensity;
                    int newR = (int)((double)(r * invInt) + 235.0 * (double)intensity);
                    int newG = (int)((double)(g * invInt) + 225.0 * (double)intensity);
                    int newB = (int)((double)(b * invInt) + 245.0 * (double)intensity);
                    tex[idx] = Col.make(newR, newG, newB);
                }
                ++x;
                ++idx;
            }
            ++y;
        }
        return texture;
    }

    private void renderStar(float x, float y, float radiusAdvance) {
        float rad = 30.0f + (float)Math.sin((double)(this.myStarRadAng + radiusAdvance) * Math.PI / 180.0) * 20.0f;
        this.renderStarTri(x, y, (float)((double)this.myStarAng), rad);
        this.renderStarTri(x, y, (float)((double)this.myStarAng + 180.0), rad);
        this.renderStarTri(x, y, (float)((double)this.myStarAng + 20.0), rad);
        this.renderStarTri(x, y, (float)((double)this.myStarAng + 200.0), rad);
    }

    private void renderSea(RenderPipeline pipe, Matrix camMat, Matrix camRotMat) {
        pipe.resetMode();
        pipe.setZSort(false);
        pipe.setRenderMode(22);
        pipe.setMatrix(camMat);
        pipe.setNormalMatrix(camRotMat);
        pipe.render(this.mySeaMesh);
    }

    public void deInit() {
        this.mySound.setCallback(null);
    }

    private void renderStarTri(float x, float y, float ang, float rad) {
        int[] xl = new int[3];
        int[] yl = new int[3];
        xl[0] = (int)((double)x + Math.cos((double)ang * Math.PI / 180.0) * (double)rad);
        yl[0] = (int)((double)y + Math.sin((double)ang * Math.PI / 180.0) * (double)rad);
        xl[1] = (int)((double)x + Math.cos(((double)ang + 120.0) * Math.PI / 180.0) * (double)rad);
        yl[1] = (int)((double)y + Math.sin(((double)ang + 120.0) * Math.PI / 180.0) * (double)rad);
        xl[2] = (int)((double)x + Math.cos(((double)ang + 240.0) * Math.PI / 180.0) * (double)rad);
        yl[2] = (int)((double)y + Math.sin(((double)ang + 240.0) * Math.PI / 180.0) * (double)rad);
        this.myScreen.drawAddTriangle(xl, yl, Col.make(10, 30, 5));
    }

    public void render() {
        RenderPipeline pipe = new RenderPipeline(this.myScreen);
        this.myScreen.clear(Col.BLACK);
        Matrix camMat = this.myCam.getMatrix();
        Matrix camRotMat = this.myCam.getRotationMatrix();
        int round = 2;
        while (round-- > 0) {
            boolean mirror = round == 1;
            switch (this.myStatus) {
                case 0: 
                case 1: {
                    this.setupRenderer(pipe, camMat, camRotMat, this.myCloverPos, new Vec(1.0f, 1.0f, 1.0f), mirror);
                    pipe.render(this.myCloverMesh);
                    break;
                }
                case 2: {
                    this.setupRenderer(pipe, camMat, camRotMat, this.myHeartPos, new Vec(this.myHeartScale, this.myHeartScale, this.myHeartScale), mirror);
                    pipe.setRenderMode(24);
                    pipe.render(this.myHeartMesh);
                    break;
                }
                case 3: {
                    this.setupRenderer(pipe, camMat, camRotMat, this.myHeartPos, new Vec(this.myHeartScale, this.myHeartScale, this.myHeartScale), mirror);
                    pipe.setColorMode(0);
                    pipe.setRenderMode(20);
                    pipe.render(this.myHeartMesh);
                    break;
                }
                default: {
                    this.setupRenderer(pipe, camMat.multiply(Matrix.rotateY(this.myRotatorAng)), camRotMat, new Vec(), new Vec(1.0f, 1.0f, 1.0f), mirror);
                    pipe.setColorMode(0);
                    pipe.setRenderMode(21);
                    pipe.render(this.myBloodRotator);
                    break;
                }
            }
            if (round != 1) continue;
            this.renderSea(pipe, camMat, camRotMat);
        }
        float x = (float)Math.cos((double)this.myStarPosAng * Math.PI / 180.0) * 60.0f;
        float y = (float)Math.sin((double)this.myStarPosAng * Math.PI / 180.0) * 60.0f;
        this.renderStar(x, y, 0.0f);
        this.renderStar(400.0f - x, 250.0f - y, 80.0f);
        this.myGreetings.render();
        if (this.myStatus >= 4) {
            this.myScreen.smooth();
            this.myScreen.motionBlur();
        }
    }

    private void setupRenderer(RenderPipeline pipe, Matrix camMat, Matrix camRotMat, Vec pos, Vec scale, boolean mirror) {
        Matrix objConvMat = Matrix.transform(pos);
        objConvMat = objConvMat.multiply(Matrix.scale(scale));
        Matrix objMat = null;
        objMat = mirror ? camMat.multiply(objConvMat.mirror()) : camMat.multiply(objConvMat);
        pipe.resetMode();
        pipe.setZSort(true);
        pipe.setColorMode(1);
        pipe.setRenderMode(23);
        pipe.setMatrix(objMat);
        pipe.setNormalMatrix(mirror ? camRotMat.mirror() : camRotMat);
    }

    public void init() {
        this.myCam = new Camera();
        this.mySeaMesh = new SeaMesh(200.0f, new Col(150, 180, 255));
        this.myCloverMesh = Clover.getMeshes();
        this.myHeartMesh = Heart.getMeshes();
        this.myBloodRotator = null;
        this.myGreetings = new GreetingsText(this.myScreen);
        this.myCamAng = 0.0f;
        this.myStarAng = 0.0f;
        this.myStarPosAng = -45.0f;
        this.myStarRadAng = 0.0f;
        this.myFocus = new Vec(0.0f, 10000.0f, 0.0f);
        this.myLightTexture = this.makeLightTexture(Col.BLACK);
        this.myHeartTexture = this.makeLightTexture(Col.RED);
        this.myBumpTexture = this.makeBumpTexture();
        this.setTexture(this.myCloverMesh, this.myLightTexture, null);
        this.setTexture(this.myHeartMesh, this.myHeartTexture, this.myBumpTexture);
        this.myCloverPos = new Vec(0.0f, 200.0f, 0.0f);
        this.myHeartPos = new Vec(0.0f, 200.0f, 0.0f);
        this.myStatus = 0;
        this.myTimeLeft = 500;
        this.myBaseHeight = 0.0f;
        this.myRotatorAng = 0.0f;
        this.myHeartScale = 1.0f;
        this.myHeartPulseMode = 0;
        this.myHeartPulseWait = 10;
        this.myScreen.clear(Col.BLACK);
        this.mySound.setCallback(this);
    }

    public void run() throws Effect.EffectEnding {
        float height;
        this.myCamAng += 1.0f;
        this.myStarAng += 3.0f;
        this.myStarPosAng += 3.0f;
        this.myStarRadAng += 2.5f;
        this.myRotatorAng -= 3.3f;
        float x = (float)((double)this.myFocus.x + Math.cos((double)this.myCamAng * Math.PI / 180.0) * 120.0);
        float y = (float)(100.0 + Math.cos((double)(this.myCamAng * 2.221f) * Math.PI / 180.0) * 60.0);
        float z = (float)((double)this.myFocus.z + Math.sin((double)this.myCamAng * Math.PI / 180.0) * 120.0);
        this.myCam.setPos(new Vec(x, y, z));
        this.myCam.lookAt(this.myFocus);
        if (this.myStatus == 1) {
            this.myBaseHeight = (this.myBaseHeight + 3.0f) * 1.7f;
        }
        if (this.myStatus == 2) {
            this.myBaseHeight -= this.myBaseHeight / 10.0f;
        }
        if (this.myStatus == 5) {
            this.myFocus.y += 7.0f;
            this.myFocus.x -= 3.0f;
            this.myStarPosAng %= 360.0f;
            if (this.myStarPosAng < 0.0f) {
                this.myStarPosAng = 360.0f - this.myStarPosAng;
            }
            if (Math.abs(315.0f - this.myStarPosAng) < 5.0f) {
                this.myStarPosAng = 315.0f;
            }
        } else {
            this.myFocus.y -= (this.myFocus.y - 50.0f) / 10.0f;
        }
        this.myCloverPos.y = height = (float)((double)this.myBaseHeight + 47.0 + Math.sin((double)(this.myCamAng * 3.33f) * Math.PI / 180.0) * 25.0);
        this.myHeartPos.y = height;
        switch (this.myHeartPulseMode) {
            default: {
                break;
            }
            case 1: {
                this.myHeartScale += 0.03f;
                break;
            }
            case 2: {
                this.myHeartScale -= 0.03f;
                break;
            }
        }
        int n = this.myHeartPulseWait;
        this.myHeartPulseWait = n + -1;
        if (n <= 0) {
            switch (this.myHeartPulseMode) {
                default: {
                    this.myHeartPulseWait = 10;
                    break;
                }
                case 1: {
                    this.myHeartPulseMode = 2;
                    this.myHeartPulseWait = 3;
                    break;
                }
                case 2: {
                    this.myHeartPulseMode = 0;
                    this.myHeartPulseWait = 10;
                    break;
                }
            }
        }
        if (this.myBloodRotator != null) {
            this.myBloodRotator.update();
        }
        this.myGreetings.run();
        if ((this.myTimeLeft += -1) <= 0) {
            switch (++this.myStatus) {
                case 1: {
                    this.myTimeLeft = 80;
                    break;
                }
                case 2: {
                    this.myTimeLeft = 500;
                    this.myBaseHeight = 1000.0f;
                    break;
                }
                case 3: {
                    this.myTimeLeft = 2;
                    break;
                }
                case 4: {
                    this.myGreetings.start();
                    this.mySound.setSoundEnabled(false);
                    this.myTimeLeft = 820;
                    this.myBloodRotator = new BloodRotator(this.myHeartPos.add(new Vec(0.0f, 20.0f, 0.0f)), 25.0f);
                    break;
                }
                case 5: {
                    this.myTimeLeft = 80;
                    break;
                }
                default: {
                    throw new Effect.EffectEnding();
                }
            }
        }
    }

    private void setTexture(Hashtable meshes, Texture tex, Texture bump) {
        Enumeration e = meshes.keys();
        while (e.hasMoreElements()) {
            Mesh mesh = (Mesh)meshes.get(e.nextElement());
            mesh.setColor(Col.WHITE);
            mesh.setTexture(tex);
            mesh.setBumpTexture(bump);
        }
    }

    private Texture makeBumpTexture() {
        Texture texture = new Texture();
        int w = texture.width;
        int h = texture.height;
        int[] data = texture.getData();
        int i = 0;
        while (i < w * h) {
            data[i] = Col.make((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
            ++i;
        }
        texture.smooth();
        texture.makeBump(1.8f);
        return texture;
    }
}

