/*
 * Decompiled with CFR 0.152.
 */
package heartbeat.blurrer;

import heartbeat.PixelScreen;
import heartbeat.TextScreen;
import heartbeat.blurrer.TextInfo;
import java.util.Hashtable;

public class OpeningText {
    private static final TextInfo[] TEXTS = new TextInfo[]{new TextInfo("name", 0, -50, 0, 2, 25, 3, 180), new TextInfo("group", -70, 30, 4, 0, 25, 3, 170), new TextInfo("code", -50, 180, 3, 0, 17, 15, 60), new TextInfo("xmunkki", 20, 280, 0, -4, 20, 30, 46), new TextInfo("nexus", 170, 280, 0, -4, 20, 34, 38), new TextInfo("preacher", 300, 280, 0, -4, 20, 38, 30), new TextInfo("sound", -50, 180, 3, 0, 17, 115, 45), new TextInfo("quart", 20, 280, 0, -4, 20, 122, 30)};
    private Hashtable myTexts;
    private PixelScreen myScreen;

    public OpeningText(PixelScreen screen) {
        this.myScreen = screen;
        this.myTexts = new Hashtable();
        this.myTexts.put("name", new TextScreen(200, 35, 0, 35, 32, "Heartbeat"));
        this.myTexts.put("group", new TextScreen(200, 35, 0, 35, 26, "Static"));
        this.myTexts.put("code", new TextScreen(100, 20, 0, 20, 16, "Code:"));
        this.myTexts.put("xmunkki", new TextScreen(100, 28, 0, 28, 24, "XMunkki"));
        this.myTexts.put("nexus", new TextScreen(100, 28, 0, 28, 20, "Nexus"));
        this.myTexts.put("preacher", new TextScreen(100, 28, 0, 28, 16, "Preacher"));
        this.myTexts.put("sound", new TextScreen(100, 20, 0, 20, 16, "The Sound:"));
        this.myTexts.put("quart", new TextScreen(130, 28, 0, 28, 20, "Quarterbrain"));
    }

    public void render() {
        int size = TEXTS.length;
        while (size-- > 0) {
            TextInfo t = TEXTS[size];
            if ((t.mode < 1 || t.mode > 2) && t.moveLeft <= 0) continue;
            this.myScreen.blit((PixelScreen)this.myTexts.get(t.id), t.xPos, t.yPos);
        }
    }

    public void run() {
        int size = TEXTS.length;
        while (size-- > 0) {
            TextInfo t = TEXTS[size];
            if (t.mode > 2) continue;
            if (t.moveLeft > 0) {
                t.xPos += t.xDir;
                t.yPos += t.yDir;
                t.moveLeft += -1;
                if (t.moveLeft > 0) continue;
                switch (t.mode) {
                    case 1: {
                        t.mode = 2;
                        t.xDir = -t.xDir;
                        t.yDir = -t.yDir;
                        break;
                    }
                    case 2: {
                        t.mode = 3;
                        break;
                    }
                }
                continue;
            }
            int n = t.timeLeft;
            t.timeLeft = n + -1;
            if (n > 0) continue;
            switch (t.mode) {
                case 0: {
                    t.mode = 1;
                    t.moveLeft = t.moveAmt;
                    t.timeLeft = t.showTime;
                    break;
                }
                case 2: {
                    t.moveLeft = t.moveAmt;
                    break;
                }
            }
        }
    }
}

