/*
 * Decompiled with CFR 0.152.
 */
package heartbeat;

import heartbeat.Col;
import heartbeat.Matrix;
import heartbeat.Mesh;
import heartbeat.PixelScreen;
import heartbeat.Plane;
import heartbeat.SingleTriRotator;
import heartbeat.Tri;
import heartbeat.Vec;
import java.util.Enumeration;
import java.util.Hashtable;

public class RenderPipeline {
    public static final int COLORMODE_PLAIN = 0;
    public static final int COLORMODE_BYNORMAL = 1;
    public static final int RENDERMODE_FLAT = 20;
    public static final int RENDERMODE_ADDITIVE = 21;
    public static final int RENDERMODE_AVERAGE = 22;
    public static final int RENDERMODE_TEXTURE = 23;
    public static final int RENDERMODE_BUMPTEXTURE = 24;
    private static final float MINZ = 10.0f;
    private static final float NEARZERO = 1.0E-7f;
    private PixelScreen myDest;
    private float myWidth;
    private float myHeight;
    private Matrix myMatrix;
    private Matrix myNormalMatrix;
    private Vec[] myRotList;
    private Vec[] myNormalList;
    private Vec[] myProjList;
    private int[] myPolyX;
    private int[] myPolyY;
    private float[] myPolyZ;
    private float[] myPolyU;
    private float[] myPolyV;
    private float[] myPolyU2;
    private float[] myPolyV2;
    private Vec[] mySplitTemp;
    private Vec[] mySplitTempIn;
    private Vec[] mySplitTempOut;
    private boolean myZCull;
    private boolean myZSort;
    private int myColorMode;
    private int myRenderMode;

    public RenderPipeline(PixelScreen dest) {
        this.myDest = dest;
        this.myWidth = dest.width;
        this.myHeight = dest.height;
        this.myMatrix = new Matrix();
        this.myNormalMatrix = new Matrix();
        this.myRotList = new Vec[1024];
        this.myNormalList = new Vec[1024];
        this.myProjList = new Vec[1024];
        this.myPolyX = new int[30];
        this.myPolyY = new int[30];
        this.myPolyZ = new float[30];
        this.myPolyU = new float[30];
        this.myPolyV = new float[30];
        this.myPolyU2 = new float[30];
        this.myPolyV2 = new float[30];
        this.mySplitTemp = new Vec[3];
        this.mySplitTempIn = new Vec[4];
        this.mySplitTempOut = new Vec[4];
        this.resetMode();
    }

    public void resetMode() {
        this.myZCull = false;
        this.myZSort = false;
        this.myColorMode = 0;
        this.myRenderMode = 20;
    }

    public void setZSort(boolean flag) {
        this.myZSort = flag;
    }

    public void setMatrix(Matrix m) {
        this.myMatrix = m;
    }

    public void setNormalMatrix(Matrix m) {
        this.myNormalMatrix = m;
    }

    public void setColorMode(int newMode) {
        this.myColorMode = newMode;
    }

    public void drawTri(int[] xList, int[] yList, float[] zList, float[] uList, float[] vList, float[] u2List, float[] v2List, Tri tri) {
        int col = tri.col;
        if (this.myZCull && tri.rotNormal.z > 0.0f) {
            return;
        }
        switch (this.myColorMode) {
            default: {
                break;
            }
            case 1: {
                col = Col.make((int)(170.0 + (double)(tri.rotNormal.z * 80.0f)), (int)(170.0 + (double)(tri.rotNormal.z * 80.0f)), (int)(170.0 + (double)(tri.rotNormal.z * 80.0f)));
                break;
            }
        }
        switch (this.myRenderMode) {
            default: {
                this.myDest.drawTriangle(xList, yList, col);
                break;
            }
            case 21: {
                this.myDest.drawAddTriangle(xList, yList, col);
                break;
            }
            case 22: {
                this.myDest.drawAvgTriangle(xList, yList, col);
                break;
            }
            case 23: {
                this.myDest.drawTexTriangle(xList, yList, uList, vList, tri.texture);
                break;
            }
            case 24: {
                this.myDest.drawBumpTexTriangle(xList, yList, uList, vList, u2List, v2List, tri.texture, tri.bump);
                break;
            }
        }
    }

    private static void quicksort(Tri[] list, int l, int r) {
        if (r - l > 4) {
            int i = (r + l) / 2;
            if (list[l].centerZ < list[i].centerZ) {
                RenderPipeline.swap(list, l, i);
            }
            if (list[l].centerZ < list[r].centerZ) {
                RenderPipeline.swap(list, l, r);
            }
            if (list[i].centerZ < list[r].centerZ) {
                RenderPipeline.swap(list, i, r);
            }
            int j = r - 1;
            RenderPipeline.swap(list, i, j);
            i = l;
            float v = list[j].centerZ;
            while (true) {
                if (list[++i].centerZ > v) {
                    continue;
                }
                while (list[--j].centerZ < v) {
                }
                if (j < i) break;
                RenderPipeline.swap(list, i, j);
            }
            RenderPipeline.swap(list, i, r - 1);
            RenderPipeline.quicksort(list, l, j);
            RenderPipeline.quicksort(list, i + 1, r);
        }
    }

    public void setZCull(boolean flag) {
        this.myZCull = flag;
    }

    private static void insertionSort(Tri[] list, int lo0, int hi0) {
        int i = lo0 + 1;
        while (i <= hi0) {
            Tri vObj = list[i];
            float v = vObj.centerZ;
            int j = i;
            while (j > lo0 && list[j - 1].centerZ < v) {
                list[j] = list[j - 1];
                --j;
            }
            list[j] = vObj;
            ++i;
        }
    }

    private static void sort(Tri[] list) {
        RenderPipeline.quicksort(list, 0, list.length - 1);
        RenderPipeline.insertionSort(list, 0, list.length - 1);
    }

    private static void swap(Tri[] list, int a, int b) {
        Tri temp = list[a];
        list[a] = list[b];
        list[b] = temp;
    }

    public void setRenderMode(int newMode) {
        this.myRenderMode = newMode;
    }

    public void render(Mesh mesh) {
        Vec v3;
        Vec v2;
        Vec v1;
        Tri tri;
        int t;
        if (mesh == null) {
            return;
        }
        int tris = mesh.triList.length;
        int vecs = mesh.vecList.length;
        Tri[] srcTriList = mesh.triList;
        Vec[] srcVecList = mesh.vecList;
        Vec[] srcNormalList = mesh.normalList;
        if (this.myRotList.length < vecs) {
            this.myRotList = new Vec[vecs + 200];
            this.myNormalList = new Vec[vecs + 200];
            this.myProjList = new Vec[vecs + 200];
        }
        float halfW = this.myWidth / 2.0f;
        float halfH = this.myHeight / 2.0f;
        int v = 0;
        while (v < vecs) {
            Vec normal = this.myNormalMatrix.translate(srcNormalList[v]);
            Vec temp = this.myMatrix.translate(srcVecList[v]);
            temp.y = -temp.y;
            temp.u = normal.x * 256.0f;
            temp.v = normal.y * 256.0f;
            temp.u2 = srcNormalList[v].x * 256.0f;
            temp.v2 = srcNormalList[v].y * 256.0f;
            this.myProjList[v] = temp.z > 10.0f ? new Vec(halfW + this.myWidth * temp.x / temp.z, halfH + this.myHeight * temp.y / temp.z, temp.z, temp.u, temp.v, temp.u2, temp.v2) : new Vec(0.0f, 0.0f, -1.0f);
            this.myRotList[v] = temp;
            this.myNormalList[v] = normal;
            ++v;
        }
        if (this.myZSort) {
            t = 0;
            while (t < tris) {
                tri = srcTriList[t];
                v1 = this.myRotList[tri.v1];
                v2 = this.myRotList[tri.v2];
                v3 = this.myRotList[tri.v3];
                tri.rotNormal = this.myNormalMatrix.translate(tri.normal);
                tri.centerZ = (v1.z + v2.z + v3.z) / 3.0f;
                ++t;
            }
            RenderPipeline.sort(srcTriList);
        }
        t = 0;
        while (t < tris) {
            tri = srcTriList[t];
            v1 = this.myProjList[tri.v1];
            v2 = this.myProjList[tri.v2];
            v3 = this.myProjList[tri.v3];
            if (!this.myZSort) {
                tri.rotNormal = this.myNormalMatrix.translate(tri.normal);
                tri.centerZ = (v1.z + v2.z + v3.z) / 3.0f;
            }
            if (v1.z < 0.0f || v2.z < 0.0f || v3.z < 0.0f) {
                this.mySplitTemp[0] = this.myRotList[tri.v1];
                this.mySplitTemp[1] = this.myRotList[tri.v2];
                this.mySplitTemp[2] = this.myRotList[tri.v3];
                this.splitProjRender(tri);
            } else {
                this.myPolyX[0] = (int)v1.x;
                this.myPolyY[0] = (int)v1.y;
                this.myPolyZ[0] = v1.z;
                this.myPolyX[1] = (int)v2.x;
                this.myPolyY[1] = (int)v2.y;
                this.myPolyZ[1] = v2.z;
                this.myPolyX[2] = (int)v3.x;
                this.myPolyY[2] = (int)v3.y;
                this.myPolyZ[2] = v3.z;
                this.myPolyU[0] = v1.u;
                this.myPolyV[0] = v1.v;
                this.myPolyU[1] = v2.u;
                this.myPolyV[1] = v2.v;
                this.myPolyU[2] = v3.u;
                this.myPolyV[2] = v3.v;
                if (this.myRenderMode == 24) {
                    this.myPolyU2[0] = v1.u2;
                    this.myPolyV2[0] = v1.v2;
                    this.myPolyU2[1] = v2.u2;
                    this.myPolyV2[1] = v2.v2;
                    this.myPolyU2[2] = v3.u2;
                    this.myPolyV2[2] = v3.v2;
                }
                this.drawTri(this.myPolyX, this.myPolyY, this.myPolyZ, this.myPolyU, this.myPolyV, this.myPolyU2, this.myPolyV2, tri);
            }
            ++t;
        }
    }

    public void render(Hashtable meshes) {
        Enumeration keys = meshes.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            this.render((Mesh)meshes.get(name));
        }
    }

    public void render(SingleTriRotator mesh) {
        if (mesh == null) {
            return;
        }
        Vec[] posList = mesh.posList;
        int[] frameList = mesh.frameList;
        SingleTriRotator.Frame[] frames = mesh.frames;
        Tri tri = new Tri(0, 0, 0, mesh.col);
        float halfW = this.myWidth / 2.0f;
        float halfH = this.myHeight / 2.0f;
        int left = posList.length;
        while (left-- > 0) {
            Vec pos = posList[left];
            SingleTriRotator.Frame frame = frames[frameList[left]];
            Vec v1 = this.myMatrix.translate(pos.add(frame.v1));
            v1.y = -v1.y;
            Vec v2 = this.myMatrix.translate(pos.add(frame.v2));
            v2.y = -v2.y;
            Vec v3 = this.myMatrix.translate(pos.add(frame.v3));
            v3.y = -v3.y;
            if (!(v1.z > 10.0f) || !(v2.z > 10.0f) || !(v3.z > 10.0f)) continue;
            this.myPolyX[0] = (int)(halfW + this.myWidth * v1.x / v1.z);
            this.myPolyY[0] = (int)(halfH + this.myHeight * v1.y / v1.z);
            this.myPolyX[1] = (int)(halfW + this.myWidth * v2.x / v2.z);
            this.myPolyY[1] = (int)(halfH + this.myHeight * v2.y / v2.z);
            this.myPolyX[2] = (int)(halfW + this.myWidth * v3.x / v3.z);
            this.myPolyY[2] = (int)(halfH + this.myHeight * v3.y / v3.z);
            this.drawTri(this.myPolyX, this.myPolyY, null, null, null, null, null, tri);
        }
    }

    private void render(Vec v1, Vec v2, Vec v3, Tri tri) {
        if (v1.z < 10.0f || v2.z < 10.0f || v3.z < 10.0f) {
            throw new Error("ERROR! Can't render negative tri's after splitting!");
        }
        this.myPolyX[0] = (int)(this.myWidth / 2.0f + this.myWidth * v1.x / v1.z);
        this.myPolyY[0] = (int)(this.myHeight / 2.0f + this.myHeight * v1.y / v1.z);
        this.myPolyX[1] = (int)(this.myWidth / 2.0f + this.myWidth * v2.x / v2.z);
        this.myPolyY[1] = (int)(this.myHeight / 2.0f + this.myHeight * v2.y / v2.z);
        this.myPolyX[2] = (int)(this.myWidth / 2.0f + this.myWidth * v3.x / v3.z);
        this.myPolyY[2] = (int)(this.myHeight / 2.0f + this.myHeight * v3.y / v3.z);
        this.myPolyZ[0] = v1.z;
        this.myPolyZ[1] = v2.z;
        this.myPolyZ[2] = v3.z;
        this.myPolyU[0] = v1.u;
        this.myPolyV[0] = v1.v;
        this.myPolyU[1] = v2.u;
        this.myPolyV[1] = v2.v;
        this.myPolyU[2] = v3.u;
        this.myPolyV[2] = v3.v;
        if (this.myRenderMode == 24) {
            this.myPolyU2[0] = v1.u2;
            this.myPolyV2[0] = v1.v2;
            this.myPolyU2[1] = v2.u2;
            this.myPolyV2[1] = v2.v2;
            this.myPolyU2[2] = v3.u2;
            this.myPolyV2[2] = v3.v2;
        }
        this.drawTri(this.myPolyX, this.myPolyY, this.myPolyZ, this.myPolyU, this.myPolyV, this.myPolyU2, this.myPolyV2, tri);
    }

    private void splitProjRender(Tri tri) {
        if (this.mySplitTemp[0].z < 10.0f && this.mySplitTemp[1].z < 10.0f && this.mySplitTemp[2].z < 10.0f) {
            return;
        }
        Plane plane = new Plane(0.0f, 0.0f, 1.0f, -10.1f);
        Vec planeNormal = plane.getNormal();
        int inCount = 0;
        int outCount = 0;
        Vec pointA = this.mySplitTemp[2];
        float sideA = plane.classifyPoint(pointA);
        int left = 0;
        while (left < 3) {
            float sect;
            Vec v;
            Vec pointB = this.mySplitTemp[left];
            float sideB = plane.classifyPoint(pointB);
            if (sideB > 0.0f) {
                if (sideA < 0.0f) {
                    v = pointB.sub(pointA);
                    sect = -plane.classifyPoint(pointA) / planeNormal.dot(v);
                    int n = outCount++;
                    int n2 = inCount++;
                    Vec vec = pointA.add(v.mul(sect));
                    this.mySplitTempIn[n2] = vec;
                    this.mySplitTempOut[n] = vec;
                }
                this.mySplitTempOut[outCount++] = pointB;
            }
            if (sideB < 0.0f) {
                if (sideA > 0.0f) {
                    v = pointB.sub(pointA);
                    sect = -plane.classifyPoint(pointA) / planeNormal.dot(v);
                    int n = outCount++;
                    int n3 = inCount++;
                    Vec vec = pointA.add(v.mul(sect));
                    this.mySplitTempIn[n3] = vec;
                    this.mySplitTempOut[n] = vec;
                }
                this.mySplitTempIn[inCount++] = pointB;
            }
            if (sideB == 0.0f) {
                int n = outCount++;
                int n4 = inCount++;
                Vec vec = pointB;
                this.mySplitTempIn[n4] = vec;
                this.mySplitTempOut[n] = vec;
            }
            pointA = pointB;
            sideA = sideB;
            ++left;
        }
        if (outCount >= 3) {
            this.render(this.mySplitTempOut[0], this.mySplitTempOut[1], this.mySplitTempOut[2], tri);
            if (outCount >= 4) {
                this.render(this.mySplitTempOut[0], this.mySplitTempOut[2], this.mySplitTempOut[3], tri);
            }
        }
    }
}

