/*
 * Decompiled with CFR 0.152.
 */
package heartbeat;

import heartbeat.Vec;

public class Plane {
    public float a;
    public float b;
    public float c;
    public float d;

    public Plane() {
        this(0.0f, 1.0f, 0.0f, 0.0f);
    }

    public Plane(float a, float b, float c, float d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public Plane(Vec dir, Vec pointOnPlane) {
        this(dir.x, dir.y, dir.z, -dir.dot(pointOnPlane));
    }

    public void reverse() {
        this.a = -this.a;
        this.b = -this.b;
        this.c = -this.c;
        this.d = -this.d;
    }

    public float classifyPoint(Vec v) {
        float f = this.a * v.x + this.b * v.y + this.c * v.z + this.d;
        if ((double)f > -1.0E-5 && (double)f < 1.0E-5) {
            return 0.0f;
        }
        return f;
    }

    public Vec getNormal() {
        return new Vec(this.a, this.b, this.c);
    }
}

