/*
 * Decompiled with CFR 0.152.
 */
package heartbeat;

import heartbeat.Col;
import heartbeat.Texture;

public class PixelScreen {
    public int width;
    public int height;
    private int[] myScreen;
    private int[] myBlurBuffer;
    private int mySize;
    private int[] myRAddSquashBuffer;
    private int[] myGAddSquashBuffer;
    private int[] myBAddSquashBuffer;

    public void drawTexTriangle(int[] xList, int[] yList, float[] uList, float[] vList, Texture tex) {
        int xLeft;
        int scrPos;
        int dv;
        int du;
        int v;
        int tmp;
        float drawV2;
        float drawV1;
        float drawU2;
        float drawU1;
        int drawX2;
        int drawX1;
        float k4;
        int k3;
        if (tex == null) {
            this.drawTriangle(xList, yList, Col.WHITE);
            return;
        }
        int[] texture = tex.getData();
        if (yList[0] > yList[1]) {
            k3 = yList[0];
            yList[0] = yList[1];
            yList[1] = k3;
            k3 = xList[0];
            xList[0] = xList[1];
            xList[1] = k3;
            k4 = uList[0];
            uList[0] = uList[1];
            uList[1] = k4;
            k4 = vList[0];
            vList[0] = vList[1];
            vList[1] = k4;
        }
        if (yList[0] > yList[2]) {
            k3 = yList[0];
            yList[0] = yList[2];
            yList[2] = k3;
            k3 = xList[0];
            xList[0] = xList[2];
            xList[2] = k3;
            k4 = uList[0];
            uList[0] = uList[2];
            uList[2] = k4;
            k4 = vList[0];
            vList[0] = vList[2];
            vList[2] = k4;
        }
        if (yList[1] > yList[2]) {
            k3 = yList[1];
            yList[1] = yList[2];
            yList[2] = k3;
            k3 = xList[1];
            xList[1] = xList[2];
            xList[2] = k3;
            k4 = uList[1];
            uList[1] = uList[2];
            uList[2] = k4;
            k4 = vList[1];
            vList[1] = vList[2];
            vList[2] = k4;
        }
        float dxMain = (float)(xList[2] - xList[0]) / (float)(yList[2] - yList[0] + 1);
        float dxUpper = (float)(xList[1] - xList[0]) / (float)(yList[1] - yList[0] + 1);
        float dxLower = (float)(xList[2] - xList[1]) / (float)(yList[2] - yList[1] + 1);
        float udxMain = (uList[2] - uList[0]) / (float)(yList[2] - yList[0] + 1);
        float udxUpper = (uList[1] - uList[0]) / (float)(yList[1] - yList[0] + 1);
        float udxLower = (uList[2] - uList[1]) / (float)(yList[2] - yList[1] + 1);
        float vdxMain = (vList[2] - vList[0]) / (float)(yList[2] - yList[0] + 1);
        float vdxUpper = (vList[1] - vList[0]) / (float)(yList[1] - yList[0] + 1);
        float vdxLower = (vList[2] - vList[1]) / (float)(yList[2] - yList[1] + 1);
        float x1 = xList[0];
        float x2 = xList[0];
        float u1 = uList[0];
        float u2 = uList[0];
        float v1 = vList[0];
        float v2 = vList[0];
        int curY = yList[0];
        int destIdx = curY * this.width;
        if (curY >= this.height) {
            return;
        }
        int yLeft = yList[1] - yList[0];
        while (yLeft > 0) {
            if (curY >= this.height) break;
            if (curY >= 0) {
                drawX1 = (int)x1;
                drawX2 = (int)x2;
                drawU1 = u1;
                drawU2 = u2;
                drawV1 = v1;
                drawV2 = v2;
                if (drawX1 > drawX2) {
                    tmp = drawX1;
                    drawX1 = drawX2;
                    drawX2 = tmp;
                    float tmp2 = drawU1;
                    drawU1 = drawU2;
                    drawU2 = tmp2;
                    tmp2 = drawV1;
                    drawV1 = drawV2;
                    drawV2 = tmp2;
                }
                if (drawX1 < this.width && drawX2 >= 0) {
                    float diff = drawX2 - drawX1 + 1;
                    int u = (int)(drawU1 * 65535.0f);
                    v = (int)(drawV1 * 65535.0f);
                    du = (int)((drawU2 - drawU1) / diff * 65535.0f);
                    dv = (int)((drawV2 - drawV1) / diff * 65535.0f);
                    if (drawX1 < 0) {
                        u += -drawX1 * du;
                        v += -drawX1 * dv;
                        drawX1 = 0;
                    }
                    if (drawX2 >= this.width) {
                        drawX2 = this.width - 1;
                    }
                    scrPos = destIdx + drawX1;
                    xLeft = drawX2 - drawX1;
                    while (xLeft > 0) {
                        this.myScreen[scrPos++] = texture[(u >> 16 & 0xFF) + ((v >> 16 & 0xFF) << 8)];
                        --xLeft;
                        u += du;
                        v += dv;
                    }
                }
            }
            x1 += dxMain;
            x2 += dxUpper;
            u1 += udxMain;
            u2 += udxUpper;
            v1 += vdxMain;
            v2 += vdxUpper;
            --yLeft;
            ++curY;
            destIdx += this.width;
        }
        x2 = xList[1];
        u2 = uList[1];
        v2 = vList[1];
        yLeft = yList[2] - yList[1];
        while (yLeft > 0) {
            if (curY >= this.height) break;
            if (curY >= 0) {
                drawX1 = (int)x1;
                drawX2 = (int)x2;
                drawU1 = u1;
                drawU2 = u2;
                drawV1 = v1;
                drawV2 = v2;
                if (drawX1 > drawX2) {
                    tmp = drawX1;
                    drawX1 = drawX2;
                    drawX2 = tmp;
                    float tmp2 = drawU1;
                    drawU1 = drawU2;
                    drawU2 = tmp2;
                    tmp2 = drawV1;
                    drawV1 = drawV2;
                    drawV2 = tmp2;
                }
                if (drawX1 < this.width && drawX2 >= 0) {
                    float diff = drawX2 - drawX1 + 1;
                    int u = (int)(drawU1 * 65535.0f);
                    v = (int)(drawV1 * 65535.0f);
                    du = (int)((drawU2 - drawU1) / diff * 65535.0f);
                    dv = (int)((drawV2 - drawV1) / diff * 65535.0f);
                    if (drawX1 < 0) {
                        u += -drawX1 * du;
                        v += -drawX1 * dv;
                        drawX1 = 0;
                    }
                    if (drawX2 >= this.width) {
                        drawX2 = this.width - 1;
                    }
                    scrPos = destIdx + drawX1;
                    xLeft = drawX2 - drawX1;
                    while (xLeft > 0) {
                        this.myScreen[scrPos++] = texture[(u >> 16 & 0xFF) + ((v >> 16 & 0xFF) << 8)];
                        --xLeft;
                        u += du;
                        v += dv;
                    }
                }
            }
            x1 += dxMain;
            x2 += dxLower;
            u1 += udxMain;
            u2 += udxLower;
            v1 += vdxMain;
            v2 += vdxLower;
            --yLeft;
            ++curY;
            destIdx += this.width;
        }
    }

    public void motionBlur() {
        int left = this.mySize;
        while (left-- > 0) {
            this.myBlurBuffer[left] = ((this.myScreen[left] & 0xFEFEFE) >> 1) + ((this.myBlurBuffer[left] & 0xFEFEFE) >> 1);
        }
        left = this.mySize;
        while (left-- > 0) {
            this.myScreen[left] = 0xFF000000 | this.myBlurBuffer[left];
        }
    }

    public PixelScreen(int width, int height) {
        this.width = width;
        this.height = height;
        this.mySize = width * height;
        this.myScreen = new int[this.mySize];
        this.myBlurBuffer = new int[this.mySize];
        this.myRAddSquashBuffer = new int[512];
        this.myGAddSquashBuffer = new int[512];
        this.myBAddSquashBuffer = new int[512];
        int i = 0;
        while (i < 512) {
            int v = i;
            if (v > 255) {
                v = 255;
            }
            this.myRAddSquashBuffer[i] = 0xFF000000 | v << 16;
            this.myGAddSquashBuffer[i] = v << 8;
            this.myBAddSquashBuffer[i] = v;
            ++i;
        }
        this.clear(Col.BLACK);
    }

    public void drawTriangle(int[] xList, int[] yList, int col) {
        int xLeft;
        int scrPos;
        int tmp;
        int drawX2;
        int drawX1;
        int k3;
        if (yList[0] > yList[1]) {
            k3 = yList[0];
            yList[0] = yList[1];
            yList[1] = k3;
            k3 = xList[0];
            xList[0] = xList[1];
            xList[1] = k3;
        }
        if (yList[0] > yList[2]) {
            k3 = yList[0];
            yList[0] = yList[2];
            yList[2] = k3;
            k3 = xList[0];
            xList[0] = xList[2];
            xList[2] = k3;
        }
        if (yList[1] > yList[2]) {
            k3 = yList[1];
            yList[1] = yList[2];
            yList[2] = k3;
            k3 = xList[1];
            xList[1] = xList[2];
            xList[2] = k3;
        }
        float dxMain = (float)(xList[2] - xList[0]) / (float)(yList[2] - yList[0] + 1);
        float dxUpper = (float)(xList[1] - xList[0]) / (float)(yList[1] - yList[0] + 1);
        float dxLower = (float)(xList[2] - xList[1]) / (float)(yList[2] - yList[1] + 1);
        float x1 = xList[0];
        float x2 = xList[0];
        int curY = yList[0];
        int destIdx = curY * this.width;
        if (curY >= this.height) {
            return;
        }
        int yLeft = yList[1] - yList[0];
        while (yLeft > 0) {
            if (curY >= this.height) break;
            if (curY >= 0) {
                drawX1 = (int)x1;
                drawX2 = (int)x2;
                if (drawX1 > drawX2) {
                    tmp = drawX1;
                    drawX1 = drawX2;
                    drawX2 = tmp;
                }
                if (drawX1 < this.width && drawX2 >= 0) {
                    if (drawX1 < 0) {
                        drawX1 = 0;
                    }
                    if (drawX2 >= this.width) {
                        drawX2 = this.width - 1;
                    }
                    scrPos = destIdx + drawX1;
                    xLeft = drawX2 - drawX1;
                    while (xLeft > 0) {
                        this.myScreen[scrPos++] = col;
                        --xLeft;
                    }
                }
            }
            x1 += dxMain;
            x2 += dxUpper;
            --yLeft;
            ++curY;
            destIdx += this.width;
        }
        x2 = xList[1];
        yLeft = yList[2] - yList[1];
        while (yLeft > 0) {
            if (curY >= this.height) break;
            if (curY >= 0) {
                drawX1 = (int)x1;
                drawX2 = (int)x2;
                if (drawX1 > drawX2) {
                    tmp = drawX1;
                    drawX1 = drawX2;
                    drawX2 = tmp;
                }
                if (drawX1 < this.width && drawX2 >= 0) {
                    if (drawX1 < 0) {
                        drawX1 = 0;
                    }
                    if (drawX2 >= this.width) {
                        drawX2 = this.width - 1;
                    }
                    scrPos = destIdx + drawX1;
                    xLeft = drawX2 - drawX1;
                    while (xLeft > 0) {
                        this.myScreen[scrPos++] = col;
                        --xLeft;
                    }
                }
            }
            x1 += dxMain;
            x2 += dxLower;
            --yLeft;
            ++curY;
            destIdx += this.width;
        }
    }

    public int[] getData() {
        return this.myScreen;
    }

    public void fadeWhite(int vol) {
        int o = this.mySize;
        vol = Math.min(255, Math.max(vol, 0));
        while (o-- > 0) {
            this.myScreen[o] = this.myRAddSquashBuffer[((this.myScreen[o] & 0xFFFFFF) >> 16) + vol] | this.myGAddSquashBuffer[((this.myScreen[o] & 0xFFFFFF & 0xFFFF) >> 8) + vol] | this.myBAddSquashBuffer[(this.myScreen[o] & 0xFFFFFF & 0xFF) + vol];
        }
    }

    public void blit(PixelScreen source, int x, int y) {
        if (source == null) {
            return;
        }
        int sWidth = source.width;
        int sHeight = source.height;
        int cWidth = sWidth;
        int cHeight = sHeight;
        int sX = 0;
        int sY = 0;
        int dX = x;
        int dY = y;
        if (dX >= this.width || dY >= this.height) {
            return;
        }
        if (dX < 0) {
            sX += -dX;
            cWidth -= -dX;
            dX = 0;
        }
        if (dY < 0) {
            sY += -dY;
            cHeight -= -dY;
            dY = 0;
        }
        if (cWidth <= 0 || cHeight <= 0) {
            return;
        }
        if (dX + cWidth > this.width) {
            cWidth = this.width - dX;
        }
        if (dY + cHeight > this.height) {
            cHeight = this.height - dY;
        }
        if (cWidth <= 0 || cHeight <= 0) {
            return;
        }
        int[] dData = this.myScreen;
        int[] sData = source.getData();
        int dIdx = dX + dY * this.width;
        int sIdx = sX + sY * sWidth;
        int yLeft = cHeight;
        while (yLeft-- > 0) {
            int di = dIdx;
            int si = sIdx;
            int xLeft = cWidth;
            while (xLeft-- > 0) {
                int col;
                if ((col = sData[si++]) != Col.BLACK) {
                    dData[di++] = col;
                    continue;
                }
                ++di;
            }
            dIdx += this.width;
            sIdx += sWidth;
        }
    }

    public void smooth(int vol) {
        int left = this.mySize - this.width * vol;
        int min = this.width * vol;
        while (left-- > min) {
            int c1 = this.myScreen[left + vol] & 0xFFFFFF;
            int c2 = this.myScreen[left - vol] & 0xFFFFFF;
            int c3 = this.myScreen[left + vol * this.width] & 0xFFFFFF;
            int c4 = this.myScreen[left - vol * this.width] & 0xFFFFFF;
            int r1 = c1 >> 16;
            int r2 = c2 >> 16;
            int r3 = c3 >> 16;
            int r4 = c4 >> 16;
            int g1 = (c1 & 0xFFFF) >> 8;
            int g2 = (c2 & 0xFFFF) >> 8;
            int g3 = (c3 & 0xFFFF) >> 8;
            int g4 = (c4 & 0xFFFF) >> 8;
            int b1 = c1 & 0xFF;
            int b2 = c2 & 0xFF;
            int b3 = c3 & 0xFF;
            int b4 = c4 & 0xFF;
            this.myScreen[left] = 0xFF000000 | (r1 + r2 + r3 + r4 >> 2 << 16) + (g1 + g2 + g3 + g4 >> 2 << 8) + (b1 + b2 + b3 + b4 >> 2);
        }
    }

    public void smooth() {
        int left = this.mySize - this.width;
        while (left-- > this.width) {
            int c1 = this.myScreen[left + 1] & 0xFFFFFF;
            int c2 = this.myScreen[left - 1] & 0xFFFFFF;
            int c3 = this.myScreen[left + this.width] & 0xFFFFFF;
            int c4 = this.myScreen[left - this.width] & 0xFFFFFF;
            int r1 = c1 >> 16;
            int r2 = c2 >> 16;
            int r3 = c3 >> 16;
            int r4 = c4 >> 16;
            int g1 = (c1 & 0xFFFF) >> 8;
            int g2 = (c2 & 0xFFFF) >> 8;
            int g3 = (c3 & 0xFFFF) >> 8;
            int g4 = (c4 & 0xFFFF) >> 8;
            int b1 = c1 & 0xFF;
            int b2 = c2 & 0xFF;
            int b3 = c3 & 0xFF;
            int b4 = c4 & 0xFF;
            this.myScreen[left] = 0xFF000000 | (r1 + r2 + r3 + r4 >> 2 << 16) + (g1 + g2 + g3 + g4 >> 2 << 8) + (b1 + b2 + b3 + b4 >> 2);
        }
    }

    public void drawBumpTexTriangle(int[] xList, int[] yList, float[] uList, float[] vList, float[] buList, float[] bvList, Texture tex, Texture bump) {
        int bumpVal;
        int yPos;
        int xPos;
        int xLeft;
        int scrPos;
        int dbv;
        int dbu;
        int bv;
        int bu;
        int dv;
        int du;
        int v;
        int tmp;
        float drawBV2;
        float drawBV1;
        float drawBU2;
        float drawBU1;
        float drawV2;
        float drawV1;
        float drawU2;
        float drawU1;
        int drawX2;
        int drawX1;
        float k4;
        int k3;
        if (tex == null || bump == null) {
            this.drawTriangle(xList, yList, Col.WHITE);
            return;
        }
        int[] texture = tex.getData();
        int[] bumpData = bump.getData();
        if (yList[0] > yList[1]) {
            k3 = yList[0];
            yList[0] = yList[1];
            yList[1] = k3;
            k3 = xList[0];
            xList[0] = xList[1];
            xList[1] = k3;
            k4 = uList[0];
            uList[0] = uList[1];
            uList[1] = k4;
            k4 = vList[0];
            vList[0] = vList[1];
            vList[1] = k4;
            k4 = buList[0];
            buList[0] = buList[1];
            buList[1] = k4;
            k4 = bvList[0];
            bvList[0] = bvList[1];
            bvList[1] = k4;
        }
        if (yList[0] > yList[2]) {
            k3 = yList[0];
            yList[0] = yList[2];
            yList[2] = k3;
            k3 = xList[0];
            xList[0] = xList[2];
            xList[2] = k3;
            k4 = uList[0];
            uList[0] = uList[2];
            uList[2] = k4;
            k4 = vList[0];
            vList[0] = vList[2];
            vList[2] = k4;
            k4 = buList[0];
            buList[0] = buList[2];
            buList[2] = k4;
            k4 = bvList[0];
            bvList[0] = bvList[2];
            bvList[2] = k4;
        }
        if (yList[1] > yList[2]) {
            k3 = yList[1];
            yList[1] = yList[2];
            yList[2] = k3;
            k3 = xList[1];
            xList[1] = xList[2];
            xList[2] = k3;
            k4 = uList[1];
            uList[1] = uList[2];
            uList[2] = k4;
            k4 = vList[1];
            vList[1] = vList[2];
            vList[2] = k4;
            k4 = buList[1];
            buList[1] = buList[2];
            buList[2] = k4;
            k4 = bvList[1];
            bvList[1] = bvList[2];
            bvList[2] = k4;
        }
        float dxMain = (float)(xList[2] - xList[0]) / (float)(yList[2] - yList[0] + 1);
        float dxUpper = (float)(xList[1] - xList[0]) / (float)(yList[1] - yList[0] + 1);
        float dxLower = (float)(xList[2] - xList[1]) / (float)(yList[2] - yList[1] + 1);
        float udxMain = (uList[2] - uList[0]) / (float)(yList[2] - yList[0] + 1);
        float udxUpper = (uList[1] - uList[0]) / (float)(yList[1] - yList[0] + 1);
        float udxLower = (uList[2] - uList[1]) / (float)(yList[2] - yList[1] + 1);
        float vdxMain = (vList[2] - vList[0]) / (float)(yList[2] - yList[0] + 1);
        float vdxUpper = (vList[1] - vList[0]) / (float)(yList[1] - yList[0] + 1);
        float vdxLower = (vList[2] - vList[1]) / (float)(yList[2] - yList[1] + 1);
        float budxMain = (buList[2] - buList[0]) / (float)(yList[2] - yList[0] + 1);
        float budxUpper = (buList[1] - buList[0]) / (float)(yList[1] - yList[0] + 1);
        float budxLower = (buList[2] - buList[1]) / (float)(yList[2] - yList[1] + 1);
        float bvdxMain = (bvList[2] - bvList[0]) / (float)(yList[2] - yList[0] + 1);
        float bvdxUpper = (bvList[1] - bvList[0]) / (float)(yList[1] - yList[0] + 1);
        float bvdxLower = (bvList[2] - bvList[1]) / (float)(yList[2] - yList[1] + 1);
        float x1 = xList[0];
        float x2 = xList[0];
        float u1 = uList[0];
        float u2 = uList[0];
        float v1 = vList[0];
        float v2 = vList[0];
        float bu1 = buList[0];
        float bu2 = buList[0];
        float bv1 = bvList[0];
        float bv2 = bvList[0];
        int curY = yList[0];
        int destIdx = curY * this.width;
        if (curY >= this.height) {
            return;
        }
        int yLeft = yList[1] - yList[0];
        while (yLeft > 0) {
            if (curY >= this.height) break;
            if (curY >= 0) {
                drawX1 = (int)x1;
                drawX2 = (int)x2;
                drawU1 = u1;
                drawU2 = u2;
                drawV1 = v1;
                drawV2 = v2;
                drawBU1 = bu1;
                drawBU2 = bu2;
                drawBV1 = bv1;
                drawBV2 = bv2;
                if (drawX1 > drawX2) {
                    tmp = drawX1;
                    drawX1 = drawX2;
                    drawX2 = tmp;
                    float tmp2 = drawU1;
                    drawU1 = drawU2;
                    drawU2 = tmp2;
                    tmp2 = drawV1;
                    drawV1 = drawV2;
                    drawV2 = tmp2;
                    tmp2 = drawBU1;
                    drawBU1 = drawBU2;
                    drawBU2 = tmp2;
                    tmp2 = drawBV1;
                    drawBV1 = drawBV2;
                    drawBV2 = tmp2;
                }
                if (drawX1 < this.width && drawX2 >= 0) {
                    float diff = drawX2 - drawX1 + 1;
                    int u = (int)(drawU1 * 65535.0f);
                    v = (int)(drawV1 * 65535.0f);
                    du = (int)((drawU2 - drawU1) / diff * 65535.0f);
                    dv = (int)((drawV2 - drawV1) / diff * 65535.0f);
                    bu = (int)(drawBU1 * 65535.0f);
                    bv = (int)(drawBV1 * 65535.0f);
                    dbu = (int)((drawBU2 - drawBU1) / diff * 65535.0f);
                    dbv = (int)((drawBV2 - drawBV1) / diff * 65535.0f);
                    if (drawX1 < 0) {
                        u += -drawX1 * du;
                        v += -drawX1 * dv;
                        bu += -drawX1 * dbu;
                        bv += -drawX1 * dbv;
                        drawX1 = 0;
                    }
                    if (drawX2 >= this.width) {
                        drawX2 = this.width - 1;
                    }
                    scrPos = destIdx + drawX1;
                    xLeft = drawX2 - drawX1;
                    while (xLeft > 0) {
                        xPos = u >> 16 & 0xFF;
                        yPos = v >> 16 & 0xFF;
                        bumpVal = bumpData[(bu >> 16 & 0xFF) + ((bv >> 16 & 0xFF) << 8)];
                        this.myScreen[scrPos++] = texture[((xPos += 127 - (bumpVal >> 8 & 0xFF)) & 0xFF) + (((yPos += 127 - (bumpVal & 0xFF)) & 0xFF) << 8)];
                        --xLeft;
                        u += du;
                        v += dv;
                        bu += dbu;
                        bv += dbv;
                    }
                }
            }
            x1 += dxMain;
            x2 += dxUpper;
            u1 += udxMain;
            u2 += udxUpper;
            v1 += vdxMain;
            v2 += vdxUpper;
            bu1 += budxMain;
            bu2 += budxUpper;
            bv1 += bvdxMain;
            bv2 += bvdxUpper;
            --yLeft;
            ++curY;
            destIdx += this.width;
        }
        curY = yList[1];
        destIdx = curY * this.width;
        x2 = xList[1];
        u2 = uList[1];
        v2 = vList[1];
        bu2 = buList[1];
        bv2 = bvList[1];
        yLeft = yList[2] - yList[1];
        while (yLeft > 0) {
            if (curY >= this.height) break;
            if (curY >= 0) {
                drawX1 = (int)x1;
                drawX2 = (int)x2;
                drawU1 = u1;
                drawU2 = u2;
                drawV1 = v1;
                drawV2 = v2;
                drawBU1 = bu1;
                drawBU2 = bu2;
                drawBV1 = bv1;
                drawBV2 = bv2;
                if (drawX1 > drawX2) {
                    tmp = drawX1;
                    drawX1 = drawX2;
                    drawX2 = tmp;
                    float tmp2 = drawU1;
                    drawU1 = drawU2;
                    drawU2 = tmp2;
                    tmp2 = drawV1;
                    drawV1 = drawV2;
                    drawV2 = tmp2;
                    tmp2 = drawBU1;
                    drawBU1 = drawBU2;
                    drawBU2 = tmp2;
                    tmp2 = drawBV1;
                    drawBV1 = drawBV2;
                    drawBV2 = tmp2;
                }
                if (drawX1 < this.width && drawX2 >= 0) {
                    float diff = drawX2 - drawX1 + 1;
                    int u = (int)(drawU1 * 65535.0f);
                    v = (int)(drawV1 * 65535.0f);
                    du = (int)((drawU2 - drawU1) / diff * 65535.0f);
                    dv = (int)((drawV2 - drawV1) / diff * 65535.0f);
                    bu = (int)(drawBU1 * 65535.0f);
                    bv = (int)(drawBV1 * 65535.0f);
                    dbu = (int)((drawBU2 - drawBU1) / diff * 65535.0f);
                    dbv = (int)((drawBV2 - drawBV1) / diff * 65535.0f);
                    if (drawX1 < 0) {
                        u += -drawX1 * du;
                        v += -drawX1 * dv;
                        bu += -drawX1 * dbu;
                        bv += -drawX1 * dbv;
                        drawX1 = 0;
                    }
                    if (drawX2 >= this.width) {
                        drawX2 = this.width - 1;
                    }
                    scrPos = destIdx + drawX1;
                    xLeft = drawX2 - drawX1;
                    while (xLeft > 0) {
                        xPos = u >> 16 & 0xFF;
                        yPos = v >> 16 & 0xFF;
                        bumpVal = bumpData[(bu >> 16 & 0xFF) + ((bv >> 16 & 0xFF) << 8)];
                        this.myScreen[scrPos++] = texture[((xPos += 127 - (bumpVal >> 8 & 0xFF)) & 0xFF) + (((yPos += 127 - (bumpVal & 0xFF)) & 0xFF) << 8)];
                        --xLeft;
                        u += du;
                        v += dv;
                        bu += dbu;
                        bv += dbv;
                    }
                }
            }
            x1 += dxMain;
            x2 += dxLower;
            u1 += udxMain;
            u2 += udxLower;
            v1 += vdxMain;
            v2 += vdxLower;
            bu1 += budxMain;
            bu2 += budxLower;
            bv1 += bvdxMain;
            bv2 += bvdxLower;
            --yLeft;
            ++curY;
            destIdx += this.width;
        }
    }

    public void clear(int color) {
        int left = this.mySize;
        while (left-- > 0) {
            this.myScreen[left] = color;
        }
    }

    public void putPixel(int x, int y, int col) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return;
        }
        this.myScreen[x + y * this.width] = col;
    }

    public int getPixel(int x, int y) {
        if ((x %= this.width) < 0) {
            x = (this.width - 1 - x) % this.width;
        }
        if ((y %= this.height) < 0) {
            y = (this.height - 1 - y) % this.height;
        }
        return this.myScreen[x + y * this.width];
    }

    public void drawAvgTriangle(int[] xList, int[] yList, int col) {
        int xLeft;
        int scrPos;
        int tmp;
        int drawX2;
        int drawX1;
        int k3;
        col = (col & 0xFEFEFE) >> 1;
        if (yList[0] > yList[1]) {
            k3 = yList[0];
            yList[0] = yList[1];
            yList[1] = k3;
            k3 = xList[0];
            xList[0] = xList[1];
            xList[1] = k3;
        }
        if (yList[0] > yList[2]) {
            k3 = yList[0];
            yList[0] = yList[2];
            yList[2] = k3;
            k3 = xList[0];
            xList[0] = xList[2];
            xList[2] = k3;
        }
        if (yList[1] > yList[2]) {
            k3 = yList[1];
            yList[1] = yList[2];
            yList[2] = k3;
            k3 = xList[1];
            xList[1] = xList[2];
            xList[2] = k3;
        }
        float dxMain = (float)(xList[2] - xList[0]) / (float)(yList[2] - yList[0] + 1);
        float dxUpper = (float)(xList[1] - xList[0]) / (float)(yList[1] - yList[0] + 1);
        float dxLower = (float)(xList[2] - xList[1]) / (float)(yList[2] - yList[1] + 1);
        float x1 = xList[0];
        float x2 = xList[0];
        int curY = yList[0];
        int destIdx = curY * this.width;
        if (curY >= this.height) {
            return;
        }
        int yLeft = yList[1] - yList[0];
        while (yLeft > 0) {
            if (curY >= this.height) break;
            if (curY >= 0) {
                drawX1 = (int)x1;
                drawX2 = (int)x2;
                if (drawX1 > drawX2) {
                    tmp = drawX1;
                    drawX1 = drawX2;
                    drawX2 = tmp;
                }
                if (drawX1 < this.width && drawX2 >= 0) {
                    if (drawX1 < 0) {
                        drawX1 = 0;
                    }
                    if (drawX2 >= this.width) {
                        drawX2 = this.width - 1;
                    }
                    scrPos = destIdx + drawX1;
                    xLeft = drawX2 - drawX1;
                    while (xLeft > 0) {
                        this.myScreen[scrPos] = 0xFF000000 | col + ((this.myScreen[scrPos] & 0xFEFEFE) >> 1);
                        ++scrPos;
                        --xLeft;
                    }
                }
            }
            x1 += dxMain;
            x2 += dxUpper;
            --yLeft;
            ++curY;
            destIdx += this.width;
        }
        x2 = xList[1];
        yLeft = yList[2] - yList[1];
        while (yLeft > 0) {
            if (curY >= this.height) break;
            if (curY >= 0) {
                drawX1 = (int)x1;
                drawX2 = (int)x2;
                if (drawX1 > drawX2) {
                    tmp = drawX1;
                    drawX1 = drawX2;
                    drawX2 = tmp;
                }
                if (drawX1 < this.width && drawX2 >= 0) {
                    if (drawX1 < 0) {
                        drawX1 = 0;
                    }
                    if (drawX2 >= this.width) {
                        drawX2 = this.width - 1;
                    }
                    scrPos = destIdx + drawX1;
                    xLeft = drawX2 - drawX1;
                    while (xLeft > 0) {
                        this.myScreen[scrPos] = 0xFF000000 | col + ((this.myScreen[scrPos] & 0xFEFEFE) >> 1);
                        ++scrPos;
                        --xLeft;
                    }
                }
            }
            x1 += dxMain;
            x2 += dxLower;
            --yLeft;
            ++curY;
            destIdx += this.width;
        }
    }

    public void drawAddTriangle(int[] xList, int[] yList, int col) {
        int c;
        int xLeft;
        int scrPos;
        int tmp;
        int drawX2;
        int drawX1;
        int k3;
        Col colObj = new Col(col);
        int r = colObj.getR();
        int g = colObj.getG();
        int b = colObj.getB();
        if (yList[0] > yList[1]) {
            k3 = yList[0];
            yList[0] = yList[1];
            yList[1] = k3;
            k3 = xList[0];
            xList[0] = xList[1];
            xList[1] = k3;
        }
        if (yList[0] > yList[2]) {
            k3 = yList[0];
            yList[0] = yList[2];
            yList[2] = k3;
            k3 = xList[0];
            xList[0] = xList[2];
            xList[2] = k3;
        }
        if (yList[1] > yList[2]) {
            k3 = yList[1];
            yList[1] = yList[2];
            yList[2] = k3;
            k3 = xList[1];
            xList[1] = xList[2];
            xList[2] = k3;
        }
        float dxMain = (float)(xList[2] - xList[0]) / (float)(yList[2] - yList[0] + 1);
        float dxUpper = (float)(xList[1] - xList[0]) / (float)(yList[1] - yList[0] + 1);
        float dxLower = (float)(xList[2] - xList[1]) / (float)(yList[2] - yList[1] + 1);
        float x1 = xList[0];
        float x2 = xList[0];
        int curY = yList[0];
        int destIdx = curY * this.width;
        if (curY >= this.height) {
            return;
        }
        int yLeft = yList[1] - yList[0];
        while (yLeft > 0) {
            if (curY >= this.height) break;
            if (curY >= 0) {
                drawX1 = (int)x1;
                drawX2 = (int)x2;
                if (drawX1 > drawX2) {
                    tmp = drawX1;
                    drawX1 = drawX2;
                    drawX2 = tmp;
                }
                if (drawX1 < this.width && drawX2 >= 0) {
                    if (drawX1 < 0) {
                        drawX1 = 0;
                    }
                    if (drawX2 >= this.width) {
                        drawX2 = this.width - 1;
                    }
                    scrPos = destIdx + drawX1;
                    xLeft = drawX2 - drawX1;
                    while (xLeft > 0) {
                        c = this.myScreen[scrPos];
                        this.myScreen[scrPos++] = this.myRAddSquashBuffer[r + (c >> 16 & 0xFF)] | this.myGAddSquashBuffer[g + (c >> 8 & 0xFF)] | this.myBAddSquashBuffer[b + (c & 0xFF)];
                        --xLeft;
                    }
                }
            }
            x1 += dxMain;
            x2 += dxUpper;
            --yLeft;
            ++curY;
            destIdx += this.width;
        }
        x2 = xList[1];
        yLeft = yList[2] - yList[1];
        while (yLeft > 0) {
            if (curY >= this.height) break;
            if (curY >= 0) {
                drawX1 = (int)x1;
                drawX2 = (int)x2;
                if (drawX1 > drawX2) {
                    tmp = drawX1;
                    drawX1 = drawX2;
                    drawX2 = tmp;
                }
                if (drawX1 < this.width && drawX2 >= 0) {
                    if (drawX1 < 0) {
                        drawX1 = 0;
                    }
                    if (drawX2 >= this.width) {
                        drawX2 = this.width - 1;
                    }
                    scrPos = destIdx + drawX1;
                    xLeft = drawX2 - drawX1;
                    while (xLeft > 0) {
                        c = this.myScreen[scrPos];
                        this.myScreen[scrPos++] = this.myRAddSquashBuffer[r + (c >> 16 & 0xFF)] | this.myGAddSquashBuffer[g + (c >> 8 & 0xFF)] | this.myBAddSquashBuffer[b + (c & 0xFF)];
                        --xLeft;
                    }
                }
            }
            x1 += dxMain;
            x2 += dxLower;
            --yLeft;
            ++curY;
            destIdx += this.width;
        }
    }
}

