/*
 * Decompiled with CFR 0.152.
 */
package heartbeat;

import heartbeat.Vec;

public class Matrix {
    public float[] data = new float[16];

    public Matrix() {
        this.identity();
    }

    public Vec translate(Vec v) {
        Vec a = new Vec();
        a.x = this.data[0] * v.x + this.data[1] * v.y + this.data[2] * v.z + this.data[3];
        a.y = this.data[4] * v.x + this.data[5] * v.y + this.data[6] * v.z + this.data[7];
        a.z = this.data[8] * v.x + this.data[9] * v.y + this.data[10] * v.z + this.data[11];
        return a;
    }

    public Matrix multiply(Matrix other) {
        Matrix ans = new Matrix();
        int aRow = 0;
        while (aRow < 4) {
            int bCol = 0;
            while (bCol < 4) {
                int aIdx = aRow * 4;
                int bIdx = bCol;
                float val = 0.0f;
                int idx = 0;
                while (idx < 4) {
                    val += this.data[aIdx] * other.data[bIdx];
                    ++idx;
                    ++aIdx;
                    bIdx += 4;
                }
                ans.data[bCol + aRow * 4] = val;
                ++bCol;
            }
            ++aRow;
        }
        return ans;
    }

    public static Matrix rotateZ(float ang) {
        float s = (float)Math.sin((double)ang * Math.PI / 180.0);
        float c = (float)Math.cos((double)ang * Math.PI / 180.0);
        Matrix m = new Matrix();
        m.data[0] = c;
        m.data[1] = -s;
        m.data[4] = s;
        m.data[5] = c;
        return m;
    }

    public static Matrix rotateX(float ang) {
        float s = (float)Math.sin((double)ang * Math.PI / 180.0);
        float c = (float)Math.cos((double)ang * Math.PI / 180.0);
        Matrix m = new Matrix();
        m.data[5] = c;
        m.data[6] = -s;
        m.data[9] = s;
        m.data[10] = c;
        return m;
    }

    public Matrix mirror() {
        return Matrix.scale(new Vec(1.0f, -1.0f, 1.0f)).multiply(this);
    }

    public static Matrix makeRotationMatrix(Vec dir, Vec up) {
        Vec x = up.cross(dir);
        Vec y = dir.cross(x);
        Vec z = dir;
        Matrix m = new Matrix();
        m.data[0] = x.x;
        m.data[1] = x.y;
        m.data[2] = x.z;
        m.data[4] = y.x;
        m.data[5] = y.y;
        m.data[6] = y.z;
        m.data[8] = z.x;
        m.data[9] = z.y;
        m.data[10] = z.z;
        return m;
    }

    public static Matrix transform(Vec moveAmt) {
        Matrix m = new Matrix();
        m.data[3] = moveAmt.x;
        m.data[7] = moveAmt.y;
        m.data[11] = moveAmt.z;
        return m;
    }

    public void identity() {
        int i = 0;
        while (i < 16) {
            this.data[i] = 0.0f;
            ++i;
        }
        this.data[0] = 1.0f;
        this.data[5] = 1.0f;
        this.data[10] = 1.0f;
        this.data[15] = 1.0f;
    }

    public static Matrix scale(Vec scale) {
        Matrix m = new Matrix();
        m.data[0] = scale.x;
        m.data[5] = scale.y;
        m.data[10] = scale.z;
        return m;
    }

    public static Matrix rotateY(float ang) {
        float s = (float)Math.sin((double)ang * Math.PI / 180.0);
        float c = (float)Math.cos((double)ang * Math.PI / 180.0);
        Matrix m = new Matrix();
        m.data[0] = c;
        m.data[2] = s;
        m.data[8] = -s;
        m.data[10] = c;
        return m;
    }
}

