/*
 * Decompiled with CFR 0.152.
 */
package heartbeat;

import heartbeat.HeartSound;
import heartbeat.Runner;
import heartbeat.Timer;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;

public class HeartBeat
extends Applet {
    private static boolean myIsApplet = true;
    private Timer myTimer;
    private HeartSound mySound;
    private Runner myRunner;

    public void stop() {
        this.myTimer.setActive(false);
        this.myTimer.setListener(null);
        this.mySound.setActive(false);
        this.mySound.setSound(null);
    }

    public void destroy() {
        this.myTimer.interrupt();
    }

    public static void main(String[] args) {
        myIsApplet = false;
        HeartBeat prg = new HeartBeat();
        prg.init();
        prg.start();
        Frame f = new Frame("Intro");
        ((Component)f).setSize(430, 280);
        f.setLayout(new BorderLayout());
        f.add((Component)prg, "Center");
        f.show();
        f.repaint();
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public void start() {
        this.myTimer.setListener(this.myRunner);
        this.myTimer.setActive(true);
        this.mySound.setActive(true);
        AudioClip sound = null;
        if (myIsApplet) {
            sound = this.getAudioClip(this.getCodeBase(), "heart.au");
        } else {
            try {
                sound = this.getAudioClip(new URL(System.getProperty("user.dir")), "heart.au");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (sound != null) {
            sound.play();
        }
        this.mySound.setSound(sound);
    }

    public void init() {
        this.myTimer = new Timer();
        this.myTimer.setPause(50);
        this.myTimer.start();
        this.mySound = new HeartSound();
        this.mySound.start();
        this.myRunner = new Runner(this.mySound);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myRunner, "Center");
    }
}

