/*
 * Decompiled with CFR 0.152.
 */
package heartbeat;

import heartbeat.Matrix;
import heartbeat.Vec;

public class Camera {
    private Vec myPos;
    private Vec myDir;

    public Camera(Vec pos) {
        this.myPos = pos;
        this.myDir = new Vec(0.0f, 0.0f, 1.0f);
    }

    public Camera() {
        this(new Vec());
    }

    public void lookAt(Vec dest) {
        this.myDir = dest.sub(this.myPos);
        this.myDir.normalize();
    }

    public Matrix getMatrix() {
        Matrix move = Matrix.transform(this.myPos.neg());
        return this.getRotationMatrix().multiply(move);
    }

    public Matrix getRotationMatrix() {
        return Matrix.makeRotationMatrix(this.myDir, new Vec(0.0f, 1.0f, 0.0f));
    }

    public Vec getPos() {
        return this.myPos;
    }

    public void setPos(Vec pos) {
        this.myPos = pos;
    }
}

