/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionInfoVisitor;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.visitor.CpInfoVisitor;

public class BranchTargetFinder
implements AttrInfoVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
CpInfoVisitor {
    private static final byte INSTRUCTION = 1;
    private static final byte BRANCH_ORIGIN = 2;
    private static final byte BRANCH_TARGET = 4;
    private static final byte INITIALIZER = 8;
    private static final byte EXCEPTION_START = 16;
    private static final byte EXCEPTION_END = 32;
    private static final byte EXCEPTION_HANDLER = 64;
    private byte[] instructionMarks;
    private boolean isInitializer;

    public BranchTargetFinder(int n) {
        this.instructionMarks = new byte[n + 1];
    }

    public boolean isInstruction(int n) {
        return (this.instructionMarks[n] & 1) != 0;
    }

    public boolean isTarget(int n) {
        return (this.instructionMarks[n] & 0x74) != 0;
    }

    public boolean isBranchOrigin(int n) {
        return (this.instructionMarks[n] & 2) != 0;
    }

    public boolean isBranchTarget(int n) {
        return (this.instructionMarks[n] & 4) != 0;
    }

    public boolean isExceptionStart(int n) {
        return (this.instructionMarks[n] & 0x10) != 0;
    }

    public boolean isExceptionEnd(int n) {
        return (this.instructionMarks[n] & 0x20) != 0;
    }

    public boolean isExceptionHandler(int n) {
        return (this.instructionMarks[n] & 0x40) != 0;
    }

    public boolean isInitializer(int n) {
        return (this.instructionMarks[n] & 8) != 0;
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        int n = codeAttrInfo.u4codeLength + 1;
        if (this.instructionMarks.length < n) {
            this.instructionMarks = new byte[n];
        } else {
            for (int i = 0; i < n; ++i) {
                this.instructionMarks[i] = 0;
            }
        }
        this.instructionMarks[0] = 4;
        this.instructionMarks[codeAttrInfo.u4codeLength] = 4;
        codeAttrInfo.instructionsAccept(classFile, methodInfo, this);
        codeAttrInfo.exceptionsAccept(classFile, methodInfo, this);
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
        int n2 = n;
        this.instructionMarks[n2] = (byte)(this.instructionMarks[n2] | 1);
        byte by = simpleInstruction.opcode;
        if (by == -87 || by == -84 || by == -83 || by == -82 || by == -81 || by == -80 || by == -65) {
            int n3 = n;
            this.instructionMarks[n3] = (byte)(this.instructionMarks[n3] | 2);
        }
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        int n2 = n;
        this.instructionMarks[n2] = (byte)(this.instructionMarks[n2] | 1);
        this.isInitializer = false;
        classFile.constantPoolEntryAccept(cpInstruction.cpIndex, this);
        if (this.isInitializer) {
            int n3 = n;
            this.instructionMarks[n3] = (byte)(this.instructionMarks[n3] | 8);
        }
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
        int n2 = n;
        this.instructionMarks[n2] = (byte)(this.instructionMarks[n2] | 1);
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
        int n2 = n;
        this.instructionMarks[n2] = (byte)(this.instructionMarks[n2] | 3);
        int n3 = n + branchInstruction.branchOffset;
        this.instructionMarks[n3] = (byte)(this.instructionMarks[n3] | 4);
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
        int n2 = n;
        this.instructionMarks[n2] = (byte)(this.instructionMarks[n2] | 3);
        int n3 = n + tableSwitchInstruction.defaultOffset;
        this.instructionMarks[n3] = (byte)(this.instructionMarks[n3] | 4);
        this.markBranchTargets(n, tableSwitchInstruction.jumpOffsets, tableSwitchInstruction.highCase - tableSwitchInstruction.lowCase + 1);
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        int n2 = n;
        this.instructionMarks[n2] = (byte)(this.instructionMarks[n2] | 3);
        int n3 = n + lookUpSwitchInstruction.defaultOffset;
        this.instructionMarks[n3] = (byte)(this.instructionMarks[n3] | 4);
        this.markBranchTargets(n, lookUpSwitchInstruction.jumpOffsets, lookUpSwitchInstruction.jumpOffsetCount);
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        this.isInitializer = methodrefCpInfo.getName(classFile).equals("<init>");
    }

    public void visitExceptionInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, ExceptionInfo exceptionInfo) {
        int n = exceptionInfo.u2startpc;
        this.instructionMarks[n] = (byte)(this.instructionMarks[n] | 0x10);
        int n2 = exceptionInfo.u2endpc;
        this.instructionMarks[n2] = (byte)(this.instructionMarks[n2] | 0x20);
        int n3 = exceptionInfo.u2handlerpc;
        this.instructionMarks[n3] = (byte)(this.instructionMarks[n3] | 0x40);
    }

    private void markBranchTargets(int n, int[] nArray, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = n + nArray[i];
            this.instructionMarks[n3] = (byte)(this.instructionMarks[n3] | 4);
        }
    }
}

