/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.KeyEvent;
import java.awt.image.BufferStrategy;
import javax.swing.JFrame;

public class R
extends JFrame {
    private boolean[] controls = new boolean[20];
    private byte[] board = new byte[2250];
    private double xp;
    private double yp;
    private double zp;
    private double ang;
    private double vx;
    private double vy;
    private double vz;
    private double dx;
    private double dy;
    private int l = 0;
    private int[] timers = new int[12];
    private boolean started;
    private String msg;
    private boolean complete;
    private int toggles;
    private int lastX;
    private int lastY;
    private boolean transport;
    private int[][] ports = new int[100][2];

    public static void main(String[] stringArray) {
        System.setProperty("sun.java2d.noddraw", "");
        new R();
    }

    private R() {
        super("Ball");
        this.setSize(640, 510);
        this.setResizable(false);
        this.show();
        this.setIconImage(this.createImage(16, 16));
        this.enableEvents(56L);
        this.createBufferStrategy(2);
        BufferStrategy bufferStrategy = this.getBufferStrategy();
        this.init();
        long l = 0L;
        while (true) {
            int n = (int)(System.currentTimeMillis() - l);
            int n2 = 0;
            while (n2 < n / 10) {
                this.logic(10);
                ++n2;
            }
            this.logic(n % 10);
            l = System.currentTimeMillis();
            this.draw((Graphics2D)bufferStrategy.getDrawGraphics());
            bufferStrategy.show();
            if (this.isVisible()) continue;
            System.exit(0);
        }
    }

    public int getTile(int n, int n2) {
        int n3 = this.l * 450 + n2 * 15 + n / 2;
        byte by = this.board[n3];
        by = (byte)(by >> n % 2 * 4);
        by = (byte)(by & 0xF);
        return by;
    }

    private void init() {
        try {
            Thread.currentThread().getContextClassLoader().getResourceAsStream("d").read(this.board);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.zp = 0.0;
        this.xp = 0.5;
        this.yp = 0.5;
        this.vx = 0.0;
        this.vy = 0.0;
        this.started = false;
        this.msg = "PRESS ENTER";
        int[] nArray = new int[]{80, 80, 99, 99, 99};
        this.timers[0] = nArray[this.l] * 1000;
        this.toggles = 0;
        if (this.complete) {
            ++this.l;
            if (this.l >= 5) {
                this.l = 0;
            }
        }
        this.ports[99][0] = 0;
        int n = 0;
        while (n < 30) {
            int n2 = 0;
            while (n2 < 30) {
                int n3 = this.getTile(n, n2);
                if (n3 == 3) {
                    this.xp = (double)n + 0.5;
                    this.yp = (double)n2 + 0.5;
                }
                if (n3 == 14) {
                    ++this.toggles;
                }
                if (n3 == 12) {
                    this.ports[this.ports[99][0]][0] = n;
                    this.ports[this.ports[99][0]][1] = n2;
                    int[] nArray2 = this.ports[99];
                    nArray2[0] = nArray2[0] + 1;
                }
                ++n2;
            }
            ++n;
        }
        this.complete = false;
    }

    private void logic(int n) {
        if (!this.started) {
            return;
        }
        if (this.timers[11] > 0) {
            this.timers[11] = this.timers[11] - n;
            if (this.timers[0] > 0) {
                if (this.complete) {
                    this.msg = "Level Complete!";
                    this.zp += (double)n;
                } else {
                    this.msg = "Try Again";
                    this.zp -= (double)n;
                }
            }
            if (this.timers[11] <= 0) {
                this.init();
            }
            return;
        }
        this.timers[0] = this.timers[0] - n;
        this.timers[1] = this.timers[1] - n;
        this.timers[2] = this.timers[2] + n;
        boolean bl = this.controls[19] = this.timers[2] / 1500 % 2 == 0;
        if (this.timers[0] <= 0) {
            this.timers[0] = 0;
            this.msg = "Time Out";
            this.timers[11] = 2000;
            return;
        }
        if (this.controls[5]) {
            this.ang -= 0.005 * (double)n;
        }
        if (this.controls[6]) {
            this.ang += 0.005 * (double)n;
        }
        if (this.controls[7]) {
            if (!this.controls[18]) {
                this.controls[18] = true;
                int n2 = this.timers[8];
                this.timers[8] = n2 - 1;
                this.ang = (double)(n2 % 4) * 1.5707963267948966;
            }
        } else {
            this.controls[18] = false;
        }
        this.dx = Math.sin(this.ang);
        this.dy = Math.cos(this.ang);
        if (this.controls[1]) {
            this.vx += this.dy * (double)n * 1.0E-5;
            this.vy -= this.dx * (double)n * 1.0E-5;
        }
        if (this.controls[0]) {
            this.vx -= this.dy * (double)n * 1.0E-5;
            this.vy += this.dx * (double)n * 1.0E-5;
        }
        if (this.controls[2]) {
            this.vx += this.dx * (double)n * 1.0E-5;
            this.vy += this.dy * (double)n * 1.0E-5;
        }
        if (this.controls[3]) {
            this.vx -= this.dx * (double)n * 1.0E-5;
            this.vy -= this.dy * (double)n * 1.0E-5;
        }
        if (this.vx > 0.008) {
            this.vx = 0.008;
        }
        if (this.vx < -0.008) {
            this.vx = -0.008;
        }
        if (this.vy > 0.008) {
            this.vy = 0.008;
        }
        if (this.vy < -0.008) {
            this.vy = -0.008;
        }
        if (this.zp > 0.0) {
            this.vz -= 0.0098 * (double)n * 0.5;
        } else {
            this.vz = 0.0;
            this.zp = 0.0;
        }
        if (this.controls[4] && this.timers[1] <= 0) {
            this.vz = 1.0;
            this.timers[1] = 500;
        }
        this.vx *= 0.997;
        this.vy *= 0.997;
        this.xp += this.vx * (double)n;
        this.yp += this.vy * (double)n;
        this.zp += this.vz * (double)n;
        if (this.lastX != (int)this.xp || this.lastY != (int)this.yp) {
            if (this.getTile(this.lastX, this.lastY) == 2) {
                this.setTile(this.lastX, this.lastY, (byte)0);
            }
            this.lastX = (int)this.xp;
            this.lastY = (int)this.yp;
        }
        if (this.xp < 0.0 || this.yp < 0.0 || this.xp >= 30.0 || this.yp >= 30.0) {
            this.timers[11] = 2000;
            return;
        }
        int n3 = this.getTile(this.lastX, this.lastY);
        if (n3 == 11 && !this.controls[19]) {
            n3 = 0;
        }
        if (n3 == 0 && this.zp == 0.0) {
            this.timers[11] = 2000;
            return;
        }
        if (n3 == 13 && this.toggles <= 0) {
            this.complete = true;
            this.timers[11] = 2000;
            return;
        }
        if (n3 == 14) {
            this.setTile(this.lastX, this.lastY, (byte)15);
            --this.toggles;
        }
        if (n3 == 12) {
            if (!this.transport && this.zp == 0.0) {
                this.transport = true;
                int n4 = (int)(Math.random() * (double)(this.ports[99][0] - 1));
                if (this.ports[n4][0] == this.lastX && this.ports[n4][1] == this.lastY) {
                    ++n4;
                }
                this.xp = (double)this.ports[n4][0] + 0.5;
                this.yp = (double)this.ports[n4][1] + 0.5;
                this.vx = 0.0;
                this.vy = 0.0;
            }
        } else {
            this.transport = false;
        }
    }

    public void setTile(int n, int n2, byte by) {
        int n3 = this.l * 450 + n2 * 15 + n / 2;
        byte by2 = this.board[n3];
        if (n % 2 == 1) {
            by = (byte)(by << 4);
            by2 = (byte)(by2 & 0xF);
        } else {
            by2 = (byte)(by2 & 0xF0);
        }
        this.board[n3] = by2 = (byte)(by2 | by);
    }

    private int addPoint(double d, double d2, Polygon polygon) {
        int[] nArray = this.getPoint(d, d2);
        if (nArray[0] < -100) {
            return 0;
        }
        if (nArray[1] > 600) {
            return 0;
        }
        polygon.addPoint(nArray[0], nArray[1]);
        return 1;
    }

    private int[] getPoint(double d, double d2) {
        double d3 = d - this.xp;
        double d4 = d2 - this.yp;
        double d5 = Math.cos(this.ang);
        double d6 = Math.sin(this.ang);
        double d7 = d3 * d5 + d4 * -d6;
        double d8 = d3 * d6 + d4 * d5;
        d7 = 500.0 * (d7 / ((d8 += 5.0) + 10.0)) * 1.5 + 320.0;
        d8 = 500.0 - 500.0 * (d8 / (d8 + 10.0)) * 1.5;
        return new int[]{(int)d7, (int)d8};
    }

    private void draw(Graphics2D graphics2D) {
        Color[] colorArray = new Color[]{Color.red, Color.green, Color.blue};
        graphics2D.setColor(Color.black);
        graphics2D.fillRect(0, 0, 640, 510);
        graphics2D.translate(0, 30);
        if (this.zp < 0.0) {
            this.drawBall(graphics2D);
        }
        Color[] colorArray2 = new Color[16];
        colorArray2[3] = Color.white;
        colorArray2[12] = colorArray[this.timers[0] / 100 % 3];
        colorArray2[13] = Color.black;
        colorArray2[14] = Color.gray;
        colorArray2[15] = Color.yellow;
        int n = 0;
        while (n < 30) {
            int n2 = 0;
            while (n2 < 30) {
                int n3 = this.getTile(n, n2);
                if (n3 != 0) {
                    Polygon polygon = new Polygon();
                    int n4 = this.addPoint(n, n2, polygon);
                    n4 += this.addPoint(n + 1, n2, polygon);
                    n4 += this.addPoint(n + 1, n2 + 1, polygon);
                    if ((n4 += this.addPoint(n, n2 + 1, polygon)) == 4 && (n3 != 11 || this.controls[19])) {
                        if (n3 == 13 && this.toggles > 0) {
                            n3 = 1;
                        }
                        Color color = colorArray[this.l % 3];
                        if ((n + n2) % 2 == 0) {
                            color = colorArray[this.l % 3].darker();
                        }
                        if (colorArray2[n3] != null) {
                            color = colorArray2[n3];
                        }
                        graphics2D.setColor(color);
                        graphics2D.fillPolygon(polygon);
                        if (n3 > 10) {
                            graphics2D.setColor(Color.darkGray);
                            if (n3 == 11) {
                                graphics2D.setColor(color.darker());
                            }
                            graphics2D.fillPolygon(polygon);
                            Polygon polygon2 = new Polygon();
                            this.addPoint((double)n + 0.1, (double)n2 + 0.1, polygon2);
                            this.addPoint((double)n + 0.9, (double)n2 + 0.1, polygon2);
                            this.addPoint((double)n + 0.9, (double)n2 + 0.9, polygon2);
                            this.addPoint((double)n + 0.1, (double)n2 + 0.9, polygon2);
                            graphics2D.setColor(color);
                            graphics2D.fillPolygon(polygon2);
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
        if (this.zp >= 0.0) {
            this.drawBall(graphics2D);
        }
        graphics2D.setColor(Color.black);
        graphics2D.fillRect(0, -20, 640, 45);
        graphics2D.setColor(Color.darkGray);
        graphics2D.drawLine(0, 25, 640, 25);
        graphics2D.setFont(graphics2D.getFont().deriveFont(1, 20.0f));
        graphics2D.setPaint(new GradientPaint(0.0f, 20.0f, Color.green, 0.0f, 0.0f, Color.white));
        graphics2D.drawString("Time: " + this.timers[0] / 1000, 530, 20);
        graphics2D.drawString("Ball", 20, 20);
        graphics2D.setPaint(new GradientPaint(0.0f, 20.0f, Color.yellow, 0.0f, 0.0f, Color.white));
        graphics2D.drawString(this.msg, (640 - graphics2D.getFontMetrics().stringWidth(this.msg)) / 2, 20);
        if (!this.started) {
            this.ang += (double)0.01f;
            graphics2D.drawString("Cursors - Move     PgUp/PgDown - View    Space - Jump", 60, 470);
        }
    }

    private void drawBall(Graphics2D graphics2D) {
        int[] nArray = this.getPoint(this.xp, this.yp);
        graphics2D.translate((double)nArray[0], (double)nArray[1] - this.zp);
        graphics2D.scale(1.5, 1.5);
        if (this.timers[11] <= 0 || this.timers[0] <= 0) {
            graphics2D.setColor(Color.black);
            int n = (int)(this.zp / 50.0);
            graphics2D.fillOval(-10 + n, (int)((double)(-5 + n) + this.zp), 20 - n * 2, 10 - n * 2);
        }
        graphics2D.setColor(Color.gray);
        graphics2D.fillOval(-10, -20, 20, 20);
        graphics2D.setColor(Color.darkGray);
        graphics2D.drawArc(-8, -18, 18, 18, 270, 90);
        graphics2D.setColor(Color.lightGray);
        graphics2D.fillOval(-7, -17, 5, 5);
        graphics2D.setColor(Color.white);
        graphics2D.fillOval(-6, -16, 2, 2);
        graphics2D.scale(0.6666666666666666, 0.6666666666666666);
        graphics2D.translate((double)(-nArray[0]), -((double)nArray[1] - this.zp));
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        int[] nArray = new int[]{37, 39, 38, 40, 32, 33, 34, 35};
        int n = 0;
        while (n < 8) {
            if (keyEvent.getKeyCode() == nArray[n]) {
                this.controls[n] = keyEvent.getID() == 401;
            }
            ++n;
        }
        if (keyEvent.getKeyCode() == 10 && !this.started) {
            this.started = true;
            this.msg = "Level " + (this.l + 1);
            this.ang = 0.0;
        }
        if (keyEvent.getKeyCode() == 27) {
            System.exit(0);
        }
    }
}

