/*
 * Decompiled with CFR 0.152.
 */
package runAwayPackage;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Random;

public class RunAway
extends Applet
implements Runnable,
KeyListener {
    Random rnd = new Random();
    int gameStatus;
    int score;
    int bestScore;
    int playerX;
    int playerY;
    int numEnemies;
    int[] xPos = new int[50];
    int[] yPos = new int[50];
    int[] xSpd = new int[50];
    int[] ySpd = new int[50];
    boolean upKey;
    boolean downKey;
    boolean leftKey;
    boolean rightKey;
    private Image dbImage;
    private Graphics dbg;

    @Override
    public void init() {
        this.addKeyListener(this);
        this.setSize(440, 440);
    }

    @Override
    public void start() {
        this.gameStatus = 0;
        this.bestScore = 0;
        this.score = 0;
        this.playerY = 190;
        this.playerX = 190;
        this.numEnemies = 0;
        this.rightKey = false;
        this.leftKey = false;
        this.downKey = false;
        this.upKey = false;
        Thread th = new Thread(this);
        th.start();
    }

    @Override
    public void run() {
        while (true) {
            if (this.gameStatus == 0) {
                continue;
            }
            if (this.upKey) {
                --this.playerY;
                if (this.playerY < 20) {
                    this.playerY = 20;
                }
            } else if (this.downKey) {
                ++this.playerY;
                if (this.playerY > 400) {
                    this.playerY = 400;
                }
            }
            if (this.leftKey) {
                --this.playerX;
                if (this.playerX < 20) {
                    this.playerX = 20;
                }
            } else if (this.rightKey) {
                ++this.playerX;
                if (this.playerX > 400) {
                    this.playerX = 400;
                }
            }
            if (this.score % 381 == 0 && this.numEnemies < 50) {
                if (this.rnd.nextInt(2) == 0) {
                    this.xPos[this.numEnemies] = -10 + this.rnd.nextInt(2) * 440;
                    this.yPos[this.numEnemies] = this.playerY + 5;
                    this.xSpd[this.numEnemies] = 1;
                    this.ySpd[this.numEnemies] = 0;
                } else {
                    this.xPos[this.numEnemies] = this.playerX + 5;
                    this.yPos[this.numEnemies] = -10 + this.rnd.nextInt(2) * 440;
                    this.xSpd[this.numEnemies] = 0;
                    this.ySpd[this.numEnemies] = 1;
                }
                ++this.numEnemies;
            }
            int i = 0;
            while (i < this.numEnemies) {
                if (this.xPos[i] < 20) {
                    this.xSpd[i] = 1;
                } else if (this.xPos[i] > 410) {
                    this.xSpd[i] = -1;
                }
                if (this.yPos[i] < 20) {
                    this.ySpd[i] = 1;
                } else if (this.yPos[i] > 410) {
                    this.ySpd[i] = -1;
                }
                int n = i;
                this.xPos[n] = this.xPos[n] + this.xSpd[i];
                int n2 = i;
                this.yPos[n2] = this.yPos[n2] + this.ySpd[i];
                if (-20 < this.playerX - this.xPos[i] && this.playerX - this.xPos[i] < 10 && -20 < this.playerY - this.yPos[i] && this.playerY - this.yPos[i] < 10) {
                    this.gameStatus = 0;
                }
                ++i;
            }
            ++this.score;
            this.repaint();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (this.gameStatus == 0) {
            if (key == 32) {
                if (this.score > this.bestScore) {
                    this.bestScore = this.score;
                }
                this.score = 0;
                this.playerY = 190;
                this.playerX = 190;
                this.numEnemies = 0;
                this.gameStatus = 1;
            }
            return;
        }
        switch (key) {
            case 38: {
                this.downKey = false;
                this.upKey = true;
                break;
            }
            case 40: {
                this.upKey = false;
                this.downKey = true;
                break;
            }
            case 37: {
                this.rightKey = false;
                this.leftKey = true;
                break;
            }
            case 39: {
                this.leftKey = false;
                this.rightKey = true;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        switch (key) {
            case 38: {
                this.upKey = false;
                break;
            }
            case 40: {
                this.downKey = false;
                break;
            }
            case 37: {
                this.leftKey = false;
                break;
            }
            case 39: {
                this.rightKey = false;
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.yellow);
        g.fillRect(0, 0, 440, 440);
        g.setColor(Color.white);
        g.fillRect(20, 20, 400, 400);
        g.setColor(Color.blue);
        g.fillRect(this.playerX, this.playerY, 20, 20);
        g.setColor(Color.red);
        int i = 0;
        while (i < this.numEnemies) {
            g.fillRect(this.xPos[i], this.yPos[i], 10, 10);
            ++i;
        }
        g.setColor(Color.black);
        g.drawString("Score: " + this.score / 100, 5, 15);
        g.drawString("Best Score: " + this.bestScore / 100, 5, 435);
        if (this.gameStatus == 0) {
            g.setColor(Color.black);
            g.drawString("PRESS SPACEBAR TO START A NEW GAME!", 100, 350);
        }
    }

    @Override
    public void update(Graphics g) {
        if (this.dbImage == null) {
            this.dbImage = this.createImage(this.getSize().width, this.getSize().height);
            this.dbg = this.dbImage.getGraphics();
        }
        this.dbg.setColor(this.getBackground());
        this.dbg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.dbg.setColor(this.getForeground());
        this.paint(this.dbg);
        g.drawImage(this.dbImage, 0, 0, this);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

