/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.ConfigurationWriter;
import proguard.ParseException;
import proguard.classfile.util.ClassUtil;
import proguard.gui.ClassPathPanel;
import proguard.gui.ClassSpecificationsPanel;
import proguard.gui.ExtensionFileFilter;
import proguard.gui.GUIResources;
import proguard.gui.ProGuardRunnable;
import proguard.gui.ReTraceRunnable;
import proguard.gui.TabbedPane;
import proguard.gui.TextAreaOutputStream;
import proguard.gui.splash.CompositeSprite;
import proguard.gui.splash.ConstantColor;
import proguard.gui.splash.ConstantDouble;
import proguard.gui.splash.ConstantFont;
import proguard.gui.splash.ConstantInt;
import proguard.gui.splash.ConstantString;
import proguard.gui.splash.LinearInt;
import proguard.gui.splash.LinearTiming;
import proguard.gui.splash.ShadowedSprite;
import proguard.gui.splash.SmoothTiming;
import proguard.gui.splash.SplashPanel;
import proguard.gui.splash.Sprite;
import proguard.gui.splash.TextSprite;
import proguard.gui.splash.TypeWriterString;
import proguard.util.ListUtil;

public class ProGuardGUI
extends JFrame {
    private static final String NO_SPLASH_OPTION = "-nosplash";
    private static final String TITLE_IMAGE_FILE = "vtitle.gif";
    private static final String BOILERPLATE_CONFIGURATION = "boilerplate.pro";
    private static final String DEFAULT_CONFIGURATION = "default.pro";
    private static final String KEEP_ATTRIBUTE_DEFAULT = "InnerClasses,SourceFile,LineNumberTable,Deprecated,Signature,*Annotation*,EnclosingMethod";
    private static final String SOURCE_FILE_ATTRIBUTE_DEFAULT = "SourceFile";
    private static final Border BORDER = BorderFactory.createEtchedBorder(0);
    static boolean systemOutRedirected;
    private JFileChooser configurationChooser = new JFileChooser("");
    private JFileChooser fileChooser = new JFileChooser("");
    private SplashPanel splashPanel;
    private ClassPathPanel programPanel = new ClassPathPanel(this, true);
    private ClassPathPanel libraryPanel = new ClassPathPanel(this, false);
    private ClassSpecification[] boilerplateKeep;
    private JCheckBox[] boilerplateKeepCheckBoxes;
    private JTextField[] boilerplateKeepTextFields;
    private ClassSpecificationsPanel additionalKeepPanel = new ClassSpecificationsPanel(this, true);
    private ClassSpecification[] boilerplateKeepNames;
    private JCheckBox[] boilerplateKeepNamesCheckBoxes;
    private JTextField[] boilerplateKeepNamesTextFields;
    private ClassSpecificationsPanel additionalKeepNamesPanel = new ClassSpecificationsPanel(this, true);
    private ClassSpecification[] boilerplateNoSideEffectMethods;
    private JCheckBox[] boilerplateNoSideEffectMethodCheckBoxes;
    private ClassSpecificationsPanel additionalNoSideEffectsPanel = new ClassSpecificationsPanel(this, false);
    private ClassSpecificationsPanel whyAreYouKeepingPanel = new ClassSpecificationsPanel(this, false);
    private JCheckBox shrinkCheckBox = new JCheckBox(this.msg("shrink"));
    private JCheckBox printUsageCheckBox = new JCheckBox(this.msg("printUsage"));
    private JCheckBox optimizeCheckBox = new JCheckBox(this.msg("optimize"));
    private JCheckBox allowAccessModificationCheckBox = new JCheckBox(this.msg("allowAccessModification"));
    private JCheckBox obfuscateCheckBox = new JCheckBox(this.msg("obfuscate"));
    private JCheckBox printMappingCheckBox = new JCheckBox(this.msg("printMapping"));
    private JCheckBox applyMappingCheckBox = new JCheckBox(this.msg("applyMapping"));
    private JCheckBox obfuscationDictionaryCheckBox = new JCheckBox(this.msg("obfuscationDictionary"));
    private JCheckBox overloadAggressivelyCheckBox = new JCheckBox(this.msg("overloadAggressively"));
    private JCheckBox defaultPackageCheckBox = new JCheckBox(this.msg("defaultPackage"));
    private JCheckBox useMixedCaseClassNamesCheckBox = new JCheckBox(this.msg("useMixedCaseClassNames"));
    private JCheckBox keepAttributesCheckBox = new JCheckBox(this.msg("keepAttributes"));
    private JCheckBox newSourceFileAttributeCheckBox = new JCheckBox(this.msg("renameSourceFileAttribute"));
    private JCheckBox printSeedsCheckBox = new JCheckBox(this.msg("printSeeds"));
    private JCheckBox verboseCheckBox = new JCheckBox(this.msg("verbose"));
    private JCheckBox ignoreWarningsCheckBox = new JCheckBox(this.msg("ignoreWarnings"));
    private JCheckBox warnCheckBox = new JCheckBox(this.msg("warn"));
    private JCheckBox noteCheckBox = new JCheckBox(this.msg("note"));
    private JCheckBox skipNonPublicLibraryClassesCheckBox = new JCheckBox(this.msg("skipNonPublicLibraryClasses"));
    private JCheckBox skipNonPublicLibraryClassMembersCheckBox = new JCheckBox(this.msg("skipNonPublicLibraryClassMembers"));
    private JTextField printUsageTextField = new JTextField(40);
    private JTextField printMappingTextField = new JTextField(40);
    private JTextField applyMappingTextField = new JTextField(40);
    private JTextField obfuscationDictionaryTextField = new JTextField(40);
    private JTextField defaultPackageTextField = new JTextField(40);
    private JTextField keepAttributesTextField = new JTextField(40);
    private JTextField newSourceFileAttributeTextField = new JTextField(40);
    private JTextField printSeedsTextField = new JTextField(40);
    private JTextArea consoleTextArea = new JTextArea(this.msg("processingInfo"), 3, 40);
    private JTextField reTraceMappingTextField = new JTextField(40);
    private JCheckBox reTraceVerboseCheckBox = new JCheckBox(this.msg("verbose"));
    private JTextArea stackTraceTextArea = new JTextArea(3, 40);
    private JTextArea reTraceTextArea = new JTextArea(this.msg("reTraceInfo"), 3, 40);

    public ProGuardGUI() {
        this.setTitle("ProGuard");
        this.setDefaultCloseOperation(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridwidth = 0;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 0.02;
        gridBagConstraints5.anchor = 18;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridwidth = 0;
        gridBagConstraints6.fill = 0;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 0.01;
        gridBagConstraints6.anchor = 10;
        gridBagConstraints6.insets = new Insets(20, 40, 20, 40);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridwidth = 0;
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.anchor = 18;
        gridBagConstraints7.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridwidth = 0;
        gridBagConstraints8.fill = 1;
        gridBagConstraints8.weightx = 1.0;
        gridBagConstraints8.weighty = 1.0;
        gridBagConstraints8.anchor = 18;
        gridBagConstraints8.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.fill = 1;
        gridBagConstraints9.weightx = 0.01;
        gridBagConstraints9.weighty = 0.01;
        gridBagConstraints9.anchor = 18;
        gridBagConstraints9.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.anchor = 14;
        gridBagConstraints10.insets = new Insets(2, 2, 4, 6);
        gridBagConstraints10.ipadx = 10;
        gridBagConstraints10.ipady = 2;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridwidth = 0;
        gridBagConstraints11.anchor = 14;
        gridBagConstraints11.insets = gridBagConstraints10.insets;
        gridBagConstraints11.ipadx = gridBagConstraints10.ipadx;
        gridBagConstraints11.ipady = gridBagConstraints10.ipady;
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            gridBagConstraints11.insets = new Insets(2, 2, 4, 22);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.configurationChooser.addChoosableFileFilter(new ExtensionFileFilter(this.msg("proExtension"), new String[]{".pro"}));
        Font font = new Font("sansserif", 1, 50);
        Color color = Color.white;
        CompositeSprite compositeSprite = new CompositeSprite(new Sprite[]{new TextSprite(new ConstantString("ProGuard"), new ConstantFont(new Font("sansserif", 1, 90)), new ConstantColor(Color.gray), new ConstantInt(160), new LinearInt(-10, 120, new SmoothTiming(500L, 1000L))), new ShadowedSprite(new ConstantInt(3), new ConstantInt(3), new ConstantDouble(0.4), new ConstantInt(2), new CompositeSprite(new Sprite[]{new TextSprite(new ConstantString(this.msg("shrinking")), new ConstantFont(font), new ConstantColor(color), new LinearInt(1000, 60, new SmoothTiming(1000L, 2000L)), new ConstantInt(70)), new TextSprite(new ConstantString(this.msg("optimization")), new ConstantFont(font), new ConstantColor(color), new LinearInt(1000, 400, new SmoothTiming(1500L, 2500L)), new ConstantInt(60)), new TextSprite(new ConstantString(this.msg("obfuscation")), new ConstantFont(font), new ConstantColor(color), new LinearInt(1000, 350, new SmoothTiming(2000L, 3000L)), new ConstantInt(140)), new TextSprite(new TypeWriterString(this.msg("developed"), new LinearTiming(3000L, 5000L)), new ConstantFont(new Font("monospaced", 1, 20)), new ConstantColor(color), new ConstantInt(250), new ConstantInt(170))}))});
        this.splashPanel = new SplashPanel(compositeSprite, 0.5, 5000L);
        this.splashPanel.setPreferredSize(new Dimension(0, 200));
        JTextArea jTextArea = new JTextArea(this.msg("proGuardInfo"), 18, 50);
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setPreferredSize(new Dimension(0, 0));
        jTextArea.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.addBorder(jTextArea, "welcome");
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.add((Component)this.splashPanel, gridBagConstraints5);
        jPanel.add((Component)jTextArea, gridBagConstraints6);
        this.programPanel.addCopyToPanelButton(this.msg("moveToLibraries"), this.libraryPanel);
        this.libraryPanel.addCopyToPanelButton(this.msg("moveToProgram"), this.programPanel);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.programPanel.getButtons());
        arrayList.addAll(this.libraryPanel.getButtons());
        this.setCommonPreferredSize(arrayList);
        arrayList = null;
        this.addBorder(this.programPanel, "programJars");
        this.addBorder(this.libraryPanel, "libraryJars");
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.add((Component)this.programPanel, gridBagConstraints8);
        jPanel2.add((Component)this.libraryPanel, gridBagConstraints8);
        this.loadBoilerplateConfiguration();
        this.boilerplateKeepCheckBoxes = new JCheckBox[this.boilerplateKeep.length];
        this.boilerplateKeepTextFields = new JTextField[this.boilerplateKeep.length];
        JButton jButton = this.createBrowseButton(this.printUsageTextField, this.msg("selectUsageFile"));
        JPanel jPanel3 = new JPanel(gridBagLayout);
        this.addBorder(jPanel3, "options");
        jPanel3.add((Component)this.shrinkCheckBox, gridBagConstraints4);
        jPanel3.add((Component)this.printUsageCheckBox, gridBagConstraints);
        jPanel3.add((Component)this.printUsageTextField, gridBagConstraints2);
        jPanel3.add((Component)jButton, gridBagConstraints3);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        jPanel4.add((Component)jPanel3, gridBagConstraints7);
        this.addClassSpecifications(this.boilerplateKeep, jPanel4, this.boilerplateKeepCheckBoxes, this.boilerplateKeepTextFields);
        this.addBorder(this.additionalKeepPanel, "keepAdditional");
        jPanel4.add((Component)this.additionalKeepPanel, gridBagConstraints8);
        this.boilerplateKeepNamesCheckBoxes = new JCheckBox[this.boilerplateKeepNames.length];
        this.boilerplateKeepNamesTextFields = new JTextField[this.boilerplateKeepNames.length];
        JButton jButton2 = this.createBrowseButton(this.printMappingTextField, this.msg("selectPrintMappingFile"));
        JButton jButton3 = this.createBrowseButton(this.applyMappingTextField, this.msg("selectApplyMappingFile"));
        JButton jButton4 = this.createBrowseButton(this.obfuscationDictionaryTextField, this.msg("selectObfuscationDictionaryFile"));
        JPanel jPanel5 = new JPanel(gridBagLayout);
        this.addBorder(jPanel5, "options");
        jPanel5.add((Component)this.obfuscateCheckBox, gridBagConstraints4);
        jPanel5.add((Component)this.printMappingCheckBox, gridBagConstraints);
        jPanel5.add((Component)this.printMappingTextField, gridBagConstraints2);
        jPanel5.add((Component)jButton2, gridBagConstraints3);
        jPanel5.add((Component)this.applyMappingCheckBox, gridBagConstraints);
        jPanel5.add((Component)this.applyMappingTextField, gridBagConstraints2);
        jPanel5.add((Component)jButton3, gridBagConstraints3);
        jPanel5.add((Component)this.obfuscationDictionaryCheckBox, gridBagConstraints);
        jPanel5.add((Component)this.obfuscationDictionaryTextField, gridBagConstraints2);
        jPanel5.add((Component)jButton4, gridBagConstraints3);
        jPanel5.add((Component)this.overloadAggressivelyCheckBox, gridBagConstraints4);
        jPanel5.add((Component)this.defaultPackageCheckBox, gridBagConstraints);
        jPanel5.add((Component)this.defaultPackageTextField, gridBagConstraints4);
        jPanel5.add((Component)this.useMixedCaseClassNamesCheckBox, gridBagConstraints4);
        jPanel5.add((Component)this.keepAttributesCheckBox, gridBagConstraints);
        jPanel5.add((Component)this.keepAttributesTextField, gridBagConstraints4);
        jPanel5.add((Component)this.newSourceFileAttributeCheckBox, gridBagConstraints);
        jPanel5.add((Component)this.newSourceFileAttributeTextField, gridBagConstraints4);
        JPanel jPanel6 = new JPanel(gridBagLayout);
        jPanel6.add((Component)jPanel5, gridBagConstraints7);
        this.addClassSpecifications(this.boilerplateKeepNames, jPanel6, this.boilerplateKeepNamesCheckBoxes, this.boilerplateKeepNamesTextFields);
        this.addBorder(this.additionalKeepNamesPanel, "keepNamesAdditional");
        jPanel6.add((Component)this.additionalKeepNamesPanel, gridBagConstraints8);
        this.boilerplateNoSideEffectMethodCheckBoxes = new JCheckBox[this.boilerplateNoSideEffectMethods.length];
        JPanel jPanel7 = new JPanel(gridBagLayout);
        this.addBorder(jPanel7, "options");
        jPanel7.add((Component)this.optimizeCheckBox, gridBagConstraints4);
        jPanel7.add((Component)this.allowAccessModificationCheckBox, gridBagConstraints4);
        JPanel jPanel8 = new JPanel(gridBagLayout);
        jPanel8.add((Component)jPanel7, gridBagConstraints7);
        this.addClassSpecifications(this.boilerplateNoSideEffectMethods, jPanel8, this.boilerplateNoSideEffectMethodCheckBoxes, null);
        this.addBorder(this.additionalNoSideEffectsPanel, "assumeNoSideEffectsAdditional");
        jPanel8.add((Component)this.additionalNoSideEffectsPanel, gridBagConstraints8);
        JButton jButton5 = this.createBrowseButton(this.printSeedsTextField, this.msg("selectSeedsFile"));
        JPanel jPanel9 = new JPanel(gridBagLayout);
        this.addBorder(jPanel9, "consistencyAndCorrectness");
        jPanel9.add((Component)this.printSeedsCheckBox, gridBagConstraints);
        jPanel9.add((Component)this.printSeedsTextField, gridBagConstraints2);
        jPanel9.add((Component)jButton5, gridBagConstraints3);
        jPanel9.add((Component)this.verboseCheckBox, gridBagConstraints4);
        jPanel9.add((Component)this.noteCheckBox, gridBagConstraints4);
        jPanel9.add((Component)this.warnCheckBox, gridBagConstraints4);
        jPanel9.add((Component)this.ignoreWarningsCheckBox, gridBagConstraints4);
        jPanel9.add((Component)this.skipNonPublicLibraryClassesCheckBox, gridBagConstraints4);
        jPanel9.add((Component)this.skipNonPublicLibraryClassMembersCheckBox, gridBagConstraints4);
        this.setCommonPreferredSize(Arrays.asList(this.printMappingCheckBox, this.applyMappingCheckBox, this.defaultPackageCheckBox, this.newSourceFileAttributeCheckBox));
        JPanel jPanel10 = new JPanel(gridBagLayout);
        jPanel10.add((Component)jPanel9, gridBagConstraints7);
        this.addBorder(this.whyAreYouKeepingPanel, "whyAreYouKeeping");
        jPanel10.add((Component)this.whyAreYouKeepingPanel, gridBagConstraints8);
        this.consoleTextArea.setOpaque(false);
        this.consoleTextArea.setEditable(false);
        this.consoleTextArea.setLineWrap(false);
        this.consoleTextArea.setWrapStyleWord(false);
        JScrollPane jScrollPane = new JScrollPane(this.consoleTextArea);
        jScrollPane.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.addBorder(jScrollPane, "processingConsole");
        JPanel jPanel11 = new JPanel(gridBagLayout);
        jPanel11.add((Component)jScrollPane, gridBagConstraints8);
        JButton jButton6 = new JButton(this.msg("loadConfiguration"));
        jButton6.addActionListener(new MyLoadConfigurationActionListener());
        JButton jButton7 = new JButton(this.msg("viewConfiguration"));
        jButton7.addActionListener(new MyViewConfigurationActionListener());
        JButton jButton8 = new JButton(this.msg("saveConfiguration"));
        jButton8.addActionListener(new MySaveConfigurationActionListener());
        JButton jButton9 = new JButton(this.msg("process"));
        jButton9.addActionListener(new MyProcessActionListener());
        JPanel jPanel12 = new JPanel(gridBagLayout);
        this.addBorder(jPanel12, "reTraceSettings");
        JButton jButton10 = this.createBrowseButton(this.reTraceMappingTextField, this.msg("selectApplyMappingFile"));
        JLabel jLabel = new JLabel(this.msg("mappingFile"));
        jLabel.setForeground(this.reTraceVerboseCheckBox.getForeground());
        jPanel12.add((Component)jLabel, gridBagConstraints);
        jPanel12.add((Component)this.reTraceMappingTextField, gridBagConstraints2);
        jPanel12.add((Component)jButton10, gridBagConstraints3);
        jPanel12.add((Component)this.reTraceVerboseCheckBox, gridBagConstraints4);
        this.stackTraceTextArea.setOpaque(true);
        this.stackTraceTextArea.setEditable(true);
        this.stackTraceTextArea.setLineWrap(false);
        this.stackTraceTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.stackTraceTextArea);
        this.addBorder(jScrollPane2, "obfuscatedStackTrace");
        this.reTraceTextArea.setOpaque(false);
        this.reTraceTextArea.setEditable(false);
        this.reTraceTextArea.setLineWrap(true);
        this.reTraceTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane3 = new JScrollPane(this.reTraceTextArea);
        jScrollPane3.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.addBorder(jScrollPane3, "deobfuscatedStackTrace");
        JPanel jPanel13 = new JPanel(gridBagLayout);
        jPanel13.add((Component)jPanel12, gridBagConstraints7);
        jPanel13.add((Component)jScrollPane2, gridBagConstraints7);
        jPanel13.add((Component)jScrollPane3, gridBagConstraints8);
        JButton jButton11 = new JButton(this.msg("loadStackTrace"));
        jButton11.addActionListener(new MyLoadStackTraceActionListener());
        JButton jButton12 = new JButton(this.msg("reTrace"));
        jButton12.addActionListener(new MyReTraceActionListener());
        TabbedPane tabbedPane = new TabbedPane();
        tabbedPane.add(this.msg("proGuardTab"), jPanel);
        tabbedPane.add(this.msg("inputOutputTab"), jPanel2);
        tabbedPane.add(this.msg("shrinkingTab"), jPanel4);
        tabbedPane.add(this.msg("obfuscationTab"), jPanel6);
        tabbedPane.add(this.msg("optimizationTab"), jPanel8);
        tabbedPane.add(this.msg("informationTab"), jPanel10);
        tabbedPane.add(this.msg("processTab"), jPanel11);
        tabbedPane.add(this.msg("reTraceTab"), jPanel13);
        tabbedPane.addImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(TITLE_IMAGE_FILE)));
        jPanel.add(Box.createGlue(), gridBagConstraints9);
        jPanel.add((Component)jButton6, gridBagConstraints10);
        jPanel.add((Component)this.createNextButton(tabbedPane), gridBagConstraints11);
        jPanel2.add(Box.createGlue(), gridBagConstraints9);
        jPanel2.add((Component)this.createPreviousButton(tabbedPane), gridBagConstraints10);
        jPanel2.add((Component)this.createNextButton(tabbedPane), gridBagConstraints11);
        jPanel4.add(Box.createGlue(), gridBagConstraints9);
        jPanel4.add((Component)this.createPreviousButton(tabbedPane), gridBagConstraints10);
        jPanel4.add((Component)this.createNextButton(tabbedPane), gridBagConstraints11);
        jPanel6.add(Box.createGlue(), gridBagConstraints9);
        jPanel6.add((Component)this.createPreviousButton(tabbedPane), gridBagConstraints10);
        jPanel6.add((Component)this.createNextButton(tabbedPane), gridBagConstraints11);
        jPanel8.add(Box.createGlue(), gridBagConstraints9);
        jPanel8.add((Component)this.createPreviousButton(tabbedPane), gridBagConstraints10);
        jPanel8.add((Component)this.createNextButton(tabbedPane), gridBagConstraints11);
        jPanel10.add(Box.createGlue(), gridBagConstraints9);
        jPanel10.add((Component)this.createPreviousButton(tabbedPane), gridBagConstraints10);
        jPanel10.add((Component)this.createNextButton(tabbedPane), gridBagConstraints11);
        jPanel11.add(Box.createGlue(), gridBagConstraints9);
        jPanel11.add((Component)this.createPreviousButton(tabbedPane), gridBagConstraints10);
        jPanel11.add((Component)jButton7, gridBagConstraints10);
        jPanel11.add((Component)jButton8, gridBagConstraints10);
        jPanel11.add((Component)jButton9, gridBagConstraints11);
        jPanel13.add(Box.createGlue(), gridBagConstraints9);
        jPanel13.add((Component)jButton11, gridBagConstraints10);
        jPanel13.add((Component)jButton12, gridBagConstraints11);
        this.loadConfiguration(this.getClass().getResource(DEFAULT_CONFIGURATION));
        this.getContentPane().add(tabbedPane);
    }

    public void startSplash() {
        this.splashPanel.start();
    }

    public void skipSplash() {
        this.splashPanel.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBoilerplateConfiguration() {
        try {
            ConfigurationParser configurationParser = new ConfigurationParser(this.getClass().getResource(BOILERPLATE_CONFIGURATION));
            Configuration configuration = new Configuration();
            try {
                configurationParser.parse(configuration);
                this.boilerplateKeep = new ClassSpecification[configuration.keep.size()];
                configuration.keep.toArray(this.boilerplateKeep);
                this.boilerplateKeepNames = new ClassSpecification[configuration.keepNames.size()];
                configuration.keepNames.toArray(this.boilerplateKeepNames);
                this.boilerplateNoSideEffectMethods = new ClassSpecification[configuration.assumeNoSideEffects.size()];
                configuration.assumeNoSideEffects.toArray(this.boilerplateNoSideEffectMethods);
            }
            finally {
                configurationParser.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addClassSpecifications(ClassSpecification[] classSpecificationArray, JPanel jPanel, JCheckBox[] jCheckBoxArray, JTextField[] jTextFieldArray) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.insets = gridBagConstraints.insets;
        GridBagLayout gridBagLayout = new GridBagLayout();
        String string = null;
        JPanel jPanel2 = null;
        for (int i = 0; i < classSpecificationArray.length; ++i) {
            String string2;
            ClassSpecification classSpecification = classSpecificationArray[i];
            String string3 = classSpecification.comments;
            int n = string3.indexOf(45);
            int n2 = string3.indexOf(46, n);
            String string4 = string3.substring(0, n).trim();
            String string5 = string3.substring(n + 1, n2).trim();
            if (!string4.equals(string)) {
                jPanel2 = new JPanel(gridBagLayout);
                string2 = "boilerplate_" + string4.toLowerCase().replace(' ', '_');
                this.addBorder(jPanel2, string2);
                jPanel.add((Component)jPanel2, gridBagConstraints3);
                string = string4;
            }
            string2 = "boilerplate_" + string5.toLowerCase().replace(' ', '_');
            jCheckBoxArray[i] = new JCheckBox(this.msg(string2));
            jPanel2.add((Component)jCheckBoxArray[i], jTextFieldArray != null ? gridBagConstraints : gridBagConstraints2);
            if (jTextFieldArray == null) continue;
            jTextFieldArray[i] = new JTextField(40);
            jPanel2.add((Component)jTextFieldArray[i], gridBagConstraints2);
        }
    }

    private void addBorder(JComponent jComponent, String string) {
        Border border = jComponent.getBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BORDER, this.msg(string));
        jComponent.setBorder(border == null ? titledBorder : new CompoundBorder(titledBorder, border));
    }

    private JButton createPreviousButton(final TabbedPane tabbedPane) {
        JButton jButton = new JButton(this.msg("previous"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                tabbedPane.previous();
            }
        });
        return jButton;
    }

    private JButton createNextButton(final TabbedPane tabbedPane) {
        JButton jButton = new JButton(this.msg("next"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                tabbedPane.next();
            }
        });
        return jButton;
    }

    private JButton createBrowseButton(final JTextField jTextField, final String string) {
        JButton jButton = new JButton(this.msg("browse"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProGuardGUI.this.fileChooser.setDialogTitle(string);
                ProGuardGUI.this.fileChooser.setSelectedFile(new File(jTextField.getText()));
                int n = ProGuardGUI.this.fileChooser.showDialog(ProGuardGUI.this, ProGuardGUI.this.msg("ok"));
                if (n == 0) {
                    jTextField.setText(ProGuardGUI.this.fileChooser.getSelectedFile().getPath());
                }
            }
        });
        return jButton;
    }

    private void setCommonPreferredSize(List list) {
        JComponent jComponent;
        int n;
        Dimension dimension = null;
        for (n = 0; n < list.size(); ++n) {
            jComponent = (JComponent)list.get(n);
            Dimension dimension2 = jComponent.getPreferredSize();
            if (dimension != null && !(dimension2.getWidth() > dimension.getWidth())) continue;
            dimension = dimension2;
        }
        for (n = 0; n < list.size(); ++n) {
            jComponent = (JComponent)list.get(n);
            jComponent.setPreferredSize(dimension);
        }
    }

    private void setProGuardConfiguration(Configuration configuration) {
        String string;
        int n;
        this.programPanel.setClassPath(configuration.programJars);
        this.libraryPanel.setClassPath(configuration.libraryJars);
        for (n = 0; n < this.boilerplateKeep.length; ++n) {
            string = this.findMatchingClassSpecifications(this.boilerplateKeep[n], configuration.keep);
            this.boilerplateKeepCheckBoxes[n].setSelected(string != null);
            this.boilerplateKeepTextFields[n].setText(string == null ? "*" : string);
        }
        this.additionalKeepPanel.setClassSpecifications(configuration.keep);
        for (n = 0; n < this.boilerplateKeepNames.length; ++n) {
            string = this.findMatchingClassSpecifications(this.boilerplateKeepNames[n], configuration.keepNames);
            this.boilerplateKeepNamesCheckBoxes[n].setSelected(string != null);
            this.boilerplateKeepNamesTextFields[n].setText(string == null ? "*" : string);
        }
        this.additionalKeepNamesPanel.setClassSpecifications(configuration.keepNames);
        for (n = 0; n < this.boilerplateNoSideEffectMethods.length; ++n) {
            boolean bl = this.findClassSpecification(this.boilerplateNoSideEffectMethods[n], configuration.assumeNoSideEffects);
            this.boilerplateNoSideEffectMethodCheckBoxes[n].setSelected(bl);
        }
        this.additionalNoSideEffectsPanel.setClassSpecifications(configuration.assumeNoSideEffects);
        this.whyAreYouKeepingPanel.setClassSpecifications(configuration.whyAreYouKeeping);
        this.shrinkCheckBox.setSelected(configuration.shrink);
        this.printUsageCheckBox.setSelected(configuration.printUsage != null);
        this.optimizeCheckBox.setSelected(configuration.optimize);
        this.allowAccessModificationCheckBox.setSelected(configuration.allowAccessModification);
        this.obfuscateCheckBox.setSelected(configuration.obfuscate);
        this.printMappingCheckBox.setSelected(configuration.printMapping != null);
        this.applyMappingCheckBox.setSelected(configuration.applyMapping != null);
        this.obfuscationDictionaryCheckBox.setSelected(configuration.obfuscationDictionary != null);
        this.overloadAggressivelyCheckBox.setSelected(configuration.overloadAggressively);
        this.defaultPackageCheckBox.setSelected(configuration.defaultPackage != null);
        this.useMixedCaseClassNamesCheckBox.setSelected(configuration.useMixedCaseClassNames);
        this.keepAttributesCheckBox.setSelected(configuration.keepAttributes != null);
        this.newSourceFileAttributeCheckBox.setSelected(configuration.newSourceFileAttribute != null);
        this.printSeedsCheckBox.setSelected(configuration.printSeeds != null);
        this.verboseCheckBox.setSelected(configuration.verbose);
        this.noteCheckBox.setSelected(configuration.note);
        this.warnCheckBox.setSelected(configuration.warn);
        this.ignoreWarningsCheckBox.setSelected(configuration.ignoreWarnings);
        this.skipNonPublicLibraryClassesCheckBox.setSelected(configuration.skipNonPublicLibraryClasses);
        this.skipNonPublicLibraryClassMembersCheckBox.setSelected(configuration.skipNonPublicLibraryClassMembers);
        this.printUsageTextField.setText(this.fileName(configuration.printUsage));
        this.printMappingTextField.setText(this.fileName(configuration.printMapping));
        this.applyMappingTextField.setText(this.fileName(configuration.applyMapping));
        this.obfuscationDictionaryTextField.setText(this.fileName(configuration.obfuscationDictionary));
        this.defaultPackageTextField.setText(configuration.defaultPackage);
        this.keepAttributesTextField.setText(configuration.keepAttributes == null ? KEEP_ATTRIBUTE_DEFAULT : ListUtil.commaSeparatedString(configuration.keepAttributes));
        this.newSourceFileAttributeTextField.setText(configuration.newSourceFileAttribute == null ? SOURCE_FILE_ATTRIBUTE_DEFAULT : configuration.newSourceFileAttribute);
        this.printSeedsTextField.setText(this.fileName(configuration.printSeeds));
        if (configuration.printMapping != null) {
            this.reTraceMappingTextField.setText(this.fileName(configuration.printMapping));
        }
    }

    private Configuration getProGuardConfiguration() {
        Configuration configuration = new Configuration();
        configuration.programJars = this.programPanel.getClassPath();
        configuration.libraryJars = this.libraryPanel.getClassPath();
        ArrayList<ClassSpecification> arrayList = new ArrayList<ClassSpecification>();
        for (int i = 0; i < this.boilerplateKeep.length; ++i) {
            if (!this.boilerplateKeepCheckBoxes[i].isSelected()) continue;
            arrayList.add(this.classSpecification(this.boilerplateKeep[i], this.boilerplateKeepTextFields[i].getText()));
        }
        List list = this.additionalKeepPanel.getClassSpecifications();
        if (list != null) {
            arrayList.addAll(list);
        }
        if (arrayList.size() > 0) {
            configuration.keep = arrayList;
        }
        ArrayList<ClassSpecification> arrayList2 = new ArrayList<ClassSpecification>();
        for (int i = 0; i < this.boilerplateKeepNames.length; ++i) {
            if (!this.boilerplateKeepNamesCheckBoxes[i].isSelected()) continue;
            arrayList2.add(this.classSpecification(this.boilerplateKeepNames[i], this.boilerplateKeepNamesTextFields[i].getText()));
        }
        List list2 = this.additionalKeepNamesPanel.getClassSpecifications();
        if (list2 != null) {
            arrayList2.addAll(list2);
        }
        if (arrayList2.size() > 0) {
            configuration.keepNames = arrayList2;
        }
        ArrayList<ClassSpecification> arrayList3 = new ArrayList<ClassSpecification>();
        for (int i = 0; i < this.boilerplateNoSideEffectMethods.length; ++i) {
            if (!this.boilerplateNoSideEffectMethodCheckBoxes[i].isSelected()) continue;
            arrayList3.add(this.boilerplateNoSideEffectMethods[i]);
        }
        List list3 = this.additionalNoSideEffectsPanel.getClassSpecifications();
        if (list3 != null) {
            arrayList3.addAll(list3);
        }
        if (arrayList3.size() > 0) {
            configuration.assumeNoSideEffects = arrayList3;
        }
        configuration.whyAreYouKeeping = this.whyAreYouKeepingPanel.getClassSpecifications();
        configuration.shrink = this.shrinkCheckBox.isSelected();
        configuration.printUsage = this.printUsageCheckBox.isSelected() ? new File(this.printUsageTextField.getText()) : null;
        configuration.optimize = this.optimizeCheckBox.isSelected();
        configuration.allowAccessModification = this.allowAccessModificationCheckBox.isSelected();
        configuration.obfuscate = this.obfuscateCheckBox.isSelected();
        configuration.printMapping = this.printMappingCheckBox.isSelected() ? new File(this.printMappingTextField.getText()) : null;
        configuration.applyMapping = this.applyMappingCheckBox.isSelected() ? new File(this.applyMappingTextField.getText()) : null;
        configuration.obfuscationDictionary = this.obfuscationDictionaryCheckBox.isSelected() ? new File(this.obfuscationDictionaryTextField.getText()) : null;
        configuration.overloadAggressively = this.overloadAggressivelyCheckBox.isSelected();
        configuration.defaultPackage = this.defaultPackageCheckBox.isSelected() ? this.defaultPackageTextField.getText() : null;
        configuration.useMixedCaseClassNames = this.useMixedCaseClassNamesCheckBox.isSelected();
        configuration.keepAttributes = this.keepAttributesCheckBox.isSelected() ? ListUtil.commaSeparatedList(this.keepAttributesTextField.getText()) : null;
        configuration.newSourceFileAttribute = this.newSourceFileAttributeCheckBox.isSelected() ? this.newSourceFileAttributeTextField.getText() : null;
        configuration.printSeeds = this.printSeedsCheckBox.isSelected() ? new File(this.printSeedsTextField.getText()) : null;
        configuration.verbose = this.verboseCheckBox.isSelected();
        configuration.note = this.noteCheckBox.isSelected();
        configuration.warn = this.warnCheckBox.isSelected();
        configuration.ignoreWarnings = this.ignoreWarningsCheckBox.isSelected();
        configuration.skipNonPublicLibraryClasses = this.skipNonPublicLibraryClassesCheckBox.isSelected();
        configuration.skipNonPublicLibraryClassMembers = this.skipNonPublicLibraryClassMembersCheckBox.isSelected();
        return configuration;
    }

    private boolean findClassSpecification(ClassSpecification classSpecification, List list) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!classSpecification.equals(list.get(i))) continue;
            list.remove(i);
            return true;
        }
        return false;
    }

    private String findMatchingClassSpecifications(ClassSpecification classSpecification, List list) {
        if (list == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        for (int i = 0; i < list.size(); ++i) {
            String string;
            ClassSpecification classSpecification2 = (ClassSpecification)list.get(i);
            classSpecification.className = string = classSpecification2.className;
            if (!classSpecification.equals(classSpecification2)) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(string == null ? "*" : ClassUtil.externalClassName(string));
            list.remove(i--);
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }

    private void addClassSpecifications(List list, ClassSpecification classSpecification, String string) {
        List list2 = ListUtil.commaSeparatedList(string);
        for (int i = 0; i < list2.size(); ++i) {
            String string2 = (String)list2.get(i);
            list.add(this.classSpecification(classSpecification, string2));
        }
    }

    private ClassSpecification classSpecification(ClassSpecification classSpecification, String string) {
        ClassSpecification classSpecification2 = (ClassSpecification)classSpecification.clone();
        classSpecification2.className = string.equals("") || string.equals("*") ? null : ClassUtil.internalClassName(string);
        return classSpecification2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration(File file) {
        this.configurationChooser.setSelectedFile(file.getAbsoluteFile());
        this.fileChooser.setCurrentDirectory(file.getAbsoluteFile().getParentFile());
        try {
            ConfigurationParser configurationParser = new ConfigurationParser(file);
            Configuration configuration = new Configuration();
            try {
                configurationParser.parse(configuration);
                this.setProGuardConfiguration(configuration);
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantParseConfigurationFile", file.getPath()), this.msg("warning"), 0);
            }
            finally {
                configurationParser.close();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantOpenConfigurationFile", file.getPath()), this.msg("warning"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration(URL uRL) {
        try {
            ConfigurationParser configurationParser = new ConfigurationParser(uRL);
            Configuration configuration = new Configuration();
            try {
                configurationParser.parse(configuration);
                this.setProGuardConfiguration(configuration);
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantParseConfigurationFile", uRL), this.msg("warning"), 0);
            }
            finally {
                configurationParser.close();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantOpenConfigurationFile", uRL), this.msg("warning"), 0);
        }
    }

    private void saveConfiguration(File file) {
        try {
            ConfigurationWriter configurationWriter = new ConfigurationWriter(file);
            configurationWriter.write(this.getProGuardConfiguration());
            configurationWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantSaveConfigurationFile", file.getPath()), this.msg("warning"), 0);
        }
    }

    private void loadStackTrace(String string) {
        try {
            File file = new File(string);
            byte[] byArray = new byte[(int)file.length()];
            FileInputStream fileInputStream = new FileInputStream(file);
            ((InputStream)fileInputStream).read(byArray);
            ((InputStream)fileInputStream).close();
            this.stackTraceTextArea.setText(new String(byArray));
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantOpenStackTraceFile", string), this.msg("warning"), 0);
        }
    }

    private String fileName(File file) {
        return file == null ? "" : file.getAbsolutePath();
    }

    private String msg(String string) {
        return GUIResources.getMessage(string);
    }

    private String msg(String string, Object object) {
        return GUIResources.getMessage(string, new Object[]{object});
    }

    public static void main(String[] stringArray) {
        ProGuardGUI proGuardGUI = new ProGuardGUI();
        proGuardGUI.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = proGuardGUI.getSize();
        proGuardGUI.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        proGuardGUI.show();
        int n = 0;
        if (n < stringArray.length && NO_SPLASH_OPTION.startsWith(stringArray[n])) {
            proGuardGUI.skipSplash();
            ++n;
        } else {
            proGuardGUI.startSplash();
        }
        if (n < stringArray.length) {
            proGuardGUI.loadConfiguration(new File(stringArray[n]));
            ++n;
        }
        if (n < stringArray.length) {
            System.out.println(proGuardGUI.getClass().getName() + ": ignoring extra arguments [" + stringArray[n] + "...]");
        }
    }

    private class MyReTraceActionListener
    implements ActionListener {
        private MyReTraceActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!systemOutRedirected) {
                systemOutRedirected = true;
                boolean bl = ProGuardGUI.this.reTraceVerboseCheckBox.isSelected();
                File file = new File(ProGuardGUI.this.reTraceMappingTextField.getText());
                String string = ProGuardGUI.this.stackTraceTextArea.getText();
                ReTraceRunnable reTraceRunnable = new ReTraceRunnable(ProGuardGUI.this.reTraceTextArea, bl, file, string);
                reTraceRunnable.run();
            }
        }
    }

    private class MyLoadStackTraceActionListener
    implements ActionListener {
        private MyLoadStackTraceActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProGuardGUI.this.fileChooser.setDialogTitle(ProGuardGUI.this.msg("selectStackTraceFile"));
            ProGuardGUI.this.fileChooser.setSelectedFile(null);
            int n = ProGuardGUI.this.fileChooser.showOpenDialog(ProGuardGUI.this);
            if (n == 0) {
                File file = ProGuardGUI.this.fileChooser.getSelectedFile();
                String string = file.getPath();
                ProGuardGUI.this.loadStackTrace(string);
            }
        }
    }

    private class MyProcessActionListener
    implements ActionListener {
        private MyProcessActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!systemOutRedirected) {
                systemOutRedirected = true;
                File file = ProGuardGUI.this.configurationChooser.getSelectedFile();
                String string = file != null ? file.getName() : ProGuardGUI.this.msg("sampleConfigurationFileName");
                Thread thread = new Thread(new ProGuardRunnable(ProGuardGUI.this.consoleTextArea, ProGuardGUI.this.getProGuardConfiguration(), string));
                thread.start();
            }
        }
    }

    private class MyViewConfigurationActionListener
    implements ActionListener {
        private MyViewConfigurationActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!systemOutRedirected) {
                ProGuardGUI.this.consoleTextArea.setText("");
                TextAreaOutputStream textAreaOutputStream = new TextAreaOutputStream(ProGuardGUI.this.consoleTextArea);
                try {
                    ConfigurationWriter configurationWriter = new ConfigurationWriter(textAreaOutputStream);
                    configurationWriter.write(ProGuardGUI.this.getProGuardConfiguration());
                    configurationWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ProGuardGUI.this.consoleTextArea.setCaretPosition(0);
            }
        }
    }

    private class MySaveConfigurationActionListener
    implements ActionListener {
        private MySaveConfigurationActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProGuardGUI.this.configurationChooser.setDialogTitle(ProGuardGUI.this.msg("saveConfigurationFile"));
            int n = ProGuardGUI.this.configurationChooser.showSaveDialog(ProGuardGUI.this);
            if (n == 0) {
                ProGuardGUI.this.saveConfiguration(ProGuardGUI.this.configurationChooser.getSelectedFile());
            }
        }
    }

    private class MyLoadConfigurationActionListener
    implements ActionListener {
        private MyLoadConfigurationActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProGuardGUI.this.configurationChooser.setDialogTitle(ProGuardGUI.this.msg("selectConfigurationFile"));
            int n = ProGuardGUI.this.configurationChooser.showOpenDialog(ProGuardGUI.this);
            if (n == 0) {
                ProGuardGUI.this.loadConfiguration(ProGuardGUI.this.configurationChooser.getSelectedFile());
            }
        }
    }
}

