/*
 * Decompiled with CFR 0.152.
 */
package me.petterroea.bday2012;

import java.awt.Color;
import java.awt.Graphics;

public class Particle {
    double x;
    double y;
    double xspeed;
    double yspeed;
    double gravity;
    int motorLife;
    int life;
    long startStamp;
    boolean dead = false;
    int r;
    int g;
    int b;
    int var;

    public Particle(int x, int y, double xspeed, double yspeed, int motorLife, int life, double gravity, int r, int g, int b, int var) {
        this.x = x;
        this.y = y;
        this.xspeed = xspeed;
        this.yspeed = yspeed;
        this.motorLife = motorLife;
        this.life = life;
        this.gravity = gravity;
        this.startStamp = System.currentTimeMillis();
        this.r = r;
        this.g = g;
        this.b = b;
        this.var = var;
    }

    public void update(int delta, Graphics gr) {
        if (this.dead || System.currentTimeMillis() - this.startStamp > (long)this.life) {
            this.dead = true;
            return;
        }
        if (System.currentTimeMillis() - this.startStamp > (long)this.motorLife) {
            this.yspeed += this.gravity * (double)delta;
        }
        this.x += this.xspeed * (double)delta / 10.0;
        this.y += this.yspeed * (double)delta / 10.0;
        Color col = new Color(this.r, this.g, this.b);
        gr.setColor(col);
        gr.drawLine((int)this.x - 1, (int)this.y - 1, (int)this.x + 1, (int)this.y + 1);
        gr.drawLine((int)this.x + 1, (int)this.y - 1, (int)this.x - 1, (int)this.y + 1);
    }
}

