; VGM player for the NeoGeo Pocket
; Z80 VGM playback driver
;
; /Mic, 2012


.MEMORYMAP
	DEFAULTSLOT 0
	SLOTSIZE $1000
	SLOT 0 $0000
.ENDME

.ROMBANKSIZE $1000
.ROMBANKS 1
.BANK 0 SLOT 0
.ORGA $00


; Sound registers
;
.define REG_CH4 $4000
.define REG_CH123 $4001


.define VGM_BUFFER_READ_POS $8000


; VGM commands recognized by the driver
;
.define CMD_GG_STEREO		$4F
.define CMD_PSG			$50
.define CMD_FM			$51
.define CMD_WAIT		$61
.define CMD_WAIT_FRAME_NTSC	$62
.define CMD_WAIT_FRAME_PAL	$63
.define CMD_END			$66


vgm_jump_table:

di
im 	1
jp 	vgm_play
; The above 3 instructions take up the first 6 bytes in the table (which are unused anyway)

.dw 0, 0,0,0,0, 0,0,0,0, 0,0,0,vgm_gg_stereo
.dw vgm_psg_write,vgm_fm_write,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
.dw 0,vgm_wait,vgm_wait_ntsc,vgm_wait_pal, 0,0,vgm_end,0, 0,0,0,0, 0,0,0,0
.dw vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait
.dw vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait


.ORGA $80
VGM_RESTART: .db 0


vgm_play:
	ld	hl,VGM_DATA_BUFFER-4
	ld	sp,hl

        ld	hl,0
        ld	a,0
        ld	(SAMPLE_DRIFT),hl
        ld	(CH1_PER),hl
        ld	(CH2_PER),hl
        ld	(CH3_PER),hl
        ld	(CUR_CHN),a
        ld	(NOISE_CFG),a
        
	ld	bc,VGM_DATA_BUFFER
	ld	iy,vgm_jump_table

vgm_play_loop:
	ld	a,c			; 4
	ld	(VGM_BUFFER_READ_POS),a	; 13
	ld	a,(bc)			; 7. Read one byte from the VGM data buffer
	inc	c			; 4
	ld	ixh,a			; 8. Save the VGM command in IXH
    	add     a,$C0 			; 7. subtract 0x40
    	rlca            		; 4. multiply by 2
    	ld      iyl,a   		; 8
    	ld      l,(iy+0) 		; 19. Load HL with command handler address
    	ld      h,(iy+1) 		; 19
	jp      (hl)    		; 4. Jump to the handler (tot 97 cycles)
	

vgm_psg_write:
	ld 	a,(bc)			; 7
	inc	c			; 4
	ld	ixh,a			; 8. Save a
	bit	7,a			; 8
	jp	z,data_byte		; 10 (37, 134)

	and	$F0			; 7. 1cct0000
        ld 	(CUR_CHN+1),a		; 13
	ld	a,ixh			; 8
	
	bit	4,a			; 8
	jp	nz,psg_volume		; 10 (83, 180)
	rlca				; 4. cctdddd1
	rlca				; 4. ctdddd1c
	rlca				; 4. tdddd1cc
	and	3			; 7. 000000cc
	rlca				; 4
	ld	(CUR_CHN),a		; 13
	cp	3*2			; 7
	jp	z,psg_noise		; 10 (136, 233)
	; Get clock-corrected period values
	ld	hl,CH1_PER		; 10
	ld	e,a			; 4
	ld	d,0			; 7
	add	hl,de			; 11
	ld	a,ixh			; 8 (176, 273)
	and	$0F			; 7. 0000dddd
	ld	d,a			; 4
	ld	a,(hl)			; 7. DDDDdddd
	and	$F0			; 7
	or	d			; 4 
	ld	(hl),a			; 7
	ld	e,a			; 4. DDDDdddd
	inc	hl			; 6 
	ld	d,(hl)			; 7. (229, 326) DE = 000000DD DDDDdddd

	ld	a,(CUR_CHN+1)		; 13. delay
	ld	hl,0			; 10. delay
	ld	a,ixh			; 8. delay (260, 357)
psg_write:
	push	de			; 11
	ld	hl,sms2ngp_freqlo_tbl	; 10
	add	hl,de			; 11 
	add	hl,de			; 11 
	ld	a,(hl)			; 7. (310, 407) DDDDdddd
	ld	d,a			; 4
	and	$0F			; 7. 0000dddd
	ld	e,a			; 4
	ld	a,(CUR_CHN+1)		; 13. 1cct0000
	or	e			; 4. 1cctdddd
	ld	(REG_CH123),a		; 13
	ld	a,(SAMPLE_DRIFT)	; 13
	add	a,10			; 7
	ld	(SAMPLE_DRIFT),a	; 13 (388, 485)

	ld	a,d			; 4
	and	$F0			; 7. DDDD0000
	inc	hl			; 6
	ld	d,(hl)			; 7. xxxxxxDD
	srl	d			; 8. xxxxxxxD
	rra				; 4. DDDDD000
	srl	d			; 8. xxxxxxxx
	rra				; 4. DDDDDD00
	rrca				; 4. 0DDDDDD0
	rrca				; 4. 00DDDDDD
	ld	(REG_CH123),a		; 13 (459, 556)

	; Write periods corrected for the 15-bit LFSR to REG_CH4 (used
	; when the noise channel is clocked by Tone2)
	pop	de			; 10

	ld	a,(hl)			; 7. DDDDDDxx
	rrca				; 4. xDDDDDDx
	rrca				; 4. xxDDDDDD
	and	$3F			; 7. 00DDDDDD
	push	af			; 11 (502, 599)

	ld	hl,sms2ngp_freqhi_tbl	; 10
	add	hl,de			; 11 
	ld	d,(hl)			; 7. 0000dddd
	ld	a,(CUR_CHN+1)		; 13. 1cct0000
	or	d			; 4. 1cctdddd
	ld	(REG_CH4),a		; 13
	pop	af			; 10. 00DDDDDD
	ld	(REG_CH4),a		; 13
	
	jp	vgm_play_loop		; 10 (593, 690)
	
data_byte:
	ld 	a,(CUR_CHN+1)		; 13
	bit	4,a			; 8
	jp	nz,psg_volume		; 10 (68, 165)
	ld	a,(CUR_CHN)		; 13
	cp	3*2			; 7
	jp	z,psg_noise		; 10 (98, 195)
	ld	hl,CH1_PER+1		; 10
	ld	e,a			; 4
	ld	d,0			; 7
	add	hl,de			; 11 (130, 227)
	ld	a,ixh			; 8
	and	$3F			; 7. 00DDDDDD
	ld	e,a			; 4 
	ld	a,0			; 7
	sla	e			; 8		
	rla				; 4. AE = 00000000 0DDDDDD0		
	sla	e			; 8
	rla				; 4. (180, 277) AE = 00000000 DDDDDD00	
	sla	e			; 8
	rla				; 4. AE = 0000000D DDDDD000
	sla	e			; 8
	rla				; 4. AE = 000000DD DDDD0000
	ld	(hl),a			; 7. CHx_PER = (CHx_PER & 0xFF) | (A << 8)
	ld	d,a			; 4. D = 000000DD
	dec	hl			; 6 (221, 318)
	ld	a,(hl)			; 7. DDDDdddd
	and	$0F			; 7. 0000dddd
	or	e			; 4. A = DDDDdddd
	ld	e,a			; 4. DE = 000000DD DDDDdddd
	ld	(hl),a			; 7. CHx_PER = (CHx_PER & 0xFF00) | A
	jp	psg_write		; 10 (260, 357)
 	
psg_noise:
	ld	a,ixh			; 8
	ld	(REG_CH4),a		; 13
	ld	a,(SAMPLE_DRIFT)	; 13
	add	a,3			; 7
	ld	(SAMPLE_DRIFT),a	; 13
	jp	vgm_play_loop		; 10 
psg_volume:
	ld	a,ixh			; 8
	ld	(REG_CH123),a		; 13
	ld	(REG_CH4),a		; 13
	ld	a,(SAMPLE_DRIFT)	; 13
	add	a,4			; 7
	ld	(SAMPLE_DRIFT),a	; 13
	ld	a,(iy+0)		; 19. delay
	jp	vgm_play_loop		; 10 

	
vgm_end:
	ld	a,1
	ld	(VGM_RESTART),a
-:
	ld	a,(VGM_RESTART)
	and	a
	jr	nz,-
	jp	vgm_play_loop



vgm_short_wait:
	ld	a,ixh	; 8
	and	$0F	    ; 7
	jp	z,vgm_play_loop	; 10
	
	; 69 cycles/iteration
-:
	ld	ix,(0)	; 20
	ld	ix,(0)	; 20
	inc	ixh	; 8
	and	$0F	; 7
	dec	a	; 4
	jp	nz,-	; 10
	jp	vgm_play_loop ; 10


vgm_wait:
	ld	a,(bc)		; 7
	inc	c		; 4
	ld	e,a		; 4
	ld	a,(bc)		; 7
	inc	c		; 4
	ld	d,a		; 4
vgm_wait2:
	ld	hl,(SAMPLE_DRIFT) ; 16
	ex	de,hl		  ; 4
	scf			  ; 4
	sbc	hl,de		  ; 15	
	dec 	hl		  ; 6 
	dec	hl		  ; 6. wait - SAMPLE_DRIFT - 3
	ex	de,hl		  ; 4
	
	; 69 cycles/iteration
-:
	ld	ix,(0)		; 20
	jp	+		; 10
+:	ld	a,ixh		; 8
	dec	de		; 6
	and	$0F	    	; 7
	ld	a,e		; 4
	or	d		; 4
	jp	nz,-		; 10
	
	ld	hl,0		; 10
	ld	(SAMPLE_DRIFT),hl ; 16 
	jp	vgm_play_loop 	; 10
	
	
vgm_wait_pal:
	ld	de,882		; 10
	jp	vgm_wait2	; 10
	
vgm_wait_ntsc:
	ld	de,735		; 10
	jp	vgm_wait2	; 10


vgm_fm_write:	; Ignored
	inc	c
	inc	c
	jp	vgm_play_loop
	
	
vgm_gg_stereo:	; Ignored
	inc	c
	jp	vgm_play_loop


CH1_PER: .dw 0
CH2_PER: .dw 0
CH3_PER: .dw 0
CH4_PER: .dw 0
TEMP:	.dw 0
CUR_CHN: .dw 0
SAMPLE_DRIFT: .dw 0
NOISE_CFG: .db 0
CH3_PER2: .dw 0


.ORGA $300
; Circular buffer of 256 bytes containing VGM data
; The TLCS900H reads the VGM data from ROM and writes it
; to the corresponding shared RAM area on its side, and the
; Z80 driver then consumes the data.
;
VGM_DATA_BUFFER:


.ORGA $400

; clock-corrected period in lower 10 bits, upper part of LFSR-corrected period in upper 6 bits
sms2ngp_freqlo_tbl:
.dw $0001,$0001,$0002,$0003,$0003,$0004,$0005,$0006,$0007,$0008,$0009,$0009,$000A,$000B,$000C,$000D
.dw $000E,$040F,$040F,$0410,$0411,$0412,$0413,$0414,$0415,$0415,$0416,$0417,$0418,$0419,$041A,$041B
.dw $041B,$041C,$041D,$081E,$081F,$0820,$0821,$0821,$0822,$0823,$0824,$0825,$0826,$0827,$0827,$0828
.dw $0829,$082A,$082B,$082C,$0C2D,$0C2D,$0C2E,$0C2F,$0C30,$0C31,$0C32,$0C33,$0C33,$0C34,$0C35,$0C36
.dw $0C37,$0C38,$0C39,$0C3A,$0C3A,$0C3B,$103C,$103D,$103E,$103F,$1040,$1040,$1041,$1042,$1043,$1044
.dw $1045,$1046,$1046,$1047,$1048,$1049,$104A,$144B,$144C,$144C,$144D,$144E,$144F,$1450,$1451,$1452
.dw $1452,$1453,$1454,$1455,$1456,$1457,$1458,$1458,$1459,$185A,$185B,$185C,$185D,$185E,$185E,$185F
.dw $1860,$1861,$1862,$1863,$1864,$1864,$1865,$1866,$1867,$1868,$1C69,$1C6A,$1C6A,$1C6B,$1C6C,$1C6D
.dw $1C6E,$1C6F,$1C70,$1C70,$1C71,$1C72,$1C73,$1C74,$1C75,$1C76,$1C76,$1C77,$2078,$2079,$207A,$207B
.dw $207C,$207C,$207D,$207E,$207F,$2080,$2081,$2082,$2082,$2083,$2084,$2085,$2086,$2487,$2488,$2488
.dw $2489,$248A,$248B,$248C,$248D,$248E,$248E,$248F,$2490,$2491,$2492,$2493,$2494,$2494,$2495,$2896
.dw $2897,$2898,$2899,$289A,$289A,$289B,$289C,$289D,$289E,$289F,$28A0,$28A0,$28A1,$28A2,$28A3,$28A4
.dw $2CA5,$2CA6,$2CA6,$2CA7,$2CA8,$2CA9,$2CAA,$2CAB,$2CAC,$2CAD,$2CAD,$2CAE,$2CAF,$2CB0,$2CB1,$2CB2
.dw $2CB3,$2CB3,$30B4,$30B5,$30B6,$30B7,$30B8,$30B9,$30B9,$30BA,$30BB,$30BC,$30BD,$30BE,$30BF,$30BF
.dw $30C0,$30C1,$30C2,$34C3,$34C4,$34C5,$34C5,$34C6,$34C7,$34C8,$34C9,$34CA,$34CB,$34CB,$34CC,$34CD
.dw $34CE,$34CF,$34D0,$34D1,$34D1,$38D2,$38D3,$38D4,$38D5,$38D6,$38D7,$38D7,$38D8,$38D9,$38DA,$38DB
.dw $38DC,$38DD,$38DD,$38DE,$38DF,$38E0,$3CE1,$3CE2,$3CE3,$3CE3,$3CE4,$3CE5,$3CE6,$3CE7,$3CE8,$3CE9
.dw $3CE9,$3CEA,$3CEB,$3CEC,$3CED,$3CEE,$3CEF,$3CEF,$40F0,$40F1,$40F2,$40F3,$40F4,$40F5,$40F5,$40F6
.dw $40F7,$40F8,$40F9,$40FA,$40FB,$40FB,$40FC,$40FD,$40FE,$44FF,$4500,$4501,$4501,$4502,$4503,$4504
.dw $4505,$4506,$4507,$4507,$4508,$4509,$450A,$450B,$450C,$450D,$450D,$490E,$490F,$4910,$4911,$4912
.dw $4913,$4913,$4914,$4915,$4916,$4917,$4918,$4919,$4919,$491A,$491B,$491C,$4D1D,$4D1E,$4D1F,$4D20
.dw $4D20,$4D21,$4D22,$4D23,$4D24,$4D25,$4D26,$4D26,$4D27,$4D28,$4D29,$4D2A,$4D2B,$4D2C,$512C,$512D
.dw $512E,$512F,$5130,$5131,$5132,$5132,$5133,$5134,$5135,$5136,$5137,$5138,$5138,$5139,$513A,$553B
.dw $553C,$553D,$553E,$553E,$553F,$5540,$5541,$5542,$5543,$5544,$5544,$5545,$5546,$5547,$5548,$5549
.dw $594A,$594A,$594B,$594C,$594D,$594E,$594F,$5950,$5950,$5951,$5952,$5953,$5954,$5955,$5956,$5956
.dw $5957,$5958,$5D59,$5D5A,$5D5B,$5D5C,$5D5C,$5D5D,$5D5E,$5D5F,$5D60,$5D61,$5D62,$5D62,$5D63,$5D64
.dw $5D65,$5D66,$5D67,$6168,$6168,$6169,$616A,$616B,$616C,$616D,$616E,$616E,$616F,$6170,$6171,$6172
.dw $6173,$6174,$6174,$6175,$6176,$6577,$6578,$6579,$657A,$657A,$657B,$657C,$657D,$657E,$657F,$6580
.dw $6580,$6581,$6582,$6583,$6584,$6585,$6986,$6986,$6987,$6988,$6989,$698A,$698B,$698C,$698C,$698D
.dw $698E,$698F,$6990,$6991,$6992,$6993,$6993,$6994,$6D95,$6D96,$6D97,$6D98,$6D99,$6D99,$6D9A,$6D9B
.dw $6D9C,$6D9D,$6D9E,$6D9F,$6D9F,$6DA0,$6DA1,$6DA2,$6DA3,$71A4,$71A5,$71A5,$71A6,$71A7,$71A8,$71A9
.dw $71AA,$71AB,$71AB,$71AC,$71AD,$71AE,$71AF,$71B0,$71B1,$71B1,$71B2,$75B3,$75B4,$75B5,$75B6,$75B7
.dw $75B7,$75B8,$75B9,$75BA,$75BB,$75BC,$75BD,$75BD,$75BE,$75BF,$75C0,$75C1,$79C2,$79C3,$79C3,$79C4
.dw $79C5,$79C6,$79C7,$79C8,$79C9,$79C9,$79CA,$79CB,$79CC,$79CD,$79CE,$79CF,$79CF,$79D0,$7DD1,$7DD2
.dw $7DD3,$7DD4,$7DD5,$7DD5,$7DD6,$7DD7,$7DD8,$7DD9,$7DDA,$7DDB,$7DDB,$7DDC,$7DDD,$7DDE,$7DDF,$81E0
.dw $81E1,$81E1,$81E2,$81E3,$81E4,$81E5,$81E6,$81E7,$81E7,$81E8,$81E9,$81EA,$81EB,$81EC,$81ED,$81ED
.dw $81EE,$85EF,$85F0,$85F1,$85F2,$85F3,$85F3,$85F4,$85F5,$85F6,$85F7,$85F8,$85F9,$85F9,$85FA,$85FB
.dw $85FC,$85FD,$89FE,$89FF,$89FF,$8A00,$8A01,$8A02,$8A03,$8A04,$8A05,$8A06,$8A06,$8A07,$8A08,$8A09
.dw $8A0A,$8A0B,$8A0C,$8A0C,$8E0D,$8E0E,$8E0F,$8E10,$8E11,$8E12,$8E12,$8E13,$8E14,$8E15,$8E16,$8E17
.dw $8E18,$8E18,$8E19,$8E1A,$8E1B,$921C,$921D,$921E,$921E,$921F,$9220,$9221,$9222,$9223,$9224,$9224
.dw $9225,$9226,$9227,$9228,$9229,$922A,$922A,$962B,$962C,$962D,$962E,$962F,$9630,$9630,$9631,$9632
.dw $9633,$9634,$9635,$9636,$9636,$9637,$9638,$9639,$9A3A,$9A3B,$9A3C,$9A3C,$9A3D,$9A3E,$9A3F,$9A40
.dw $9A41,$9A42,$9A42,$9A43,$9A44,$9A45,$9A46,$9A47,$9A48,$9A48,$9E49,$9E4A,$9E4B,$9E4C,$9E4D,$9E4E
.dw $9E4E,$9E4F,$9E50,$9E51,$9E52,$9E53,$9E54,$9E54,$9E55,$9E56,$9E57,$A258,$A259,$A25A,$A25A,$A25B
.dw $A25C,$A25D,$A25E,$A25F,$A260,$A260,$A261,$A262,$A263,$A264,$A265,$A266,$A266,$A667,$A668,$A669
.dw $A66A,$A66B,$A66C,$A66C,$A66D,$A66E,$A66F,$A670,$A671,$A672,$A672,$A673,$A674,$A675,$AA76,$AA77
.dw $AA78,$AA79,$AA79,$AA7A,$AA7B,$AA7C,$AA7D,$AA7E,$AA7F,$AA7F,$AA80,$AA81,$AA82,$AA83,$AA84,$AA85
.dw $AE85,$AE86,$AE87,$AE88,$AE89,$AE8A,$AE8B,$AE8B,$AE8C,$AE8D,$AE8E,$AE8F,$AE90,$AE91,$AE91,$AE92
.dw $AE93,$B294,$B295,$B296,$B297,$B297,$B298,$B299,$B29A,$B29B,$B29C,$B29D,$B29D,$B29E,$B29F,$B2A0
.dw $B2A1,$B2A2,$B6A3,$B6A3,$B6A4,$B6A5,$B6A6,$B6A7,$B6A8,$B6A9,$B6A9,$B6AA,$B6AB,$B6AC,$B6AD,$B6AE
.dw $B6AF,$B6AF,$B6B0,$B6B1,$BAB2,$BAB3,$BAB4,$BAB5,$BAB5,$BAB6,$BAB7,$BAB8,$BAB9,$BABA,$BABB,$BABB
.dw $BABC,$BABD,$BABE,$BABF,$BAC0,$BEC1,$BEC1,$BEC2,$BEC3,$BEC4,$BEC5,$BEC6,$BEC7,$BEC7,$BEC8,$BEC9
.dw $BECA,$BECB,$BECC,$BECD,$BECD,$BECE,$BECF,$C2D0,$C2D1,$C2D2,$C2D3,$C2D3,$C2D4,$C2D5,$C2D6,$C2D7
.dw $C2D8,$C2D9,$C2D9,$C2DA,$C2DB,$C2DC,$C2DD,$C2DE,$C6DF,$C6DF,$C6E0,$C6E1,$C6E2,$C6E3,$C6E4,$C6E5
.dw $C6E5,$C6E6,$C6E7,$C6E8,$C6E9,$C6EA,$C6EB,$C6EC,$C6EC,$C6ED,$CAEE,$CAEF,$CAF0,$CAF1,$CAF2,$CAF2
.dw $CAF3,$CAF4,$CAF5,$CAF6,$CAF7,$CAF8,$CAF8,$CAF9,$CAFA,$CAFB,$CAFC,$CEFD,$CEFE,$CEFE,$CEFF,$CF00
.dw $CF01,$CF02,$CF03,$CF04,$CF04,$CF05,$CF06,$CF07,$CF08,$CF09,$CF0A,$CF0A,$CF0B,$D30C,$D30D,$D30E
.dw $D30F,$D310,$D310,$D311,$D312,$D313,$D314,$D315,$D316,$D316,$D317,$D318,$D319,$D31A,$D71B,$D71C
.dw $D71C,$D71D,$D71E,$D71F,$D720,$D721,$D722,$D722,$D723,$D724,$D725,$D726,$D727,$D728,$D728,$D729
.dw $DB2A,$DB2B,$DB2C,$DB2D,$DB2E,$DB2E,$DB2F,$DB30,$DB31,$DB32,$DB33,$DB34,$DB34,$DB35,$DB36,$DB37
.dw $DB38,$DF39,$DF3A,$DF3A,$DF3B,$DF3C,$DF3D,$DF3E,$DF3F,$DF40,$DF40,$DF41,$DF42,$DF43,$DF44,$DF45
.dw $DF46,$DF46,$DF47,$E348,$E349,$E34A,$E34B,$E34C,$E34C,$E34D,$E34E,$E34F,$E350,$E351,$E352,$E352
.dw $E353,$E354,$E355,$E356,$E757,$E758,$E758,$E759,$E75A,$E75B,$E75C,$E75D,$E75E,$E75F,$E75F,$E760
.dw $E761,$E762,$E763,$E764,$E765,$E765,$EB66,$EB67,$EB68,$EB69,$EB6A,$EB6B,$EB6B,$EB6C,$EB6D,$EB6E

sms2ngp_freqhi_tbl:
.db $01,$01,$02,$03,$04,$05,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E
.db $0F,$00,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0B,$0C
.db $0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$06,$07,$08,$09,$0A,$0B
.db $0C,$0D,$0E,$0F,$00,$01,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A
.db $0B,$0C,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$06,$07,$08
.db $09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$01,$02,$03,$04,$05,$06,$07
.db $08,$09,$0A,$0B,$0C,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06
.db $07,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$02,$03,$04
.db $05,$06,$07,$08,$09,$0A,$0B,$0C,$0C,$0D,$0E,$0F,$00,$01,$02,$03
.db $04,$05,$06,$07,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02
.db $02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0D,$0E,$0F,$00
.db $01,$02,$03,$04,$05,$06,$07,$08,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
.db $00,$01,$02,$03,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0D
.db $0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$08,$09,$0A,$0B,$0C
.db $0D,$0E,$0F,$00,$01,$02,$03,$03,$04,$05,$06,$07,$08,$09,$0A,$0B
.db $0C,$0D,$0E,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$09
.db $0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$04,$05,$06,$07,$08
.db $09,$0A,$0B,$0C,$0D,$0E,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07
.db $08,$09,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$04,$05
.db $06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$0F,$00,$01,$02,$03,$04
.db $05,$06,$07,$08,$09,$0A,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03
.db $04,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$0F,$00,$01
.db $02,$03,$04,$05,$06,$07,$08,$09,$0A,$0A,$0B,$0C,$0D,$0E,$0F,$00
.db $01,$02,$03,$04,$05,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
.db $00,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0B,$0C,$0D
.db $0E,$0F,$00,$01,$02,$03,$04,$05,$05,$06,$07,$08,$09,$0A,$0B,$0C
.db $0D,$0E,$0F,$00,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B
.db $0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$06,$07,$08,$09
.db $0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$01,$02,$03,$04,$05,$06,$07,$08
.db $09,$0A,$0B,$0C,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$06
.db $07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$01,$02,$03,$04,$05
.db $06,$07,$08,$09,$0A,$0B,$0C,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04
.db $05,$06,$07,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$02
.db $03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0C,$0D,$0E,$0F,$00,$01
.db $02,$03,$04,$05,$06,$07,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00
.db $01,$02,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0D,$0E
.db $0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$08,$09,$0A,$0B,$0C,$0D
.db $0E,$0F,$00,$01,$02,$03,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C
.db $0D,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$08,$09,$0A
.db $0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$03,$04,$05,$06,$07,$08,$09
.db $0A,$0B,$0C,$0D,$0E,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08
.db $09,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$04,$05,$06
.db $07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0E,$0F,$00,$01,$02,$03,$04,$05
.db $06,$07,$08,$09,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04
.db $04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$0F,$00,$01,$02
.db $03,$04,$05,$06,$07,$08,$09,$0A,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01
.db $02,$03,$04,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$0F
.db $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0A,$0B,$0C,$0D,$0E
.db $0F,$00,$01,$02,$03,$04,$05,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D
.db $0E,$0F,$00,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0B
.db $0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$05,$06,$07,$08,$09,$0A
.db $0B,$0C,$0D,$0E,$0F,$00,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09
.db $0A,$0B,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$06,$07
.db $08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$01,$02,$03,$04,$05,$06
.db $07,$08,$09,$0A,$0B,$0C,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05
.db $06,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$01,$02,$03
.db $04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0C,$0D,$0E,$0F,$00,$01,$02
.db $03,$04,$05,$06,$07,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01
.db $02,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0C,$0D,$0E,$0F
.db $00,$01,$02,$03,$04,$05,$06,$07,$07,$08,$09,$0A,$0B,$0C,$0D,$0E
.db $0F,$00,$01,$02,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D
.db $0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$08,$09,$0A,$0B
.db $0C,$0D,$0E,$0F,$00,$01,$02,$03,$03,$04,$05,$06,$07,$08,$09,$0A
.db $0B,$0C,$0D,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$08


