' bin2obj - the overloader alternative
' by Plasma / Jon Petrosky  [02-10-2006]

DEFINT A-Z
'$LIB:     'QB.LIB'
'$INCLUDE: 'QB.BI'

DECLARE FUNCTION GetCom$ ()
DECLARE FUNCTION GetBase$ (Filename$)
DECLARE SUB ParseCmd (InFile$, ObjFile$, BiFile$, GetName$, WriteName$)

PRINT "bin2obj - the overloader alternative"
PRINT "by Plasma / Jon Petrosky  [02-10-2006]"
PRINT

ParseCmd InFile$, ObjFile$, BiFile$, GetName$, WriteName$

IF LEN(WriteName$) = 0 THEN
  PRINT "Usage: BIN2OBJ BinFile ObjFile BiFile GetName WriteName"
  PRINT
  PRINT "   InFile - Input filename (any file <= 64K)"
  PRINT "  ObjFile - Output filename for OMF object file"
  PRINT "   BiFile - Output filename for QB include (use NUL to omit)"
  PRINT "  GetName - Name of get procedure (use * to omit)"
  PRINT "WriteName - Name of write procedure (use * to omit)"
  END
END IF

PRINT "Dumping " + CHR$(34) + InFile$ + CHR$(34) + " to " + CHR$(34) + ObjFile$ + CHR$(34) + "...";

OPEN InFile$ FOR BINARY AS #1
OPEN ObjFile$ FOR BINARY AS #2

THeader$ = CHR$(&H80) + MKI$(LEN(InFile$) + 2) + CHR$(LEN(InFile$)) + InFile$ + CHR$(0)
PUT #2, , THeader$

LName$ = CHR$(&H96) + MKI$(2) + CHR$(0) + CHR$(0)
PUT #2, , LName$


' Code segment
Base$ = GetBase$(InFile$)
LName$ = CHR$(&H96) + MKI$(LEN(Base$) + 12) + CHR$(LEN(Base$) + 5) + Base$ + "_TEXT" + CHR$(4) + "CODE" + CHR$(0)
PUT #2, , LName$

Size& = LOF(1)
SegDef$ = CHR$(&H98) + MKI$(7) + CHR$(&HA8) + MKI$(Size& + 80) + CHR$(2) + CHR$(3) + CHR$(1) + CHR$(0)
PUT #2, , SegDef$


' Data segment
LName$ = CHR$(&H96) + MKI$(12) + CHR$(5) + "_DATA" + CHR$(4) + "DATA" + CHR$(0)
PUT #2, , LName$

SegDef$ = CHR$(&H98) + MKI$(7) + CHR$(&HA8) + MKI$(0) + CHR$(4) + CHR$(5) + CHR$(1) + CHR$(0)
PUT #2, , SegDef$


LName$ = CHR$(&H96) + MKI$(8) + CHR$(6) + "DGROUP" + CHR$(0)
PUT #2, , LName$

GroupDef$ = CHR$(&H9A) + MKI$(4) + CHR$(6) + CHR$(&HFF) + CHR$(2) + CHR$(0)
PUT #2, , GroupDef$

IF GetName$ <> "*" THEN
  PubName$ = CHR$(&H90) + MKI$(LEN(GetName$) + 7) + CHR$(0) + CHR$(1) + CHR$(LEN(GetName$)) + GetName$ + MKI$(0) + CHR$(0) + CHR$(0)
  PUT #2, , PubName$
END IF

IF WriteName$ <> "*" THEN
  PubName$ = CHR$(&H90) + MKI$(LEN(WriteName$) + 7) + CHR$(0) + CHR$(1) + CHR$(LEN(WriteName$)) + WriteName$ + MKI$(24) + CHR$(0) + CHR$(0)
  PUT #2, , PubName$
END IF

WeakExt$ = CHR$(&H88) + MKI$(4) + CHR$(&H40) + CHR$(&HA2) + CHR$(1) + CHR$(0)
PUT #2, , WeakExt$

DataRec$ = CHR$(&HA0) + MKI$(83) + CHR$(1) + MKI$(0)
DataRec$ = DataRec$ + MKL$(&H8BEC8B55) + MKL$(&H0F8C085E) + MKL$(&HB8065E8B) + MKL$(&H0789004F)
DataRec$ = DataRec$ + MKL$(&H004DA12E) + MKL$(&H0004CA5D) + MKL$(&H1EEC8B55) + MKL$(&HC9333CB4)
DataRec$ = DataRec$ + MKL$(&H8B085E8E) + MKL$(&H21CD0656) + MKL$(&HD88B1C72) + MKL$(&H8B2E40B4)
DataRec$ = DataRec$ + MKL$(&HBA004D0E) + MKL$(&H1F0E004F) + MKL$(&H3EB421CD) + MKL$(&HFFB821CD)
DataRec$ = DataRec$ + MKL$(&HCA5D1FFF) + MKL$(&HC0330004) + MKL$(&H04CA5D1F) + CHR$(0) + MKI$(Size&) + CHR$(0)
PUT #2, , DataRec$

FixUp$ = CHR$(&H9C) + MKI$(17) + MKL$(&H01540CC4) + MKL$(&H015412C4) + MKL$(&H015431C4) + MKL$(&H015434C4) + CHR$(0)
PUT #2, , FixUp$

Offset& = 79
Buffer$ = ""
Byte$ = " "
FOR i& = 1 TO Size&
  GET #1, , Byte$
  Buffer$ = Buffer$ + Byte$
  IF LEN(Buffer$) = 1020 THEN
    DataRec$ = CHR$(&HA0) + MKI$(1024) + CHR$(1) + MKI$(Offset&) + Buffer$ + CHR$(0)
    PUT #2, , DataRec$
    Offset& = Offset& + 1020
    Buffer$ = ""
  END IF
NEXT
IF LEN(Buffer$) THEN
  DataRec$ = CHR$(&HA0) + MKI$(LEN(Buffer$) + 4) + CHR$(1) + MKI$(Offset&) + Buffer$ + CHR$(0)
  PUT #2, , DataRec$
END IF

ModEnd$ = CHR$(&H8A) + MKI$(2) + CHR$(0) + CHR$(0)
PUT #2, , ModEnd$

CLOSE #2
CLOSE #1

PRINT "done."

IF UCASE$(BiFile$) <> "NUL" THEN

  PRINT "Writing include file " + CHR$(34) + BiFile$ + CHR$(34) + "...";

  OPEN BiFile$ FOR OUTPUT AS #1

  PRINT #1, "' Generated by bin2obj on " + DATE$ + " at " + TIME$
  PRINT #1, ""
  IF GetName$ <> "*" THEN
    PRINT #1, "DECLARE FUNCTION " + GetName$ + "% (Segment%, Offset%)"
  END IF
  IF WriteName$ <> "*" THEN
    PRINT #1, "DECLARE FUNCTION " + WriteName$ + "% (BYVAL FilenameSeg%, BYVAL FilenameOff%)"
  END IF

  CLOSE #1
  PRINT "done."

END IF

END

FUNCTION GetBase$ (Filename$)

  Base$ = Filename$

  Slash = INSTR(Base$, "\")
  DO WHILE Slash
    Base$ = RIGHT$(Base$, LEN(Base$) - Slash)
    Slash = INSTR(Base$, "\")
  LOOP

  Period = INSTR(Base$, ".")
  IF Period THEN Base$ = LEFT$(Base$, Period - 1)

  GetBase$ = Base$

END FUNCTION

FUNCTION GetCom$

  DIM Regs AS RegTypeX

  Regs.ax = &H2F00
  INTERRUPTX &H21, Regs, Regs

  DEF SEG = Regs.es
  Offset = Regs.bx
  Length = PEEK(Offset)

  FOR i = Offset + 1 TO Offset + Length
    Com$ = Com$ + CHR$(PEEK(i))
  NEXT

 GetCom$ = LTRIM$(RTRIM$(Com$))

END FUNCTION

SUB ParseCmd (InFile$, ObjFile$, BiFile$, GetName$, WriteName$)

  Cmd$ = GetCom$ + " "
  Tag = 0
  Prev = 0
  Split = INSTR(1, Cmd$, " ")
  DO WHILE Split > 0
    Token$ = LTRIM$(MID$(Cmd$, Prev + 1, Split - Prev - 1))
    IF LEN(Token$) THEN
      SELECT CASE Tag
        CASE 0
          InFile$ = Token$
        CASE 1
          ObjFile$ = Token$
        CASE 2
          BiFile$ = Token$
        CASE 3
          GetName$ = Token$
        CASE 4
          WriteName$ = Token$
          EXIT DO
      END SELECT
      Tag = Tag + 1
    END IF
    Prev = Split
    Split = INSTR(Split + 1, Cmd$, " ")
  LOOP

END SUB

