; NASM or fasm 1

org	0x100

	; assume: ax=bx=0, cx=0xFF (doesn't really matter), dx=cs=ds=es, bp=0x9??

	mov al,0x13
	int 0x10		; set 320x200 (256 colors) graphical video mode

	add dh,al		; dx = cs + 0x1300
	mov es,dx		; es = segment behind 64k+ of our code (extra video buffer)

	xchg ax,bp		; ah = 9 (bp = 0x13)
	mov dx,text
	int 0x21		; output the text

	push es
	pop ds			; ds = es

	xchg ax,bx		; ax = 0 (bx = 0x9??)
	dec ch			; cx = -1
	rep stosb		; clear extra video buffer
	dec ax			; al = -1
	mov di,0xA2D0		; set pointer to pixel at 130,80 (col,row)
	mov cl,160
	rep stosb		; fill 160 pixels by 0xFF color (draw horizontal line)

	mov bx,0x19A0		; set pointer to pixel at 20,160 (col,row)
	mov di,320		; screen width in pixels
vline:	mov [bx],ax		; draw vertical line...
	add bx,di
	ja vline		; ...until bottom

	mov dx,0x3C8
	mov al,0xC0
	out dx,al		; start palette set from 0xC0 color
	inc dx
pal:	out dx,al		; red component
	outsb			; green = 0
	outsb			; blue = 0
	inc al			; increase color (al mod 64 = 1, 2, 3..63)
	jnz pal			; set colors 0xC0..0xFF to red gradient (from dark to saturated)

	mov ch,0xA0
	mov ds,cx		; ds = 0xA000 = vedeo segment

mainloop:
        ; bx = pixel pointer, dx = pixel pointer delta value (initial values doesn't matter)
	cmp bh,0xFA
	jae skip		; jump if current pixel is out of screen
	mov ax,[bx]		; else get color of pixel (ah = 0 in the most cases - need at the loop end for scan code check and text mode set)
	cmp al,0xC0
	jbe skip		; jump if pixel color is out of red gradient range (0xC1..0xFF, excluding 0xC0)

	; flame effect
	dec ax			; else decrase color by 1 (make it darker)
	mov [bx+1],al
	mov [bx-1],al
	mov [bx+di],al		; di = 320
	mov [bx-320],al		; and fill pixels around the current by new color

	mov si,-640		; position delta: 2 lines up
	test dh,dh
	js nowind		; jump if dx is negative (poor pseudorandom boolean check)
	inc si
	inc si			; si += 2 (wind effect)
nowind:	mov [bx+si],al		; add pixel 2 lines higher than current pixel considering possible wind
skip:
	; restore cross
	mov al,[es:bx]		; get color from extra video buffer
	or [bx],al		; replace pixel on screen by 0xFF is al = 0xFF (slow cross redraw)
	add bx,dx		; increase pixel pointer by (pseudorandom) delta value
	inc dx			; increase delta value

	in al,0x60		; read keyboard scan code (also delay on real system)
	dec ax
	jnz mainloop		; repeat if Esc key is not pressed

	mov al,3
	int 0x10		; set text video mode

	ret			; return to DOS

text	db	'russkie idut...$'
